close all;

nMax = 301;

x = zeros(1,nMax);

M = 60; 

w = zeros(1,61);
w = 0.54 - 0.46 * cos( 2 * pi * (0:M) / M );

figure(1); 
clf;
subplot(2,3,1);
stem(w);
title('window');

x1 = w.*cos( 0.2 * pi * (0:M) );
x2 = w.*cos( 0.4 * pi * (0:M) - pi/2);
x3 = w.*cos( 0.8 * pi * (0:M) + pi/5);

x(1:(M+1)) = x2;
x((M+1):(2*M+1)) = x1;
x((2*M+2):(3*M+2)) = x3;

subplot(2,3,2);
plot(x);
xlabel('Time');
title('Input Signal');

%pause; 

f = fftshift(fft(x));

kVec = -150:1:150;

subplot(2,3,3); 
plot(2 * pi * kVec / 301, abs(f));
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('DFT Magnitude');

%pause; 

% evaluate magnitude response, group delay 
pVec = -pi : .001 : pi;
H_freq = zeros(1,length(pVec));

for k = 1:length(H_freq),
    H_freq(k) = eval_h( exp(1i * pVec(k)) );
end

subplot(2,3,4);
plot(pVec,abs(H_freq));
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('Magnitude response |H(e^{j\omega})|');
%pause;

arg_H = unwrap(angle(H_freq)); 

subplot(2,3,5);
plot(pVec,arg_H);
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('Phase Response arg H(e^{j\omega})');
%pause;

groupDelay = zeros(1,length(pVec));

for j = 1:length(pVec),
    groupDelay(j) = gd_h(pVec(j));
end

subplot(2,3,6);
plot(pVec,real(groupDelay));
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('Group Delay \tau(\omega)');
%pause;

figure(3);
subplot(5,1,1);
plot(x,'LineWidth',2);
title('Input signal x');
subplot(5,1,2);
plot(2 * pi * kVec / 301, abs(f),'LineWidth',2);
title('DFT magnitude of input: |X(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(5,1,3);
plot(pVec,abs(H_freq),'LineWidth',2);
title('Magnitude response |H(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(5,1,4);
plot(pVec,arg_H,'LineWidth',2);
title('Phase response arg [ H(e^{j \omega}) ] (in radians)');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(5,1,5);
plot(pVec,groupDelay,'LineWidth',2);
title('Group delay grd[ H(e^{j \omega}) ] (in samples)');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
pause;

[num,denom] = expand_H;

y = implement_tf(num,denom,x,length(x));

figure(4);
subplot(2,2,1);
plot(x,'linewidth',2);
title('Input x');
subplot(2,2,2);
plot(real(y),'linewidth',2);
title('Output y'); 
subplot(2,2,3);
plot(2 * pi * kVec / 301, abs(f),'LineWidth',2);
title('DFT magnitude of input: |X(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(2,2,4);
fy = fftshift(fft(y)); 
plot(2 * pi * kVec / 301, abs(fy),'LineWidth',2);
title('DFT magnitude of input: |X(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 

pause;


x1 = w.*cos( 0.2 * pi * (0:M) );
x2 = w.*cos( 0.4 * pi * (0:M) - pi/2);
x3 = w.*cos( 0.8 * pi * (0:M) + pi/5);

x(1:(M+1)) = x3;
x((M+1):(2*M+1)) = x1;
x((2*M+2):(3*M+2)) = x2;

subplot(2,3,2);
plot(x);
xlabel('Time');
title('Input Signal');

%pause; 

f = fftshift(fft(x));

kVec = -150:1:150;

subplot(2,3,3); 
plot(2 * pi * kVec / 301, abs(f));
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('DFT Magnitude');

%pause; 

% evaluate magnitude response, group delay 
pVec = -pi : .001 : pi;
H_freq = zeros(1,length(pVec));

for k = 1:length(H_freq),
    H_freq(k) = eval_h( exp(i * pVec(k)) );
end

subplot(2,3,4);
plot(pVec,abs(H_freq));
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('Magnitude response |H(e^{j\omega})|');
%pause;

arg_H = unwrap(angle(H_freq)); 

subplot(2,3,5);
plot(pVec,arg_H);
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('Phase Response arg H(e^{j\omega})');
%pause;

groupDelay = zeros(1,length(pVec));

for j = 1:length(pVec),
    groupDelay(j) = gd_h(pVec(j));
end

subplot(2,3,6);
plot(pVec,real(groupDelay));
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
title('Group Delay \tau(\omega)');
%pause;

figure(3);
subplot(5,1,1);
plot(x,'LineWidth',2);
title('Input signal x');
subplot(5,1,2);
plot(2 * pi * kVec / 301, abs(f),'LineWidth',2);
title('DFT magnitude of input: |X(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(5,1,3);
plot(pVec,abs(H_freq),'LineWidth',2);
title('Magnitude response |H(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(5,1,4);
plot(pVec,arg_H,'LineWidth',2);
title('Phase response arg [ H(e^{j \omega}) ] (in radians)');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(5,1,5);
plot(pVec,groupDelay,'LineWidth',2);
title('Group delay grd[ H(e^{j \omega}) ] (in samples)');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
pause;

[num,denom] = expand_H;

y = implement_tf(num,denom,x,length(x));

figure(4);
subplot(2,2,1);
plot(x,'linewidth',2);
title('Input x');
subplot(2,2,2);
plot(real(y),'linewidth',2);
title('Output y'); 
subplot(2,2,3);
plot(2 * pi * kVec / 301, abs(f),'LineWidth',2);
title('DFT magnitude of input: |X(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 
subplot(2,2,4);
fy = fftshift(fft(y)); 
plot(2 * pi * kVec / 301, abs(fy),'LineWidth',2);
title('DFT magnitude of input: |X(e^{j \omega})|');
set(gca,'xtick',[-pi,-pi/2,0,pi/2,pi]); 
set(gca,'xticklabels',{'-\pi','-\pi/2','0','\pi/2','\pi'}); 




