M = 15
b = ones(M+1,1) / (M+1);

[H,W] = freqz(b);

figure; 
subplot(3,1,1);
plot(W,abs(H),'b-','LineWidth',5);
title('|H(e^{j\omega})|');
set(gca,'xtick',[0,pi/4,pi/2,3*pi/4,pi]);
set(gca,'xticklabels',{'0','\pi/4','\pi/2','3 \pi/4','\pi'},'FontSize',20);
subplot(3,1,2);
plot(W,zeros(size(W)),'r-','LineWidth',2);
hold on
plot(W,real(H ./ exp(- 1i * W * M / 2 )),'b-','LineWidth',5);
title('A(e^{j\omega})');
set(gca,'xtick',[0,pi/4,pi/2,3*pi/4,pi]);
set(gca,'xticklabels',{'0','\pi/4','\pi/2','3 \pi/4','\pi'},'FontSize',20);
subplot(3,1,3);
plot(W,angle(H),'b-','LineWidth',5);
title('\angle H(e^{j \omega})');
set(gca,'xtick',[0,pi/4,pi/2,3*pi/4,pi]);
set(gca,'xticklabels',{'0','\pi/4','\pi/2','3 \pi/4','\pi'},'FontSize',20);