function [num,denom] = expand_H

c1 = 0.95 * exp( i * ( .15 * pi + .02 * pi * 1 ));
c2 = 0.95 * exp( i * ( .15 * pi + .02 * pi * 2 ));
c3 = 0.95 * exp( i * ( .15 * pi + .02 * pi * 3 ));
c4 = 0.95 * exp( i * ( .15 * pi + .02 * pi * 4 ));

% expand numerator of H(z)
n1 = [1, -.98*exp( i * .8 * pi)];
n2 = [1, -.98*exp(-i * .8 * pi)];

m1 = [abs(c1)^2, - (c1+conj(c1)), 1];
m2 = [abs(c2)^2, - (c2+conj(c2)), 1];
m3 = [abs(c3)^2, - (c3+conj(c3)), 1];
m4 = [abs(c4)^2, - (c4+conj(c4)), 1];

num = conv(n1,conv(n2,conv(m1,conv(m1,conv(m2,conv(m2,conv(m3,conv(m3,conv(m4,m4)))))))));

% expand denominator of H(z)
d1 = [1, -.8 * exp(i * .4 * pi)];
d2 = [1, -.8 * exp(-i * .4 * pi)];

q1 = [1, - (c1 + conj(c1)), abs(c1)^2];
q2 = [1, - (c2 + conj(c2)), abs(c2)^2];
q3 = [1, - (c3 + conj(c3)), abs(c3)^2];
q4 = [1, - (c4 + conj(c4)), abs(c4)^2];

denom = conv(d1,conv(d2,conv(q1,conv(q1,conv(q2,conv(q2,conv(q3,conv(q3,conv(q4,q4)))))))));