function hz = eval_h(z)


c1 = 0.95 * exp( 1i * ( .15 * pi + .02 * pi * 1 ));
c2 = 0.95 * exp( 1i * ( .15 * pi + .02 * pi * 2 ));
c3 = 0.95 * exp( 1i * ( .15 * pi + .02 * pi * 3 ));
c4 = 0.95 * exp( 1i * ( .15 * pi + .02 * pi * 4 ));

h1z =    ( ( 1 - .98 * exp(1i * .8 * pi) / z ) * ( 1 - .98 * exp(-1i * .8 * pi) / z ) ) ...
       / ( ( 1 - .8  * exp(1i * .4 * pi) / z ) * ( 1 - .8  * exp(-1i * .4 * pi) / z ) );
   
f1z =    ( ( conj(c1) - 1/z ) * ( c1 - 1/z ) ) ...
       / ( ( 1 - c1 / z ) * ( 1 - conj(c1) / z ) );
   
f2z =    ( ( conj(c2) - 1/z ) * ( c2 - 1/z ) ) ...
       / ( ( 1 - c2 / z ) * ( 1 - conj(c2) / z ) );

f3z =    ( ( conj(c3) - 1/z ) * ( c3 - 1/z ) ) ...
       / ( ( 1 - c3 / z ) * ( 1 - conj(c3) / z ) );

f4z =    ( ( conj(c4) - 1/z ) * ( c4 - 1/z ) ) ...
       / ( ( 1 - c4 / z ) * ( 1 - conj(c4) / z ) );

hz = h1z * f1z^2 * f2z^2 * f3z^2 * f4z^2;