/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.virtual;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;

public class VirtualContentPanel
extends JPanel {
    private Image resizedImage;
    private String mode = "centre";
    private static final String CENTRE = "centre";
    private static final String FIT = "fit";
    private static final String STRETCH = "stretch";
    private static final String FILL = "fill";

    public VirtualContentPanel(Dimension preferredSize, Color background, final Image image, final String mode) {
        this.setLayout(null);
        this.setPreferredSize(preferredSize);
        this.setBackground(background);
        this.resizedImage = image;
        this.mode = mode;
        if (!(mode.equals(CENTRE) || mode.equals(FIT) || mode.equals(STRETCH) || mode.equals(FILL))) {
            this.mode = CENTRE;
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (image != null) {
                    if (mode.equals(VirtualContentPanel.STRETCH)) {
                        VirtualContentPanel.this.resizedImage = image.getScaledInstance(VirtualContentPanel.this.getWidth(), VirtualContentPanel.this.getHeight(), 4);
                    } else if (!mode.equals(VirtualContentPanel.CENTRE)) {
                        double factor = mode.equals(VirtualContentPanel.FIT) ? Math.min((double)VirtualContentPanel.this.getWidth() / (double)image.getWidth(null), (double)VirtualContentPanel.this.getHeight() / (double)image.getHeight(null)) : Math.max((double)VirtualContentPanel.this.getWidth() / (double)image.getWidth(null), (double)VirtualContentPanel.this.getHeight() / (double)image.getHeight(null));
                        VirtualContentPanel.this.resizedImage = image.getScaledInstance((int)(factor * (double)image.getWidth(null)), (int)(factor * (double)image.getHeight(null)), 4);
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.resizedImage != null) {
            if (this.mode.equals(STRETCH)) {
                g.drawImage(this.resizedImage, 0, 0, null);
            } else if (this.mode.equals(CENTRE)) {
                g.drawImage(this.resizedImage, this.resizedImage.getWidth(null) > this.getWidth() ? (this.resizedImage.getWidth(null) - this.getWidth()) / -2 : (this.getWidth() - this.resizedImage.getWidth(null)) / 2, this.resizedImage.getHeight(null) > this.getHeight() ? (this.resizedImage.getHeight(null) - this.getHeight()) / -2 : (this.getHeight() - this.resizedImage.getHeight(null)) / 2, null);
            } else {
                g.drawImage(this.resizedImage, (this.getWidth() - this.resizedImage.getWidth(null)) / 2, (this.getHeight() - this.resizedImage.getHeight(null)) / 2, null);
            }
        }
    }
}

