/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.imagesetchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class ImageSetChooserPanel
extends JPanel {
    String imageSet;
    private JLabel actionsFile;
    private JLabel behaviorsFile;
    private JLabel caption;
    private JCheckBox checkbox;
    private JLabel image;

    public ImageSetChooserPanel() {
        this.initComponents();
    }

    public ImageSetChooserPanel(String imageSet, String actions, String behaviors, String imageLocation, String caption) {
        this.initComponents();
        this.imageSet = imageSet;
        this.caption.setText(caption);
        this.caption.setFont(this.caption.getFont().deriveFont(1));
        this.actionsFile.setText(actions);
        this.behaviorsFile.setText(behaviors);
        try {
            BufferedImage img = ImageIO.read(new File(imageLocation));
            this.image.setIcon(new ImageIcon(img.getScaledInstance(60, 60, 1)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCheckbox(boolean value) {
        this.checkbox.setSelected(value);
    }

    public String getImageSetName() {
        return this.imageSet;
    }

    private void initComponents() {
        this.checkbox = new JCheckBox();
        this.caption = new JLabel();
        this.actionsFile = new JLabel();
        this.behaviorsFile = new JLabel();
        this.image = new JLabel();
        this.setMinimumSize(new Dimension(248, 80));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(248, 80));
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.checkbox.setOpaque(false);
        this.add((Component)this.checkbox, new AbsoluteConstraints(10, 30, -1, -1));
        this.caption.setText("Builder");
        this.add((Component)this.caption, new AbsoluteConstraints(110, 10, -1, -1));
        this.actionsFile.setText("img/Builder/conf/actionsxml");
        this.add((Component)this.actionsFile, new AbsoluteConstraints(110, 30, -1, -1));
        this.behaviorsFile.setText("img/Builder/conf/behaviors.xml");
        this.add((Component)this.behaviorsFile, new AbsoluteConstraints(110, 50, -1, -1));
        this.image.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.add((Component)this.image, new AbsoluteConstraints(40, 10, 60, 60));
    }
}

