/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.image;

import com.group_finity.mascot.image.ImagePair;
import com.group_finity.mascot.image.MascotImage;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class ImagePairs {
    private static ConcurrentHashMap<String, ImagePair> imagepairs = new ConcurrentHashMap();

    public static void load(String filename, ImagePair imagepair) {
        if (!imagepairs.containsKey(filename)) {
            imagepairs.put(filename, imagepair);
        }
    }

    public static ImagePair getImagePair(String filename) {
        if (!imagepairs.containsKey(filename)) {
            return null;
        }
        ImagePair ip = imagepairs.get(filename);
        return ip;
    }

    public static boolean contains(String filename) {
        return imagepairs.containsKey(filename);
    }

    public static void clear() {
        imagepairs.clear();
    }

    public static void removeAll(String searchTerm) {
        if (imagepairs.isEmpty()) {
            return;
        }
        Enumeration<String> key = imagepairs.keys();
        while (key.hasMoreElements()) {
            String filename = key.nextElement();
            if (!searchTerm.equals(Paths.get(filename, new String[0]).getName(2).toString())) continue;
            imagepairs.remove(filename);
        }
    }

    public static MascotImage getImage(String filename, boolean isLookRight) {
        if (!imagepairs.containsKey(filename)) {
            return null;
        }
        return imagepairs.get(filename).getImage(isLookRight);
    }
}

