/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.image;

import com.group_finity.mascot.image.ImagePair;
import com.group_finity.mascot.image.ImagePairs;
import com.group_finity.mascot.image.MascotImage;
import hqx.Hqx_2x;
import hqx.Hqx_3x;
import hqx.Hqx_4x;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public class ImagePairLoader {
    public static void load(Path path, Path rightPath, Point center, double scaling, Filter filter, double opacity) throws IOException {
        if (ImagePairs.contains(path.toString() + (rightPath == null ? "" : rightPath.toString()))) {
            return;
        }
        BufferedImage leftImage = ImagePairLoader.scale(ImagePairLoader.premultiply(ImageIO.read(path.toFile()), opacity), scaling, filter);
        BufferedImage rightImage = rightPath == null ? ImagePairLoader.flip(leftImage) : ImagePairLoader.scale(ImagePairLoader.premultiply(ImageIO.read(rightPath.toFile()), opacity), scaling, filter);
        ImagePair ip = new ImagePair(new MascotImage(leftImage, new Point((int)Math.round((double)center.x * scaling), (int)Math.round((double)center.y * scaling))), new MascotImage(rightImage, new Point(rightImage.getWidth() - (int)Math.round((double)center.x * scaling), (int)Math.round((double)center.y * scaling))));
        ImagePairs.load(path.toString() + (rightPath == null ? "" : rightPath.toString()), ip);
    }

    private static BufferedImage flip(BufferedImage src) {
        BufferedImage copy = new BufferedImage(src.getWidth(), src.getHeight(), src.getType() == 0 ? 2 : src.getType());
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                copy.setRGB(copy.getWidth() - x - 1, y, src.getRGB(x, y));
            }
        }
        return copy;
    }

    private static BufferedImage premultiply(BufferedImage source, double opacity) {
        BufferedImage returnImage = new BufferedImage(source.getWidth(), source.getHeight(), source.getType() == 0 ? 3 : source.getType());
        for (int y = 0; y < returnImage.getHeight(); ++y) {
            for (int x = 0; x < returnImage.getWidth(); ++x) {
                Color colour = new Color(source.getRGB(x, y), true);
                float[] components = colour.getComponents(null);
                components[3] = (float)((double)components[3] * opacity);
                components[0] = components[3] * components[0];
                components[1] = components[3] * components[1];
                components[2] = components[3] * components[2];
                colour = new Color(components[0], components[1], components[2], components[3]);
                returnImage.setRGB(x, y, colour.getRGB());
            }
        }
        return returnImage;
    }

    private static BufferedImage scale(BufferedImage source, double scaling, Filter filter) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage workingImage = null;
        double effectiveScaling = scaling;
        if (filter == Filter.HQX && scaling > 1.0) {
            int[] buffer;
            int[] rbgValues = source.getRGB(0, 0, width, height, null, 0, width);
            if (scaling == 4.0 || scaling == 8.0) {
                buffer = new int[(width *= 4) * (height *= 4)];
                Hqx_4x.hq4x_32_rb(rbgValues, buffer, width / 4, height / 4);
                rbgValues = buffer;
                effectiveScaling = scaling > 4.0 ? 2.0 : 1.0;
            } else if (scaling == 3.0 || scaling == 6.0) {
                buffer = new int[(width *= 3) * (height *= 3)];
                Hqx_3x.hq3x_32_rb(rbgValues, buffer, width / 3, height / 3);
                rbgValues = buffer;
                effectiveScaling = scaling > 4.0 ? 2.0 : 1.0;
            } else if (scaling == 2.0) {
                buffer = new int[(width *= 2) * (height *= 2)];
                Hqx_2x.hq2x_32_rb(rbgValues, buffer, width / 2, height / 2);
                rbgValues = buffer;
                effectiveScaling = 1.0;
            } else {
                filter = Filter.NEAREST_NEIGHBOUR;
            }
            if (filter == Filter.HQX) {
                workingImage = new BufferedImage((int)Math.round((double)width * effectiveScaling), (int)Math.round((double)height * effectiveScaling), 3);
                int srcColIndex = 0;
                int srcRowIndex = 0;
                for (int y = 0; y < workingImage.getHeight(); ++y) {
                    for (int x = 0; x < workingImage.getWidth(); ++x) {
                        workingImage.setRGB(x, y, rbgValues[srcColIndex / (int)effectiveScaling]);
                        ++srcColIndex;
                    }
                    if ((double)(++srcRowIndex) != effectiveScaling) {
                        srcColIndex -= workingImage.getWidth();
                        continue;
                    }
                    srcRowIndex = 0;
                }
            }
        }
        width = (int)Math.round((double)width * effectiveScaling);
        height = (int)Math.round((double)height * effectiveScaling);
        BufferedImage copy = new BufferedImage(width, height, 3);
        Graphics2D g2d = copy.createGraphics();
        Object renderHint = filter == Filter.BICUBIC ? RenderingHints.VALUE_INTERPOLATION_BICUBIC : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, renderHint);
        g2d.drawImage(workingImage != null ? workingImage : source, 0, 0, width, height, null);
        g2d.dispose();
        return copy;
    }

    public static enum Filter {
        NEAREST_NEIGHBOUR,
        HQX,
        BICUBIC;

    }
}

