/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.config;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.animation.Pose;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.AnimationInstantiationException;
import com.group_finity.mascot.exception.ConfigurationException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.hotspot.Hotspot;
import com.group_finity.mascot.image.ImagePairLoader;
import com.group_finity.mascot.script.Variable;
import com.group_finity.mascot.sound.SoundLoader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnimationBuilder {
    private static final Logger log = Logger.getLogger(AnimationBuilder.class.getName());
    private final String condition;
    private String imageSet = "";
    private final List<Pose> poses = new ArrayList<Pose>();
    private final List<Hotspot> hotspots = new ArrayList<Hotspot>();
    private final ResourceBundle schema;
    private final String turn;

    public AnimationBuilder(ResourceBundle schema, Entry animationNode, String imageSet) throws ConfigurationException {
        if (!imageSet.equals("")) {
            this.imageSet = imageSet;
        }
        this.schema = schema;
        this.condition = animationNode.getAttribute(schema.getString("Condition")) == null ? "true" : animationNode.getAttribute(schema.getString("Condition"));
        this.turn = animationNode.getAttribute(schema.getString("IsTurn")) == null ? "false" : animationNode.getAttribute(schema.getString("IsTurn"));
        log.log(Level.INFO, "Start Reading Animations");
        for (Entry frameNode : animationNode.selectChildren(schema.getString("Pose"))) {
            try {
                this.poses.add(this.loadPose(frameNode));
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load pose: {0}", e);
                throw new ConfigurationException(Main.getInstance().getLanguageBundle().getString("FailedLoadPoseErrorMessage") + " " + frameNode.getAttributes().toString());
            }
        }
        for (Entry frameNode : animationNode.selectChildren(schema.getString("Hotspot"))) {
            try {
                this.hotspots.add(this.loadHotspot(frameNode));
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load hotspot: {0}", e);
                throw new ConfigurationException(Main.getInstance().getLanguageBundle().getString("FailedLoadHotspotErrorMessage") + " " + frameNode.getAttributes().toString());
            }
        }
        log.log(Level.INFO, "Animations Finished Loading");
    }

    private Pose loadPose(Entry frameNode) throws IOException {
        Path imageText = frameNode.getAttribute(this.schema.getString("Image")) != null ? Paths.get(".", "img", this.imageSet, frameNode.getAttribute(this.schema.getString("Image"))) : null;
        Path imageRightText = frameNode.getAttribute(this.schema.getString("ImageRight")) != null ? Paths.get(".", "img", this.imageSet + frameNode.getAttribute(this.schema.getString("ImageRight"))) : null;
        String anchorText = frameNode.getAttribute(this.schema.getString("ImageAnchor")) != null ? frameNode.getAttribute(this.schema.getString("ImageAnchor")) : null;
        String moveText = frameNode.getAttribute(this.schema.getString("Velocity"));
        String durationText = frameNode.getAttribute(this.schema.getString("Duration"));
        String soundText = frameNode.getAttribute(this.schema.getString("Sound")) != null ? frameNode.getAttribute(this.schema.getString("Sound")) : null;
        String volumeText = frameNode.getAttribute(this.schema.getString("Volume")) != null ? frameNode.getAttribute(this.schema.getString("Volume")) : "0";
        double opacity = Double.parseDouble(Main.getInstance().getProperties().getProperty("Opacity", "1.0"));
        double scaling = Double.parseDouble(Main.getInstance().getProperties().getProperty("Scaling", "1.0"));
        String filterText = Main.getInstance().getProperties().getProperty("Filter", "false");
        ImagePairLoader.Filter filter = ImagePairLoader.Filter.NEAREST_NEIGHBOUR;
        if (filterText.equalsIgnoreCase("true") || filterText.equalsIgnoreCase("hqx")) {
            filter = ImagePairLoader.Filter.HQX;
        } else if (filterText.equalsIgnoreCase("bicubic")) {
            filter = ImagePairLoader.Filter.BICUBIC;
        }
        if (imageText != null) {
            String[] anchorCoordinates = anchorText.split(",");
            Point anchor = new Point(Integer.parseInt(anchorCoordinates[0]), Integer.parseInt(anchorCoordinates[1]));
            try {
                ImagePairLoader.load(imageText, imageRightText, anchor, scaling, filter, opacity);
            }
            catch (Exception e) {
                String error = imageText.toString();
                if (imageRightText != null) {
                    error = error + ", " + imageRightText.toString();
                }
                log.log(Level.SEVERE, "Failed to load image: {0}", error);
                throw new IOException(Main.getInstance().getLanguageBundle().getString("FailedLoadImageErrorMessage") + " " + error);
            }
        }
        String[] moveCoordinates = moveText.split(",");
        int moveX = Integer.parseInt(moveCoordinates[0]);
        int moveY = Integer.parseInt(moveCoordinates[1]);
        int n = Math.abs(moveX) > 0 && Math.abs((double)moveX * scaling) < 1.0 ? (moveX > 0 ? 1 : -1) : (moveX = (int)Math.round((double)moveX * scaling));
        moveY = Math.abs(moveY) > 0 && Math.abs((double)moveY * scaling) < 1.0 ? (moveY > 0 ? 1 : -1) : (int)Math.round((double)moveY * scaling);
        int duration = Integer.parseInt(durationText);
        if (soundText != null) {
            try {
                soundText = Paths.get(".", "sound", soundText).toFile().exists() ? Paths.get(".", "sound", soundText).toString() : (Paths.get(".", "sound", this.imageSet, soundText).toFile().exists() ? Paths.get(".", "sound", this.imageSet, soundText).toString() : Paths.get(".", "img", this.imageSet, "sound", soundText).toString());
                SoundLoader.load(soundText, Float.parseFloat(volumeText));
                soundText = soundText + Float.parseFloat(volumeText);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load sound: {0}", soundText);
                throw new IOException(Main.getInstance().getLanguageBundle().getString("FailedLoadSoundErrorMessage") + soundText);
            }
        }
        Pose pose = new Pose(imageText, imageRightText, moveX, moveY, duration, soundText != null ? soundText : null);
        log.log(Level.INFO, "ReadPosition({0})", pose);
        return pose;
    }

    private Hotspot loadHotspot(Entry frameNode) throws IOException {
        RectangularShape shape;
        String shapeText = frameNode.getAttribute(this.schema.getString("Shape"));
        String originText = frameNode.getAttribute(this.schema.getString("Origin"));
        String sizeText = frameNode.getAttribute(this.schema.getString("Size"));
        String behaviourText = frameNode.getAttribute(this.schema.getString("Behaviour"));
        double scaling = Double.parseDouble(Main.getInstance().getProperties().getProperty("Scaling", "1.0"));
        String[] originCoordinates = originText.split(",");
        String[] sizeCoordinates = sizeText.split(",");
        Point origin = new Point((int)Math.round((double)Integer.parseInt(originCoordinates[0]) * scaling), (int)Math.round((double)Integer.parseInt(originCoordinates[1]) * scaling));
        Dimension size = new Dimension((int)Math.round((double)Integer.parseInt(sizeCoordinates[0]) * scaling), (int)Math.round((double)Integer.parseInt(sizeCoordinates[1]) * scaling));
        if (shapeText.equalsIgnoreCase("Rectangle")) {
            shape = new Rectangle(origin, size);
        } else if (shapeText.equalsIgnoreCase("Ellipse")) {
            shape = new Ellipse2D.Float(origin.x, origin.y, size.width, size.height);
        } else {
            log.log(Level.SEVERE, "Failed to load hotspot shape: {0}", shapeText);
            throw new IOException(Main.getInstance().getLanguageBundle().getString("HotspotShapeNotSupportedErrorMessage") + " " + shapeText);
        }
        Hotspot hotspot = new Hotspot(behaviourText, shape);
        log.log(Level.INFO, "ReadHotSpot({0})", hotspot);
        return hotspot;
    }

    public Animation buildAnimation() throws AnimationInstantiationException {
        try {
            return new Animation(Variable.parse(this.condition), this.poses.toArray(new Pose[0]), this.hotspots.toArray(new Hotspot[0]), Boolean.parseBoolean(this.turn));
        }
        catch (VariableException e) {
            throw new AnimationInstantiationException(Main.getInstance().getLanguageBundle().getString("FailedConditionEvaluationErrorMessage"), e);
        }
    }
}

