/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.action;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.ActionBase;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Regist
extends ActionBase {
    public static final String PARAMETER_OFFSETX = "OffsetX";
    private static final int DEFAULT_OFFSETX = 0;
    public static final String PARAMETER_OFFSETTYPE = "OffsetType";
    private static final String DEFAULT_OFFSETTYPE = "ImageAnchor";
    private double scaling;
    private static final Logger log = Logger.getLogger(Regist.class.getName());

    public Regist(ResourceBundle schema, List<Animation> animations, VariableMap context) {
        super(schema, animations, context);
    }

    @Override
    public void init(Mascot mascot) throws VariableException {
        super.init(mascot);
        this.scaling = Double.parseDouble(Main.getInstance().getProperties().getProperty("Scaling", "1.0"));
    }

    @Override
    public boolean hasNext() throws VariableException {
        int offsetX = (int)Math.round((double)this.getOffsetX() * this.scaling);
        if (this.getOffsetType().equals(this.getSchema().getString("Origin"))) {
            offsetX = 0 - offsetX + this.getMascot().getImage().getCenter().x;
        }
        boolean notMoved = Math.abs(this.getEnvironment().getCursor().getX() - this.getMascot().getAnchor().x + offsetX) < 5;
        return super.hasNext() && notMoved;
    }

    @Override
    protected void tick() throws LostGroundException, VariableException {
        this.getMascot().setDragging(true);
        Animation animation = this.getAnimation();
        animation.next(this.getMascot(), this.getTime());
        if (this.getTime() + 1 >= this.getAnimation().getDuration()) {
            this.getMascot().setLookRight(Math.random() < 0.5);
            log.log(Level.INFO, "Lost Ground ({0},{1})", new Object[]{this.getMascot(), this});
            throw new LostGroundException();
        }
    }

    @Override
    protected void refreshHotspots() {
        this.getMascot().getHotspots().clear();
    }

    private int getOffsetX() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_OFFSETX), Number.class, 0)).intValue();
    }

    private String getOffsetType() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_OFFSETTYPE), String.class, DEFAULT_OFFSETTYPE);
    }
}

