/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.action;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.action.Animate;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Interact
extends Animate {
    private static final Logger log = Logger.getLogger(Interact.class.getName());
    public static final String PARAMETER_BEHAVIOUR = "Behaviour";
    private static final String DEFAULT_BEHAVIOUR = "";

    public Interact(ResourceBundle schema, List<Animation> animations, VariableMap context) {
        super(schema, animations, context);
    }

    @Override
    public boolean hasNext() throws VariableException {
        return super.hasNext() && this.getMascot().getManager().hasOverlappingMascotsAtPoint(this.getMascot().getAnchor());
    }

    @Override
    protected void tick() throws LostGroundException, VariableException {
        super.tick();
        if (!(this.getTime() != this.getAnimation().getDuration() - 1 && this.getAnimation().getDuration() != 1 || this.getBehavior().trim().isEmpty())) {
            try {
                this.getMascot().setBehavior(Main.getInstance().getConfiguration(this.getMascot().getImageSet()).buildBehavior(this.getBehavior(), this.getMascot()));
            }
            catch (BehaviorInstantiationException e) {
                log.log(Level.SEVERE, "Fatal Exception", e);
                Main.showError(Main.getInstance().getLanguageBundle().getString("FailedSetBehaviourErrorMessage"), e);
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "Fatal Exception", e);
                Main.showError(Main.getInstance().getLanguageBundle().getString("FailedSetBehaviourErrorMessage"), e);
            }
        }
    }

    private String getBehavior() throws VariableException {
        return this.eval(this.getSchema().getString(PARAMETER_BEHAVIOUR), String.class, DEFAULT_BEHAVIOUR);
    }
}

