/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.Main;
import com.nilo.plaf.nimrod.NimRODFontDialog;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class SettingsWindow
extends JDialog {
    private final Path configPath = Paths.get(".", "conf", "settings.properties");
    private final Path themePath = Paths.get(".", "conf", "theme.properties");
    private NimRODTheme theme;
    private NimRODTheme oldTheme;
    private NimRODLookAndFeel lookAndFeel;
    private final ArrayList<String> listData = new ArrayList();
    private final ArrayList<String> blacklistData = new ArrayList();
    private Boolean alwaysShowShimejiChooser = false;
    private Boolean alwaysShowInformationScreen = false;
    private String filter = "nearest";
    private double scaling = 1.0;
    private double opacity = 1.0;
    private Boolean windowedMode = false;
    private Dimension windowSize = new Dimension(600, 500);
    private Color backgroundColour = new Color(0, 255, 0);
    private String backgroundMode = "centre";
    private String backgroundImage = null;
    private final String[] backgroundModes = new String[]{"centre", "fill", "fit", "stretch"};
    private Color primaryColour1;
    private Color primaryColour2;
    private Color primaryColour3;
    private Color secondaryColour1;
    private Color secondaryColour2;
    private Color secondaryColour3;
    private Color blackColour;
    private Color whiteColour;
    private Font font;
    private double menuOpacity = 1.0;
    private Boolean colourWasChanged = false;
    private Boolean suppressTextChanged = true;
    private Boolean imageReloadRequired = false;
    private Boolean interactiveWindowReloadRequired = false;
    private Boolean environmentReloadRequired = false;
    private JButton btnAddInteractiveWindow;
    private JButton btnBackgroundColourChange;
    private JButton btnBackgroundImageChange;
    private JButton btnBackgroundImageRemove;
    private JButton btnBlackColourChange;
    private JButton btnCancel;
    private JButton btnChangeFont;
    private JButton btnDiscord;
    private JButton btnDone;
    private JButton btnPatreon;
    private JButton btnPrimaryColour1Change;
    private JButton btnPrimaryColour2Change;
    private JButton btnRemoveInteractiveWindow;
    private JButton btnReset;
    private JButton btnSecondaryColour1Change;
    private JButton btnSecondaryColour2Change;
    private JButton btnSecondaryColour3Change;
    private JButton btnWebsite;
    private JButton btnWhiteColourChange;
    private JCheckBox chkAlwaysShowInformationScreen;
    private JCheckBox chkAlwaysShowShimejiChooser;
    private JCheckBox chkWindowModeEnabled;
    private JComboBox<String> cmbBackgroundImageMode;
    private Box.Filler glue1;
    private Box.Filler glue2;
    private Box.Filler glueBackground;
    private Box.Filler glueBackground2;
    private Box.Filler glueBlackColoura;
    private Box.Filler glueBlackColourb;
    private Box.Filler gluePrimaryColour1a;
    private Box.Filler gluePrimaryColour1b;
    private Box.Filler gluePrimaryColour2a;
    private Box.Filler gluePrimaryColour2b;
    private Box.Filler glueSecondaryColour1a;
    private Box.Filler glueSecondaryColour1b;
    private Box.Filler glueSecondaryColour2a;
    private Box.Filler glueSecondaryColour2b;
    private Box.Filler glueSecondaryColour3a;
    private Box.Filler glueSecondaryColour3b;
    private Box.Filler glueWhiteColoura;
    private Box.Filler glueWhiteColourb;
    private ButtonGroup grpFilter;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JLabel lblBackground;
    private JLabel lblBackgroundColour;
    private JLabel lblBackgroundImage;
    private JLabel lblBackgroundImageCaption;
    private JLabel lblBlackColour;
    private JLabel lblDevelopedBy;
    private JLabel lblDimensions;
    private JLabel lblDimensionsX;
    private JLabel lblFilter;
    private JLabel lblIcon;
    private JLabel lblKilkakon;
    private JLabel lblMenuOpacity;
    private JLabel lblOpacity;
    private JLabel lblPrimaryColour1;
    private JLabel lblPrimaryColour2;
    private JLabel lblScaling;
    private JLabel lblSecondaryColour1;
    private JLabel lblSecondaryColour2;
    private JLabel lblSecondaryColour3;
    private JLabel lblShimejiEE;
    private JLabel lblVersion;
    private JLabel lblWhiteColour;
    private JList lstInteractiveWindows;
    private JList lstInteractiveWindowsBlacklist;
    private JPanel pnlAbout;
    private JPanel pnlAboutButtons;
    private JPanel pnlBackgroundImage;
    private JPanel pnlBackgroundPreview;
    private JPanel pnlBackgroundPreviewContainer;
    private JPanel pnlBlackColourPreview;
    private JPanel pnlBlackColourPreviewContainer;
    private JPanel pnlBlacklistTab;
    private JEditorPane pnlEditorPane;
    private JPanel pnlFooter;
    private JPanel pnlGeneral;
    private JPanel pnlInteractiveButtons;
    private JTabbedPane pnlInteractiveTabs;
    private JPanel pnlInteractiveWindows;
    private JPanel pnlPrimaryColour1Preview;
    private JPanel pnlPrimaryColour1PreviewContainer;
    private JPanel pnlPrimaryColour2Preview;
    private JPanel pnlPrimaryColour2PreviewContainer;
    private JScrollPane pnlScrollPane;
    private JPanel pnlSecondaryColour1Preview;
    private JPanel pnlSecondaryColour1PreviewContainer;
    private JPanel pnlSecondaryColour2Preview;
    private JPanel pnlSecondaryColour2PreviewContainer;
    private JPanel pnlSecondaryColour3Preview;
    private JPanel pnlSecondaryColour3PreviewContainer;
    private JTabbedPane pnlTabs;
    private JPanel pnlTheme;
    private JPanel pnlThemeButtons;
    private JPanel pnlWhiteColourPreview;
    private JPanel pnlWhiteColourPreviewContainer;
    private JPanel pnlWhitelistTab;
    private JPanel pnlWindowMode;
    private JRadioButton radFilterBicubic;
    private JRadioButton radFilterHqx;
    private JRadioButton radFilterNearest;
    private Box.Filler rigid1;
    private Box.Filler rigid2;
    private Box.Filler rigid3;
    private Box.Filler rigid4;
    private JSlider sldMenuOpacity;
    private JSlider sldOpacity;
    private JSlider sldScaling;
    private JSpinner spnWindowHeight;
    private JSpinner spnWindowWidth;
    private JTextField txtBackgroundColour;
    private JTextField txtBlackColour;
    private JTextField txtPrimaryColour1;
    private JTextField txtPrimaryColour2;
    private JTextField txtSecondaryColour1;
    private JTextField txtSecondaryColour2;
    private JTextField txtSecondaryColour3;
    private JTextField txtWhiteColour;

    public SettingsWindow(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void init() {
        this.setLocationRelativeTo(null);
        this.grpFilter.add(this.radFilterNearest);
        this.grpFilter.add(this.radFilterBicubic);
        this.grpFilter.add(this.radFilterHqx);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int index = 0; index < 9; ++index) {
            labelTable.put(index * 10, new JLabel(index + "x"));
        }
        this.sldScaling.setLabelTable(labelTable);
        this.sldScaling.setPaintLabels(true);
        this.sldScaling.setSnapToTicks(true);
        Properties properties = Main.getInstance().getProperties();
        this.alwaysShowShimejiChooser = Boolean.parseBoolean(properties.getProperty("AlwaysShowShimejiChooser", "false"));
        this.alwaysShowInformationScreen = Boolean.parseBoolean(properties.getProperty("AlwaysShowInformationScreen", "false"));
        String filterText = Main.getInstance().getProperties().getProperty("Filter", "false");
        this.filter = "nearest";
        if (filterText.equalsIgnoreCase("true") || filterText.equalsIgnoreCase("hqx")) {
            this.filter = "hqx";
        } else if (filterText.equalsIgnoreCase("bicubic")) {
            this.filter = "bicubic";
        }
        this.opacity = Double.parseDouble(properties.getProperty("Opacity", "1.0"));
        this.scaling = Double.parseDouble(properties.getProperty("Scaling", "1.0"));
        this.windowedMode = properties.getProperty("Environment", "generic").equals("virtual");
        String[] windowArray = properties.getProperty("WindowSize", "600x500").split("x");
        this.windowSize = new Dimension(Integer.parseInt(windowArray[0]), Integer.parseInt(windowArray[1]));
        this.backgroundColour = Color.decode(properties.getProperty("Background", "#00FF00"));
        this.backgroundImage = properties.getProperty("BackgroundImage", "");
        this.backgroundMode = properties.getProperty("BackgroundMode", "centre");
        float menuScaling = Float.parseFloat(properties.getProperty("MenuDPI", "96")) / 96.0f;
        this.chkAlwaysShowShimejiChooser.setSelected(this.alwaysShowShimejiChooser);
        this.chkAlwaysShowInformationScreen.setSelected(this.alwaysShowInformationScreen);
        if (this.filter.equals("bicubic")) {
            this.radFilterBicubic.setSelected(true);
        } else if (this.filter.equals("hqx")) {
            this.radFilterHqx.setSelected(true);
        } else {
            this.radFilterNearest.setSelected(true);
        }
        this.sldOpacity.setValue((int)(this.opacity * 100.0));
        this.sldScaling.setValue((int)(this.scaling * 10.0));
        for (String item : properties.getProperty("InteractiveWindows", "").split("/")) {
            if (item.isEmpty()) continue;
            this.listData.add(item);
        }
        this.lstInteractiveWindows.setListData(this.listData.toArray());
        for (String item : properties.getProperty("InteractiveWindowsBlacklist", "").split("/")) {
            if (item.isEmpty()) continue;
            this.blacklistData.add(item);
        }
        this.lstInteractiveWindowsBlacklist.setListData(this.blacklistData.toArray());
        Properties themeProperties = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.themePath.toFile());
            themeProperties.load(input);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.primaryColour1 = Color.decode(themeProperties.getProperty("nimrodlf.p1", "#1EA6EB"));
        this.primaryColour2 = Color.decode(themeProperties.getProperty("nimrodlf.p2", "#28B0F5"));
        this.primaryColour3 = Color.decode(themeProperties.getProperty("nimrodlf.p3", "#32BAFF"));
        this.secondaryColour1 = Color.decode(themeProperties.getProperty("nimrodlf.s1", "#BCBCBE"));
        this.secondaryColour2 = Color.decode(themeProperties.getProperty("nimrodlf.s2", "#C6C6C8"));
        this.secondaryColour3 = Color.decode(themeProperties.getProperty("nimrodlf.s3", "#D0D0D2"));
        this.blackColour = Color.decode(themeProperties.getProperty("nimrodlf.b", "#000000"));
        this.whiteColour = Color.decode(themeProperties.getProperty("nimrodlf.w", "#FFFFFF"));
        this.menuOpacity = Integer.parseInt(properties.getProperty("nimrodlf.menuOpacity", "255")) / 255;
        this.font = Font.decode(themeProperties.getProperty("nimrodlf.font", "SansSerif-PLAIN-12"));
        this.font = this.font.deriveFont((float)this.font.getSize() * menuScaling);
        this.pnlPrimaryColour1Preview.setBackground(this.primaryColour1);
        this.txtPrimaryColour1.setText(String.format("#%02X%02X%02X", this.primaryColour1.getRed(), this.primaryColour1.getGreen(), this.primaryColour1.getBlue()));
        this.pnlPrimaryColour2Preview.setBackground(this.primaryColour2);
        this.txtPrimaryColour2.setText(String.format("#%02X%02X%02X", this.primaryColour2.getRed(), this.primaryColour2.getGreen(), this.primaryColour2.getBlue()));
        this.pnlSecondaryColour1Preview.setBackground(this.secondaryColour1);
        this.txtSecondaryColour1.setText(String.format("#%02X%02X%02X", this.secondaryColour1.getRed(), this.secondaryColour1.getGreen(), this.secondaryColour1.getBlue()));
        this.pnlSecondaryColour2Preview.setBackground(this.secondaryColour2);
        this.txtSecondaryColour2.setText(String.format("#%02X%02X%02X", this.secondaryColour2.getRed(), this.secondaryColour2.getGreen(), this.secondaryColour2.getBlue()));
        this.pnlSecondaryColour3Preview.setBackground(this.secondaryColour3);
        this.txtSecondaryColour3.setText(String.format("#%02X%02X%02X", this.secondaryColour3.getRed(), this.secondaryColour3.getGreen(), this.secondaryColour3.getBlue()));
        this.pnlBlackColourPreview.setBackground(this.blackColour);
        this.txtBlackColour.setText(String.format("#%02X%02X%02X", this.blackColour.getRed(), this.blackColour.getGreen(), this.blackColour.getBlue()));
        this.pnlWhiteColourPreview.setBackground(this.whiteColour);
        this.txtWhiteColour.setText(String.format("#%02X%02X%02X", this.whiteColour.getRed(), this.whiteColour.getGreen(), this.whiteColour.getBlue()));
        this.theme = new NimRODTheme();
        this.theme.setPrimary1(this.primaryColour1);
        this.theme.setPrimary2(this.primaryColour2);
        this.theme.setPrimary3(this.primaryColour3);
        this.theme.setSecondary1(this.secondaryColour1);
        this.theme.setSecondary2(this.secondaryColour2);
        this.theme.setSecondary3(this.secondaryColour3);
        this.theme.setBlack(this.blackColour);
        this.theme.setWhite(this.whiteColour);
        this.sldMenuOpacity.setValue((int)(this.menuOpacity * 100.0));
        this.theme.setFont(this.font);
        this.oldTheme = new NimRODTheme();
        this.oldTheme.setPrimary1(this.primaryColour1);
        this.oldTheme.setPrimary2(this.primaryColour2);
        this.oldTheme.setPrimary3(this.primaryColour3);
        this.oldTheme.setSecondary1(this.secondaryColour1);
        this.oldTheme.setSecondary2(this.secondaryColour2);
        this.oldTheme.setSecondary3(this.secondaryColour3);
        this.oldTheme.setBlack(this.blackColour);
        this.oldTheme.setWhite(this.whiteColour);
        this.oldTheme.setMenuOpacity((int)(this.menuOpacity * 255.0));
        this.oldTheme.setFont(this.font);
        this.lookAndFeel = (NimRODLookAndFeel)UIManager.getLookAndFeel();
        this.chkWindowModeEnabled.setSelected(this.windowedMode);
        this.spnWindowWidth.setBackground(this.txtBackgroundColour.getBackground());
        this.spnWindowHeight.setBackground(this.txtBackgroundColour.getBackground());
        this.spnWindowWidth.setEnabled(this.windowedMode);
        this.spnWindowHeight.setEnabled(this.windowedMode);
        this.spnWindowWidth.setValue(this.windowSize.width);
        this.spnWindowHeight.setValue(this.windowSize.height);
        this.txtBackgroundColour.setText(String.format("#%02X%02X%02X", this.backgroundColour.getRed(), this.backgroundColour.getGreen(), this.backgroundColour.getBlue()));
        this.btnBackgroundColourChange.setEnabled(this.windowedMode);
        this.btnBackgroundImageChange.setEnabled(this.windowedMode);
        this.pnlBackgroundPreview.setBackground(this.backgroundColour);
        if (this.backgroundImage != null) {
            try {
                Dimension size = this.pnlBackgroundImage.getPreferredSize();
                this.refreshBackgroundImage();
                this.pnlBackgroundImage.setPreferredSize(size);
            }
            catch (Exception e) {
                this.backgroundImage = null;
                this.lblBackgroundImage.setIcon(null);
            }
        }
        this.cmbBackgroundImageMode.setEnabled(this.windowedMode != false && this.backgroundImage != null);
        this.btnBackgroundImageRemove.setEnabled(this.windowedMode != false && this.backgroundImage != null);
        ResourceBundle language = Main.getInstance().getLanguageBundle();
        this.setTitle(language.getString("Settings"));
        this.pnlTabs.setTitleAt(0, language.getString("General"));
        this.pnlTabs.setTitleAt(1, language.getString("InteractiveWindows"));
        this.pnlTabs.setTitleAt(2, language.getString("Theme"));
        this.pnlTabs.setTitleAt(3, language.getString("WindowMode"));
        this.pnlTabs.setTitleAt(4, language.getString("About"));
        this.lblShimejiEE.setText(language.getString("ShimejiEE"));
        this.lblDevelopedBy.setText(language.getString("DevelopedBy"));
        this.chkAlwaysShowShimejiChooser.setText(language.getString("AlwaysShowShimejiChooser"));
        this.chkAlwaysShowInformationScreen.setText(language.getString("AlwaysShowInformationScreen"));
        this.lblOpacity.setText(language.getString("Opacity"));
        this.lblScaling.setText(language.getString("Scaling"));
        this.lblFilter.setText(language.getString("FilterOptions"));
        this.radFilterNearest.setText(language.getString("NearestNeighbour"));
        this.radFilterHqx.setText(language.getString("Filter"));
        this.radFilterBicubic.setText(language.getString("BicubicFilter"));
        this.pnlInteractiveTabs.setTitleAt(0, language.getString("Whitelist"));
        this.pnlInteractiveTabs.setTitleAt(1, language.getString("Blacklist"));
        this.btnAddInteractiveWindow.setText(language.getString("Add"));
        this.btnRemoveInteractiveWindow.setText(language.getString("Remove"));
        this.lblPrimaryColour1.setText(language.getString("PrimaryColour1"));
        this.lblPrimaryColour2.setText(language.getString("PrimaryColour2"));
        this.lblSecondaryColour1.setText(language.getString("SecondaryColour1"));
        this.lblSecondaryColour2.setText(language.getString("SecondaryColour2"));
        this.lblSecondaryColour3.setText(language.getString("SecondaryColour3"));
        this.lblBlackColour.setText(language.getString("BlackColour"));
        this.lblWhiteColour.setText(language.getString("WhiteColour"));
        this.lblMenuOpacity.setText(language.getString("MenuOpacity"));
        this.btnChangeFont.setText(language.getString("ChangeFont"));
        this.btnReset.setText(language.getString("Reset"));
        this.chkWindowModeEnabled.setText(language.getString("WindowedModeEnabled"));
        this.lblDimensions.setText(language.getString("Dimensions"));
        this.lblBackground.setText(language.getString("Background"));
        this.btnBackgroundColourChange.setText(language.getString("Change"));
        this.btnBackgroundImageChange.setText(language.getString("Change"));
        this.cmbBackgroundImageMode.addItem(language.getString("BackgroundModeCentre"));
        this.cmbBackgroundImageMode.addItem(language.getString("BackgroundModeFill"));
        this.cmbBackgroundImageMode.addItem(language.getString("BackgroundModeFit"));
        this.cmbBackgroundImageMode.addItem(language.getString("BackgroundModeStretch"));
        this.btnBackgroundImageRemove.setText(language.getString("Remove"));
        this.lblShimejiEE.setText(language.getString("ShimejiEE"));
        this.lblDevelopedBy.setText(language.getString("DevelopedBy"));
        this.btnWebsite.setText(language.getString("Website"));
        this.btnDone.setText(language.getString("Done"));
        this.btnCancel.setText(language.getString("Cancel"));
        for (int index = 0; index < this.backgroundModes.length; ++index) {
            if (!this.backgroundMode.equals(this.backgroundModes[index])) continue;
            this.cmbBackgroundImageMode.setSelectedIndex(index);
            break;
        }
    }

    public boolean display() {
        float menuScaling = Float.parseFloat(Main.getInstance().getProperties().getProperty("MenuDPI", "96")) / 96.0f;
        this.getContentPane().setPreferredSize(new Dimension((int)(600.0f * menuScaling), (int)(497.0f * menuScaling)));
        this.sldOpacity.setPreferredSize(new Dimension((int)((float)this.sldOpacity.getPreferredSize().width * menuScaling), (int)((float)this.sldOpacity.getPreferredSize().height * menuScaling)));
        this.sldScaling.setPreferredSize(new Dimension((int)((float)this.sldScaling.getPreferredSize().width * menuScaling), (int)((float)this.sldScaling.getPreferredSize().height * menuScaling)));
        this.btnAddInteractiveWindow.setPreferredSize(new Dimension((int)((float)this.btnAddInteractiveWindow.getPreferredSize().width * menuScaling), (int)((float)this.btnAddInteractiveWindow.getPreferredSize().height * menuScaling)));
        this.btnRemoveInteractiveWindow.setPreferredSize(new Dimension((int)((float)this.btnRemoveInteractiveWindow.getPreferredSize().width * menuScaling), (int)((float)this.btnRemoveInteractiveWindow.getPreferredSize().height * menuScaling)));
        this.pnlInteractiveButtons.setPreferredSize(new Dimension(this.pnlInteractiveButtons.getPreferredSize().width, this.btnAddInteractiveWindow.getPreferredSize().height + 6));
        this.txtPrimaryColour1.setPreferredSize(new Dimension((int)((float)this.txtPrimaryColour1.getPreferredSize().width * menuScaling), (int)((float)this.txtPrimaryColour1.getPreferredSize().height * menuScaling)));
        this.txtPrimaryColour2.setPreferredSize(new Dimension((int)((float)this.txtPrimaryColour2.getPreferredSize().width * menuScaling), (int)((float)this.txtPrimaryColour2.getPreferredSize().height * menuScaling)));
        this.txtSecondaryColour1.setPreferredSize(new Dimension((int)((float)this.txtSecondaryColour1.getPreferredSize().width * menuScaling), (int)((float)this.txtSecondaryColour1.getPreferredSize().height * menuScaling)));
        this.txtSecondaryColour2.setPreferredSize(new Dimension((int)((float)this.txtSecondaryColour2.getPreferredSize().width * menuScaling), (int)((float)this.txtSecondaryColour2.getPreferredSize().height * menuScaling)));
        this.txtSecondaryColour3.setPreferredSize(new Dimension((int)((float)this.txtSecondaryColour3.getPreferredSize().width * menuScaling), (int)((float)this.txtSecondaryColour3.getPreferredSize().height * menuScaling)));
        this.txtBlackColour.setPreferredSize(new Dimension((int)((float)this.txtBlackColour.getPreferredSize().width * menuScaling), (int)((float)this.txtBlackColour.getPreferredSize().height * menuScaling)));
        this.txtWhiteColour.setPreferredSize(new Dimension((int)((float)this.txtWhiteColour.getPreferredSize().width * menuScaling), (int)((float)this.txtWhiteColour.getPreferredSize().height * menuScaling)));
        this.pnlPrimaryColour1PreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlPrimaryColour1PreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlPrimaryColour1PreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlPrimaryColour1Preview.setPreferredSize(new Dimension((int)((float)this.pnlPrimaryColour1Preview.getPreferredSize().width * menuScaling), (int)((float)this.pnlPrimaryColour1Preview.getPreferredSize().height * menuScaling)));
        this.pnlPrimaryColour2PreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlPrimaryColour2PreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlPrimaryColour2PreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlPrimaryColour2Preview.setPreferredSize(new Dimension((int)((float)this.pnlPrimaryColour2Preview.getPreferredSize().width * menuScaling), (int)((float)this.pnlPrimaryColour2Preview.getPreferredSize().height * menuScaling)));
        this.pnlSecondaryColour1PreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlSecondaryColour1PreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlSecondaryColour1PreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlSecondaryColour1Preview.setPreferredSize(new Dimension((int)((float)this.pnlSecondaryColour1Preview.getPreferredSize().width * menuScaling), (int)((float)this.pnlSecondaryColour1Preview.getPreferredSize().height * menuScaling)));
        this.pnlSecondaryColour2PreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlSecondaryColour2PreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlSecondaryColour2PreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlSecondaryColour2Preview.setPreferredSize(new Dimension((int)((float)this.pnlSecondaryColour2Preview.getPreferredSize().width * menuScaling), (int)((float)this.pnlSecondaryColour2Preview.getPreferredSize().height * menuScaling)));
        this.pnlSecondaryColour3PreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlSecondaryColour3PreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlSecondaryColour3PreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlSecondaryColour3Preview.setPreferredSize(new Dimension((int)((float)this.pnlSecondaryColour3Preview.getPreferredSize().width * menuScaling), (int)((float)this.pnlSecondaryColour3Preview.getPreferredSize().height * menuScaling)));
        this.pnlBlackColourPreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlBlackColourPreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlBlackColourPreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlBlackColourPreview.setPreferredSize(new Dimension((int)((float)this.pnlBlackColourPreview.getPreferredSize().width * menuScaling), (int)((float)this.pnlBlackColourPreview.getPreferredSize().height * menuScaling)));
        this.pnlWhiteColourPreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlWhiteColourPreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlWhiteColourPreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlWhiteColourPreview.setPreferredSize(new Dimension((int)((float)this.pnlWhiteColourPreview.getPreferredSize().width * menuScaling), (int)((float)this.pnlWhiteColourPreview.getPreferredSize().height * menuScaling)));
        this.btnPrimaryColour1Change.setPreferredSize(new Dimension((int)((float)this.btnPrimaryColour1Change.getPreferredSize().width * menuScaling), (int)((float)this.btnPrimaryColour1Change.getPreferredSize().height * menuScaling)));
        this.btnPrimaryColour2Change.setPreferredSize(new Dimension((int)((float)this.btnPrimaryColour2Change.getPreferredSize().width * menuScaling), (int)((float)this.btnPrimaryColour2Change.getPreferredSize().height * menuScaling)));
        this.btnSecondaryColour1Change.setPreferredSize(new Dimension((int)((float)this.btnSecondaryColour1Change.getPreferredSize().width * menuScaling), (int)((float)this.btnSecondaryColour1Change.getPreferredSize().height * menuScaling)));
        this.btnSecondaryColour2Change.setPreferredSize(new Dimension((int)((float)this.btnSecondaryColour2Change.getPreferredSize().width * menuScaling), (int)((float)this.btnSecondaryColour2Change.getPreferredSize().height * menuScaling)));
        this.btnSecondaryColour3Change.setPreferredSize(new Dimension((int)((float)this.btnSecondaryColour3Change.getPreferredSize().width * menuScaling), (int)((float)this.btnSecondaryColour3Change.getPreferredSize().height * menuScaling)));
        this.btnBlackColourChange.setPreferredSize(new Dimension((int)((float)this.btnBlackColourChange.getPreferredSize().width * menuScaling), (int)((float)this.btnBlackColourChange.getPreferredSize().height * menuScaling)));
        this.btnWhiteColourChange.setPreferredSize(new Dimension((int)((float)this.btnWhiteColourChange.getPreferredSize().width * menuScaling), (int)((float)this.btnWhiteColourChange.getPreferredSize().height * menuScaling)));
        this.sldMenuOpacity.setPreferredSize(new Dimension((int)((float)this.sldMenuOpacity.getPreferredSize().width * menuScaling), (int)((float)this.sldMenuOpacity.getPreferredSize().height * menuScaling)));
        this.btnChangeFont.setPreferredSize(new Dimension((int)((float)this.btnChangeFont.getPreferredSize().width * menuScaling), (int)((float)this.btnChangeFont.getPreferredSize().height * menuScaling)));
        this.btnReset.setPreferredSize(new Dimension((int)((float)this.btnReset.getPreferredSize().width * menuScaling), (int)((float)this.btnReset.getPreferredSize().height * menuScaling)));
        this.pnlThemeButtons.setPreferredSize(new Dimension(this.pnlThemeButtons.getPreferredSize().width, this.btnReset.getPreferredSize().height + 6));
        this.spnWindowWidth.setPreferredSize(new Dimension((int)((float)this.spnWindowWidth.getPreferredSize().width * menuScaling), (int)((float)this.spnWindowWidth.getPreferredSize().height * menuScaling)));
        this.spnWindowHeight.setPreferredSize(new Dimension((int)((float)this.spnWindowHeight.getPreferredSize().width * menuScaling), (int)((float)this.spnWindowHeight.getPreferredSize().height * menuScaling)));
        this.txtBackgroundColour.setPreferredSize(new Dimension((int)((float)this.txtBackgroundColour.getPreferredSize().width * menuScaling), (int)((float)this.txtBackgroundColour.getPreferredSize().height * menuScaling)));
        this.pnlBackgroundPreviewContainer.setPreferredSize(new Dimension((int)((float)this.pnlBackgroundPreviewContainer.getPreferredSize().width * menuScaling), (int)((float)this.pnlBackgroundPreviewContainer.getPreferredSize().height * menuScaling)));
        this.pnlBackgroundPreview.setPreferredSize(new Dimension((int)((float)this.pnlBackgroundPreview.getPreferredSize().width * menuScaling), (int)((float)this.pnlBackgroundPreview.getPreferredSize().height * menuScaling)));
        this.btnBackgroundColourChange.setPreferredSize(new Dimension((int)((float)this.btnBackgroundColourChange.getPreferredSize().width * menuScaling), (int)((float)this.btnBackgroundColourChange.getPreferredSize().height * menuScaling)));
        this.btnBackgroundImageChange.setPreferredSize(new Dimension((int)((float)this.btnBackgroundImageChange.getPreferredSize().width * menuScaling), (int)((float)this.btnBackgroundImageChange.getPreferredSize().height * menuScaling)));
        this.btnBackgroundImageRemove.setPreferredSize(new Dimension((int)((float)this.btnBackgroundImageRemove.getPreferredSize().width * menuScaling), (int)((float)this.btnBackgroundImageRemove.getPreferredSize().height * menuScaling)));
        this.cmbBackgroundImageMode.setPreferredSize(this.btnBackgroundImageRemove.getPreferredSize());
        this.pnlBackgroundImage.setPreferredSize(new Dimension((int)((float)this.pnlBackgroundImage.getPreferredSize().width * menuScaling), (int)((float)this.pnlBackgroundImage.getPreferredSize().height * menuScaling)));
        this.pnlBackgroundImage.setMaximumSize(this.pnlBackgroundImage.getPreferredSize());
        this.lblIcon.setPreferredSize(new Dimension((int)((float)this.lblIcon.getPreferredSize().width * menuScaling), (int)((float)this.lblIcon.getPreferredSize().height * menuScaling)));
        this.lblIcon.setMaximumSize(this.lblIcon.getPreferredSize());
        if (this.getIconImages().size() > 0) {
            this.lblIcon.setIcon(new ImageIcon(this.getIconImages().get(0).getScaledInstance(this.lblIcon.getPreferredSize().width, this.lblIcon.getPreferredSize().height, 1)));
        }
        this.btnWebsite.setPreferredSize(new Dimension((int)((float)this.btnWebsite.getPreferredSize().width * menuScaling), (int)((float)this.btnWebsite.getPreferredSize().height * menuScaling)));
        this.btnDiscord.setPreferredSize(new Dimension((int)((float)this.btnDiscord.getPreferredSize().width * menuScaling), (int)((float)this.btnDiscord.getPreferredSize().height * menuScaling)));
        this.btnPatreon.setPreferredSize(new Dimension((int)((float)this.btnPatreon.getPreferredSize().width * menuScaling), (int)((float)this.btnPatreon.getPreferredSize().height * menuScaling)));
        this.pnlAboutButtons.setPreferredSize(new Dimension(this.pnlAboutButtons.getPreferredSize().width, this.btnWebsite.getPreferredSize().height + 6));
        this.btnDone.setPreferredSize(new Dimension((int)((float)this.btnDone.getPreferredSize().width * menuScaling), (int)((float)this.btnDone.getPreferredSize().height * menuScaling)));
        this.btnCancel.setPreferredSize(new Dimension((int)((float)this.btnCancel.getPreferredSize().width * menuScaling), (int)((float)this.btnCancel.getPreferredSize().height * menuScaling)));
        this.pnlFooter.setPreferredSize(new Dimension(this.pnlFooter.getPreferredSize().width, this.btnDone.getPreferredSize().height + 6));
        this.pack();
        this.suppressTextChanged = false;
        this.setVisible(true);
        this.suppressTextChanged = true;
        return true;
    }

    private void browseToUrl(String url) {
        try {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) {
                throw new UnsupportedOperationException(Main.getInstance().getLanguageBundle().getString("FailedOpenWebBrowserErrorMessage") + " " + url);
            }
            desktop.browse(new URI(url));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error", -1);
        }
    }

    public boolean getEnvironmentReloadRequired() {
        return this.environmentReloadRequired;
    }

    public boolean getImageReloadRequired() {
        return this.imageReloadRequired;
    }

    public boolean getInteractiveWindowReloadRequired() {
        return this.interactiveWindowReloadRequired;
    }

    private void initComponents() {
        this.grpFilter = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.pnlTabs = new JTabbedPane();
        this.pnlGeneral = new JPanel();
        this.chkAlwaysShowShimejiChooser = new JCheckBox();
        this.lblScaling = new JLabel();
        this.sldScaling = new JSlider();
        this.lblFilter = new JLabel();
        this.radFilterNearest = new JRadioButton();
        this.radFilterBicubic = new JRadioButton();
        this.radFilterHqx = new JRadioButton();
        this.sldOpacity = new JSlider();
        this.lblOpacity = new JLabel();
        this.chkAlwaysShowInformationScreen = new JCheckBox();
        this.pnlInteractiveWindows = new JPanel();
        this.pnlInteractiveTabs = new JTabbedPane();
        this.pnlWhitelistTab = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lstInteractiveWindows = new JList();
        this.pnlBlacklistTab = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lstInteractiveWindowsBlacklist = new JList();
        this.pnlInteractiveButtons = new JPanel();
        this.btnAddInteractiveWindow = new JButton();
        this.btnRemoveInteractiveWindow = new JButton();
        this.pnlTheme = new JPanel();
        this.pnlThemeButtons = new JPanel();
        this.btnChangeFont = new JButton();
        this.btnReset = new JButton();
        this.lblPrimaryColour1 = new JLabel();
        this.txtPrimaryColour1 = new JTextField();
        this.pnlPrimaryColour1PreviewContainer = new JPanel();
        this.gluePrimaryColour1a = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlPrimaryColour1Preview = new JPanel();
        this.gluePrimaryColour1b = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.btnPrimaryColour1Change = new JButton();
        this.lblPrimaryColour2 = new JLabel();
        this.txtPrimaryColour2 = new JTextField();
        this.pnlPrimaryColour2PreviewContainer = new JPanel();
        this.gluePrimaryColour2a = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlPrimaryColour2Preview = new JPanel();
        this.gluePrimaryColour2b = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.btnPrimaryColour2Change = new JButton();
        this.lblSecondaryColour1 = new JLabel();
        this.txtSecondaryColour1 = new JTextField();
        this.pnlSecondaryColour1PreviewContainer = new JPanel();
        this.glueSecondaryColour1a = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlSecondaryColour1Preview = new JPanel();
        this.glueSecondaryColour1b = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.btnSecondaryColour1Change = new JButton();
        this.lblSecondaryColour2 = new JLabel();
        this.txtSecondaryColour2 = new JTextField();
        this.pnlSecondaryColour2PreviewContainer = new JPanel();
        this.glueSecondaryColour2a = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlSecondaryColour2Preview = new JPanel();
        this.glueSecondaryColour2b = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.btnSecondaryColour2Change = new JButton();
        this.lblSecondaryColour3 = new JLabel();
        this.txtSecondaryColour3 = new JTextField();
        this.pnlSecondaryColour3PreviewContainer = new JPanel();
        this.glueSecondaryColour3a = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlSecondaryColour3Preview = new JPanel();
        this.glueSecondaryColour3b = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.btnSecondaryColour3Change = new JButton();
        this.lblMenuOpacity = new JLabel();
        this.sldMenuOpacity = new JSlider();
        this.lblBlackColour = new JLabel();
        this.txtBlackColour = new JTextField();
        this.pnlBlackColourPreviewContainer = new JPanel();
        this.glueBlackColoura = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlBlackColourPreview = new JPanel();
        this.glueBlackColourb = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.btnBlackColourChange = new JButton();
        this.lblWhiteColour = new JLabel();
        this.txtWhiteColour = new JTextField();
        this.pnlWhiteColourPreviewContainer = new JPanel();
        this.glueWhiteColoura = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlWhiteColourPreview = new JPanel();
        this.glueWhiteColourb = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.btnWhiteColourChange = new JButton();
        this.pnlScrollPane = new JScrollPane();
        this.pnlEditorPane = new JEditorPane();
        this.pnlWindowMode = new JPanel();
        this.chkWindowModeEnabled = new JCheckBox();
        this.lblDimensions = new JLabel();
        this.lblDimensionsX = new JLabel();
        this.lblBackground = new JLabel();
        this.txtBackgroundColour = new JTextField();
        this.btnBackgroundColourChange = new JButton();
        this.spnWindowWidth = new JSpinner();
        this.spnWindowHeight = new JSpinner();
        this.lblBackgroundColour = new JLabel();
        this.pnlBackgroundPreviewContainer = new JPanel();
        this.glueBackground = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlBackgroundPreview = new JPanel();
        this.glueBackground2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.lblBackgroundImageCaption = new JLabel();
        this.pnlBackgroundImage = new JPanel();
        this.lblBackgroundImage = new JLabel();
        this.btnBackgroundImageChange = new JButton();
        this.btnBackgroundImageRemove = new JButton();
        this.cmbBackgroundImageMode = new JComboBox();
        this.pnlAbout = new JPanel();
        this.glue1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.lblIcon = new JLabel();
        this.rigid1 = new Box.Filler(new Dimension(0, 15), new Dimension(0, 15), new Dimension(0, 15));
        this.lblShimejiEE = new JLabel();
        this.rigid2 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 5), new Dimension(0, 10));
        this.lblVersion = new JLabel();
        this.rigid3 = new Box.Filler(new Dimension(0, 15), new Dimension(0, 15), new Dimension(0, 15));
        this.lblDevelopedBy = new JLabel();
        this.lblKilkakon = new JLabel();
        this.rigid4 = new Box.Filler(new Dimension(0, 30), new Dimension(0, 30), new Dimension(0, 30));
        this.pnlAboutButtons = new JPanel();
        this.btnWebsite = new JButton();
        this.btnDiscord = new JButton();
        this.btnPatreon = new JButton();
        this.glue2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlFooter = new JPanel();
        this.btnDone = new JButton();
        this.btnCancel = new JButton();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.setDefaultCloseOperation(2);
        this.chkAlwaysShowShimejiChooser.setText("Always Show Shimeji Chooser");
        this.chkAlwaysShowShimejiChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SettingsWindow.this.chkAlwaysShowShimejiChooserItemStateChanged(evt);
            }
        });
        this.lblScaling.setText("Scaling");
        this.sldScaling.setMajorTickSpacing(10);
        this.sldScaling.setMaximum(80);
        this.sldScaling.setMinorTickSpacing(5);
        this.sldScaling.setPaintLabels(true);
        this.sldScaling.setPaintTicks(true);
        this.sldScaling.setSnapToTicks(true);
        this.sldScaling.setValue(10);
        this.sldScaling.setPreferredSize(new Dimension(300, 45));
        this.sldScaling.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsWindow.this.sldScalingStateChanged(evt);
            }
        });
        this.lblFilter.setText("Filter");
        this.radFilterNearest.setText("Nearest");
        this.radFilterNearest.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SettingsWindow.this.radFilterItemStateChanged(evt);
            }
        });
        this.radFilterBicubic.setText("Bicubic");
        this.radFilterBicubic.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SettingsWindow.this.radFilterItemStateChanged(evt);
            }
        });
        this.radFilterHqx.setText("hqx");
        this.radFilterHqx.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SettingsWindow.this.radFilterItemStateChanged(evt);
            }
        });
        this.sldOpacity.setMajorTickSpacing(10);
        this.sldOpacity.setMinorTickSpacing(5);
        this.sldOpacity.setPaintLabels(true);
        this.sldOpacity.setPaintTicks(true);
        this.sldOpacity.setSnapToTicks(true);
        this.sldOpacity.setValue(10);
        this.sldOpacity.setPreferredSize(new Dimension(300, 45));
        this.sldOpacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsWindow.this.sldOpacityStateChanged(evt);
            }
        });
        this.lblOpacity.setText("Opacity");
        this.chkAlwaysShowInformationScreen.setText("Always Show Information Screen");
        this.chkAlwaysShowInformationScreen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SettingsWindow.this.chkAlwaysShowInformationScreenItemStateChanged(evt);
            }
        });
        GroupLayout pnlGeneralLayout = new GroupLayout(this.pnlGeneral);
        this.pnlGeneral.setLayout(pnlGeneralLayout);
        pnlGeneralLayout.setHorizontalGroup(pnlGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlGeneralLayout.createSequentialGroup().addContainerGap().addGroup(pnlGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkAlwaysShowShimejiChooser).addComponent(this.lblFilter).addComponent(this.lblScaling).addGroup(pnlGeneralLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(pnlGeneralLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sldOpacity, -2, -1, -2).addGroup(pnlGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radFilterNearest).addComponent(this.sldScaling, -2, -1, -2).addComponent(this.radFilterBicubic).addComponent(this.radFilterHqx)))).addComponent(this.lblOpacity).addComponent(this.chkAlwaysShowInformationScreen)).addContainerGap(26, Short.MAX_VALUE)));
        pnlGeneralLayout.setVerticalGroup(pnlGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlGeneralLayout.createSequentialGroup().addContainerGap().addComponent(this.chkAlwaysShowShimejiChooser).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkAlwaysShowInformationScreen).addGap(18, 18, 18).addComponent(this.lblOpacity).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sldOpacity, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblScaling).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sldScaling, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radFilterNearest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radFilterBicubic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radFilterHqx).addContainerGap(40, Short.MAX_VALUE)));
        this.pnlTabs.addTab("General", this.pnlGeneral);
        this.lstInteractiveWindows.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.lstInteractiveWindows);
        GroupLayout pnlWhitelistTabLayout = new GroupLayout(this.pnlWhitelistTab);
        this.pnlWhitelistTab.setLayout(pnlWhitelistTabLayout);
        pnlWhitelistTabLayout.setHorizontalGroup(pnlWhitelistTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWhitelistTabLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 301, Short.MAX_VALUE).addContainerGap()));
        pnlWhitelistTabLayout.setVerticalGroup(pnlWhitelistTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWhitelistTabLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 237, Short.MAX_VALUE).addContainerGap()));
        this.pnlInteractiveTabs.addTab("Whitelist", this.pnlWhitelistTab);
        this.lstInteractiveWindowsBlacklist.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.lstInteractiveWindowsBlacklist);
        GroupLayout pnlBlacklistTabLayout = new GroupLayout(this.pnlBlacklistTab);
        this.pnlBlacklistTab.setLayout(pnlBlacklistTabLayout);
        pnlBlacklistTabLayout.setHorizontalGroup(pnlBlacklistTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlBlacklistTabLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 301, Short.MAX_VALUE).addContainerGap()));
        pnlBlacklistTabLayout.setVerticalGroup(pnlBlacklistTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlBlacklistTabLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 237, Short.MAX_VALUE).addContainerGap()));
        this.pnlInteractiveTabs.addTab("Blacklist", this.pnlBlacklistTab);
        this.pnlInteractiveButtons.setPreferredSize(new Dimension(380, 36));
        this.pnlInteractiveButtons.setLayout(new FlowLayout(1, 10, 5));
        this.btnAddInteractiveWindow.setText("Add");
        this.btnAddInteractiveWindow.setMaximumSize(new Dimension(130, 26));
        this.btnAddInteractiveWindow.setMinimumSize(new Dimension(95, 23));
        this.btnAddInteractiveWindow.setName("");
        this.btnAddInteractiveWindow.setPreferredSize(new Dimension(130, 26));
        this.btnAddInteractiveWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnAddInteractiveWindowActionPerformed(evt);
            }
        });
        this.pnlInteractiveButtons.add(this.btnAddInteractiveWindow);
        this.btnRemoveInteractiveWindow.setText("Remove");
        this.btnRemoveInteractiveWindow.setMaximumSize(new Dimension(130, 26));
        this.btnRemoveInteractiveWindow.setMinimumSize(new Dimension(95, 23));
        this.btnRemoveInteractiveWindow.setPreferredSize(new Dimension(130, 26));
        this.btnRemoveInteractiveWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnRemoveInteractiveWindowActionPerformed(evt);
            }
        });
        this.pnlInteractiveButtons.add(this.btnRemoveInteractiveWindow);
        GroupLayout pnlInteractiveWindowsLayout = new GroupLayout(this.pnlInteractiveWindows);
        this.pnlInteractiveWindows.setLayout(pnlInteractiveWindowsLayout);
        pnlInteractiveWindowsLayout.setHorizontalGroup(pnlInteractiveWindowsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlInteractiveWindowsLayout.createSequentialGroup().addContainerGap().addGroup(pnlInteractiveWindowsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlInteractiveButtons, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.pnlInteractiveTabs)).addContainerGap()));
        pnlInteractiveWindowsLayout.setVerticalGroup(pnlInteractiveWindowsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlInteractiveWindowsLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlInteractiveTabs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlInteractiveButtons, -2, -1, -2).addContainerGap()));
        this.pnlTabs.addTab("InteractiveWindows", this.pnlInteractiveWindows);
        this.pnlThemeButtons.setPreferredSize(new Dimension(380, 36));
        this.pnlThemeButtons.setLayout(new FlowLayout(1, 10, 5));
        this.btnChangeFont.setText("Change Font");
        this.btnChangeFont.setMaximumSize(new Dimension(130, 26));
        this.btnChangeFont.setName("");
        this.btnChangeFont.setPreferredSize(new Dimension(130, 26));
        this.btnChangeFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnChangeFontActionPerformed(evt);
            }
        });
        this.pnlThemeButtons.add(this.btnChangeFont);
        this.btnReset.setText("Reset");
        this.btnReset.setMaximumSize(new Dimension(130, 26));
        this.btnReset.setMinimumSize(new Dimension(95, 23));
        this.btnReset.setPreferredSize(new Dimension(130, 26));
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnResetActionPerformed(evt);
            }
        });
        this.pnlThemeButtons.add(this.btnReset);
        this.lblPrimaryColour1.setText("Primary 1");
        this.txtPrimaryColour1.setText("#00FF00");
        this.txtPrimaryColour1.setPreferredSize(new Dimension(70, 24));
        this.txtPrimaryColour1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtPrimaryColour1);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtPrimaryColour1);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtPrimaryColour1);
            }
        });
        ((AbstractDocument)this.txtPrimaryColour1.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.txtPrimaryColour1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SettingsWindow.this.txtPrimaryColour1FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SettingsWindow.this.txtPrimaryColour1FocusLost(evt);
            }
        });
        this.pnlPrimaryColour1PreviewContainer.setLayout(new BoxLayout(this.pnlPrimaryColour1PreviewContainer, 1));
        this.pnlPrimaryColour1PreviewContainer.add(this.gluePrimaryColour1a);
        this.pnlPrimaryColour1Preview.setBorder(new SoftBevelBorder(1));
        this.pnlPrimaryColour1Preview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlPrimaryColour1PreviewLayout = new GroupLayout(this.pnlPrimaryColour1Preview);
        this.pnlPrimaryColour1Preview.setLayout(pnlPrimaryColour1PreviewLayout);
        pnlPrimaryColour1PreviewLayout.setHorizontalGroup(pnlPrimaryColour1PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlPrimaryColour1PreviewLayout.setVerticalGroup(pnlPrimaryColour1PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlPrimaryColour1PreviewContainer.add(this.pnlPrimaryColour1Preview);
        this.pnlPrimaryColour1PreviewContainer.add(this.gluePrimaryColour1b);
        this.btnPrimaryColour1Change.setText("Change");
        this.btnPrimaryColour1Change.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnPrimaryColour1ChangeActionPerformed(evt);
            }
        });
        this.lblPrimaryColour2.setText("Primary 2");
        this.txtPrimaryColour2.setText("#00FF00");
        this.txtPrimaryColour2.setPreferredSize(new Dimension(70, 24));
        this.txtPrimaryColour2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtPrimaryColour2);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtPrimaryColour2);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtPrimaryColour2);
            }
        });
        ((AbstractDocument)this.txtPrimaryColour2.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.txtPrimaryColour2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SettingsWindow.this.txtPrimaryColour2FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SettingsWindow.this.txtPrimaryColour2FocusLost(evt);
            }
        });
        this.pnlPrimaryColour2PreviewContainer.setLayout(new BoxLayout(this.pnlPrimaryColour2PreviewContainer, 1));
        this.pnlPrimaryColour2PreviewContainer.add(this.gluePrimaryColour2a);
        this.pnlPrimaryColour2Preview.setBorder(new SoftBevelBorder(1));
        this.pnlPrimaryColour2Preview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlPrimaryColour2PreviewLayout = new GroupLayout(this.pnlPrimaryColour2Preview);
        this.pnlPrimaryColour2Preview.setLayout(pnlPrimaryColour2PreviewLayout);
        pnlPrimaryColour2PreviewLayout.setHorizontalGroup(pnlPrimaryColour2PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlPrimaryColour2PreviewLayout.setVerticalGroup(pnlPrimaryColour2PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlPrimaryColour2PreviewContainer.add(this.pnlPrimaryColour2Preview);
        this.pnlPrimaryColour2PreviewContainer.add(this.gluePrimaryColour2b);
        this.btnPrimaryColour2Change.setText("Change");
        this.btnPrimaryColour2Change.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnPrimaryColour2ChangeActionPerformed(evt);
            }
        });
        this.lblSecondaryColour1.setText("Secondary 1");
        this.txtSecondaryColour1.setText("#00FF00");
        this.txtSecondaryColour1.setPreferredSize(new Dimension(70, 24));
        this.txtSecondaryColour1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour1);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour1);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour1);
            }
        });
        ((AbstractDocument)this.txtSecondaryColour1.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.txtSecondaryColour1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SettingsWindow.this.txtSecondaryColour1FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SettingsWindow.this.txtSecondaryColour1FocusLost(evt);
            }
        });
        this.pnlSecondaryColour1PreviewContainer.setLayout(new BoxLayout(this.pnlSecondaryColour1PreviewContainer, 1));
        this.pnlSecondaryColour1PreviewContainer.add(this.glueSecondaryColour1a);
        this.pnlSecondaryColour1Preview.setBorder(new SoftBevelBorder(1));
        this.pnlSecondaryColour1Preview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlSecondaryColour1PreviewLayout = new GroupLayout(this.pnlSecondaryColour1Preview);
        this.pnlSecondaryColour1Preview.setLayout(pnlSecondaryColour1PreviewLayout);
        pnlSecondaryColour1PreviewLayout.setHorizontalGroup(pnlSecondaryColour1PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlSecondaryColour1PreviewLayout.setVerticalGroup(pnlSecondaryColour1PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlSecondaryColour1PreviewContainer.add(this.pnlSecondaryColour1Preview);
        this.pnlSecondaryColour1PreviewContainer.add(this.glueSecondaryColour1b);
        this.btnSecondaryColour1Change.setText("Change");
        this.btnSecondaryColour1Change.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnSecondaryColour1ChangeActionPerformed(evt);
            }
        });
        this.lblSecondaryColour2.setText("Secondary 2");
        this.txtSecondaryColour2.setText("#00FF00");
        this.txtSecondaryColour2.setPreferredSize(new Dimension(70, 24));
        this.txtSecondaryColour2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour2);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour2);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour2);
            }
        });
        ((AbstractDocument)this.txtSecondaryColour2.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.txtSecondaryColour2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SettingsWindow.this.txtSecondaryColour2FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SettingsWindow.this.txtSecondaryColour2FocusLost(evt);
            }
        });
        this.pnlSecondaryColour2PreviewContainer.setLayout(new BoxLayout(this.pnlSecondaryColour2PreviewContainer, 1));
        this.pnlSecondaryColour2PreviewContainer.add(this.glueSecondaryColour2a);
        this.pnlSecondaryColour2Preview.setBorder(new SoftBevelBorder(1));
        this.pnlSecondaryColour2Preview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlSecondaryColour2PreviewLayout = new GroupLayout(this.pnlSecondaryColour2Preview);
        this.pnlSecondaryColour2Preview.setLayout(pnlSecondaryColour2PreviewLayout);
        pnlSecondaryColour2PreviewLayout.setHorizontalGroup(pnlSecondaryColour2PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlSecondaryColour2PreviewLayout.setVerticalGroup(pnlSecondaryColour2PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlSecondaryColour2PreviewContainer.add(this.pnlSecondaryColour2Preview);
        this.pnlSecondaryColour2PreviewContainer.add(this.glueSecondaryColour2b);
        this.btnSecondaryColour2Change.setText("Change");
        this.btnSecondaryColour2Change.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnSecondaryColour2ChangeActionPerformed(evt);
            }
        });
        this.lblSecondaryColour3.setText("Secondary 3");
        this.txtSecondaryColour3.setText("#00FF00");
        this.txtSecondaryColour3.setPreferredSize(new Dimension(70, 24));
        this.txtSecondaryColour3.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour3);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour3);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtSecondaryColour3);
            }
        });
        ((AbstractDocument)this.txtSecondaryColour3.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.txtSecondaryColour3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SettingsWindow.this.txtSecondaryColour3FocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SettingsWindow.this.txtSecondaryColour3FocusLost(evt);
            }
        });
        this.pnlSecondaryColour3PreviewContainer.setLayout(new BoxLayout(this.pnlSecondaryColour3PreviewContainer, 1));
        this.pnlSecondaryColour3PreviewContainer.add(this.glueSecondaryColour3a);
        this.pnlSecondaryColour3Preview.setBorder(new SoftBevelBorder(1));
        this.pnlSecondaryColour3Preview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlSecondaryColour3PreviewLayout = new GroupLayout(this.pnlSecondaryColour3Preview);
        this.pnlSecondaryColour3Preview.setLayout(pnlSecondaryColour3PreviewLayout);
        pnlSecondaryColour3PreviewLayout.setHorizontalGroup(pnlSecondaryColour3PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlSecondaryColour3PreviewLayout.setVerticalGroup(pnlSecondaryColour3PreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlSecondaryColour3PreviewContainer.add(this.pnlSecondaryColour3Preview);
        this.pnlSecondaryColour3PreviewContainer.add(this.glueSecondaryColour3b);
        this.btnSecondaryColour3Change.setText("Change");
        this.btnSecondaryColour3Change.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnSecondaryColour3ChangeActionPerformed(evt);
            }
        });
        this.lblMenuOpacity.setText("Menu Opacity");
        this.sldMenuOpacity.setMajorTickSpacing(10);
        this.sldMenuOpacity.setMinorTickSpacing(5);
        this.sldMenuOpacity.setPaintLabels(true);
        this.sldMenuOpacity.setPaintTicks(true);
        this.sldMenuOpacity.setSnapToTicks(true);
        this.sldMenuOpacity.setValue(10);
        this.sldMenuOpacity.setPreferredSize(new Dimension(300, 45));
        this.sldMenuOpacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsWindow.this.sldMenuOpacityStateChanged(evt);
            }
        });
        this.lblBlackColour.setText("Text");
        this.txtBlackColour.setText("#00FF00");
        this.txtBlackColour.setPreferredSize(new Dimension(70, 24));
        this.txtBlackColour.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtBlackColour);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtBlackColour);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtBlackColour);
            }
        });
        ((AbstractDocument)this.txtBlackColour.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.txtBlackColour.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SettingsWindow.this.txtBlackColourFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SettingsWindow.this.txtBlackColourFocusLost(evt);
            }
        });
        this.pnlBlackColourPreviewContainer.setLayout(new BoxLayout(this.pnlBlackColourPreviewContainer, 1));
        this.pnlBlackColourPreviewContainer.add(this.glueBlackColoura);
        this.pnlBlackColourPreview.setBorder(new SoftBevelBorder(1));
        this.pnlBlackColourPreview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlBlackColourPreviewLayout = new GroupLayout(this.pnlBlackColourPreview);
        this.pnlBlackColourPreview.setLayout(pnlBlackColourPreviewLayout);
        pnlBlackColourPreviewLayout.setHorizontalGroup(pnlBlackColourPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlBlackColourPreviewLayout.setVerticalGroup(pnlBlackColourPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlBlackColourPreviewContainer.add(this.pnlBlackColourPreview);
        this.pnlBlackColourPreviewContainer.add(this.glueBlackColourb);
        this.btnBlackColourChange.setText("Change");
        this.btnBlackColourChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnBlackColourChangeActionPerformed(evt);
            }
        });
        this.lblWhiteColour.setText("Background");
        this.lblWhiteColour.setToolTipText("");
        this.txtWhiteColour.setText("#00FF00");
        this.txtWhiteColour.setPreferredSize(new Dimension(70, 24));
        this.txtWhiteColour.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtWhiteColour);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtWhiteColour);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtWhiteColour);
            }
        });
        ((AbstractDocument)this.txtWhiteColour.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.txtWhiteColour.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SettingsWindow.this.txtWhiteColourFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SettingsWindow.this.txtWhiteColourFocusLost(evt);
            }
        });
        this.pnlWhiteColourPreviewContainer.setLayout(new BoxLayout(this.pnlWhiteColourPreviewContainer, 1));
        this.pnlWhiteColourPreviewContainer.add(this.glueWhiteColoura);
        this.pnlWhiteColourPreview.setBorder(new SoftBevelBorder(1));
        this.pnlWhiteColourPreview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlWhiteColourPreviewLayout = new GroupLayout(this.pnlWhiteColourPreview);
        this.pnlWhiteColourPreview.setLayout(pnlWhiteColourPreviewLayout);
        pnlWhiteColourPreviewLayout.setHorizontalGroup(pnlWhiteColourPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlWhiteColourPreviewLayout.setVerticalGroup(pnlWhiteColourPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlWhiteColourPreviewContainer.add(this.pnlWhiteColourPreview);
        this.pnlWhiteColourPreviewContainer.add(this.glueWhiteColourb);
        this.btnWhiteColourChange.setText("Change");
        this.btnWhiteColourChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnWhiteColourChangeActionPerformed(evt);
            }
        });
        this.pnlScrollPane.setHorizontalScrollBarPolicy(31);
        this.pnlEditorPane.setEditable(false);
        this.pnlEditorPane.setContentType("text/html");
        this.pnlEditorPane.setRequestFocusEnabled(false);
        this.pnlScrollPane.setViewportView(this.pnlEditorPane);
        GroupLayout pnlThemeLayout = new GroupLayout(this.pnlTheme);
        this.pnlTheme.setLayout(pnlThemeLayout);
        pnlThemeLayout.setHorizontalGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createSequentialGroup().addContainerGap().addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createSequentialGroup().addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pnlThemeButtons, -2, 0, Short.MAX_VALUE).addGroup(pnlThemeLayout.createSequentialGroup().addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPrimaryColour1).addComponent(this.lblPrimaryColour2).addComponent(this.lblSecondaryColour1).addComponent(this.lblSecondaryColour2).addComponent(this.lblSecondaryColour3).addComponent(this.lblBlackColour).addComponent(this.lblWhiteColour)).addGap(18, 18, 18).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createSequentialGroup().addComponent(this.txtSecondaryColour3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlSecondaryColour3PreviewContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSecondaryColour3Change)).addGroup(pnlThemeLayout.createSequentialGroup().addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, pnlThemeLayout.createSequentialGroup().addComponent(this.txtWhiteColour, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlWhiteColourPreviewContainer, -1, -1, -2)).addGroup(pnlThemeLayout.createSequentialGroup().addComponent(this.txtBlackColour, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlBlackColourPreviewContainer, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnBlackColourChange).addComponent(this.btnWhiteColourChange, GroupLayout.Alignment.TRAILING))).addGroup(pnlThemeLayout.createSequentialGroup().addComponent(this.txtPrimaryColour2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlPrimaryColour2PreviewContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnPrimaryColour2Change)).addGroup(pnlThemeLayout.createSequentialGroup().addComponent(this.txtSecondaryColour1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlSecondaryColour1PreviewContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSecondaryColour1Change)).addGroup(pnlThemeLayout.createSequentialGroup().addComponent(this.txtSecondaryColour2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlSecondaryColour2PreviewContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSecondaryColour2Change)).addGroup(pnlThemeLayout.createSequentialGroup().addComponent(this.txtPrimaryColour1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlPrimaryColour1PreviewContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnPrimaryColour1Change))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlScrollPane, -2, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(pnlThemeLayout.createSequentialGroup().addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMenuOpacity).addGroup(pnlThemeLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.sldMenuOpacity, -2, -1, -2))).addGap(0, 26, Short.MAX_VALUE)))));
        pnlThemeLayout.setVerticalGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlThemeLayout.createSequentialGroup().addContainerGap().addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(pnlThemeLayout.createSequentialGroup().addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPrimaryColour1).addComponent(this.txtPrimaryColour1, -2, -1, -2).addComponent(this.btnPrimaryColour1Change)).addComponent(this.pnlPrimaryColour1PreviewContainer, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPrimaryColour2).addComponent(this.txtPrimaryColour2, -2, -1, -2).addComponent(this.btnPrimaryColour2Change)).addComponent(this.pnlPrimaryColour2PreviewContainer, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSecondaryColour1).addComponent(this.txtSecondaryColour1, -2, -1, -2).addComponent(this.btnSecondaryColour1Change)).addComponent(this.pnlSecondaryColour1PreviewContainer, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSecondaryColour2).addComponent(this.txtSecondaryColour2, -2, -1, -2).addComponent(this.btnSecondaryColour2Change)).addComponent(this.pnlSecondaryColour2PreviewContainer, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSecondaryColour3).addComponent(this.txtSecondaryColour3, -2, -1, -2).addComponent(this.btnSecondaryColour3Change)).addComponent(this.pnlSecondaryColour3PreviewContainer, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBlackColour).addComponent(this.txtBlackColour, -2, -1, -2).addComponent(this.btnBlackColourChange)).addComponent(this.pnlBlackColourPreviewContainer, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(pnlThemeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblWhiteColour).addComponent(this.txtWhiteColour, -2, -1, -2).addComponent(this.btnWhiteColourChange)).addComponent(this.pnlWhiteColourPreviewContainer, -2, 24, -2))).addComponent(this.pnlScrollPane)).addGap(18, 18, 18).addComponent(this.lblMenuOpacity).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sldMenuOpacity, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pnlThemeButtons, -2, -1, -2).addContainerGap()));
        this.pnlTabs.addTab("Theme", this.pnlTheme);
        this.chkWindowModeEnabled.setText("Enable Windowed Mode");
        this.chkWindowModeEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SettingsWindow.this.chkWindowModeEnabledItemStateChanged(evt);
            }
        });
        this.lblDimensions.setText("Dimensions");
        this.lblDimensionsX.setText("x");
        this.lblBackground.setText("Background");
        this.txtBackgroundColour.setText("#00FF00");
        this.txtBackgroundColour.setPreferredSize(new Dimension(70, 24));
        this.txtBackgroundColour.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtBackgroundColour);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtBackgroundColour);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsWindow.this.colourTextChanged(SettingsWindow.this.txtBackgroundColour);
            }
        });
        ((AbstractDocument)this.txtBackgroundColour.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int offset, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() + text.length() <= 7) {
                    super.insertString(filterBypass, offset, text, attributes);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
                if (text != null && text.matches("[#0-9a-fA-F]*") && filterBypass.getDocument().getLength() - length + text.length() <= 7) {
                    super.replace(filterBypass, offset, length, text, attributes);
                }
            }
        });
        this.btnBackgroundColourChange.setText("Change");
        this.btnBackgroundColourChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnBackgroundColourChangeActionPerformed(evt);
            }
        });
        this.spnWindowWidth.setModel(new SpinnerNumberModel(0, 0, 10000, 1));
        this.spnWindowWidth.setPreferredSize(new Dimension(60, 24));
        this.spnWindowWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsWindow.this.spnWindowWidthStateChanged(evt);
            }
        });
        this.spnWindowHeight.setModel(new SpinnerNumberModel(0, 0, 10000, 1));
        this.spnWindowHeight.setMinimumSize(new Dimension(30, 20));
        this.spnWindowHeight.setPreferredSize(new Dimension(60, 24));
        this.spnWindowHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsWindow.this.spnWindowHeightStateChanged(evt);
            }
        });
        this.lblBackgroundColour.setText("Colour");
        this.pnlBackgroundPreviewContainer.setLayout(new BoxLayout(this.pnlBackgroundPreviewContainer, 1));
        this.pnlBackgroundPreviewContainer.add(this.glueBackground);
        this.pnlBackgroundPreview.setBorder(new SoftBevelBorder(1));
        this.pnlBackgroundPreview.setPreferredSize(new Dimension(20, 20));
        GroupLayout pnlBackgroundPreviewLayout = new GroupLayout(this.pnlBackgroundPreview);
        this.pnlBackgroundPreview.setLayout(pnlBackgroundPreviewLayout);
        pnlBackgroundPreviewLayout.setHorizontalGroup(pnlBackgroundPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        pnlBackgroundPreviewLayout.setVerticalGroup(pnlBackgroundPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.pnlBackgroundPreviewContainer.add(this.pnlBackgroundPreview);
        this.pnlBackgroundPreviewContainer.add(this.glueBackground2);
        this.lblBackgroundImageCaption.setText("Image");
        this.pnlBackgroundImage.setBorder(new SoftBevelBorder(1));
        this.pnlBackgroundImage.setPreferredSize(new Dimension(96, 96));
        this.pnlBackgroundImage.setLayout(new BorderLayout());
        this.lblBackgroundImage.setHorizontalAlignment(0);
        this.pnlBackgroundImage.add((Component)this.lblBackgroundImage, "Center");
        this.btnBackgroundImageChange.setText("Change");
        this.btnBackgroundImageChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnBackgroundImageChangeActionPerformed(evt);
            }
        });
        this.btnBackgroundImageRemove.setText("Remove");
        this.btnBackgroundImageRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnBackgroundImageRemoveActionPerformed(evt);
            }
        });
        this.cmbBackgroundImageMode.setModel(new DefaultComboBoxModel());
        this.cmbBackgroundImageMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.cmbBackgroundImageModeActionPerformed(evt);
            }
        });
        GroupLayout pnlWindowModeLayout = new GroupLayout(this.pnlWindowMode);
        this.pnlWindowMode.setLayout(pnlWindowModeLayout);
        pnlWindowModeLayout.setHorizontalGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWindowModeLayout.createSequentialGroup().addContainerGap().addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkWindowModeEnabled).addGroup(pnlWindowModeLayout.createSequentialGroup().addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDimensions).addComponent(this.lblBackground).addGroup(pnlWindowModeLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBackgroundImageCaption).addComponent(this.lblBackgroundColour)))).addGap(18, 18, 18).addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(pnlWindowModeLayout.createSequentialGroup().addComponent(this.spnWindowWidth, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDimensionsX).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spnWindowHeight, -2, -1, -2)).addGroup(pnlWindowModeLayout.createSequentialGroup().addComponent(this.txtBackgroundColour, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlBackgroundPreviewContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnBackgroundColourChange, -1, -1, Short.MAX_VALUE)).addGroup(pnlWindowModeLayout.createSequentialGroup().addComponent(this.pnlBackgroundImage, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnBackgroundImageRemove, -1, -1, Short.MAX_VALUE).addComponent(this.btnBackgroundImageChange, -1, -1, Short.MAX_VALUE).addComponent(this.cmbBackgroundImageMode, 0, -1, Short.MAX_VALUE)))))).addContainerGap(85, Short.MAX_VALUE)));
        pnlWindowModeLayout.setVerticalGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWindowModeLayout.createSequentialGroup().addContainerGap().addComponent(this.chkWindowModeEnabled).addGap(18, 18, 18).addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDimensions).addComponent(this.lblDimensionsX).addComponent(this.spnWindowWidth, -2, -1, -2).addComponent(this.spnWindowHeight, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lblBackground).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBackgroundColour).addComponent(this.txtBackgroundColour, -2, -1, -2).addComponent(this.btnBackgroundColourChange)).addComponent(this.pnlBackgroundPreviewContainer, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlWindowModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlWindowModeLayout.createSequentialGroup().addComponent(this.btnBackgroundImageChange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbBackgroundImageMode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBackgroundImageRemove)).addGroup(pnlWindowModeLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.lblBackgroundImageCaption)).addComponent(this.pnlBackgroundImage, -2, -1, -2)).addContainerGap(115, Short.MAX_VALUE)));
        this.pnlTabs.addTab("WindowMode", this.pnlWindowMode);
        this.pnlAbout.setLayout(new BoxLayout(this.pnlAbout, 1));
        this.pnlAbout.add(this.glue1);
        this.lblIcon.setAlignmentX(0.5f);
        this.lblIcon.setMinimumSize(new Dimension(64, 64));
        this.lblIcon.setPreferredSize(new Dimension(64, 64));
        this.pnlAbout.add(this.lblIcon);
        this.pnlAbout.add(this.rigid1);
        this.lblShimejiEE.setFont(this.lblShimejiEE.getFont().deriveFont(this.lblShimejiEE.getFont().getStyle() | 1, this.lblShimejiEE.getFont().getSize() + 10));
        this.lblShimejiEE.setText("Shimeji");
        this.lblShimejiEE.setAlignmentX(0.5f);
        this.pnlAbout.add(this.lblShimejiEE);
        this.pnlAbout.add(this.rigid2);
        this.lblVersion.setFont(this.lblVersion.getFont().deriveFont((float)this.lblVersion.getFont().getSize() + 4.0f));
        this.lblVersion.setText("1.0.22");
        this.lblVersion.setAlignmentX(0.5f);
        this.pnlAbout.add(this.lblVersion);
        this.pnlAbout.add(this.rigid3);
        this.lblDevelopedBy.setText("developed by");
        this.lblDevelopedBy.setAlignmentX(0.5f);
        this.pnlAbout.add(this.lblDevelopedBy);
        this.lblKilkakon.setText("Kilkakon");
        this.lblKilkakon.setAlignmentX(0.5f);
        this.pnlAbout.add(this.lblKilkakon);
        this.pnlAbout.add(this.rigid4);
        this.pnlAboutButtons.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        this.pnlAboutButtons.setLayout(new FlowLayout(1, 10, 5));
        this.btnWebsite.setText("Website");
        this.btnWebsite.setAlignmentX(0.5f);
        this.btnWebsite.setMaximumSize(new Dimension(130, 26));
        this.btnWebsite.setPreferredSize(new Dimension(100, 26));
        this.btnWebsite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnWebsiteActionPerformed(evt);
            }
        });
        this.pnlAboutButtons.add(this.btnWebsite);
        this.btnDiscord.setText("Discord");
        this.btnDiscord.setAlignmentX(0.5f);
        this.btnDiscord.setMaximumSize(new Dimension(130, 26));
        this.btnDiscord.setPreferredSize(new Dimension(100, 26));
        this.btnDiscord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnDiscordActionPerformed(evt);
            }
        });
        this.pnlAboutButtons.add(this.btnDiscord);
        this.btnPatreon.setText("Patreon");
        this.btnPatreon.setAlignmentX(0.5f);
        this.btnPatreon.setMaximumSize(new Dimension(130, 26));
        this.btnPatreon.setPreferredSize(new Dimension(100, 26));
        this.btnPatreon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnPatreonActionPerformed(evt);
            }
        });
        this.pnlAboutButtons.add(this.btnPatreon);
        this.pnlAbout.add(this.pnlAboutButtons);
        this.pnlAbout.add(this.glue2);
        this.pnlTabs.addTab("About", this.pnlAbout);
        this.pnlFooter.setPreferredSize(new Dimension(380, 36));
        this.pnlFooter.setLayout(new FlowLayout(1, 10, 5));
        this.btnDone.setText("Done");
        this.btnDone.setMaximumSize(new Dimension(130, 26));
        this.btnDone.setMinimumSize(new Dimension(95, 23));
        this.btnDone.setName("");
        this.btnDone.setPreferredSize(new Dimension(130, 26));
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnDoneActionPerformed(evt);
            }
        });
        this.pnlFooter.add(this.btnDone);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setMaximumSize(new Dimension(130, 26));
        this.btnCancel.setMinimumSize(new Dimension(95, 23));
        this.btnCancel.setPreferredSize(new Dimension(130, 26));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsWindow.this.btnCancelActionPerformed(evt);
            }
        });
        this.pnlFooter.add(this.btnCancel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlFooter, -2, 0, Short.MAX_VALUE).addComponent(this.pnlTabs)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlTabs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlFooter, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnDoneActionPerformed(ActionEvent evt) {
        try {
            Properties properties = Main.getInstance().getProperties();
            String interactiveWindows = this.listData.toString().replace("[", "").replace("]", "").replace(", ", "/");
            String interactiveWindowsBlacklist = this.blacklistData.toString().replace("[", "").replace("]", "").replace(", ", "/");
            String[] windowArray = properties.getProperty("WindowSize", "600x500").split("x");
            Dimension window = new Dimension(Integer.parseInt(windowArray[0]), Integer.parseInt(windowArray[1]));
            float menuScaling = Float.parseFloat(properties.getProperty("MenuDPI", "96")) / 96.0f;
            this.environmentReloadRequired = properties.getProperty("Environment", "generic").equals("virtual") != this.windowedMode.booleanValue() || !window.equals(this.windowSize) || !Color.decode(properties.getProperty("Background", "#00FF00")).equals(this.backgroundColour) || !properties.getProperty("BackgroundMode", "centre").equals(this.backgroundMode) || !properties.getProperty("BackgroundImage", "").equalsIgnoreCase(this.backgroundImage == null ? "" : this.backgroundImage);
            this.imageReloadRequired = !properties.getProperty("Filter", "false").equalsIgnoreCase(this.filter) || Double.parseDouble(properties.getProperty("Scaling", "1.0")) != this.scaling || Double.parseDouble(properties.getProperty("Opacity", "1.0")) != this.opacity;
            this.interactiveWindowReloadRequired = !properties.getProperty("InteractiveWindows", "").equals(interactiveWindows) || !properties.getProperty("InteractiveWindowsBlacklist", "").equals(interactiveWindowsBlacklist);
            FileOutputStream output = new FileOutputStream(this.configPath.toFile());
            try {
                properties.setProperty("AlwaysShowShimejiChooser", this.alwaysShowShimejiChooser.toString());
                properties.setProperty("AlwaysShowInformationScreen", this.alwaysShowInformationScreen.toString());
                properties.setProperty("Opacity", Double.toString(this.opacity));
                properties.setProperty("Scaling", Double.toString(this.scaling));
                properties.setProperty("Filter", this.filter);
                properties.setProperty("InteractiveWindows", interactiveWindows);
                properties.setProperty("InteractiveWindowsBlacklist", interactiveWindowsBlacklist);
                properties.setProperty("Environment", this.windowedMode != false ? "virtual" : "generic");
                if (this.windowedMode.booleanValue()) {
                    properties.setProperty("WindowSize", this.windowSize.width + "x" + this.windowSize.height);
                    properties.setProperty("Background", String.format("#%02X%02X%02X", this.backgroundColour.getRed(), this.backgroundColour.getGreen(), this.backgroundColour.getBlue()));
                    properties.setProperty("BackgroundMode", this.backgroundMode);
                    properties.setProperty("BackgroundImage", this.backgroundImage == null ? "" : this.backgroundImage);
                }
                properties.store(output, "Shimeji-ee Configuration Options");
            }
            finally {
                output.close();
            }
            FileOutputStream themeOutput = new FileOutputStream(this.themePath.toFile());
            try {
                properties = new Properties();
                properties.setProperty("nimrodlf.p1", String.format("#%02X%02X%02X", this.primaryColour1.getRed(), this.primaryColour1.getGreen(), this.primaryColour1.getBlue()));
                properties.setProperty("nimrodlf.p2", String.format("#%02X%02X%02X", this.primaryColour2.getRed(), this.primaryColour2.getGreen(), this.primaryColour2.getBlue()));
                properties.setProperty("nimrodlf.p3", String.format("#%02X%02X%02X", this.primaryColour3.getRed(), this.primaryColour3.getGreen(), this.primaryColour3.getBlue()));
                properties.setProperty("nimrodlf.s1", String.format("#%02X%02X%02X", this.secondaryColour1.getRed(), this.secondaryColour1.getGreen(), this.secondaryColour1.getBlue()));
                properties.setProperty("nimrodlf.s2", String.format("#%02X%02X%02X", this.secondaryColour2.getRed(), this.secondaryColour2.getGreen(), this.secondaryColour2.getBlue()));
                properties.setProperty("nimrodlf.s3", String.format("#%02X%02X%02X", this.secondaryColour3.getRed(), this.secondaryColour3.getGreen(), this.secondaryColour3.getBlue()));
                properties.setProperty("nimrodlf.b", String.format("#%02X%02X%02X", this.blackColour.getRed(), this.blackColour.getGreen(), this.blackColour.getBlue()));
                properties.setProperty("nimrodlf.w", String.format("#%02X%02X%02X", this.whiteColour.getRed(), this.whiteColour.getGreen(), this.whiteColour.getBlue()));
                properties.setProperty("nimrodlf.menuOpacity", String.valueOf((int)(this.menuOpacity * 255.0)));
                properties.setProperty("nimrodlf.frameOpacity", "255");
                properties.setProperty("nimrodlf.font", String.format("%s-%s-%d", this.font.getName(), this.font.getStyle() == 0 ? "PLAIN" : (this.font.getStyle() == 1 ? "BOLD" : (this.font.getStyle() == 2 ? "ITALIC" : "BOLDITALIC")), (int)((float)this.font.getSize() / menuScaling)));
                properties.store(themeOutput, null);
            }
            finally {
                themeOutput.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.theme = this.oldTheme;
        this.refreshTheme();
        this.dispose();
    }

    private void btnAddInteractiveWindowActionPerformed(ActionEvent evt) {
        String inputValue = JOptionPane.showInputDialog(this.rootPane, Main.getInstance().getLanguageBundle().getString("InteractiveWindowHintMessage"), Main.getInstance().getLanguageBundle().getString(this.pnlInteractiveTabs.getSelectedIndex() == 0 ? "AddInteractiveWindow" : "BlacklistInteractiveWindow"), 3);
        if (inputValue != null && !inputValue.trim().isEmpty() && !inputValue.contains("/")) {
            if (this.pnlInteractiveTabs.getSelectedIndex() == 0) {
                this.listData.add(inputValue.trim());
                this.lstInteractiveWindows.setListData(this.listData.toArray());
            } else {
                this.blacklistData.add(inputValue.trim());
                this.lstInteractiveWindowsBlacklist.setListData(this.blacklistData.toArray());
            }
        }
    }

    private void btnRemoveInteractiveWindowActionPerformed(ActionEvent evt) {
        if (this.pnlInteractiveTabs.getSelectedIndex() == 0) {
            if (this.lstInteractiveWindows.getSelectedIndex() != -1) {
                this.listData.remove(this.lstInteractiveWindows.getSelectedIndex());
                this.lstInteractiveWindows.setListData(this.listData.toArray());
            }
        } else if (this.lstInteractiveWindowsBlacklist.getSelectedIndex() != -1) {
            this.blacklistData.remove(this.lstInteractiveWindowsBlacklist.getSelectedIndex());
            this.lstInteractiveWindowsBlacklist.setListData(this.blacklistData.toArray());
        }
    }

    private void chkAlwaysShowShimejiChooserItemStateChanged(ItemEvent evt) {
        this.alwaysShowShimejiChooser = evt.getStateChange() == 1;
    }

    private void radFilterItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            ItemSelectable source = evt.getItemSelectable();
            this.filter = source == this.radFilterNearest ? "nearest" : (source == this.radFilterHqx ? "hqx" : "bicubic");
        }
    }

    private void sldScalingStateChanged(ChangeEvent evt) {
        if (!this.sldScaling.getValueIsAdjusting()) {
            if (this.sldScaling.getValue() == 0) {
                this.sldScaling.setValue(5);
            } else {
                this.scaling = (double)this.sldScaling.getValue() / 10.0;
                if (this.scaling == 2.0 || this.scaling == 3.0 || this.scaling == 4.0 || this.scaling == 6.0 || this.scaling == 8.0) {
                    this.radFilterHqx.setEnabled(true);
                } else {
                    this.radFilterHqx.setEnabled(false);
                    if (this.filter.equals("hqx")) {
                        this.radFilterNearest.setSelected(true);
                    }
                }
            }
        }
    }

    private void btnWebsiteActionPerformed(ActionEvent evt) {
        this.browseToUrl("http://kilkakon.com/");
    }

    private void btnDiscordActionPerformed(ActionEvent evt) {
        this.browseToUrl("https://discord.gg/NBq3zqfA2B");
    }

    private void btnPatreonActionPerformed(ActionEvent evt) {
        this.browseToUrl("https://patreon.com/kilkakon");
    }

    private void sldOpacityStateChanged(ChangeEvent evt) {
        if (!this.sldOpacity.getValueIsAdjusting()) {
            if (this.sldOpacity.getValue() == 0) {
                this.sldOpacity.setValue(5);
            } else {
                this.opacity = (double)this.sldOpacity.getValue() / 100.0;
            }
        }
    }

    private void spnWindowHeightStateChanged(ChangeEvent evt) {
        this.windowSize.height = ((SpinnerNumberModel)this.spnWindowHeight.getModel()).getNumber().intValue();
    }

    private void spnWindowWidthStateChanged(ChangeEvent evt) {
        this.windowSize.width = ((SpinnerNumberModel)this.spnWindowWidth.getModel()).getNumber().intValue();
    }

    private void btnBackgroundColourChangeActionPerformed(ActionEvent evt) {
        this.backgroundColour = this.chooseColour(this.backgroundColour, this.txtBackgroundColour, this.pnlBackgroundPreview, "ChooseBackgroundColour");
    }

    private void chkWindowModeEnabledItemStateChanged(ItemEvent evt) {
        this.windowedMode = evt.getStateChange() == 1;
        this.spnWindowWidth.setEnabled(this.windowedMode);
        this.spnWindowHeight.setEnabled(this.windowedMode);
        this.btnBackgroundColourChange.setEnabled(this.windowedMode);
        this.btnBackgroundImageChange.setEnabled(this.windowedMode);
        this.cmbBackgroundImageMode.setEnabled(this.windowedMode != false && this.backgroundImage != null);
        this.btnBackgroundImageRemove.setEnabled(this.windowedMode != false && this.backgroundImage != null);
    }

    private void btnBackgroundImageChangeActionPerformed(ActionEvent evt) {
        JFileChooser dialog = new JFileChooser();
        dialog.setDialogTitle(Main.getInstance().getLanguageBundle().getString("ChooseBackgroundImage"));
        if (dialog.showOpenDialog(this) == 0) {
            try {
                this.backgroundImage = dialog.getSelectedFile().getCanonicalPath();
                this.refreshBackgroundImage();
            }
            catch (Exception e) {
                this.backgroundImage = null;
                this.lblBackgroundImage.setIcon(null);
            }
            this.cmbBackgroundImageMode.setEnabled(this.windowedMode != false && this.backgroundImage != null);
            this.btnBackgroundImageRemove.setEnabled(this.windowedMode != false && this.backgroundImage != null);
        }
    }

    private void btnBackgroundImageRemoveActionPerformed(ActionEvent evt) {
        this.backgroundImage = null;
        this.lblBackgroundImage.setIcon(null);
        this.cmbBackgroundImageMode.setEnabled(false);
        this.btnBackgroundImageRemove.setEnabled(false);
    }

    private void cmbBackgroundImageModeActionPerformed(ActionEvent evt) {
        if (this.cmbBackgroundImageMode.getSelectedIndex() > -1) {
            this.backgroundMode = this.backgroundModes[this.cmbBackgroundImageMode.getSelectedIndex()];
        }
        this.refreshBackgroundImage();
    }

    private void chkAlwaysShowInformationScreenItemStateChanged(ItemEvent evt) {
        this.alwaysShowInformationScreen = evt.getStateChange() == 1;
    }

    private void btnWhiteColourChangeActionPerformed(ActionEvent evt) {
        this.updateThemeHelpText("WhiteColourHelpText");
        this.whiteColour = this.chooseColour(this.whiteColour, this.txtWhiteColour, this.pnlWhiteColourPreview, "ChooseColour");
        this.theme.setWhite(this.whiteColour);
        this.refreshTheme();
    }

    private void btnBlackColourChangeActionPerformed(ActionEvent evt) {
        this.updateThemeHelpText("BlackColourHelpText");
        this.blackColour = this.chooseColour(this.blackColour, this.txtBlackColour, this.pnlBlackColourPreview, "ChooseColour");
        this.theme.setBlack(this.blackColour);
        this.refreshTheme();
    }

    private void sldMenuOpacityStateChanged(ChangeEvent evt) {
        if (!this.sldMenuOpacity.getValueIsAdjusting()) {
            if (this.sldMenuOpacity.getValue() == 0) {
                this.sldMenuOpacity.setValue(1);
            } else {
                this.menuOpacity = (double)this.sldMenuOpacity.getValue() / 100.0;
                this.theme.setMenuOpacity((int)(this.menuOpacity * 255.0));
            }
        }
    }

    private void btnSecondaryColour3ChangeActionPerformed(ActionEvent evt) {
        this.updateThemeHelpText("SecondaryColour3HelpText");
        this.secondaryColour3 = this.chooseColour(this.secondaryColour3, this.txtSecondaryColour3, this.pnlSecondaryColour3Preview, "ChooseColour");
        this.theme.setSecondary3(this.secondaryColour3);
        this.refreshTheme();
    }

    private void txtSecondaryColour3FocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsWindow.this.colourWasChanged.booleanValue()) {
                    SettingsWindow.this.colourWasChanged = false;
                    SettingsWindow.this.theme.setSecondary3(SettingsWindow.this.secondaryColour3);
                    SettingsWindow.this.refreshTheme();
                }
            }
        });
    }

    private void btnSecondaryColour2ChangeActionPerformed(ActionEvent evt) {
        this.updateThemeHelpText("SecondaryColour2HelpText");
        this.secondaryColour2 = this.chooseColour(this.secondaryColour2, this.txtSecondaryColour2, this.pnlSecondaryColour2Preview, "ChooseColour");
        this.theme.setSecondary2(this.secondaryColour2);
        this.refreshTheme();
    }

    private void txtSecondaryColour2FocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsWindow.this.colourWasChanged.booleanValue()) {
                    SettingsWindow.this.colourWasChanged = false;
                    SettingsWindow.this.theme.setSecondary2(SettingsWindow.this.secondaryColour2);
                    SettingsWindow.this.refreshTheme();
                }
            }
        });
    }

    private void btnSecondaryColour1ChangeActionPerformed(ActionEvent evt) {
        this.updateThemeHelpText("SecondaryColour1HelpText");
        this.secondaryColour1 = this.chooseColour(this.secondaryColour1, this.txtSecondaryColour1, this.pnlSecondaryColour1Preview, "ChooseColour");
        this.theme.setSecondary1(this.secondaryColour1);
        this.refreshTheme();
    }

    private void txtSecondaryColour1FocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsWindow.this.colourWasChanged.booleanValue()) {
                    SettingsWindow.this.colourWasChanged = false;
                    SettingsWindow.this.theme.setSecondary1(SettingsWindow.this.secondaryColour1);
                    SettingsWindow.this.refreshTheme();
                }
            }
        });
    }

    private void btnPrimaryColour2ChangeActionPerformed(ActionEvent evt) {
        this.updateThemeHelpText("PrimaryColour2HelpText");
        this.primaryColour2 = this.chooseColour(this.primaryColour2, this.txtPrimaryColour2, this.pnlPrimaryColour2Preview, "ChooseColour");
        this.theme.setPrimary2(this.primaryColour2);
        this.refreshTheme();
    }

    private void txtPrimaryColour2FocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsWindow.this.colourWasChanged.booleanValue()) {
                    SettingsWindow.this.colourWasChanged = false;
                    SettingsWindow.this.theme.setPrimary2(SettingsWindow.this.primaryColour2);
                    SettingsWindow.this.refreshTheme();
                }
            }
        });
    }

    private void btnPrimaryColour1ChangeActionPerformed(ActionEvent evt) {
        this.updateThemeHelpText("PrimaryColour1HelpText");
        this.primaryColour1 = this.chooseColour(this.primaryColour1, this.txtPrimaryColour1, this.pnlPrimaryColour1Preview, "ChooseColour");
        this.theme.setPrimary1(this.primaryColour1);
        this.refreshTheme();
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.suppressTextChanged = true;
        float menuScaling = Float.parseFloat(Main.getInstance().getProperties().getProperty("MenuDPI", "96")) / 96.0f;
        this.primaryColour1 = Color.decode("#1EA6EB");
        this.primaryColour2 = Color.decode("#28B0F5");
        this.primaryColour3 = Color.decode("#32BAFF");
        this.secondaryColour1 = Color.decode("#BCBCBE");
        this.secondaryColour2 = Color.decode("#C6C6C8");
        this.secondaryColour3 = Color.decode("#D0D0D2");
        this.blackColour = Color.decode("#000000");
        this.whiteColour = Color.decode("#FFFFFF");
        this.font = Font.decode("SansSerif-PLAIN-12");
        this.font = this.font.deriveFont((float)this.font.getSize() * menuScaling);
        this.pnlPrimaryColour1Preview.setBackground(this.primaryColour1);
        this.txtPrimaryColour1.setText(String.format("#%02X%02X%02X", this.primaryColour1.getRed(), this.primaryColour1.getGreen(), this.primaryColour1.getBlue()));
        this.pnlPrimaryColour2Preview.setBackground(this.primaryColour2);
        this.txtPrimaryColour2.setText(String.format("#%02X%02X%02X", this.primaryColour2.getRed(), this.primaryColour2.getGreen(), this.primaryColour2.getBlue()));
        this.pnlSecondaryColour1Preview.setBackground(this.secondaryColour1);
        this.txtSecondaryColour1.setText(String.format("#%02X%02X%02X", this.secondaryColour1.getRed(), this.secondaryColour1.getGreen(), this.secondaryColour1.getBlue()));
        this.pnlSecondaryColour2Preview.setBackground(this.secondaryColour2);
        this.txtSecondaryColour2.setText(String.format("#%02X%02X%02X", this.secondaryColour2.getRed(), this.secondaryColour2.getGreen(), this.secondaryColour2.getBlue()));
        this.pnlSecondaryColour3Preview.setBackground(this.secondaryColour3);
        this.txtSecondaryColour3.setText(String.format("#%02X%02X%02X", this.secondaryColour3.getRed(), this.secondaryColour3.getGreen(), this.secondaryColour3.getBlue()));
        this.pnlBlackColourPreview.setBackground(this.blackColour);
        this.txtBlackColour.setText(String.format("#%02X%02X%02X", this.blackColour.getRed(), this.blackColour.getGreen(), this.blackColour.getBlue()));
        this.pnlWhiteColourPreview.setBackground(this.whiteColour);
        this.txtWhiteColour.setText(String.format("#%02X%02X%02X", this.whiteColour.getRed(), this.whiteColour.getGreen(), this.whiteColour.getBlue()));
        this.menuOpacity = 1.0;
        this.theme.setPrimary1(this.primaryColour1);
        this.theme.setPrimary2(this.primaryColour2);
        this.theme.setPrimary3(this.primaryColour3);
        this.theme.setSecondary1(this.secondaryColour1);
        this.theme.setSecondary2(this.secondaryColour2);
        this.theme.setSecondary3(this.secondaryColour3);
        this.theme.setBlack(this.blackColour);
        this.theme.setWhite(this.whiteColour);
        this.theme.setFont(this.font);
        this.sldMenuOpacity.setValue((int)(this.menuOpacity * 100.0));
        this.refreshTheme();
        this.pnlEditorPane.setText("");
        this.colourWasChanged = false;
        this.suppressTextChanged = false;
    }

    private void btnChangeFontActionPerformed(ActionEvent evt) {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
        NimRODFontDialog dialog = new NimRODFontDialog((Frame)frame, this.font);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)frame);
        dialog.setVisible(true);
        this.font = dialog.getSelectedFont();
        if (!dialog.isCanceled()) {
            this.theme.setFont(this.font);
            this.refreshTheme();
        }
    }

    private void txtPrimaryColour1FocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsWindow.this.colourWasChanged.booleanValue()) {
                    SettingsWindow.this.colourWasChanged = false;
                    SettingsWindow.this.theme.setPrimary1(SettingsWindow.this.primaryColour1);
                    SettingsWindow.this.refreshTheme();
                }
            }
        });
    }

    private void txtBlackColourFocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsWindow.this.colourWasChanged.booleanValue()) {
                    SettingsWindow.this.colourWasChanged = false;
                    SettingsWindow.this.theme.setBlack(SettingsWindow.this.blackColour);
                    SettingsWindow.this.refreshTheme();
                }
            }
        });
    }

    private void txtWhiteColourFocusLost(FocusEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SettingsWindow.this.colourWasChanged.booleanValue()) {
                    SettingsWindow.this.colourWasChanged = false;
                    SettingsWindow.this.theme.setWhite(SettingsWindow.this.whiteColour);
                    SettingsWindow.this.refreshTheme();
                }
            }
        });
    }

    private void txtPrimaryColour1FocusGained(FocusEvent evt) {
        this.updateThemeHelpText("PrimaryColour1HelpText");
    }

    private void txtPrimaryColour2FocusGained(FocusEvent evt) {
        this.updateThemeHelpText("PrimaryColour2HelpText");
    }

    private void txtSecondaryColour1FocusGained(FocusEvent evt) {
        this.updateThemeHelpText("SecondaryColour1HelpText");
    }

    private void txtSecondaryColour2FocusGained(FocusEvent evt) {
        this.updateThemeHelpText("SecondaryColour2HelpText");
    }

    private void txtSecondaryColour3FocusGained(FocusEvent evt) {
        this.updateThemeHelpText("SecondaryColour3HelpText");
    }

    private void txtBlackColourFocusGained(FocusEvent evt) {
        this.updateThemeHelpText("BlackColourHelpText");
    }

    private void txtWhiteColourFocusGained(FocusEvent evt) {
        this.updateThemeHelpText("WhiteColourHelpText");
    }

    private void colourTextChanged(JTextField field) {
        if (this.suppressTextChanged.booleanValue() || !this.isVisible()) {
            return;
        }
        String text = field.getText();
        if (text == null) {
            return;
        }
        if (text.length() != 7 || !text.matches("#[0-9a-fA-F]{6}")) {
            return;
        }
        Color newColour = Color.decode(text);
        if (field.equals(this.txtPrimaryColour1)) {
            if (!newColour.equals(this.primaryColour1)) {
                this.colourWasChanged = true;
                this.primaryColour1 = newColour;
                this.pnlPrimaryColour1Preview.setBackground(this.primaryColour1);
            }
        } else if (field.equals(this.txtPrimaryColour2)) {
            if (!newColour.equals(this.primaryColour2)) {
                this.colourWasChanged = true;
                this.primaryColour2 = Color.decode(text);
                this.pnlPrimaryColour2Preview.setBackground(this.primaryColour2);
            }
        } else if (field.equals(this.txtSecondaryColour1)) {
            if (!newColour.equals(this.secondaryColour1)) {
                this.colourWasChanged = true;
                this.secondaryColour1 = Color.decode(text);
                this.pnlSecondaryColour1Preview.setBackground(this.secondaryColour1);
            }
        } else if (field.equals(this.txtSecondaryColour2)) {
            if (!newColour.equals(this.secondaryColour2)) {
                this.colourWasChanged = true;
                this.secondaryColour2 = Color.decode(text);
                this.pnlSecondaryColour2Preview.setBackground(this.secondaryColour2);
            }
        } else if (field.equals(this.txtSecondaryColour3)) {
            if (!newColour.equals(this.secondaryColour3)) {
                this.colourWasChanged = true;
                this.secondaryColour3 = Color.decode(text);
                this.pnlSecondaryColour3Preview.setBackground(this.secondaryColour3);
            }
        } else if (field.equals(this.txtBlackColour)) {
            if (!newColour.equals(this.blackColour)) {
                this.colourWasChanged = true;
                this.blackColour = Color.decode(text);
                this.pnlBlackColourPreview.setBackground(this.blackColour);
            }
        } else if (field.equals(this.txtWhiteColour)) {
            if (!newColour.equals(this.whiteColour)) {
                this.colourWasChanged = true;
                this.whiteColour = Color.decode(text);
                this.pnlWhiteColourPreview.setBackground(this.whiteColour);
            }
        } else if (field.equals(this.txtBackgroundColour) && !newColour.equals(this.backgroundColour)) {
            this.backgroundColour = Color.decode(text);
            this.pnlBackgroundPreview.setBackground(this.backgroundColour);
        }
    }

    private Color chooseColour(Color colour, JTextField field, JPanel preview, String title) {
        Color newColour = JColorChooser.showDialog(this, Main.getInstance().getLanguageBundle().getString(title), colour);
        if (newColour != null) {
            this.suppressTextChanged = true;
            colour = newColour;
            field.setText(String.format("#%02X%02X%02X", colour.getRed(), colour.getGreen(), colour.getBlue()));
            preview.setBackground(colour);
            this.suppressTextChanged = false;
        }
        return colour;
    }

    private void updateThemeHelpText(String languageEntry) {
        StringBuilder html = new StringBuilder("<font style=\"font:");
        if (this.font.getStyle() == 1) {
            html.append("bold ");
        }
        if (this.font.getStyle() == 2) {
            html.append("italic ");
        }
        if (this.font.getStyle() == 3) {
            html.append("italic bold ");
        }
        html.append(this.font.getSize());
        html.append("pt ");
        html.append(this.font.getFontName());
        html.append("; color:");
        html.append(String.format("#%02X%02X%02X", this.blackColour.getRed(), this.blackColour.getGreen(), this.blackColour.getBlue()));
        html.append("\">");
        html.append(Main.getInstance().getLanguageBundle().getString(languageEntry));
        html.append("</font>");
        this.pnlEditorPane.setText(html.toString());
    }

    private void refreshBackgroundImage() {
        Dimension size = this.pnlBackgroundImage.getPreferredSize();
        Image image = new ImageIcon(this.backgroundImage).getImage();
        if (this.backgroundMode.equals("stretch")) {
            image = image.getScaledInstance(size.width, size.height, 4);
        } else if (!this.backgroundMode.equals("centre")) {
            double factor = this.backgroundMode.equals("fit") ? Math.min((double)size.width / (double)image.getWidth(null), (double)size.height / (double)image.getHeight(null)) : Math.max((double)size.width / (double)image.getWidth(null), (double)size.height / (double)image.getHeight(null));
            image = image.getScaledInstance((int)(factor * (double)image.getWidth(null)), (int)(factor * (double)image.getHeight(null)), 4);
        }
        this.lblBackgroundImage.setIcon(new ImageIcon(image));
        this.lblBackgroundImage.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
    }

    private void refreshTheme() {
        try {
            NimRODLookAndFeel.setCurrentTheme((MetalTheme)this.theme);
            UIManager.setLookAndFeel((LookAndFeel)this.lookAndFeel);
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
    }
}

