/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.config.Configuration;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class InformationWindow
extends JFrame {
    private final Path themePath = Paths.get(".", "conf", "theme.properties");
    private JButton btnClose;
    private JLabel lblSplashImage;
    private JEditorPane pnlEditorPane;
    private JPanel pnlFooter;
    private JPanel pnlImage;
    private JScrollPane pnlScrollPane;

    public InformationWindow() {
        this.initComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String imageSet, Configuration config) {
        this.setLocationRelativeTo(null);
        Image icon = null;
        try {
            icon = new ImageIcon(Paths.get(".", "img", "icon.png").toString()).getImage();
        }
        catch (Exception exception) {
        }
        finally {
            if (icon == null) {
                icon = new BufferedImage(16, 16, 1);
            }
        }
        this.setIconImage(icon);
        Image image = new ImageIcon(Paths.get(".", "img", imageSet, config.getInformation("SplashImage")).toString()).getImage();
        try {
            this.lblSplashImage.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Properties themeProperties = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.themePath.toFile());
            themeProperties.load(input);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Color textColour = Color.decode(themeProperties.getProperty("nimrodlf.b", "#000000"));
        Color linkColour = Color.decode(themeProperties.getProperty("nimrodlf.p2", "#28B0F5"));
        final ResourceBundle language = Main.getInstance().getLanguageBundle();
        this.setTitle(config.containsInformationKey("Name") ? config.getInformation("Name") : language.getString("Information"));
        StringBuilder html = new StringBuilder("<center style=\"font:");
        if (this.lblSplashImage.getFont().getStyle() == 1) {
            html.append("bold ");
        }
        if (this.lblSplashImage.getFont().getStyle() == 2) {
            html.append("italic ");
        }
        if (this.lblSplashImage.getFont().getStyle() == 3) {
            html.append("italic bold ");
        }
        html.append(this.lblSplashImage.getFont().getSize());
        html.append("pt ");
        html.append(this.lblSplashImage.getFont().getFontName());
        html.append("; color:");
        html.append(String.format("#%02X%02X%02X", textColour.getRed(), textColour.getGreen(), textColour.getBlue()));
        html.append("\">");
        if (config.containsInformationKey("ArtistName")) {
            html.append(language.getString("ArtBy"));
            html.append(" ");
            if (config.containsInformationKey("ArtistURL")) {
                html.append("<a href=\"");
                html.append(config.getInformation("ArtistURL"));
                html.append("\" style=\"color:");
                html.append(String.format("#%02X%02X%02X", linkColour.getRed(), linkColour.getGreen(), linkColour.getBlue()));
                html.append("\">");
            }
            html.append(config.getInformation("ArtistName"));
            if (config.containsInformationKey("ArtistURL")) {
                html.append("</a>");
            }
        }
        if (config.containsInformationKey("ScripterName")) {
            if (config.containsInformationKey("ArtistName")) {
                html.append(" - ");
            }
            html.append(language.getString("ScriptedBy"));
            html.append(" ");
            if (config.containsInformationKey("ScripterURL")) {
                html.append("<a href=\"");
                html.append(config.getInformation("ScripterURL"));
                html.append("\" style=\"color:");
                html.append(String.format("#%02X%02X%02X", linkColour.getRed(), linkColour.getGreen(), linkColour.getBlue()));
                html.append("\">");
            }
            html.append(config.getInformation("ScripterName"));
            if (config.containsInformationKey("ScripterURL")) {
                html.append("</a>");
            }
        }
        if (config.containsInformationKey("CommissionerName")) {
            if (config.containsInformationKey("ArtistName") || config.containsInformationKey("ScripterName")) {
                html.append(" - ");
            }
            html.append(language.getString("CommissionedBy"));
            html.append(" ");
            if (config.containsInformationKey("CommissionerURL")) {
                html.append("<a href=\"");
                html.append(config.getInformation("CommissionerURL"));
                html.append("\" style=\"color:");
                html.append(String.format("#%02X%02X%02X", linkColour.getRed(), linkColour.getGreen(), linkColour.getBlue()));
                html.append("\">");
            }
            html.append(config.getInformation("CommissionerName"));
            if (config.containsInformationKey("CommissionerURL")) {
                html.append("</a>");
            }
        }
        if (config.containsInformationKey("SupportName")) {
            if (config.containsInformationKey("ArtistName") || config.containsInformationKey("ScripterName") || config.containsInformationKey("CommissionerName")) {
                html.append(" - ");
            }
            html.append(language.getString("SupportAt"));
            html.append(" ");
            if (config.containsInformationKey("SupportURL")) {
                html.append("<a href=\"");
                html.append(config.getInformation("SupportURL"));
                html.append("\" style=\"color:");
                html.append(String.format("#%02X%02X%02X", linkColour.getRed(), linkColour.getGreen(), linkColour.getBlue()));
                html.append("\">");
            }
            html.append(config.getInformation("SupportName"));
            if (config.containsInformationKey("SupportURL")) {
                html.append("</a>");
            }
        }
        html.append("</center>");
        this.pnlEditorPane.setText(html.toString());
        this.pnlEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                StringTokenizer st;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (st = new StringTokenizer(e.getDescription(), " ")).hasMoreTokens()) {
                    String url = st.nextToken();
                    if (JOptionPane.showConfirmDialog(InformationWindow.this, language.getString("ConfirmVisitWebsiteMessage") + "\n" + language.getString("ExerciseCautionAndBewareSusLinksMessage") + "\n" + url, language.getString("VisitWebsite"), 0) == 0) {
                        try {
                            Desktop desktop;
                            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                            if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) {
                                throw new UnsupportedOperationException(Main.getInstance().getLanguageBundle().getString("FailedOpenWebBrowserErrorMessage") + " " + url);
                            }
                            desktop.browse(new URI(url));
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(InformationWindow.this, exc.toString(), "Error", -1);
                        }
                    }
                }
            }
        });
        this.btnClose.setText(language.getString("Close"));
    }

    public boolean display() {
        float menuScaling = Float.parseFloat(Main.getInstance().getProperties().getProperty("MenuDPI", "96")) / 96.0f;
        this.pnlEditorPane.setBackground(this.getBackground());
        this.pnlEditorPane.setBorder(null);
        this.pnlScrollPane.setBorder(null);
        this.pnlScrollPane.setViewportBorder(null);
        this.lblSplashImage.setPreferredSize(new Dimension((int)((float)this.lblSplashImage.getIcon().getIconWidth() * menuScaling), (int)((float)this.lblSplashImage.getIcon().getIconHeight() * menuScaling)));
        this.pnlEditorPane.setPreferredSize(new Dimension((int)((float)this.pnlEditorPane.getPreferredSize().width * menuScaling), (int)((float)this.pnlEditorPane.getPreferredSize().height * menuScaling)));
        this.pnlScrollPane.setPreferredSize(new Dimension((int)((float)this.pnlScrollPane.getPreferredSize().width * menuScaling), (int)((float)this.pnlScrollPane.getPreferredSize().height * menuScaling)));
        this.btnClose.setPreferredSize(new Dimension((int)((float)this.btnClose.getPreferredSize().width * menuScaling), (int)((float)this.btnClose.getPreferredSize().height * menuScaling)));
        this.pnlFooter.setPreferredSize(new Dimension(this.pnlFooter.getPreferredSize().width, this.btnClose.getPreferredSize().height + 6));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return true;
    }

    private void initComponents() {
        this.pnlImage = new JPanel();
        this.lblSplashImage = new JLabel();
        this.pnlScrollPane = new JScrollPane();
        this.pnlEditorPane = new JEditorPane();
        this.pnlFooter = new JPanel();
        this.btnClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.pnlImage.setLayout(new BoxLayout(this.pnlImage, 1));
        this.lblSplashImage.setAlignmentX(0.5f);
        this.pnlImage.add(this.lblSplashImage);
        this.pnlEditorPane.setEditable(false);
        this.pnlEditorPane.setBorder(null);
        this.pnlEditorPane.setContentType("text/html");
        this.pnlEditorPane.setText("");
        this.pnlScrollPane.setViewportView(this.pnlEditorPane);
        this.pnlFooter.setPreferredSize(new Dimension(380, 36));
        this.pnlFooter.setLayout(new FlowLayout(1, 10, 5));
        this.btnClose.setText("Close");
        this.btnClose.setMaximumSize(new Dimension(130, 26));
        this.btnClose.setMinimumSize(new Dimension(95, 23));
        this.btnClose.setName("");
        this.btnClose.setPreferredSize(new Dimension(130, 26));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InformationWindow.this.btnCloseActionPerformed(evt);
            }
        });
        this.pnlFooter.add(this.btnClose);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pnlImage, -1, 600, Short.MAX_VALUE).addComponent(this.pnlFooter, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlScrollPane, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlImage, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlScrollPane, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlFooter, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(InformationWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(InformationWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(InformationWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(InformationWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

