/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.language;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.toml.Toml;
import su.plo.config.toml.TomlWriter;
import su.plo.slib.api.language.ServerTranslator;
import su.plo.slib.api.logging.McLazyLogger;
import su.plo.slib.api.logging.McLoggerFactory;
import su.plo.voice.api.server.language.ServerLanguages;
import su.plo.voice.api.server.resource.ResourceLoader;
import su.plo.voice.libs.crowdin.CrowdinLib;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.ResultKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.coroutines.Continuation;
import su.plo.voice.libs.kotlin.coroutines.intrinsics.IntrinsicsKt;
import su.plo.voice.libs.kotlin.enums.EnumEntries;
import su.plo.voice.libs.kotlin.enums.EnumEntriesKt;
import su.plo.voice.libs.kotlin.io.CloseableKt;
import su.plo.voice.libs.kotlin.io.TextStreamsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.functions.Function2;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.StringsKt;
import su.plo.voice.libs.kotlinx.coroutines.CoroutineScope;
import su.plo.voice.libs.kotlinx.coroutines.future.FutureKt;
import su.plo.voice.util.CoroutineScopes;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J(\u0010\u001d\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rH\u0002J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%2\u0006\u0010!\u001a\u00020\"H\u0002J2\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010&\u001a\u00020\u00102\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u000eH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lsu/plo/voice/server/language/VoiceServerLanguages;", "Lsu/plo/voice/api/server/language/ServerLanguages;", "serverTranslator", "Lsu/plo/slib/api/language/ServerTranslator;", "crowdinEnabled", "", "(Lsu/plo/slib/api/language/ServerTranslator;Z)V", "getCrowdinEnabled", "()Z", "setCrowdinEnabled", "(Z)V", "languages", "", "", "Lsu/plo/voice/server/language/VoiceServerLanguages$VoiceServerLanguage;", "downloadCrowdinTranslations", "", "translationsURL", "Ljava/net/URL;", "fileName", "languagesFolder", "Ljava/io/File;", "getClientLanguage", "", "languageName", "getLanguage", "scope", "Lsu/plo/voice/server/language/VoiceServerLanguages$LanguageScope;", "getServerLanguage", "loadLanguage", "languageFile", "defaults", "Lsu/plo/config/toml/Toml;", "resourceLoader", "Lsu/plo/voice/api/server/resource/ResourceLoader;", "crowdinTranslation", "readLanguagesList", "", "register", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "registerSync", "saveLanguage", "language", "Companion", "LanguageScope", "VoiceServerLanguage", "server-proxy-common"})
@SourceDebugExtension(value={"SMAP\nVoiceServerLanguages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerLanguages.kt\nsu/plo/voice/server/language/VoiceServerLanguages\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,438:1\n1855#2,2:439\n1855#2,2:441\n766#2:447\n857#2,2:448\n215#3,2:443\n215#3,2:445\n*S KotlinDebug\n*F\n+ 1 VoiceServerLanguages.kt\nsu/plo/voice/server/language/VoiceServerLanguages\n*L\n38#1:439,2\n98#1:441,2\n340#1:447\n340#1:448,2\n217#1:443,2\n222#1:445,2\n*E\n"})
public final class VoiceServerLanguages
implements ServerLanguages {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerTranslator serverTranslator;
    private boolean crowdinEnabled;
    @NotNull
    private final Map<String, VoiceServerLanguage> languages;
    @NotNull
    private static final McLazyLogger LOGGER = McLoggerFactory.createLogger("VoiceServerLanguages");

    public VoiceServerLanguages(@NotNull ServerTranslator serverTranslator, boolean crowdinEnabled) {
        Intrinsics.checkNotNullParameter(serverTranslator, "serverTranslator");
        this.serverTranslator = serverTranslator;
        this.crowdinEnabled = crowdinEnabled;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap(...)");
        this.languages = hashMap;
    }

    public /* synthetic */ VoiceServerLanguages(ServerTranslator serverTranslator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(serverTranslator, bl);
    }

    @Override
    public boolean getCrowdinEnabled() {
        return this.crowdinEnabled;
    }

    @Override
    public void setCrowdinEnabled(boolean bl) {
        this.crowdinEnabled = bl;
    }

    @Override
    @NotNull
    public synchronized CompletableFuture<Void> register(@NotNull ResourceLoader resourceLoader, @NotNull File languagesFolder) {
        Intrinsics.checkNotNullParameter(resourceLoader, "resourceLoader");
        Intrinsics.checkNotNullParameter(languagesFolder, "languagesFolder");
        try {
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap(...)");
            Map languages = hashMap;
            List<String> languagesList = this.readLanguagesList(resourceLoader);
            Iterable $this$forEach$iv = languagesList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String languageName = (String)element$iv;
                boolean bl = false;
                String string = "%s.toml";
                Object[] objectArray = new Object[]{languageName};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                File languageFile = new File(languagesFolder, string2);
                VoiceServerLanguage language2 = this.loadLanguage(resourceLoader, languageFile, languageName);
                languages.put(languageName, language2);
            }
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> VoiceServerLanguages.register$lambda$1(this, languages, languagesFolder));
            Intrinsics.checkNotNullExpressionValue(completableFuture, "runAsync(...)");
            return completableFuture;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load languages", e);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Void> register(@NotNull URL translationsURL, @Nullable String fileName, @NotNull ResourceLoader resourceLoader, @NotNull File languagesFolder) {
        Intrinsics.checkNotNullParameter(translationsURL, "translationsURL");
        Intrinsics.checkNotNullParameter(resourceLoader, "resourceLoader");
        Intrinsics.checkNotNullParameter(languagesFolder, "languagesFolder");
        return FutureKt.future$default(CoroutineScopes.INSTANCE.getDefaultSupervisor(), null, null, new Function2<CoroutineScope, Continuation<? super Void>, Object>(this, translationsURL, fileName, resourceLoader, languagesFolder, null){
            int label;
            final /* synthetic */ VoiceServerLanguages this$0;
            final /* synthetic */ URL $translationsURL;
            final /* synthetic */ String $fileName;
            final /* synthetic */ ResourceLoader $resourceLoader;
            final /* synthetic */ File $languagesFolder;
            {
                this.this$0 = $receiver;
                this.$translationsURL = $translationsURL;
                this.$fileName = $fileName;
                this.$resourceLoader = $resourceLoader;
                this.$languagesFolder = $languagesFolder;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        VoiceServerLanguages.access$registerSync(this.this$0, this.$translationsURL, this.$fileName, this.$resourceLoader, this.$languagesFolder);
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Void> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @Override
    @NotNull
    public Map<String, String> getServerLanguage(@Nullable String languageName) {
        return this.getLanguage(languageName, LanguageScope.SERVER);
    }

    @Override
    @NotNull
    public Map<String, String> getClientLanguage(@Nullable String languageName) {
        return this.getLanguage(languageName, LanguageScope.CLIENT);
    }

    private final void registerSync(URL translationsURL, String fileName, ResourceLoader resourceLoader, File languagesFolder) {
        try {
            String[] languageFileName;
            File crowdinFolder;
            if (this.getCrowdinEnabled()) {
                try {
                    this.downloadCrowdinTranslations(translationsURL, fileName, languagesFolder);
                }
                catch (Exception e) {
                    Object[] objectArray = new Object[]{translationsURL, fileName, e.getMessage()};
                    LOGGER.warn("Failed to download archive with translations {} ({}) translations: {}", objectArray);
                }
            }
            if (!(crowdinFolder = new File(languagesFolder, ".crowdin")).exists()) {
                this.register(resourceLoader, languagesFolder).get();
                return;
            }
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap(...)");
            Map languages = hashMap;
            List<String> languagesList = this.readLanguagesList(resourceLoader);
            Iterable $this$forEach$iv = languagesList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String languageName = (String)element$iv;
                boolean bl = false;
                languageFileName = languageName + ".toml";
                File crowdinFile = new File(crowdinFolder, (String)languageFileName);
                File languageFile = new File(languagesFolder, (String)languageFileName);
                VoiceServerLanguage language2 = this.loadLanguage(resourceLoader, crowdinFile, languageFile, languageName);
                languages.put(languageName, language2);
            }
            File[] crowdinTranslations = crowdinFolder.listFiles();
            if (crowdinTranslations != null) {
                for (File crowdinFile : crowdinTranslations) {
                    if (Intrinsics.areEqual(crowdinFile.getName(), "timestamp")) continue;
                    String string = crowdinFile.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    languageFileName = new String[]{"."};
                    String languageName = (String)StringsKt.split$default((CharSequence)string, languageFileName, false, 0, 6, null).get(0);
                    if (languages.containsKey(languageName)) continue;
                    File languageFile = new File(languagesFolder, crowdinFile.getName());
                    Intrinsics.checkNotNull(crowdinFile);
                    VoiceServerLanguage language3 = this.loadLanguage(resourceLoader, crowdinFile, languageFile, languageName);
                    languages.put(languageName, language3);
                }
            }
            this.register(languages, languagesFolder);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load languages", e);
        }
    }

    private final void downloadCrowdinTranslations(URL translationsURL, String fileName, File languagesFolder) throws Exception {
        Object object;
        long timestamp = 0L;
        File crowdinFolder = new File(languagesFolder, ".crowdin");
        File timestampFile = new File(crowdinFolder, "timestamp");
        if (timestampFile.exists()) {
            byte[] byArray = Files.readAllBytes(timestampFile.toPath());
            Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
            object = byArray;
            String timestampString = new String((byte[])object, su.plo.voice.libs.kotlin.text.Charsets.UTF_8);
            try {
                timestamp = Long.parseLong(timestampString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (System.currentTimeMillis() - timestamp < 259200000L) {
            return;
        }
        Object t = CrowdinLib.downloadRawTranslations$default(CrowdinLib.INSTANCE, translationsURL, fileName, null, 4, null).get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        Map rawTranslations = (Map)t;
        crowdinFolder.mkdirs();
        Path path = timestampFile.toPath();
        object = String.valueOf(System.currentTimeMillis());
        byte[] byArray = ((String)object).getBytes(su.plo.voice.libs.kotlin.text.Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Files.write(path, byArray, new OpenOption[0]);
        if (rawTranslations.isEmpty()) {
            return;
        }
        for (Map.Entry entry : rawTranslations.entrySet()) {
            String languageName = (String)entry.getKey();
            byte[] translationBytes = (byte[])entry.getValue();
            Files.write(new File(crowdinFolder, languageName + ".toml").toPath(), translationBytes, new OpenOption[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void register(Map<String, VoiceServerLanguage> languages, File languagesFolder) throws IOException {
        String languageName;
        Map.Entry<String, VoiceServerLanguage> entry;
        Map.Entry<String, VoiceServerLanguage> element$iv;
        VoiceServerLanguage value;
        void entry2;
        if (languages.isEmpty()) {
            return;
        }
        String string = this.serverTranslator.getDefaultLanguage();
        VoiceServerLanguage voiceServerLanguage = languages.get(CollectionsKt.first((Iterable)languages.keySet()));
        Intrinsics.checkNotNull(voiceServerLanguage);
        VoiceServerLanguage defaultLanguage2 = languages.getOrDefault(string, voiceServerLanguage);
        languagesFolder.mkdirs();
        File[] fileArray = languagesFolder.listFiles();
        Intrinsics.checkNotNull(fileArray);
        File[] fileArray2 = fileArray;
        boolean bl = false;
        int iterator2 = fileArray2.length;
        while (entry2 < iterator2) {
            File file = fileArray2[entry2];
            if (!file.isDirectory()) {
                String fileName = file.getName();
                Intrinsics.checkNotNull(fileName);
                if (StringsKt.endsWith$default(fileName, ".toml", false, 2, null)) {
                    String languageName2;
                    Intrinsics.checkNotNullExpressionValue(fileName.substring(0, fileName.length() - 5), "substring(...)");
                    if (!languages.containsKey(languageName2)) {
                        Intrinsics.checkNotNull(file);
                        VoiceServerLanguage language3 = this.loadLanguage(file, null);
                        language3.merge(defaultLanguage2);
                        languages.put(languageName2, language3);
                    }
                }
            }
            ++entry2;
        }
        for (Map.Entry entry3 : languages.entrySet()) {
            String key = (String)entry3.getKey();
            value = (VoiceServerLanguage)entry3.getValue();
            File languageFile = new File(languagesFolder, key + ".toml");
            this.saveLanguage(languageFile, value);
        }
        for (Map.Entry entry3 : languages.entrySet()) {
            VoiceServerLanguage language4;
            String languageName3 = (String)entry3.getKey();
            value = (VoiceServerLanguage)entry3.getValue();
            Intrinsics.checkNotNullExpressionValue(this.languages.computeIfAbsent(languageName3, arg_0 -> VoiceServerLanguages.register$lambda$3(new Function1<String, VoiceServerLanguage>(value){
                final /* synthetic */ VoiceServerLanguage $value;
                {
                    this.$value = $value;
                    super(1);
                }

                @NotNull
                public final VoiceServerLanguage invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$value;
                }
            }, arg_0)), "computeIfAbsent(...)");
            language4.merge(value);
            language4.merge(defaultLanguage2);
        }
        Map<String, VoiceServerLanguage> $this$forEach$iv = this.languages;
        boolean bl2 = false;
        Iterator<Map.Entry<String, VoiceServerLanguage>> iterator3 = $this$forEach$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            entry = element$iv = iterator3.next();
            boolean bl3 = false;
            languageName = entry.getKey();
            VoiceServerLanguage language2 = entry.getValue();
            if (languages.containsKey(languageName)) continue;
            language2.merge(defaultLanguage2);
        }
        $this$forEach$iv = this.languages;
        boolean bl4 = false;
        iterator3 = $this$forEach$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            entry = element$iv = iterator3.next();
            boolean bl5 = false;
            languageName = entry.getKey();
            VoiceServerLanguage language2 = entry.getValue();
            this.serverTranslator.register(languageName, language2.getServerLanguage());
        }
    }

    private final Map<String, String> getLanguage(String languageName, LanguageScope scope) {
        String string;
        block6: {
            block5: {
                string = languageName;
                if (string == null) break block5;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                string = string2;
                if (string2 != null) break block6;
            }
            string = this.serverTranslator.getDefaultLanguage();
        }
        VoiceServerLanguage language2 = this.languages.get(string);
        if (languageName == null && language2 == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            Intrinsics.checkNotNullExpressionValue(immutableMap, "of(...)");
            return (Map)immutableMap;
        }
        if (language2 == null) {
            return this.getLanguage(null, scope);
        }
        return scope == LanguageScope.SERVER ? language2.getServerLanguage() : language2.getClientLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VoiceServerLanguage loadLanguage(ResourceLoader resourceLoader, File crowdinTranslation, File languageFile, String languageName) throws IOException {
        Object inputStream2;
        Object object;
        Toml crowdinDefaults = null;
        if (crowdinTranslation.exists()) {
            Closeable closeable = new FileInputStream(crowdinTranslation);
            object = null;
            try {
                inputStream2 = (FileInputStream)closeable;
                boolean bl = false;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream2, Charsets.UTF_8);
                crowdinDefaults = new Toml().read(inputStreamReader);
                inputStream2 = Unit.INSTANCE;
            }
            catch (Throwable inputStream2) {
                object = inputStream2;
                throw inputStream2;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)object);
            }
        }
        Toml jarDefaults = null;
        try {
            object = resourceLoader.load("languages/" + languageName + ".toml");
            inputStream2 = null;
            try {
                InputStream inputStream3 = (InputStream)object;
                boolean bl = false;
                if (inputStream3 != null) {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream3, Charsets.UTF_8);
                    jarDefaults = new Toml().read(inputStreamReader);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                inputStream2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)inputStream2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (crowdinDefaults == null && jarDefaults == null) {
            throw new IOException("Both crowdin and jar defaults are null for language " + languageName);
        }
        Toml tomlLanguage = new Toml();
        if (languageFile.exists()) {
            try {
                tomlLanguage.read(languageFile);
            }
            catch (Exception e) {
                throw new IOException("Failed to load language " + languageFile.getName(), e);
            }
        }
        VoiceServerLanguage language2 = new VoiceServerLanguage(tomlLanguage, null);
        if (crowdinDefaults != null) {
            language2.merge(new VoiceServerLanguage(crowdinDefaults, null));
        }
        if (jarDefaults != null) {
            language2.merge(new VoiceServerLanguage(jarDefaults, null));
        }
        return language2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VoiceServerLanguage loadLanguage(ResourceLoader resourceLoader, File languageFile, String languageName) throws IOException {
        try {
            Closeable closeable = resourceLoader.load("languages/" + languageName + ".toml");
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                if (inputStream == null) {
                    throw new IOException("Resource 'languages/" + languageName + ".toml' not found");
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.UTF_8);
                Toml toml = new Toml().read(inputStreamReader);
                Intrinsics.checkNotNullExpressionValue(toml, "read(...)");
                Toml defaults = toml;
                VoiceServerLanguage voiceServerLanguage = this.loadLanguage(languageFile, defaults);
                return voiceServerLanguage;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to load language " + languageName, e);
        }
    }

    private final VoiceServerLanguage loadLanguage(File languageFile, Toml defaults) throws IOException {
        Toml language2 = new Toml();
        if (languageFile.exists()) {
            try {
                language2.read(languageFile);
            }
            catch (Exception e) {
                throw new IOException("Failed to load language " + languageFile.getName(), e);
            }
        }
        return new VoiceServerLanguage(language2, defaults);
    }

    private final void saveLanguage(File languageFile, VoiceServerLanguage language2) throws IOException {
        try {
            new TomlWriter().write(language2.getOriginal(), languageFile);
        }
        catch (Exception e) {
            throw new IOException("Failed to save language", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<String> readLanguagesList(ResourceLoader resourceLoader) {
        Closeable closeable = resourceLoader.load("languages/list");
        Throwable throwable = null;
        try {
            List list;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) {
                throw new IllegalStateException("Resource 'languages/list' not found");
            }
            InputStream languagesList = inputStream2;
            Closeable closeable2 = new BufferedReader(new InputStreamReader(languagesList, StandardCharsets.UTF_8));
            Throwable throwable2 = null;
            try {
                void $this$filterTo$iv$iv;
                BufferedReader br = (BufferedReader)closeable2;
                boolean bl2 = false;
                Iterable $this$filter$iv = TextStreamsKt.readLines(br);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)it).length() > 0;
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally(closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally(closeable2, throwable2);
            List list2 = list;
            return list2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private static final void register$lambda$1(VoiceServerLanguages this$0, Map $languages, File $languagesFolder) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($languages, "$languages");
        Intrinsics.checkNotNullParameter($languagesFolder, "$languagesFolder");
        this$0.register($languages, $languagesFolder);
    }

    private static final VoiceServerLanguage register$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (VoiceServerLanguage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$registerSync(VoiceServerLanguages $this, URL translationsURL, String fileName, ResourceLoader resourceLoader, File languagesFolder) {
        $this.registerSync(translationsURL, fileName, resourceLoader, languagesFolder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsu/plo/voice/server/language/VoiceServerLanguages$Companion;", "", "()V", "LOGGER", "Lsu/plo/slib/api/logging/McLazyLogger;", "server-proxy-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lsu/plo/voice/server/language/VoiceServerLanguages$LanguageScope;", "", "(Ljava/lang/String;I)V", "CLIENT", "SERVER", "server-proxy-common"})
    private static final class LanguageScope
    extends Enum<LanguageScope> {
        public static final /* enum */ LanguageScope CLIENT = new LanguageScope();
        public static final /* enum */ LanguageScope SERVER = new LanguageScope();
        private static final /* synthetic */ LanguageScope[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LanguageScope[] values() {
            return (LanguageScope[])$VALUES.clone();
        }

        public static LanguageScope valueOf(String value) {
            return Enum.valueOf(LanguageScope.class, value);
        }

        @NotNull
        public static EnumEntries<LanguageScope> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = languageScopeArray = new LanguageScope[]{LanguageScope.CLIENT, LanguageScope.SERVER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0000J<\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fH\u0002J.\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u0017"}, d2={"Lsu/plo/voice/server/language/VoiceServerLanguages$VoiceServerLanguage;", "", "language", "Lsu/plo/config/toml/Toml;", "defaults", "(Lsu/plo/config/toml/Toml;Lsu/plo/config/toml/Toml;)V", "clientLanguage", "", "", "getClientLanguage", "()Ljava/util/Map;", "original", "", "getOriginal", "setOriginal", "(Ljava/util/Map;)V", "serverLanguage", "getServerLanguage", "languageToMapOfStrings", "merge", "", "mergeMaps", "scope", "server-proxy-common"})
    @SourceDebugExtension(value={"SMAP\nVoiceServerLanguages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceServerLanguages.kt\nsu/plo/voice/server/language/VoiceServerLanguages$VoiceServerLanguage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,438:1\n215#2:439\n215#2,2:440\n216#2:442\n*S KotlinDebug\n*F\n+ 1 VoiceServerLanguages.kt\nsu/plo/voice/server/language/VoiceServerLanguages$VoiceServerLanguage\n*L\n419#1:439\n423#1:440,2\n419#1:442\n*E\n"})
    private static final class VoiceServerLanguage {
        @NotNull
        private Map<String, ? extends Object> original;
        @NotNull
        private final Map<String, String> serverLanguage;
        @NotNull
        private final Map<String, String> clientLanguage;

        public VoiceServerLanguage(@NotNull Toml language2, @Nullable Toml defaults) {
            Map<String, Object> map2;
            Intrinsics.checkNotNullParameter(language2, "language");
            if (defaults == null) {
                Map<String, Object> map3 = language2.toMap();
                map2 = map3;
                Intrinsics.checkNotNullExpressionValue(map3, "toMap(...)");
            } else {
                Map<String, Object> map4 = language2.toMap();
                Intrinsics.checkNotNullExpressionValue(map4, "toMap(...)");
                Map<String, Object> map5 = defaults.toMap();
                Intrinsics.checkNotNullExpressionValue(map5, "toMap(...)");
                map2 = this.mergeMaps(map4, map5);
            }
            this.original = map2;
            this.serverLanguage = this.mergeMaps(language2, "server", defaults);
            this.clientLanguage = this.mergeMaps(language2, "client", defaults);
        }

        @NotNull
        public final Map<String, Object> getOriginal() {
            return this.original;
        }

        public final void setOriginal(@NotNull Map<String, ? extends Object> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.original = map2;
        }

        @NotNull
        public final Map<String, String> getServerLanguage() {
            return this.serverLanguage;
        }

        @NotNull
        public final Map<String, String> getClientLanguage() {
            return this.clientLanguage;
        }

        public final void merge(@NotNull VoiceServerLanguage language2) {
            Intrinsics.checkNotNullParameter(language2, "language");
            this.original = this.mergeMaps(this.original, language2.original);
            language2.serverLanguage.forEach((arg_0, arg_1) -> VoiceServerLanguage.merge$lambda$0(new Function2<String, String, Unit>(this.serverLanguage){

                public final void invoke(@NotNull String p0, @NotNull String p1) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    ((Map)this.receiver).putIfAbsent(p0, p1);
                }
            }, arg_0, arg_1));
            language2.clientLanguage.forEach((arg_0, arg_1) -> VoiceServerLanguage.merge$lambda$2(new Function2<String, String, Unit>(this.clientLanguage){

                public final void invoke(@NotNull String p0, @NotNull String p1) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    ((Map)this.receiver).putIfAbsent(p0, p1);
                }
            }, arg_0, arg_1));
        }

        private final Map<String, Object> mergeMaps(Map<String, ? extends Object> language2, Map<String, ? extends Object> defaults) {
            ConcurrentMap concurrentMap = Maps.newConcurrentMap();
            Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
            Map merged = concurrentMap;
            merged.putAll(language2);
            for (Map.Entry<String, ? extends Object> entry : defaults.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Map map2 = merged;
                    Object object = language2.get(key);
                    if (object == null) {
                        object = Maps.newHashMap();
                    }
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    Map<String, Object> map3 = this.mergeMaps((Map)object, (Map)value);
                    map2.put(key, map3);
                    continue;
                }
                if (language2.containsKey(key)) continue;
                merged.put(key, value);
            }
            return merged;
        }

        private final Map<String, String> mergeMaps(Toml language2, String scope, Toml defaults) {
            ConcurrentMap concurrentMap = Maps.newConcurrentMap();
            Intrinsics.checkNotNullExpressionValue(concurrentMap, "newConcurrentMap(...)");
            Map defaultsMap = concurrentMap;
            if (defaults != null) {
                Toml toml = defaults.getTable(scope) == null ? new Toml() : defaults.getTable(scope);
                Intrinsics.checkNotNull(toml);
                defaultsMap.putAll(this.languageToMapOfStrings(toml));
            }
            Toml toml = language2.getTable(scope) == null ? new Toml() : language2.getTable(scope);
            Intrinsics.checkNotNull(toml);
            Map<String, String> languageMap = this.languageToMapOfStrings(toml);
            defaultsMap.putAll(languageMap);
            return defaultsMap;
        }

        private final Map<String, String> languageToMapOfStrings(Toml language2) {
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap(...)");
            Map languageMap = hashMap;
            Map<String, Object> map2 = language2.toMap();
            Intrinsics.checkNotNullExpressionValue(map2, "toMap(...)");
            Map<String, Object> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Map<String, String> tableContents;
                    Toml toml = language2.getTable(key);
                    Intrinsics.checkNotNullExpressionValue(toml, "getTable(...)");
                    Map<String, String> $this$forEach$iv2 = tableContents = this.languageToMapOfStrings(toml);
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<String, String>> iterator3 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry<String, String> element$iv2;
                        Map.Entry<String, String> entry2 = element$iv2 = iterator3.next();
                        boolean bl2 = false;
                        String contentKey = entry2.getKey();
                        String contentValue = entry2.getValue();
                        languageMap.put(key + '.' + contentKey, contentValue);
                    }
                    continue;
                }
                Intrinsics.checkNotNull(key);
                languageMap.put(key, value.toString());
            }
            return languageMap;
        }

        private static final void merge$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final void merge$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }
}

