/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.VertexFormatMode;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.event.render.VoiceDistanceRenderEvent;
import su.plo.voice.api.client.render.DistanceVisualizer;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.render.LevelRenderEvent;
import su.plo.voice.client.extension.OptionsKt;
import su.plo.voice.client.render.ModCamera;

public final class VoiceDistanceVisualizer
implements DistanceVisualizer {
    private static final int SPHERE_STACK = 18;
    private static final int SPHERE_SLICE = 36;
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final Map<UUID, VisualizeEntry> entries = Maps.newConcurrentMap();

    @Override
    public synchronized void render(int radius, int color, @Nullable Pos3d position) {
        if (!((Boolean)this.config.getAdvanced().getVisualizeVoiceDistance().value()).booleanValue()) {
            return;
        }
        if (radius < 2 || radius > OptionsKt.renderDistanceValue(class_310.method_1551().field_1690) * 16) {
            return;
        }
        VoiceDistanceRenderEvent event = new VoiceDistanceRenderEvent(this, radius, color);
        if (!this.voiceClient.getEventBus().fire(event)) {
            return;
        }
        UUID key = position == null ? UUID.fromString("00000000-0000-0000-0000-000000000000") : UUID.randomUUID();
        this.entries.put(key, new VisualizeEntry(color, radius, position != null ? new class_243(position.getX(), position.getY(), position.getZ()) : null));
    }

    @EventSubscribe
    public void onLevelRender(@NotNull LevelRenderEvent event) {
        for (Map.Entry<UUID, VisualizeEntry> entry : this.entries.entrySet()) {
            UUID key = entry.getKey();
            VisualizeEntry value = entry.getValue();
            if (value.alpha() == 0 || !((Boolean)this.config.getAdvanced().getVisualizeVoiceDistance().value()).booleanValue()) {
                this.entries.remove(key);
                continue;
            }
            if (value.position() != null && event.getCamera().position().method_1022(value.position()) > (double)(OptionsKt.renderDistanceValue(class_310.method_1551().field_1690) * 16)) {
                this.entries.remove(key);
                continue;
            }
            this.renderEntry(value, event.getStack(), event.getCamera(), event.getDelta());
        }
    }

    private void renderEntry(@NotNull VisualizeEntry entry, @NotNull class_4587 stack, @NotNull ModCamera camera, float delta) {
        class_243 center;
        if (System.currentTimeMillis() - entry.lastChanged() > 2000L) {
            entry.alpha(Math.max(0, entry.alpha() - (int)(10.0f * delta)));
        }
        if (entry.position() != null) {
            center = entry.position();
        } else {
            class_746 clientPlayer = class_310.method_1551().field_1724;
            if (clientPlayer == null) {
                return;
            }
            center = clientPlayer.method_19538();
        }
        RenderUtil.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderUtil.polygonOffset(-3.0f, -3.0f);
        RenderUtil.enablePolygonOffset();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.method_22903();
        RenderUtil.lineWidth(1.0f);
        stack.method_22904(center.field_1352 - camera.position().field_1352, center.field_1351 - camera.position().field_1351, center.field_1350 - camera.position().field_1350);
        class_287 buffer = RenderUtil.beginBufferWithDefaultShader(VertexFormatMode.TRIANGLE_STRIP, class_290.field_1576);
        int r = entry.color() >> 16 & 0xFF;
        int g = entry.color() >> 8 & 0xFF;
        int b = entry.color() & 0xFF;
        float stackStep = 0.17453292f;
        float sliceStep = 0.08726646f;
        for (int i = 0; i < 18; ++i) {
            float alpha0 = (float)(-1.5707963267948966 + (double)((float)i * stackStep));
            float alpha1 = alpha0 + stackStep;
            float r0 = (float)((double)entry.radius() * Math.cos(alpha0));
            float r1 = (float)((double)entry.radius() * Math.cos(alpha1));
            float y0 = (float)((double)entry.radius() * Math.sin(alpha0));
            float y1 = (float)((double)entry.radius() * Math.sin(alpha1));
            for (int j = 0; j < 72; ++j) {
                float beta = (float)j * sliceStep;
                float x0 = (float)((double)r0 * Math.cos(beta));
                float x1 = (float)((double)r1 * Math.cos(beta));
                float z0 = (float)((double)(-r0) * Math.sin(beta));
                float z1 = (float)((double)(-r1) * Math.sin(beta));
                VertexBuilder.create(buffer).position(stack, x0, y0, z0).color(r, g, b, entry.alpha()).end();
                VertexBuilder.create(buffer).position(stack, x1, y1, z1).color(r, g, b, entry.alpha()).end();
            }
        }
        RenderUtil.drawBuffer(buffer);
        stack.method_22909();
        RenderUtil.polygonOffset(0.0f, 0.0f);
        RenderUtil.disablePolygonOffset();
        RenderSystem.disableBlend();
        RenderUtil.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderUtil.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    public VoiceDistanceVisualizer(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }

    private static final class VisualizeEntry {
        private final int color;
        private final float radius;
        @Nullable
        private final class_243 position;
        private int alpha = 150;
        private long lastChanged = System.currentTimeMillis();

        public VisualizeEntry(int color, float radius, @Nullable class_243 position) {
            this.color = color;
            this.radius = radius;
            this.position = position;
        }

        public int color() {
            return this.color;
        }

        public float radius() {
            return this.radius;
        }

        @Nullable
        public class_243 position() {
            return this.position;
        }

        public int alpha() {
            return this.alpha;
        }

        public long lastChanged() {
            return this.lastChanged;
        }

        public VisualizeEntry alpha(int alpha) {
            this.alpha = alpha;
            return this;
        }

        public VisualizeEntry lastChanged(long lastChanged) {
            this.lastChanged = lastChanged;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VisualizeEntry)) {
                return false;
            }
            VisualizeEntry other = (VisualizeEntry)o;
            if (this.color() != other.color()) {
                return false;
            }
            if (Float.compare(this.radius(), other.radius()) != 0) {
                return false;
            }
            if (this.alpha() != other.alpha()) {
                return false;
            }
            if (this.lastChanged() != other.lastChanged()) {
                return false;
            }
            class_243 this$position = this.position();
            class_243 other$position = other.position();
            return !(this$position == null ? other$position != null : !this$position.equals(other$position));
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            result2 = result2 * 59 + this.color();
            result2 = result2 * 59 + Float.floatToIntBits(this.radius());
            result2 = result2 * 59 + this.alpha();
            long $lastChanged = this.lastChanged();
            result2 = result2 * 59 + (int)($lastChanged >>> 32 ^ $lastChanged);
            class_243 $position = this.position();
            result2 = result2 * 59 + ($position == null ? 43 : $position.hashCode());
            return result2;
        }

        public String toString() {
            return "VoiceDistanceVisualizer.VisualizeEntry(color=" + this.color() + ", radius=" + this.radius() + ", position=" + this.position() + ", alpha=" + this.alpha() + ", lastChanged=" + this.lastChanged() + ")";
        }
    }
}

