/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_266;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.VertexFormatMode;
import su.plo.lib.mod.extensions.PoseStackKt;
import su.plo.slib.api.chat.component.McLiteralText;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.position.Pos3d;
import su.plo.slib.mod.extension.ScoreboardKt;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.audio.source.ClientStaticSource;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.LivingEntityRenderEvent;
import su.plo.voice.client.event.render.LevelRenderEvent;
import su.plo.voice.client.extension.MathKt;
import su.plo.voice.client.gui.PlayerVolumeAction;
import su.plo.voice.client.render.ModCamera;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;

public final class SourceIconRenderer {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final PlayerVolumeAction volumeAction;

    public SourceIconRenderer(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull PlayerVolumeAction volumeAction) {
        this.voiceClient = voiceClient;
        this.config = config;
        this.volumeAction = volumeAction;
        LivingEntityRenderEvent.INSTANCE.registerListener(this::onLivingEntityRender);
    }

    @EventSubscribe
    public void onLevelRender(@NotNull LevelRenderEvent event) {
        if (this.isIconHidden() || !((Boolean)this.config.getOverlay().getShowStaticSourceIcons().value()).booleanValue()) {
            return;
        }
        for (ClientAudioSource source2 : this.voiceClient.getSourceManager().getSources()) {
            if (!(source2.getSourceInfo() instanceof StaticSourceInfo) || !((SourceInfo)source2.getSourceInfo()).isIconVisible() || !source2.isActivated()) continue;
            Optional sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source2.getSourceInfo()).getLineId());
            if (!sourceLine.isPresent()) {
                return;
            }
            ClientStaticSource staticSource = (ClientStaticSource)source2;
            Pos3d sourcePosition = ((StaticSourceInfo)staticSource.getSourceInfo()).getPosition();
            this.renderStatic(event.getStack(), event.getCamera(), event.getLightSupplier().getLight(sourcePosition), class_2960.method_12829((String)((ClientSourceLine)sourceLine.get()).getIcon()), staticSource, event.getDelta());
        }
    }

    private void onLivingEntityRender(@NotNull class_1309 entity, @NotNull class_4587 stack, int light, boolean shouldShowName) {
        if (entity instanceof class_1657) {
            this.renderPlayer((class_1657)entity, stack, light, shouldShowName);
        } else {
            this.renderLivingEntity(entity, stack, light, shouldShowName);
        }
    }

    private void renderPlayer(@NotNull class_1657 player, @NotNull class_4587 stack, int light, boolean shouldShowName) {
        String iconLocation;
        boolean isFakePlayer;
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        boolean bl = isFakePlayer = !class_310.method_1551().method_1562().method_31363().contains(player.method_5667());
        if (this.isIconHidden() || player.method_5667().equals(clientPlayer.method_5667()) || isFakePlayer || player.method_5756((class_1657)clientPlayer)) {
            return;
        }
        boolean hasPercent = false;
        Optional<VoicePlayerInfo> playerInfo = connection.get().getPlayerById(player.method_5667());
        if (!playerInfo.isPresent()) {
            iconLocation = "plasmovoice:textures/icons/headset_not_installed.png";
        } else if (((Boolean)this.config.getVoice().getVolumes().getMute("source_" + player.method_5667()).value()).booleanValue()) {
            iconLocation = "plasmovoice:textures/icons/speaker_disabled.png";
        } else if (playerInfo.get().isMuted()) {
            iconLocation = "plasmovoice:textures/icons/speaker_muted.png";
        } else if (playerInfo.get().isVoiceDisabled()) {
            iconLocation = "plasmovoice:textures/icons/headset_disabled.png";
        } else {
            Collection sources = this.voiceClient.getSourceManager().getPlayerSources(player.method_5667());
            hasPercent = this.volumeAction.isShown(player);
            if (hasPercent) {
                this.renderPercent((class_1297)player, stack, light, shouldShowName);
            }
            if (sources.isEmpty()) {
                return;
            }
            ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(sources);
            if (highestSourceLine == null) {
                return;
            }
            iconLocation = highestSourceLine.getIcon();
        }
        this.renderEntity((class_1297)player, stack, light, shouldShowName, class_2960.method_12829((String)iconLocation), hasPercent);
    }

    private void renderLivingEntity(@NotNull class_1309 entity, @NotNull class_4587 stack, int light, boolean shouldShowName) {
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            return;
        }
        if (this.isIconHidden() || entity.method_5756((class_1657)clientPlayer)) {
            return;
        }
        Collection sources = this.voiceClient.getSourceManager().getEntitySources(entity.method_5628());
        ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(sources);
        if (highestSourceLine == null) {
            return;
        }
        this.renderEntity((class_1297)entity, stack, light, shouldShowName, class_2960.method_12829((String)highestSourceLine.getIcon()), false);
    }

    private void renderEntity(@NonNull class_1297 entity, @NonNull class_4587 stack, int light, boolean hasLabel, @NonNull class_2960 iconLocation, boolean hasPercent) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (iconLocation == null) {
            throw new NullPointerException("iconLocation is marked non-null but is null");
        }
        class_243 position = entity.method_19538();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        double distance = camera.method_19326().method_1028(position.method_10216(), position.method_10214(), position.method_10215());
        if (distance > 4096.0) {
            return;
        }
        stack.method_22903();
        if (hasPercent) {
            stack.method_22904(0.0, 0.3, 0.0);
        }
        this.translateEntityMatrix(entity, camera, stack, distance, hasLabel);
        if (entity.method_21752()) {
            this.vertices(stack, 40, light, iconLocation, false);
        } else {
            this.vertices(stack, 255, light, iconLocation, false);
            this.vertices(stack, 40, light, iconLocation, true);
        }
        stack.method_22909();
    }

    private void renderPercent(@NotNull class_1297 entity, @NonNull class_4587 stack, int light, boolean hasLabel) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        class_243 position = entity.method_19538();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        double distance = camera.method_19326().method_1028(position.method_10216(), position.method_10214(), position.method_10215());
        if (distance > 4096.0) {
            return;
        }
        stack.method_22903();
        this.translateEntityMatrix(entity, camera, stack, distance, hasLabel);
        stack.method_22904(5.0, 0.0, 0.0);
        DoubleConfigEntry volume = this.config.getVoice().getVolumes().getVolume("source_" + entity.method_5667());
        McLiteralText text = McTextComponent.literal((int)Math.round((Double)volume.value() * 100.0) + "%");
        int backgroundColor = 0x3F000000;
        int xOffset = -RenderUtil.getTextWidth(text) / 2;
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderUtil.fill(stack, xOffset - 1, -1, xOffset + RenderUtil.getTextWidth(text) + 1, 8, backgroundColor);
        RenderUtil.drawStringLight(stack, text, xOffset, 0, 0x20FFFFFF, light, !entity.method_21752(), false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderUtil.drawStringLight(stack, text, xOffset, 0, -1, light, false, false);
        RenderSystem.disableBlend();
        stack.method_22909();
    }

    private void translateEntityMatrix(@NotNull class_1297 entity, @NonNull class_4184 camera, @NonNull class_4587 stack, double distance, boolean hasLabel) {
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (hasLabel) {
            class_1657 player;
            class_266 belowNameObjective;
            stack.method_22904(0.0, 0.3, 0.0);
            if (entity instanceof class_1657 && (belowNameObjective = ScoreboardKt.getObjectiveBelowName((player = (class_1657)entity).method_7327())) != null && distance < 100.0) {
                stack.method_22904(0.0, 0.3, 0.0);
            }
        }
        stack.method_22904(0.0, (double)entity.method_17682() + 0.5, 0.0);
        PoseStackKt.rotate(stack, -camera.method_19330(), 0.0f, 1.0f, 0.0f);
        PoseStackKt.rotate(stack, camera.method_19329(), 1.0f, 0.0f, 0.0f);
        stack.method_22905(-0.025f, -0.025f, 0.025f);
        stack.method_22904(-5.0, -1.0, 0.0);
    }

    private void renderStatic(@NonNull class_4587 stack, @NonNull ModCamera camera, int light, @NotNull class_2960 iconLocation, @NotNull ClientStaticSource staticSource, double delta) {
        Pos3d lastPosition;
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        Pos3d position = ((StaticSourceInfo)staticSource.getSourceInfo()).getPosition();
        if (position.distanceSquared(lastPosition = staticSource.getLastRenderPosition()) > 1.0) {
            lastPosition.setX(position.getX());
            lastPosition.setY(position.getY());
            lastPosition.setZ(position.getZ());
        } else {
            lastPosition.setX(class_3532.method_16436((double)delta, (double)lastPosition.getX(), (double)position.getX()));
            lastPosition.setY(class_3532.method_16436((double)delta, (double)lastPosition.getY(), (double)position.getY()));
            lastPosition.setZ(class_3532.method_16436((double)delta, (double)lastPosition.getZ(), (double)position.getZ()));
        }
        double distanceToCamera = camera.position().method_1025(MathKt.toVec3(lastPosition));
        if (distanceToCamera > 4096.0) {
            return;
        }
        stack.method_22903();
        stack.method_22904(lastPosition.getX() - camera.position().field_1352, lastPosition.getY() - camera.position().field_1351, lastPosition.getZ() - camera.position().field_1350);
        PoseStackKt.rotate(stack, -camera.pitch(), 0.0f, 1.0f, 0.0f);
        PoseStackKt.rotate(stack, camera.yaw(), 1.0f, 0.0f, 0.0f);
        stack.method_22905(-0.025f, -0.025f, 0.025f);
        stack.method_22904(-5.0, 0.0, 0.0);
        this.vertices(stack, 255, light, iconLocation, false);
        this.vertices(stack, 40, light, iconLocation, true);
        stack.method_22909();
    }

    private void vertices(@NonNull class_4587 stack, int alpha, int light, @NotNull class_2960 iconLocation, boolean seeThrough) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (seeThrough) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        } else {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
        class_1921 renderType = seeThrough ? class_1921.method_23030((class_2960)iconLocation) : class_1921.method_23028((class_2960)iconLocation);
        class_287 buffer = RenderUtil.beginBufferWithDefaultShader(VertexFormatMode.QUADS, renderType.method_23031());
        this.vertex(stack, buffer, 0.0f, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
        this.vertex(stack, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        renderType.method_23012(buffer, RenderSystem.getVertexSorting());
    }

    private void vertex(@NonNull class_4587 stack, @NonNull class_287 buffer, float x, float y, float z, float u, float v, int alpha, int light) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        VertexBuilder.create(buffer).position(stack, x, y, z).color(255, 255, 255, alpha).uv(u, v).light(light).normal(stack, 0.0f, 0.0f, -1.0f).end();
    }

    private boolean isIconHidden() {
        int showIcons = (Integer)this.config.getOverlay().getShowSourceIcons().value();
        return showIcons == 2 || class_310.method_1551().field_1690.field_1842 && showIcons == 0;
    }

    private <T extends SourceInfo> ClientSourceLine getHighestActivatedSourceLine(@NotNull Collection<ClientAudioSource<T>> sources) {
        SourceLine highestSourceLine = null;
        for (ClientAudioSource<T> source2 : sources) {
            Optional sourceLine;
            if (!source2.isActivated() || !((SourceInfo)source2.getSourceInfo()).isIconVisible() || !(sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source2.getSourceInfo()).getLineId())).isPresent() || highestSourceLine != null && highestSourceLine.getWeight() >= ((ClientSourceLine)sourceLine.get()).getWeight()) continue;
            highestSourceLine = (ClientSourceLine)sourceLine.get();
        }
        return highestSourceLine;
    }
}

