/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.client.gui.components.AbstractSlider;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.client.config.hotkey.Hotkey;
import su.plo.voice.api.client.config.hotkey.Hotkeys;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class VolumeSliderWidget
extends AbstractSlider
implements UpdatableWidget {
    private final Hotkeys keyBindings;
    private final DoubleConfigEntry entry;
    private final String suffix;

    public VolumeSliderWidget(@NotNull Hotkeys keyBindings, @NotNull DoubleConfigEntry entry, @NotNull String suffix, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.keyBindings = keyBindings;
        this.entry = entry;
        this.suffix = suffix;
        this.updateValue();
    }

    @Override
    protected void updateText() {
        this.text = McTextComponent.literal(Math.round(this.value * (this.entry.getMax() * 100.0)) + this.suffix);
    }

    @Override
    protected void applyValue() {
        if (!this.keyBindings.getPressedKeys().contains(Hotkey.Type.KEYSYM.getOrCreate(340))) {
            this.value = this.calculateValue(this.value);
        }
        this.entry.set(this.value * this.entry.getMax());
    }

    @Override
    public void updateValue() {
        this.value = (Double)this.entry.value() / this.entry.getMax();
        this.updateText();
    }

    @Override
    protected void renderTrack(@NotNull class_4587 stack, int mouseX, int mouseY) {
        GuiWidgetTexture sprite = this.isHoveredOrFocused() ? GuiWidgetTexture.BUTTON_ACTIVE : GuiWidgetTexture.BUTTON_DEFAULT;
        RenderUtil.bindTexture(0, sprite.getLocation());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x0 = this.x + (int)(this.value * (double)(this.getSliderWidth() - 8));
        RenderUtil.blitSprite(stack, sprite, x0, this.y, 0, 0, 4, 20);
        RenderUtil.blitSprite(stack, sprite, x0 + 4, this.y, sprite.getSpriteWidth() - 4, 0, 4, 20);
    }

    private double calculateValue(double value) {
        return (double)(Math.round(value * this.entry.getMax() * 100.0 / 5.0) * 5L) / (this.entry.getMax() * 100.0);
    }
}

