/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.gui.screen.TooltipScreen;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.language.LanguageUtil;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.component.McTranslatableText;
import su.plo.slib.api.chat.style.McTextStyle;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientTimedOutEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.ModVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.extension.TextKt;
import su.plo.voice.client.gui.settings.MicrophoneTestController;
import su.plo.voice.client.gui.settings.VoiceScreens;
import su.plo.voice.client.gui.settings.VoiceSettingsAboutFeature;
import su.plo.voice.client.gui.settings.VoiceSettingsNavigation;
import su.plo.voice.client.gui.settings.tab.ActivationTabWidget;
import su.plo.voice.client.gui.settings.tab.AddonsTabWidget;
import su.plo.voice.client.gui.settings.tab.AdvancedTabWidget;
import su.plo.voice.client.gui.settings.tab.DevicesTabWidget;
import su.plo.voice.client.gui.settings.tab.HotKeysTabWidget;
import su.plo.voice.client.gui.settings.tab.OverlayTabWidget;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.tab.VolumeTabWidget;

public final class VoiceSettingsScreen
extends GuiScreen
implements GuiWidgetListener,
TooltipScreen {
    private final BaseVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final McTextComponent title;
    private final VoiceSettingsNavigation navigation;
    private final VoiceSettingsAboutFeature aboutFeature;
    private final MicrophoneTestController testController;
    private int titleWidth;
    @Nullable
    private McTextComponent tooltip;
    private boolean preventEscClose;

    public VoiceSettingsScreen(@NotNull BaseVoiceClient voiceClient) {
        this.voiceClient = voiceClient;
        this.config = voiceClient.getConfig();
        this.title = this.getSettingsTitle();
        this.navigation = new VoiceSettingsNavigation(voiceClient, this, this.config);
        this.aboutFeature = new VoiceSettingsAboutFeature(this);
        this.testController = new MicrophoneTestController(voiceClient, this.config);
        voiceClient.getEventBus().register(voiceClient, this);
    }

    @Override
    public void tick() {
        this.navigation.tick();
        this.aboutFeature.tick();
    }

    @Override
    public void init() {
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.testController);
        this.voiceClient.getEventBus().register(this.voiceClient, this.testController);
        this.titleWidth = RenderUtil.getTextWidth(this.getTitle());
        this.clearWidgets();
        this.navigation.addTab(McTextComponent.translatable("gui.plasmovoice.devices", new Object[0]), class_2960.method_12829((String)"plasmovoice:textures/icons/tabs/devices.png"), new DevicesTabWidget(this, this.voiceClient, this.config, this.testController));
        this.navigation.addTab(McTextComponent.translatable("gui.plasmovoice.volume", new Object[0]), class_2960.method_12829((String)"plasmovoice:textures/icons/tabs/volume.png"), new VolumeTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(McTextComponent.translatable("gui.plasmovoice.activation", new Object[0]), class_2960.method_12829((String)"plasmovoice:textures/icons/tabs/activation.png"), new ActivationTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(McTextComponent.translatable("gui.plasmovoice.overlay", new Object[0]), class_2960.method_12829((String)"plasmovoice:textures/icons/tabs/overlay.png"), new OverlayTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(McTextComponent.translatable("gui.plasmovoice.advanced", new Object[0]), class_2960.method_12829((String)"plasmovoice:textures/icons/tabs/advanced.png"), new AdvancedTabWidget(this, this.voiceClient, this.config));
        this.navigation.addTab(McTextComponent.translatable("gui.plasmovoice.hotkeys", new Object[0]), class_2960.method_12829((String)"plasmovoice:textures/icons/tabs/hotkeys.png"), new HotKeysTabWidget(this, this.voiceClient, this.config));
        if (this.voiceClient.getAddonConfigs().size() > 0) {
            this.navigation.addTab(McTextComponent.translatable("gui.plasmovoice.addons", new Object[0]), class_2960.method_12829((String)"plasmovoice:textures/icons/tabs/addons.png"), new AddonsTabWidget(this, this.voiceClient, this.config));
        }
        this.addWidget(this.navigation);
        this.navigation.init();
    }

    @Override
    public void removed() {
        this.navigation.removed();
        this.testController.stop();
        this.config.save(true);
        this.navigation.getActiveTab().ifPresent(TabWidget::removed);
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this);
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.testController);
    }

    @Override
    public void clearWidgets() {
        this.navigation.clearTabs();
        super.clearWidgets();
    }

    @Override
    @NotNull
    public McTextComponent getTitle() {
        return this.title;
    }

    @Override
    public boolean shouldCloseOnEsc() {
        if (this.preventEscClose) {
            this.preventEscClose = false;
            return false;
        }
        return true;
    }

    @Override
    public void render(@NotNull class_4587 stack, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        this.screen.renderBackground(stack);
        this.navigation.renderTab(stack, mouseX, mouseY, delta);
        this.navigation.renderBackground(stack);
        super.render(stack, mouseX, mouseY, delta);
        RenderUtil.drawString(stack, this.title, 14, 15, 0xFFFFFF);
        this.navigation.renderButtons(stack, mouseX, mouseY, delta);
        this.aboutFeature.render(stack, delta);
        if (this.tooltip == null && this.isTitleHovered(mouseX, mouseY)) {
            this.tooltip = this.getVersionTooltip();
        }
        if (this.tooltip != null) {
            this.screen.renderTooltipWrapped(stack, TextKt.getStringSplitToWidth(RenderUtil.getFormattedString(this.tooltip), 180.0f, true, true).stream().map(McTextComponent::literal).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int modifiers) {
        if (super.keyPressed(keyCode, modifiers)) {
            return true;
        }
        if (ModVoiceClient.MENU_KEY.method_1417(keyCode, 0)) {
            VoiceScreens.INSTANCE.openSettings(this.voiceClient);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isTitleHovered(mouseX, mouseY) && this.navigation.getActive() >= 0) {
            this.aboutFeature.titleClicked();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isTitleHovered(double mouseX, double mouseY) {
        return mouseX >= 14.0 && mouseX <= (double)(14 + this.titleWidth) && mouseY >= 15.0 && mouseY <= (double)(15 + RenderUtil.getFontHeight());
    }

    @EventSubscribe
    public void onTimedOut(@NotNull UdpClientTimedOutEvent event) {
        if (event.isTimedOut()) {
            VoiceScreens.INSTANCE.openNotAvailable(this.voiceClient);
        }
    }

    @EventSubscribe
    public void onClosed(@NotNull UdpClientClosedEvent event) {
        VoiceScreens.INSTANCE.openNotAvailable(this.voiceClient);
    }

    private McTextComponent getSettingsTitle() {
        String[] versionSplit = this.voiceClient.getVersion().split("\\+");
        String version = versionSplit[0];
        McTextStyle versionColor = McTextStyle.WHITE;
        if (versionSplit.length > 1) {
            versionColor = McTextStyle.YELLOW;
        }
        McTranslatableText title = McTextComponent.translatable("gui.plasmovoice.title", McTextComponent.literal("Plasmo Voice"), McTextComponent.literal(version).withStyle(versionColor));
        if (LanguageUtil.getOrDefault("gui.plasmovoice.title").split("%").length != 3) {
            return McTextComponent.literal(String.format("Plasmo Voice %s%s Settings", new Object[]{versionColor, version}));
        }
        return title;
    }

    private McTextComponent getVersionTooltip() {
        String[] versionSplit = this.voiceClient.getVersion().split("\\+");
        if (versionSplit.length < 2) {
            return null;
        }
        return McTextComponent.literal("build+" + versionSplit[1]);
    }

    public VoiceSettingsNavigation getNavigation() {
        return this.navigation;
    }

    public MicrophoneTestController getTestController() {
        return this.testController;
    }

    public int getTitleWidth() {
        return this.titleWidth;
    }

    @Override
    public void setTooltip(@Nullable McTextComponent tooltip) {
        this.tooltip = tooltip;
    }

    public void setPreventEscClose(boolean preventEscClose) {
        this.preventEscClose = preventEscClose;
    }
}

