/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.extensions.EntityKt;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.source.BaseClientAudioSource;
import su.plo.voice.client.audio.source.ClientDirectSource;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001bH\u0014R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lsu/plo/voice/client/audio/source/ClientPlayerSource;", "Lsu/plo/voice/client/audio/source/BaseClientAudioSource;", "Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "voiceClient", "Lsu/plo/voice/client/BaseVoiceClient;", "config", "Lsu/plo/voice/client/config/VoiceClientConfig;", "sourceInfo", "(Lsu/plo/voice/client/BaseVoiceClient;Lsu/plo/voice/client/config/VoiceClientConfig;Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;)V", "sourceMute", "Lsu/plo/config/entry/BooleanConfigEntry;", "getSourceMute", "()Lsu/plo/config/entry/BooleanConfigEntry;", "sourcePlayer", "Lnet/minecraft/world/entity/player/Player;", "getSourcePlayer", "()Lnet/minecraft/world/entity/player/Player;", "sourceVolume", "Lsu/plo/config/entry/DoubleConfigEntry;", "getSourceVolume", "()Lsu/plo/config/entry/DoubleConfigEntry;", "setSourceVolume", "(Lsu/plo/config/entry/DoubleConfigEntry;)V", "getLookAngle", "Lnet/minecraft/world/phys/Vec3;", "getPosition", "isPanningDisabled", "", "process", "", "packet", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceAudioEndPacket;", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "shouldWrite", "plasmovoice-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nClientPlayerSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientPlayerSource.kt\nsu/plo/voice/client/audio/source/ClientPlayerSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n800#2,11:64\n766#2:75\n857#2,2:76\n2624#2,3:78\n*S KotlinDebug\n*F\n+ 1 ClientPlayerSource.kt\nsu/plo/voice/client/audio/source/ClientPlayerSource\n*L\n47#1:64,11\n48#1:75\n48#1:76,2\n49#1:78,3\n*E\n"})
public final class ClientPlayerSource
extends BaseClientAudioSource<PlayerSourceInfo> {
    @NotNull
    private DoubleConfigEntry sourceVolume;

    public ClientPlayerSource(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull PlayerSourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(sourceInfo, "sourceInfo");
        super(voiceClient, config, (SourceInfo)sourceInfo);
        this.sourceVolume = config.getVoice().getVolumes().getVolume("source_" + sourceInfo.getPlayerInfo().getPlayerId());
    }

    @Override
    @NotNull
    public DoubleConfigEntry getSourceVolume() {
        return this.sourceVolume;
    }

    @Override
    public void setSourceVolume(@NotNull DoubleConfigEntry doubleConfigEntry) {
        Intrinsics.checkNotNullParameter(doubleConfigEntry, "<set-?>");
        this.sourceVolume = doubleConfigEntry;
    }

    @Override
    public void process(@NotNull SourceAudioPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Object e = this.getSourceMute().value();
        Intrinsics.checkNotNullExpressionValue(e, "value(...)");
        if (((Boolean)e).booleanValue()) {
            return;
        }
        super.process(packet);
    }

    @Override
    public void process(@NotNull SourceAudioEndPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Object e = this.getSourceMute().value();
        Intrinsics.checkNotNullExpressionValue(e, "value(...)");
        if (((Boolean)e).booleanValue()) {
            return;
        }
        super.process(packet);
    }

    @Override
    @NotNull
    protected class_243 getPosition() {
        class_1657 class_16572 = this.getSourcePlayer();
        if (class_16572 == null || (class_16572 = EntityKt.eyePosition((class_1297)class_16572)) == null) {
            class_243 class_2432 = class_243.field_1353;
            class_16572 = class_2432;
            Intrinsics.checkNotNullExpressionValue(class_2432, "ZERO");
        }
        return class_16572;
    }

    @Override
    @NotNull
    protected class_243 getLookAngle() {
        class_1657 class_16572 = this.getSourcePlayer();
        Object object = class_16572 != null ? class_16572.method_5720() : null;
        if (object == null) {
            class_243 class_2432 = class_243.field_1353;
            object = class_2432;
            Intrinsics.checkNotNullExpressionValue(class_2432, "ZERO");
        }
        return object;
    }

    @Override
    protected boolean isPanningDisabled() {
        return Intrinsics.areEqual(this.getSourcePlayer(), this.getListener()) || super.isPanningDisabled();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean shouldWrite() {
        McGameProfile mcGameProfile;
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        if ((Boolean)this.getVoiceClient().getConfig().getAdvanced().getMutePlayerOnDirect().value() == false) return true;
        Collection collection = this.getVoiceClient().getSourceManager().getSources();
        Intrinsics.checkNotNullExpressionValue(collection, "getSources(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Object object = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ClientDirectSource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientDirectSource it = (ClientDirectSource)element$iv$iv;
            boolean bl = false;
            if (!it.isActivated()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$none$iv = (List)destination$iv$iv;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        object = $this$none$iv.iterator();
        do {
            if (!object.hasNext()) return true;
            Object element$iv = object.next();
            ClientDirectSource it = (ClientDirectSource)element$iv;
            boolean bl = false;
            mcGameProfile = ((DirectSourceInfo)it.getSourceInfo()).getSender();
        } while (!Intrinsics.areEqual(mcGameProfile != null ? mcGameProfile.getId() : null, ((PlayerSourceInfo)this.getSourceInfo()).getPlayerInfo().getPlayerId()));
        return false;
    }

    private final BooleanConfigEntry getSourceMute() {
        return this.getConfig().getVoice().getVolumes().getMute("source_" + ((PlayerSourceInfo)this.getSourceInfo()).getPlayerInfo().getPlayerId());
    }

    private final class_1657 getSourcePlayer() {
        class_638 class_6382 = class_310.method_1551().field_1687;
        return class_6382 != null ? class_6382.method_18470(((PlayerSourceInfo)this.getSourceInfo()).getPlayerInfo().getPlayerId()) : null;
    }
}

