/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.language;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.component.McTranslatableText;
import su.plo.slib.api.command.McChatHolder;
import su.plo.voice.api.server.resource.ResourceLoader;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H&J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H&J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J2\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J2\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00132\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0004H\u0016R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\"\u00c0\u0006\u0001"}, d2={"Lsu/plo/voice/api/server/language/ServerLanguages;", "", "clientLanguage", "", "", "getClientLanguage", "()Ljava/util/Map;", "crowdinEnabled", "", "getCrowdinEnabled", "()Z", "setCrowdinEnabled", "(Z)V", "serverLanguage", "getServerLanguage", "languageName", "holder", "Lsu/plo/slib/api/command/McChatHolder;", "register", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "url", "Ljava/net/URL;", "fileName", "resourceLoader", "Lsu/plo/voice/api/server/resource/ResourceLoader;", "languagesFolder", "Ljava/io/File;", "crowdinProjectId", "translate", "Lsu/plo/slib/api/chat/component/McTextComponent;", "text", "Lsu/plo/slib/api/chat/component/McTranslatableText;", "key", "server-proxy-common"})
public interface ServerLanguages {
    public boolean getCrowdinEnabled();

    public void setCrowdinEnabled(boolean var1);

    @NotNull
    public CompletableFuture<Void> register(@NotNull ResourceLoader var1, @NotNull File var2);

    @NotNull
    default public CompletableFuture<Void> register(@NotNull String crowdinProjectId, @Nullable String fileName, @NotNull ResourceLoader resourceLoader, @NotNull File languagesFolder) {
        Intrinsics.checkNotNullParameter(crowdinProjectId, "crowdinProjectId");
        Intrinsics.checkNotNullParameter(resourceLoader, "resourceLoader");
        Intrinsics.checkNotNullParameter(languagesFolder, "languagesFolder");
        URL uRL = URI.create("https://crowdin.com/backend/download/project/" + crowdinProjectId + ".zip").toURL();
        Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
        return this.register(uRL, fileName, resourceLoader, languagesFolder);
    }

    @NotNull
    public CompletableFuture<Void> register(@NotNull URL var1, @Nullable String var2, @NotNull ResourceLoader var3, @NotNull File var4);

    @NotNull
    public Map<String, String> getServerLanguage(@Nullable String var1);

    @NotNull
    public Map<String, String> getClientLanguage(@Nullable String var1);

    @NotNull
    default public Map<String, String> getServerLanguage() {
        return this.getServerLanguage((String)null);
    }

    @NotNull
    default public Map<String, String> getServerLanguage(@NotNull McChatHolder holder) {
        Intrinsics.checkNotNullParameter(holder, "holder");
        return this.getServerLanguage(holder.getLanguage());
    }

    @NotNull
    default public Map<String, String> getClientLanguage() {
        return this.getClientLanguage((String)null);
    }

    @NotNull
    default public Map<String, String> getClientLanguage(@NotNull McChatHolder holder) {
        Intrinsics.checkNotNullParameter(holder, "holder");
        return this.getClientLanguage(holder.getLanguage());
    }

    @Nullable
    default public McTextComponent translate(@NotNull McTranslatableText text, @NotNull McChatHolder holder, @NotNull String key) {
        McTextComponent mcTextComponent;
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(holder, "holder");
        Intrinsics.checkNotNullParameter(key, "key");
        Map<String, String> language2 = this.getServerLanguage(holder.getLanguage());
        if (!language2.containsKey(key)) {
            mcTextComponent = text;
        } else {
            String string = language2.get(key);
            Intrinsics.checkNotNull(string);
            mcTextComponent = McTextComponent.Companion.literal(string);
        }
        return mcTextComponent;
    }
}

