/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.mod.entity;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5894;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.slib.api.permission.PermissionTristate;
import su.plo.slib.api.server.McServerLib;
import su.plo.slib.api.server.entity.McServerEntity;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.slib.mod.chat.ComponentTextConverter;
import su.plo.slib.mod.entity.ModServerEntity;
import su.plo.slib.mod.extension.ScoreboardKt;
import su.plo.slib.permission.PermissionSupplier;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u000fJ\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001bJ\u001f\u0010!\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010&\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010)\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010*\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010(R\u0014\u0010,\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010(R\"\u0010-\u001a\u00020\u000b8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00103R\u0014\u00105\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00100R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00106R \u00108\u001a\b\u0012\u0004\u0012\u00020\u000b078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\u001c\u0010=\u001a\u0004\u0018\u00010<8VX\u0096\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lsu/plo/slib/mod/entity/ModServerPlayer;", "Lsu/plo/slib/mod/entity/ModServerEntity;", "Lnet/minecraft/class_3222;", "Lsu/plo/slib/api/server/entity/player/McServerPlayer;", "Lsu/plo/slib/api/server/McServerLib;", "minecraftServer", "Lsu/plo/slib/permission/PermissionSupplier;", "permissions", "player", "<init>", "(Lsu/plo/slib/api/server/McServerLib;Lsu/plo/slib/permission/PermissionSupplier;Lnet/minecraft/class_3222;)V", "", "channel", "", "addChannel", "(Ljava/lang/String;)Z", "canSee", "(Lsu/plo/slib/api/server/entity/player/McServerPlayer;)Z", "permission", "Lsu/plo/slib/api/permission/PermissionTristate;", "getPermission", "(Ljava/lang/String;)Lsu/plo/slib/api/permission/PermissionTristate;", "hasPermission", "Lsu/plo/slib/api/chat/component/McTextComponent;", "reason", "", "kick", "(Lsu/plo/slib/api/chat/component/McTextComponent;)V", "text", "sendActionBar", "sendMessage", "", "data", "sendPacket", "(Ljava/lang/String;[B)V", "Lsu/plo/slib/api/entity/player/McGameProfile;", "getGameProfile", "()Lsu/plo/slib/api/entity/player/McGameProfile;", "gameProfile", "getHasLabelScoreboard", "()Z", "hasLabelScoreboard", "isOnline", "isSneaking", "isSpectator", "language", "Ljava/lang/String;", "getLanguage", "()Ljava/lang/String;", "setLanguage", "(Ljava/lang/String;)V", "Lsu/plo/slib/api/server/McServerLib;", "getName", "name", "Lsu/plo/slib/permission/PermissionSupplier;", "", "registeredChannels", "Ljava/util/Set;", "getRegisteredChannels", "()Ljava/util/Set;", "Lsu/plo/slib/api/server/entity/McServerEntity;", "spectatorTarget", "Lsu/plo/slib/api/server/entity/McServerEntity;", "getSpectatorTarget", "()Lsu/plo/slib/api/server/entity/McServerEntity;", "slib-fabric-1.20.1"})
public final class ModServerPlayer
extends ModServerEntity<class_3222>
implements McServerPlayer {
    @NotNull
    private final McServerLib minecraftServer;
    @NotNull
    private final PermissionSupplier permissions;
    @NotNull
    private String language;
    @NotNull
    private final Set<String> registeredChannels;
    @Nullable
    private final McServerEntity spectatorTarget;

    public ModServerPlayer(@NotNull McServerLib minecraftServer, @NotNull PermissionSupplier permissions, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter(minecraftServer, "minecraftServer");
        Intrinsics.checkNotNullParameter(permissions, "permissions");
        Intrinsics.checkNotNullParameter(player, "player");
        super(minecraftServer, (class_1297)player);
        this.minecraftServer = minecraftServer;
        this.permissions = permissions;
        this.language = "en_us";
        CopyOnWriteArraySet copyOnWriteArraySet = Sets.newCopyOnWriteArraySet();
        Intrinsics.checkNotNullExpressionValue(copyOnWriteArraySet, "newCopyOnWriteArraySet(...)");
        this.registeredChannels = copyOnWriteArraySet;
    }

    @Override
    @NotNull
    public McGameProfile getGameProfile() {
        UUID uUID = ((class_3222)this.getInstance()).method_5667();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUUID(...)");
        McGameProfile mcGameProfile = this.minecraftServer.getGameProfile(uUID);
        if (mcGameProfile == null) {
            throw new IllegalStateException("Game profile not found");
        }
        return mcGameProfile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((class_3222)this.getInstance()).method_7334().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    public boolean isSpectator() {
        return ((class_3222)this.getInstance()).method_7325();
    }

    @Override
    public boolean isSneaking() {
        return ((class_3222)this.getInstance()).method_21752();
    }

    @Override
    public boolean getHasLabelScoreboard() {
        class_269 class_2692 = ((class_3222)this.getInstance()).method_7327();
        Intrinsics.checkNotNullExpressionValue(class_2692, "getScoreboard(...)");
        return ScoreboardKt.getObjectiveBelowName(class_2692) != null;
    }

    @Override
    public boolean isOnline() {
        return !((class_3222)this.getInstance()).method_14239();
    }

    @Override
    @NotNull
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.language = string;
    }

    @NotNull
    public Set<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    @Override
    @Nullable
    public McServerEntity getSpectatorTarget() {
        if (((class_3222)this.getInstance()).method_14242() == this.getInstance()) {
            return null;
        }
        if (this.spectatorTarget == null || !((class_3222)this.getInstance()).method_14242().equals(this.spectatorTarget.getInstance())) {
            class_1297 class_12972 = ((class_3222)this.getInstance()).method_14242();
            Intrinsics.checkNotNullExpressionValue(class_12972, "getCamera(...)");
            return this.minecraftServer.getEntityByInstance(class_12972);
        }
        return this.spectatorTarget;
    }

    @Override
    public boolean canSee(@NotNull McServerPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        class_3222 serverPlayer = (class_3222)player.getInstance();
        return serverPlayer.method_7325() ? ((class_3222)this.getInstance()).method_7325() : true;
    }

    @Override
    @NotNull
    public PermissionTristate getPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        return this.permissions.getPermission(this.getInstance(), permission);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        return this.permissions.hasPermission(this.getInstance(), permission);
    }

    @Override
    public void kick(@NotNull McTextComponent reason) {
        Intrinsics.checkNotNullParameter(reason, "reason");
        String json2 = this.minecraftServer.getTextConverter().convertToJson(this, reason);
        class_2561 component = ComponentTextConverter.INSTANCE.convertFromJson(json2);
        ((class_3222)this.getInstance()).field_13987.method_14367(component);
    }

    @Override
    public void sendActionBar(@NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(text, "text");
        String json2 = this.minecraftServer.getTextConverter().convertToJson(this, text);
        class_2561 component = ComponentTextConverter.INSTANCE.convertFromJson(json2);
        ((class_3222)this.getInstance()).field_13987.method_14364((class_2596)new class_5894(component));
    }

    @Override
    public void sendMessage(@NotNull McTextComponent text) {
        Intrinsics.checkNotNullParameter(text, "text");
        String json2 = this.minecraftServer.getTextConverter().convertToJson(this, text);
        class_2561 component = ComponentTextConverter.INSTANCE.convertFromJson(json2);
        ((class_3222)this.getInstance()).method_43496(component);
    }

    @Override
    public void sendPacket(@NotNull String channel, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(data, "data");
        class_2960 class_29602 = class_2960.method_12829((String)channel);
        if (class_29602 == null) {
            throw new IllegalArgumentException("Invalid channel key");
        }
        class_2960 channelKey = class_29602;
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])data));
        ServerPlayNetworking.send((class_3222)((class_3222)this.getInstance()), (class_2960)channelKey, (class_2540)buf);
    }

    public final boolean addChannel(@NotNull String channel) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        return this.getRegisteredChannels().add(channel);
    }
}

