/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.translation;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.libs.adventure.adventure.key.Key;
import su.plo.slib.libs.adventure.adventure.text.Component;
import su.plo.slib.libs.adventure.adventure.text.TranslatableComponent;
import su.plo.slib.libs.adventure.adventure.text.renderer.TranslatableComponentRenderer;
import su.plo.slib.libs.adventure.adventure.translation.GlobalTranslator;
import su.plo.slib.libs.adventure.adventure.translation.Translator;
import su.plo.slib.libs.adventure.examination.ExaminableProperty;

final class GlobalTranslatorImpl
implements GlobalTranslator {
    private static final Key NAME = Key.key("adventure", "global");
    static final GlobalTranslatorImpl INSTANCE = new GlobalTranslatorImpl();
    final TranslatableComponentRenderer<Locale> renderer = TranslatableComponentRenderer.usingTranslationSource(this);
    private final Set<Translator> sources = Collections.newSetFromMap(new ConcurrentHashMap());

    private GlobalTranslatorImpl() {
    }

    @Override
    @NotNull
    public Key name() {
        return NAME;
    }

    @Override
    @NotNull
    public Iterable<? extends Translator> sources() {
        return Collections.unmodifiableSet(this.sources);
    }

    @Override
    public boolean addSource(@NotNull Translator source2) {
        Objects.requireNonNull(source2, "source");
        if (source2 == this) {
            throw new IllegalArgumentException("GlobalTranslationSource");
        }
        return this.sources.add(source2);
    }

    @Override
    public boolean removeSource(@NotNull Translator source2) {
        Objects.requireNonNull(source2, "source");
        return this.sources.remove(source2);
    }

    @Override
    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(locale, "locale");
        for (Translator source2 : this.sources) {
            MessageFormat translation = source2.translate(key, locale);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    @Override
    @Nullable
    public Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
        Objects.requireNonNull(component, "component");
        Objects.requireNonNull(locale, "locale");
        for (Translator source2 : this.sources) {
            Component translation = source2.translate(component, locale);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("sources", this.sources));
    }
}

