/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.api.permission;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.style.McTextStyle;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.JvmStatic;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lsu/plo/slib/api/permission/PermissionManager;", "", "<init>", "()V", "", "clear", "", "name", "Lsu/plo/slib/api/permission/PermissionDefault;", "getPermissionDefault", "(Ljava/lang/String;)Lsu/plo/slib/api/permission/PermissionDefault;", "permissionDefault", "register", "(Ljava/lang/String;Lsu/plo/slib/api/permission/PermissionDefault;)V", "", "unregister", "(Ljava/lang/String;)Z", "", "defaultPermissionByName", "Ljava/util/Map;", "Lsu/plo/slib/api/chat/component/McTextComponent;", "noPermissionMessage", "Lsu/plo/slib/api/chat/component/McTextComponent;", "getNoPermissionMessage", "()Lsu/plo/slib/api/chat/component/McTextComponent;", "setNoPermissionMessage", "(Lsu/plo/slib/api/chat/component/McTextComponent;)V", "Companion", "api-common"})
public final class PermissionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, PermissionDefault> defaultPermissionByName;
    @NotNull
    private McTextComponent noPermissionMessage;
    @NotNull
    private static final PermissionDefault DEFAULT_PERMISSION = PermissionDefault.OP;

    public PermissionManager() {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMap(...)");
        this.defaultPermissionByName = hashMap;
        this.noPermissionMessage = McTextComponent.Companion.literal("I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.").withStyle(McTextStyle.RED);
    }

    @NotNull
    public final McTextComponent getNoPermissionMessage() {
        return this.noPermissionMessage;
    }

    public final void setNoPermissionMessage(@NotNull McTextComponent mcTextComponent) {
        Intrinsics.checkNotNullParameter(mcTextComponent, "<set-?>");
        this.noPermissionMessage = mcTextComponent;
    }

    public final void register(@NotNull String name, @NotNull PermissionDefault permissionDefault) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)permissionDefault, "permissionDefault");
        this.defaultPermissionByName.put(name, permissionDefault);
    }

    public final boolean unregister(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.defaultPermissionByName.remove(name) != null;
    }

    public final void clear() {
        this.defaultPermissionByName.clear();
    }

    @NotNull
    public final PermissionDefault getPermissionDefault(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        PermissionDefault permissionDefault = this.defaultPermissionByName.getOrDefault(name, DEFAULT_PERMISSION);
        Intrinsics.checkNotNull((Object)permissionDefault);
        return permissionDefault;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u0012\u0004\b\u0007\u0010\u0003\u00a8\u0006\b"}, d2={"Lsu/plo/slib/api/permission/PermissionManager$Companion;", "", "<init>", "()V", "Lsu/plo/slib/api/permission/PermissionDefault;", "DEFAULT_PERMISSION", "Lsu/plo/slib/api/permission/PermissionDefault;", "getDEFAULT_PERMISSION$annotations", "api-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getDEFAULT_PERMISSION$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

