/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.render.TextureUtilKt;
import su.plo.slib.api.entity.player.McGameProfile;

public final class ModPlayerSkins {
    private static final Cache<String, class_2960> skins = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @Nullable String fallback) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(playerId);
        if (playerInfo != null) {
            return;
        }
        class_2960 skinLocation = (class_2960)skins.getIfPresent((Object)nick);
        if (skinLocation != null) {
            return;
        }
        if (fallback != null) {
            class_2960 fallbackIdentifier = ResourceLocationUtil.tryBuild("plasmovoice", "skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)nick.toLowerCase()));
            TextureUtilKt.registerBase64Texture(fallback, fallbackIdentifier);
            skins.put((Object)nick, (Object)fallbackIdentifier);
        }
        GameProfile profile = new GameProfile(playerId, nick);
        class_1071 skinManager = class_310.method_1551().method_1582();
        Map textures = skinManager.method_4654(profile);
        if (textures.isEmpty()) {
            skinManager.method_4652(profile, (type, identifier, texture) -> {
                if (type.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                    skins.put((Object)profile.getName(), (Object)identifier);
                }
            }, false);
        } else {
            String hash = Hashing.sha1().hashUnencodedChars((CharSequence)((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN)).getHash()).toString();
            class_2960 identifier2 = class_2960.method_12829((String)("skins/" + hash));
            skins.put((Object)profile.getName(), (Object)identifier2);
        }
    }

    public static synchronized void loadSkin(@NotNull McGameProfile gameProfile) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        class_2960 skinLocation = (class_2960)skins.getIfPresent((Object)gameProfile.getName());
        if (skinLocation != null) {
            return;
        }
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile.getProperties().forEach(property -> profile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature())));
        skinLocation = ModPlayerSkins.getInsecureSkinLocation(profile);
        skins.put((Object)gameProfile.getName(), (Object)skinLocation);
    }

    public static class_2960 getInsecureSkinLocation(GameProfile gameProfile) {
        MinecraftProfileTexture minecraftProfileTexture = (MinecraftProfileTexture)class_310.method_1551().method_1582().method_4654(gameProfile).get(MinecraftProfileTexture.Type.SKIN);
        return minecraftProfileTexture != null ? class_310.method_1551().method_1582().method_4656(minecraftProfileTexture, MinecraftProfileTexture.Type.SKIN) : ModPlayerSkins.getDefaultSkin(gameProfile.getId());
    }

    @NotNull
    public static synchronized class_2960 getSkin(@NotNull UUID playerId, @NotNull String nick) {
        class_640 playerInfo = class_310.method_1551().method_1562().method_2871(playerId);
        if (playerInfo != null) {
            return playerInfo.method_2968();
        }
        class_2960 skinLocation = (class_2960)skins.getIfPresent((Object)nick);
        if (skinLocation != null) {
            return skinLocation;
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static class_2960 getDefaultSkin(@NotNull UUID playerId) {
        return class_1068.method_4648((UUID)playerId);
    }

    private ModPlayerSkins() {
    }
}

