/**
 * @file	pmpr201.h
 * @brief	PC-PR201nNX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "pmbase.h"
#include "cmdparser.h"

typedef enum {
	PRINT_PR201_CODEMODE_8BIT = 0,
	PRINT_PR201_CODEMODE_7BIT = 1,
} PRINT_PR201_CODEMODE;

typedef enum {
	PRINT_PR201_PRINTMODE_N = 'N', // HSpCJ
	PRINT_PR201_PRINTMODE_H = 'H', // HDpCJ
	PRINT_PR201_PRINTMODE_Q = 'Q', // RfX
	PRINT_PR201_PRINTMODE_E = 'E', // G[g
	PRINT_PR201_PRINTMODE_P = 'P', // v|[Vi
	PRINT_PR201_PRINTMODE_K = 'K', // 
	PRINT_PR201_PRINTMODE_t = 't', // c
} PRINT_PR201_PRINTMODE;

typedef enum {
	PRINT_PR201_HSPMODE_NHS = '0',
	PRINT_PR201_HSPMODE_SHS = '1',
} PRINT_PR201_HSPMODE;

typedef enum {
	PRINT_PR201_CHARMODE_8BIT_KATAKANA = '$',
	PRINT_PR201_CHARMODE_8BIT_HIRAGANA = '&',
	PRINT_PR201_CHARMODE_7BIT_ASCII = '$',
	PRINT_PR201_CHARMODE_7BIT_HIRAGANA = '&',
	PRINT_PR201_CHARMODE_7BIT_CG = '#',
	// ȉAG~[V̓s̒l
	PRINT_PR201_CHARMODE_7BIT_KATAKANA = '%',
} PRINT_PR201_CHARMODE;

typedef enum {
	PRINT_PR201_SCRIPTMODE_DISABLE = '0',
	PRINT_PR201_SCRIPTMODE_SUPER = '1',
	PRINT_PR201_SCRIPTMODE_SUB = '2',
} PRINT_PR201_SCRIPTMODE;

typedef struct {
	float posX; // `ʒuX pixel
	float posY; // `ʒuY pixel
	float actualLineHeight; // ݂̍s̎ۂ̍

	float leftMargin; // }[W C`P
	float rightMargin;  // E}[W C`P
	float topMargin; // }[W C`P

	bool isKanji; // (2byte)[hǂ

	PRINT_PR201_CODEMODE codemode; // 8bit/7bitR[h[hiPRINT_PR201_CHARMODẺ߂ςj

	bool isSelect; // SELECT/DESELECT
	PRINT_PR201_PRINTMODE mode; // 󎚃[h
	PRINT_PR201_HSPMODE hspMode; // HSpCJ[h
	PRINT_PR201_CHARMODE charMode; // LN^[h
	PRINT_PR201_SCRIPTMODE scriptMode; // XNvg[h
	bool downloadCharMode; // _E[h󎚃[h
	int charScaleX; // XP[X
	int charScaleY; // XP[Y
	float lpi; // lines per inch
	bool bold; // 
	int lineselect; // EI
	int linep1; // param1 S=
	int linep2; // param2 1=d, 1=d
	int linep3; // param3 ̑ 2=א, 4=
	int linecolor; // F
	bool lineenable; // EL
	int dotsp_left; // hbgXy[X
	int dotsp_right; // EhbgXy[X
	bool copymode; // Rs[[h
	int color; // F

	bool hasGraphic; // OtBbN󎚂邩ǂ
	float graphicPosY; // OtBbN̕`ʒuY pixel

	void SetDefault()
	{
		posX = 0;
		posY = 0;
		actualLineHeight = 0;

		leftMargin = 0; // }[Wʒu C`P
		rightMargin = 13.6;  // E}[Wʒu C`P
		topMargin = 0; // }[W C`P

		isKanji = false;

		codemode = PRINT_PR201_CODEMODE_8BIT;

		isSelect = true;
		mode = PRINT_PR201_PRINTMODE_N;
		hspMode = PRINT_PR201_HSPMODE_NHS;
		charMode = PRINT_PR201_CHARMODE_8BIT_KATAKANA;
		scriptMode = PRINT_PR201_SCRIPTMODE_DISABLE;
		downloadCharMode = false;
		charScaleX = 1;
		charScaleY = 1;
		lpi = 1.0 / 6;
		bold = false;
		lineselect = 1;
		linep1 = 'S';
		linep2 = 1;
		linep3 = 2;
		linecolor = 0;
		lineenable = false;
		dotsp_left = 0;
		dotsp_right = 0;
		copymode = false;
		color = 0;

		hasGraphic = false;
		graphicPosY = 0;
	}
} PRINT_PR201_STATE;

typedef struct {
	HFONT oldfont;			/*!< Old Font */
	HFONT fontbase;			/*!< Font Base */
	HFONT fontrot90;		/*!< Font Rotation */
	HFONT fontbold;			/*!< Bold Font Base */
	HFONT fontboldrot90;	/*!< Bold Font Rotation */
	HPEN penline; // Cpy
	HBRUSH brsDot[8]; // hbg`puV8F

	UINT8 lastlinecolor;
	UINT8 lastlinep1;
	UINT8 lastlinep2;
	UINT8 lastlinep3;
} PRINT_PR201_GDIOBJ;

/**
 * @brief PC-PR201nNX
 */
class CPrintPR201 : public CPrintBase
{
public:
	CPrintPR201();
	virtual ~CPrintPR201();

	virtual void StartPrint(HDC hdc, int offsetXPixel, int offsetYPixel, int widthPixel, int heightPixel, float dpiX, float dpiY, float dotscale, bool rectdot);
	
	virtual void EndPrint();

	virtual bool Write(UINT8 data);
	
	virtual PRINT_COMMAND_RESULT DoCommand();

	virtual bool HasRenderingCommand();

	bool CheckOverflowLine(float addCharWidth);
	bool CheckOverflowPage(float addLineHeight);

	void UpdateFont();
	void UpdateLinePen();

	double CalcDotPitchX() {
		return m_dpiX / (float)160; // PC-PR201 1f肪1/160C`
	}
	double CalcDotPitchY() {
		return m_dpiY / (float)160; // PC-PR201 1f肪1/160C`
	}
	double CalcVFULineHeight() {
		return m_dpiY / 6; // 1/6 inch 1s
	}
	double CalcLineHeight() {
		return m_dpiY / m_state.lpi; // ݒ肳Ăs̍
	}
	double CalcActualLineHeight() {
		return max(m_state.actualLineHeight, CalcLineHeight()); // ݒ肳Ăs̍
	}
	double CalcCPI() {
		return 14;
	}
	double CalcCurrentLetterWidth() {
		float charWidth = (float)m_dpiX / CalcCPI();
		if (m_state.mode == PRINT_PR201_PRINTMODE_Q) { // RfX
			charWidth *= 0.6;
		}
		else if (m_state.mode == PRINT_PR201_PRINTMODE_E) { // G[g
			charWidth *= 0.8;
		}
		else if (m_state.mode == PRINT_PR201_PRINTMODE_P) { // v|[Vi XXX; {͎̕
			charWidth *= 0.9;
		}
		return charWidth;
	}

	PRINT_PR201_STATE m_state; // PC-PR201

	PRINT_PR201_GDIOBJ m_gdiobj; // GDI`pIuWFNg

	UINT8* m_colorbuf;	// J[obt@
	int m_colorbuf_w;	// J[obt@
	int m_colorbuf_h;	// J[obt@
	
private:
	void RenderGraphic();
	void Render(int count);

	PrinterCommandParser* m_parser;

	int m_cmdIndex; // sR}h̃CfbNX
	bool m_lastNewPage; // Oy[W肵ǂ

	PRINT_PR201_STATE m_renderstate; // PC-PR201ԁi`pobNAbvj

};
