/**
 * @file	cmdparser.cpp
 * @brief	GXP[vV[PXȂǂ̃R}hp[X܂
 */

/*
 * Copyright (c) 2026 SimK
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "compiler.h"
#include "cmdparser.h"

PrinterCommandParser::PrinterCommandParser(const PRINTCMD_DEFINE *commandTable, int commandTableLength, PRINTCMD_CALLBACK_RESULT (*unknownCommandCallback)(void* param, const std::vector<UINT8>& curBuffer), UINT32 (*variableLengthCallback)(void* param, const PRINTCMD_DEFINE& cmddef, const std::vector<UINT8>& curBuffer), void* callbackParam)
	: m_buffer()
	, m_commandTable()
	, m_parsedCommandList()
	, m_unknownCommandCallback(unknownCommandCallback)
	, m_variableLengthCallback(variableLengthCallback)
	, m_callbackParam(callbackParam)
	, m_cmdlen(0)
	, m_dataRemainValid(false)
	, m_dataRemain(0)
	, m_terminatorValid(false)
	, m_terminator('\0')
{
	m_commandTable.insert(m_commandTable.end(), commandTable, commandTable + commandTableLength);
}

PrinterCommandParser::~PrinterCommandParser()
{
}

void PrinterCommandParser::AddToCommandList()
{
	PRINTCMD_DATA d = { 0 };
	std::vector<UINT8> sub(m_buffer.begin() + m_cmdlen, m_buffer.end());
	d.cmd = m_cmddef;
	d.data = sub;
	m_parsedCommandList.push_back(d);
	m_buffer.clear();
}

bool PrinterCommandParser::PushByte(UINT8 data)
{
	m_buffer.push_back(data);

	// f[^m肵Ăꍇ͂̒܂œǂށiăp[Xȗj
	if (m_dataRemainValid) {
		m_dataRemain--;
		if (m_dataRemain <= 0) {
			// ϒR[obN͓ǂ߂邾ǂł瑗
			if (!m_addLengthChecked && m_cmddef->varlength && m_variableLengthCallback) {
				m_dataRemain += (*m_variableLengthCallback)(m_callbackParam, *m_cmddef, m_buffer); // Z
				m_addLengthChecked = true;
			}
			if (m_dataRemain == 0) {
				m_dataRemainValid = false;
				AddToCommandList();
				return true;
			}
		}
		return false;
	}

	// I[ꍇ͂̕܂ŉ񂷁iăp[Xȗj
	if (m_terminatorValid) {
		m_dataRemain--;
		if (data == m_terminator) {
			m_terminatorValid = false;
			AddToCommandList();
			return true;
		}
		return false;
	}

	const int bufLen = m_buffer.size();
	int bufPos = 0;
	UINT8 cmd = m_buffer[0];
	for (std::vector<PRINTCMD_DEFINE>::iterator it = m_commandTable.begin(); it != m_commandTable.end(); ++it) {
		bufPos = 0;

		// R}hvmF
		bool match = true;
		UINT8 *lpCmds = it->cmd;
		int cmdlen = it->cmdlen;
		for (int i = 0; i < cmdlen; i++) {
			if (bufPos == bufLen) return false; // vĂ邪rŏIĂꍇ͎w
			if (it->cmd[bufPos] != m_buffer[bufPos]) {
				match = false;
				break;
			}
			bufPos++;
		}
		if (!match) continue;

		m_cmddef = &(*it);
		m_cmdlen = cmdlen;
		m_addLengthChecked = false;

		// ǂݎς݃f[^
		const int dataLen = bufLen - m_cmdlen;

		// ނɉăR}h
		switch (it->type) {
		case PRINTCMD_TYPE_FIXEDLEN:
		{
			// cǂݎ萔m
			if (dataLen > it->fixedlen_datalength) {
				m_dataRemain = 0; //ُ
			}
			else {
				m_dataRemain = it->fixedlen_datalength - dataLen;
			}
			if (m_dataRemain == 0) {
				if (m_cmddef->varlength && m_variableLengthCallback) {
					m_dataRemain += (*m_variableLengthCallback)(m_callbackParam, *m_cmddef, m_buffer); // Z
					m_addLengthChecked = true;
				}
				if (m_dataRemain == 0) {
					// OK
					AddToCommandList();
					return true;
				}
				else {
					m_dataRemainValid = true;
					return false;
				}
			}
			else {
				m_dataRemainValid = true;
				return false;
			}
		}
		case PRINTCMD_TYPE_LENFIELD:
		{
			if (dataLen < it->lenfield_length) return false; // ܂f[^Ȃꍇ͎w

			// ǂݎς݃f[^
			int elementCount = 0;
			int i = 0;
			for (int i = 0; i < it->lenfield_length; i++) {
				elementCount *= 10;
				if (m_buffer[bufPos] < '0' || '9' < m_buffer[bufPos]) {
					// ُf[^@obt@NA
					m_buffer.clear();
					return false;
				}
				elementCount += (int)m_buffer[bufPos] - '0';
				bufPos++;
			}

			// cǂݎ萔m
			if (dataLen - it->lenfield_length > elementCount * it->lenfield_elementsize) {
				m_dataRemain = 0; //ُ
			}
			else {
				m_dataRemain = elementCount * it->lenfield_elementsize - (dataLen - it->lenfield_length);
			}
			if (m_dataRemain == 0) {
				if (m_cmddef->varlength && m_variableLengthCallback) {
					m_dataRemain += (*m_variableLengthCallback)(m_callbackParam, *m_cmddef, m_buffer); // Z
					m_addLengthChecked = true;
				}
				if (m_dataRemain == 0) {
					// OK
					AddToCommandList();
					return true;
				}
				else {
					m_dataRemainValid = true;
					return false;
				}
			}
			else {
				m_dataRemainValid = true;
				return false;
			}

			return false;
		}
		case PRINTCMD_TYPE_TERMINATOR:
		{
			// I`ꂽ
			m_terminatorValid = true;
			m_terminator = it->terminator_char;
			return false;
		}
		default:
		{
			// ُf[^@obt@NA
			m_buffer.clear();
			return false;
		}
		}
	}

	// R}h炸
	if (m_unknownCommandCallback) {
		PRINTCMD_CALLBACK_RESULT result = (*m_unknownCommandCallback)(m_callbackParam, m_buffer);
		switch (result) {
		case PRINTCMD_CALLBACK_RESULT_CONTINUE:
			// p
			return false;

		case PRINTCMD_CALLBACK_RESULT_COMPLETE:
		{
			// 
			PRINTCMD_DATA d = { 0 };
			std::vector<UINT8> sub(m_buffer.begin(), m_buffer.end());
			d.data = sub;
			m_parsedCommandList.push_back(d);
			m_buffer.clear();
			return true;
		}

		case PRINTCMD_CALLBACK_RESULT_INVALID:
			// 
			m_buffer.clear();
			return false;

		}
	}

	// ُf[^@obt@NA
	m_buffer.clear();
	return false;
}

std::vector<PRINTCMD_DATA>& PrinterCommandParser::GetParsedCommandList()
{
	return m_parsedCommandList;
}
