/**
 * @file	cmspooler.h
 * @brief	WindowsXv[ NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <vector>

#include "cmbase.h"
#include "print/pmbase.h"

#define PRINT_EMU_MODE_RAW		0
#define PRINT_EMU_MODE_PR201	1
#define PRINT_EMU_MODE_ESCP		2

#define ESCPEMU_PAGE_ALIGNMENT_LEFT		0
#define ESCPEMU_PAGE_ALIGNMENT_CENTER	1

/**
 * @brief commng p foCX NX
 */
class CComSpooler : public CComBase
{
public:
	int m_pageTimeout;				/*!< v^^CAEg */
	HANDLE m_hThreadTimeout;
	HANDLE m_hThreadExitEvent;
	CRITICAL_SECTION m_csPrint;
	DWORD m_lastSendTime;
	bool m_hasValidData;			/*!< Lȃf[^ꂽ */
	int m_dataCounter;				/*!< v^ɑꂽf[^ */

	static CComSpooler* CreateInstance(COMCFG *comcfg);

	void CCEndThread();
	void CCEndDocPrinter();

protected:
	CComSpooler();
	virtual ~CComSpooler();
	virtual UINT Read(UINT8* pData);
	virtual UINT Write(UINT8 cData);
	virtual UINT8 GetStat();
	virtual INTPTR Message(UINT nMessage, INTPTR nParam);

private:
	UINT8 m_emulation;				/*!< v^G~[V[h */
	bool m_isOpened;				/*!< v^JĂ */
	bool m_isStart;					/*!< y[WJn */
	TCHAR m_printerName[MAX_PATH];  /*!< v^ */
	HANDLE m_hPrinter;				/*!< v^ nh */
	DWORD m_jobId;					/*!< v^WuID */
	bool m_lastHasError;			/*!< v^I[vɎs */

	// v^G~[Vp
	CPrintBase *m_print;			/*!< v^G~[V */

	HDC m_hdc;						/*!< GDIv^HDC */
	bool m_requestNewPage;			/*!< y[WNGXgi󔒃y[Wɕt̂hߗpj */

	bool m_rectdot;				/*!< _`ŕ` */
	float m_dotscale;			/*!< _̑傫␳ */
	UINT8* m_colorbuf;			/*!< J[obt@ */
	int m_colorbuf_w;			/*!< J[obt@ */
	int m_colorbuf_h;			/*!< J[obt@ */
	int m_pageAlignment;		/*!< y[WACg */
	int m_additionalOfsX;		/*!< ǉʒuItZbg X */
	int m_additionalOfsY;		/*!< ǉʒuItZbg Y */
	float m_scale;				/*!< XP[ */

	bool SetConfigurations(COMCFG* comcfg);
	bool Initialize(COMCFG* comcfg);
	bool CCOpenPrinter();
	void CCStartDocPrinter();

	void CCStartPrint();
};
