/**
 * @file	cmspooler.cpp
 * @brief	WindowsXv[ NX̓̒`s܂
 */

#include "compiler.h"
#include "np2.h"
#include "cmspooler.h"
#include "print/pmpr201.h"
#include "print/pmescp.h"

#include <process.h>
#include <codecnv/codecnv.h>

#if 0
#undef	TRACEOUT
static void trace_fmt_ex(const char* fmt, ...)
{
	char stmp[2048];
	va_list ap;
	va_start(ap, fmt);
	vsprintf(stmp, fmt, ap);
	strcat(stmp, "\n");
	va_end(ap);
	OutputDebugStringA(stmp);
}
#define	TRACEOUT(s)	trace_fmt_ex s
static void trace_fmt_exw(const WCHAR* fmt, ...)
{
	WCHAR stmp[2048];
	va_list ap;
	va_start(ap, fmt);
	vswprintf(stmp, 2048, fmt, ap);
	wcscat(stmp, L"\n");
	va_end(ap);
	OutputDebugStringW(stmp);
}
#define	TRACEOUTW(s)	trace_fmt_exw s
#else
#define	TRACEOUTW(s)	(void)0
#endif	/* 1 */

static float graph_escp_lpi = (float)160 / 24;

 // [__CAOɕ\ꂽƂɁA}EXJ[\o悤ɂ
static HHOOK g_hCbt = nullptr;
static bool g_mouseOn = false;
static LRESULT CALLBACK CbtProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (nCode == HCBT_CREATEWND)
	{
		g_mouseOn = true;
		ShowCursor(TRUE);
	}
	return CallNextHookEx(g_hCbt, nCode, wParam, lParam);
}
static void InstallThreadModalDetectHook()
{
	if (g_hCbt) return;
	g_mouseOn = false;
	DWORD tid = GetCurrentThreadId();
	g_hCbt = SetWindowsHookExW(WH_CBT, CbtProc, nullptr, tid);
}
static void UninstallThreadModalDetectHook()
{
	if (!g_hCbt) return;
	UnhookWindowsHookEx(g_hCbt);
	g_hCbt = nullptr;
	if (g_mouseOn) {
		ShowCursor(FALSE);
	}
}

static unsigned int __stdcall cComSpooler_TimeoutThread(LPVOID vdParam)
{
	CComSpooler* t = (CComSpooler*)vdParam;
	
	while (WaitForSingleObject(t->m_hThreadExitEvent, 500) == WAIT_TIMEOUT) {
		EnterCriticalSection(&t->m_csPrint);
		if (GetTickCounter() - t->m_lastSendTime >= t->m_pageTimeout) {
			t->CCEndDocPrinter();
			t->m_hThreadTimeout = NULL;
			LeaveCriticalSection(&t->m_csPrint);
			break;
		}
		LeaveCriticalSection(&t->m_csPrint);
	}
	return 0;
}

static bool GetActualPrinterName(const LPTSTR printerName, LPTSTR actualPrinterName)
{
	if (printerName && _tcslen(printerName) > 0)
	{
		_tcscpy(actualPrinterName, printerName);
	}
	else
	{
		DWORD buflen = MAX_PATH;
		if (!GetDefaultPrinter(actualPrinterName, &buflen)) {
			return false;
		}
		if (_tcslen(actualPrinterName) == 0) return false;
	}
	return true;
}

static unsigned short jis_to_sjis(unsigned short jis)
{
	UINT8 j1 = (UINT8)(jis >> 8);
	UINT8 j2 = (UINT8)(jis & 0xFF);

	/* JIS X 0208 ̗L͈̓`FbN */
	if (j1 < 0x21 || j1 > 0x7E || j2 < 0x21 || j2 > 0x7E) {
		return 0;
	}

	/*
	 *   s1 = (j1 + 1)/2 + 0x70;  s1 >= 0xA0 Ȃ s1 += 0x40;
	 *   s2 = j2 + 0x1F;          j1 Ȃ s2 += 0x5E;
	 *   s2 >= 0x7F Ȃ s2++;
	 */
	UINT8 s1 = (UINT8)(((j1 + 1) >> 1) + 0x70);
	if (s1 >= 0xA0) {
		s1 = (UINT8)(s1 + 0x40);
	}

	UINT8 s2 = (UINT8)(j2 + 0x1F);
	if ((j1 & 1) == 0) {               /* j1 i悪j */
		s2 = (UINT8)(s2 + 0x5E);
	}
	if (s2 >= 0x7F) {
		s2 = (UINT8)(s2 + 1);
	}

	return (UINT16)((UINT16)s1 << 8 | s2);
}

static COLORREF ColorCodeToColorRef(UINT8 colorCode)
{
	switch (colorCode) {
	case 0:
		return RGB(0,0,0);
	case 1:
		return RGB(0, 0, 255);
	case 2:
		return RGB(255, 0, 0);
	case 3:
		return RGB(255, 0, 255);
	case 4:
		return RGB(0, 255, 0);
	case 5:
		return RGB(0, 255, 255);
	case 6:
		return RGB(255, 255, 0);
	case 7:
		return RGB(255, 255, 255);
	}
	return RGB(0, 0, 0);
}


/**
 * CX^X쐬
 * @param[in] comcfg COMCFG
 * @return CX^X
 */
CComSpooler* CComSpooler::CreateInstance(COMCFG* comcfg)
{
	CComSpooler* pPara = new CComSpooler;
	if (!pPara->Initialize(comcfg))
	{
		delete pPara;
		pPara = NULL;
	}
	return pPara;
}

/**
 * RXgN^
 */
CComSpooler::CComSpooler()
	: CComBase(COMCONNECT_PARALLEL)
	, m_emulation(PRINT_EMU_MODE_RAW)
	, m_pageTimeout(5000)
	, m_lastSendTime(0)
	, m_isOpened(false)
	, m_isStart(false)
	, m_printerName()
	, m_hPrinter(NULL)
	, m_hThreadTimeout(NULL)
	, m_hThreadExitEvent(NULL)
	, m_csPrint()
	, m_hasValidData(false)
	, m_dataCounter(0)
	, m_jobId(0)
	, m_hdc(NULL)
	, m_print(NULL)
	, m_additionalOfsX(0)
	, m_additionalOfsY(0)
{
	InitializeCriticalSection(&m_csPrint);
	m_hThreadExitEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
}

/**
 * fXgN^
 */
CComSpooler::~CComSpooler()
{
	if (m_isOpened)
	{
		CCEndThread();
		CCEndDocPrinter();

		if (!m_emulation) {
			::ClosePrinter(m_hPrinter);
			m_hPrinter = NULL;
			m_isOpened = false;
		}
	}
	CloseHandle(m_hThreadExitEvent);
	DeleteCriticalSection(&m_csPrint);
}

/**
 * v^J
 */
bool CComSpooler::CCOpenPrinter()
{
	EnterCriticalSection(&m_csPrint);

	if (m_isOpened) goto finalize;

	TCHAR printerName[MAX_PATH];
	if (!GetActualPrinterName(m_printerName, printerName)) {
		goto finalize;
	}
	if (!m_emulation) {
		if (!::OpenPrinter(printerName, &m_hPrinter, nullptr)) {
			m_isOpened = true;
			goto finalize;
		}
	}
	m_isOpened = true;

finalize:
	LeaveCriticalSection(&m_csPrint);
	return m_isOpened;
}
/**
 * v^Jn
 */
void CComSpooler::CCStartDocPrinter()
{
	InstallThreadModalDetectHook();
	EnterCriticalSection(&m_csPrint);

	if (!m_isOpened) goto finalize;
	if (m_isStart) goto finalize;

	SYSTEMTIME st;
	GetLocalTime(&st);

	TCHAR documentName[MAX_PATH] = { 0 };
	_stprintf(documentName, _T("NP2_PRINT_%04u%02u%02u_%02u%02u%02u"), st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond);

	if (m_print) {
		delete m_print;
		m_print = NULL;
	}
	switch (m_emulation) {
	case PRINT_EMU_MODE_PR201:
		m_print = new CPrintPR201();
		break;
	case PRINT_EMU_MODE_ESCP:
		m_print = new CPrintESCP();
		break;
	}

	if (!m_print) {
		// RAWo̓[h
		DOC_INFO_1 di = { 0 };
		di.pDocName = documentName;
		di.pOutputFile = nullptr;
		di.pDatatype = _T("RAW");

		m_jobId = ::StartDocPrinter(m_hPrinter, 1, (LPBYTE)&di);
		if (m_jobId == 0) {
			goto finalize;
		}

		if (!::StartPagePrinter(m_hPrinter)) {
			::EndDocPrinter(m_hPrinter);
			goto finalize;
		}
	}
	else {
		// G~[V[h
		TCHAR printerName[MAX_PATH];
		if (!GetActualPrinterName(m_printerName, printerName)) {
			goto finalize;
		}

		HANDLE hPrinter;
		OpenPrinter(printerName, &hPrinter, NULL);
		if (!hPrinter) {
			goto finalize;
		}
		LONG dmsize = DocumentProperties(
			NULL,
			hPrinter,
			printerName,
			NULL,
			NULL,
			0
		);
		DEVMODE* pDevMode = (DEVMODE*)malloc(dmsize);
		DocumentProperties(
			NULL,
			hPrinter,
			printerName,
			pDevMode,
			NULL,
			DM_OUT_BUFFER
		);
		ClosePrinter(hPrinter);
		//pDevMode->dmFields |= DM_PAPERSIZE | DM_ORIENTATION;
		//pDevMode->dmPaperSize = DMPAPER_A4;
		//pDevMode->dmOrientation = DMORIENT_PORTRAIT;
		//pDevMode->dmFields |= DM_PAPERWIDTH | DM_PAPERLENGTH;
		//pDevMode->dmPaperWidth = 1000;
		//pDevMode->dmPaperLength = 1480;
		m_hdc = CreateDCW(L"WINSPOOL", printerName, nullptr, pDevMode);
		free(pDevMode);
		if (!m_hdc) {
			goto finalize;
		}

		DOCINFO di = { 0 };
		di.cbSize = sizeof(di);
		di.lpszDocName = documentName;
		m_jobId = ::StartDoc(m_hdc, &di);
		if (m_jobId <= 0) {
			m_jobId = 0;
			DeleteDC(m_hdc);
			goto finalize;
		}

		if (::StartPage(m_hdc) <= 0) {
			EndDoc(m_hdc);
			DeleteDC(m_hdc);
			goto finalize;
		}

		CCStartPrint();
	}

	// ^CAEgĎJn
	if (m_pageTimeout > 0 && !m_hThreadTimeout) {
		unsigned int dwID;
		m_hThreadTimeout = (HANDLE)_beginthreadex(NULL, 0, cComSpooler_TimeoutThread, this, 0, &dwID);
	}

	m_lastSendTime = GetTickCounter();
	m_dataCounter = 0;
	m_hasValidData = false;
	m_isStart = true;
finalize:
	LeaveCriticalSection(&m_csPrint);
	UninstallThreadModalDetectHook();
}
/**
 * ^CAEgĎXbhI
 */
void CComSpooler::CCEndThread()
{
	// ^CAEgĎI
	if (m_hThreadTimeout) {
		SetEvent(m_hThreadExitEvent);
		if (WaitForSingleObject(m_hThreadTimeout, 10000) == WAIT_TIMEOUT)
		{
			TerminateThread(m_hThreadTimeout, 0); // ]rXbhׂ
		}
		CloseHandle(m_hThreadTimeout);
		m_hThreadTimeout = NULL;
	}
}

/**
 * v^I
 */
void CComSpooler::CCEndDocPrinter()
{
	EnterCriticalSection(&m_csPrint);

	if (!m_isOpened) goto finalize;
	if (!m_isStart) goto finalize;

	if (!m_print) {
		// RAWo̓[h
		if (!m_hasValidData && m_dataCounter <= 100) {
			// ݃f[^Ǝv̂Ŏ̂Ă
			::SetJob(m_hPrinter, m_jobId, 0, NULL, JOB_CONTROL_CANCEL);
		}
		::EndPagePrinter(m_hPrinter);
		::EndDocPrinter(m_hPrinter);
	}
	else {
		// G~[V[h
		m_print->EndPrint();

		if (!m_hasValidData && m_dataCounter <= 100) {
			// ݃f[^Ǝv̂Ŏ̂Ă
			::AbortDoc(m_hdc);
		}
		else {
			::EndPage(m_hdc);
			::EndDoc(m_hdc);
		}

		DeleteDC(m_hdc);
		m_hdc = NULL;
	}

	if (m_print) {
		delete m_print;
		m_print = NULL;
	}

	m_isStart = false;
finalize:
	LeaveCriticalSection(&m_csPrint);
}

bool CComSpooler::SetConfigurations(COMCFG* comcfg)
{
	if (comcfg->spoolPrinterName) {
		_tcscpy(m_printerName, comcfg->spoolPrinterName);
	}
	m_emulation = comcfg->spoolEmulation;
	m_pageTimeout = comcfg->spoolTimeout;
	m_dotscale = comcfg->spoolDotSize / 100.0;
	m_rectdot = comcfg->spoolRectDot ? true : false;
	m_pageAlignment = comcfg->spoolPageAlignment;
	m_additionalOfsX = comcfg->spoolOffsetXmm;
	m_additionalOfsY = comcfg->spoolOffsetYmm;
	m_scale = comcfg->spoolScale / 100.0f;

	m_lastHasError = false;

	return true;
}

/**
 * 
 * @param[in] comcfg COMCFG
 * @retval true 
 * @retval false s
 */
bool CComSpooler::Initialize(COMCFG* comcfg)
{
	SetConfigurations(comcfg);

	return true;
}

/**
 * ǂݍ
 * @param[out] pData obt@
 * @return TCY
 */
UINT CComSpooler::Read(UINT8* pData)
{
	return 0;
}

/**
 * 
 * @param[out] cData f[^
 * @return TCY
 */
UINT CComSpooler::Write(UINT8 cData)
{
	UINT ret = 0;
	DWORD lastSendTime = m_lastSendTime;
	m_lastSendTime = GetTickCounter();

	EnterCriticalSection(&m_csPrint);
	DWORD dwWrittenSize;
	if (!m_isOpened) {
		if (m_lastHasError && m_lastSendTime - lastSendTime < 1000) {
			// ZԂő߂Ȃ悤ɂ
			m_lastSendTime = GetTickCounter();
			goto finalize;
		}
		if (!CCOpenPrinter()) {
			m_lastHasError = true;
			m_lastSendTime = GetTickCounter();
			goto finalize;
		}
		m_lastHasError = false;
	}

	if (!m_isStart) {
		// ȂEOT͖
		if (cData == 0x04) {
			ret = 1; // 
			goto finalize;
		}

		if (m_lastHasError && !m_isStart && m_lastSendTime - lastSendTime < 1000) {
			// ZԂő߂Ȃ悤ɂ
			m_lastSendTime = GetTickCounter();
			goto finalize;
		}
		CCStartDocPrinter();
		if (!m_isStart) {
			m_lastHasError = true;
			m_lastSendTime = GetTickCounter();
			goto finalize;
		}
	}

	m_lastHasError = false;

	m_lastSendTime = GetTickCounter();
	if (m_dataCounter < 10000) {
		m_dataCounter++;
	}
	if (0x08 <= cData && cData <= 0x0d || 0x20 <= cData) {
		m_hasValidData = true;
	}
	if (!m_print) {
		ret = (::WritePrinter(m_hPrinter, &cData, 1, &dwWrittenSize)) ? 1 : 0;
	}
	else {
		if (m_print->Write(cData)) {
			// 1R}h
			PRINT_COMMAND_RESULT writeResult;
			do {
				if (m_requestNewPage && m_print->HasRenderingCommand()) {
					// y[Ws
					::EndPage(m_hdc);
					::StartPage(m_hdc);
					m_requestNewPage = false;
				}
				writeResult = m_print->DoCommand();
				if (writeResult == PRINT_COMMAND_RESULT_COMPLETEPAGE) {
					m_requestNewPage = true;
				}
			} while (writeResult != PRINT_COMMAND_RESULT_OK);
		}
		ret = 1;
	}

finalize:
	LeaveCriticalSection(&m_csPrint);
	return ret;
}

/**
 * Xe[^X𓾂
 * bit 7: ~CI (RI, RING)
 * bit 6: ~CS (CTS)
 * bit 5: ~CD (DCD, RLSD)
 * bit 4: reserved
 * bit 3: reserved
 * bit 2: reserved
 * bit 1: reserved
 * bit 0: ~DSR (DR)
 * @return Xe[^X
 */
UINT8 CComSpooler::GetStat()
{
	return 0x00;
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParam p^
 * @return Ug R[h
 */
INTPTR CComSpooler::Message(UINT nMessage, INTPTR nParam)
{
	switch (nMessage)
	{
		case COMMSG_REOPEN:
			EnterCriticalSection(&m_csPrint);
			if (m_isOpened)
			{
				CCEndThread();
				CCEndDocPrinter();

				::ClosePrinter(m_hPrinter);
				m_hPrinter = NULL;
				m_isOpened = false;
				m_lastHasError = false;
			}

			if (nParam) {
				SetConfigurations((COMCFG*)nParam);
			}

			LeaveCriticalSection(&m_csPrint);
			break;

		default:
			break;
	}
	return 0;
}

// v^G~[V

void CComSpooler::CCStartPrint()
{
	float dpiX = GetDeviceCaps(m_hdc, LOGPIXELSX);
	float dpiY = GetDeviceCaps(m_hdc, LOGPIXELSY);
	float physWidth = GetDeviceCaps(m_hdc, PHYSICALWIDTH);
	float physHeight = GetDeviceCaps(m_hdc, PHYSICALHEIGHT);

	float pageoffsetx = m_additionalOfsX * dpiX / 25.4;
	float pageoffsety = m_additionalOfsY * dpiY / 25.4;
	if (m_pageAlignment == ESCPEMU_PAGE_ALIGNMENT_CENTER) {
		// \tgɂĒlooȂ̂ňӖs@ނ𓾂A4ꑾYƂ
		pageoffsetx -= 2176.0 / 160 * dpiX / 2 - 210 / 2 * dpiX / 25.4; // v^hbg/2 - A4Z/2
	}
	float pagescaleoffsetx = 1;
	float pagescaleoffsety = 1;
	if (m_scale > 0) {
		// XP[@񂹂
		pagescaleoffsetx = (1 - m_scale) * physWidth / 2;
		pagescaleoffsety = (1 - m_scale) * physHeight / 2;
		pageoffsetx *= m_scale;
		pageoffsety *= m_scale;
		physWidth *= m_scale;
		physHeight *= m_scale;
		dpiX *= m_scale;
		dpiY *= m_scale;
	}

	m_print->StartPrint(m_hdc, pageoffsetx + pagescaleoffsetx, pageoffsety + pagescaleoffsety, physWidth, physHeight, dpiX, dpiY, m_dotscale, m_rectdot);

	m_requestNewPage = false;
}
