/**
 * @file	cmfile.cpp
 * @brief	t@C_v NX̓̒`s܂
 */

#include "compiler.h"
#include "cmfile.h"
#include "np2.h"

#include <process.h>

static unsigned int __stdcall cComFile_TimeoutThread(LPVOID vdParam)
{
    CComFile* t = (CComFile*)vdParam;

    while (WaitForSingleObject(t->m_hThreadExitEvent, 500) == WAIT_TIMEOUT) {
        EnterCriticalSection(&t->m_csPrint);
        if (GetTickCounter() - t->m_lastSendTime >= t->m_pageTimeout) {
            t->CCCloseFile();
            t->m_hThreadTimeout = NULL;
            LeaveCriticalSection(&t->m_csPrint);
            break;
        }
        LeaveCriticalSection(&t->m_csPrint);
    }
    return 0;
}


static BOOL DirectoryExists(const TCHAR* path)
{
	DWORD attr = GetFileAttributes(path);
	if (attr == INVALID_FILE_ATTRIBUTES) return FALSE;
	return (attr & FILE_ATTRIBUTE_DIRECTORY) ? TRUE : FALSE;
}

static BOOL FileExists(const TCHAR* path)
{
	DWORD attr = GetFileAttributes(path);
	return (attr != INVALID_FILE_ATTRIBUTES);
}

// dirpath: ۑfBNg
// ߂l: ͗Lȃt@CnhAsINVALID_HANDLE_VALUE
HANDLE OpenUniqueDumpFile(const TCHAR* dirpath)
{
    if (!dirpath)
    {
        return INVALID_HANDLE_VALUE;
    }

    if (!DirectoryExists(dirpath))
    {
        return INVALID_HANDLE_VALUE;
    }

    SYSTEMTIME st;
    GetLocalTime(&st);

    // t@C̃x[X
    TCHAR base[MAX_PATH] = { 0 };
    _stprintf(base, _T("PORTDUMP_%04u%02u%02u_%02u%02u%02u"), st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond);

    // dirpath̖\Εt
    TCHAR dirWithSep[MAX_PATH];
    _tcscpy(dirWithSep, dirpath);
    size_t len = _tcslen(dirWithSep);
    if (len > 0 && dirWithSep[len - 1] != _T('\\'))
    {
        dirWithSep[len] = '\\';
        dirWithSep[len + 1] = '\0';
        len++;
    }

    // Փ˂ȂOT
    // suffix=0 -> PORTDUMP_yyyyMMdd_hhmmss.bin
    // suffix>0 -> PORTDUMP_...._n.bin
    for (DWORD suffix = 0; suffix < 100000; ++suffix)
    {
        TCHAR fullpath[MAX_PATH] = { 0 };

        if (suffix == 0)
        {
            _stprintf(fullpath, _T("%s%s.bin"), dirWithSep, base);
        }
        else
        {
            _stprintf(fullpath, _T("%s%s%lu.bin"), dirWithSep, base, suffix);
        }

        HANDLE hFile = CreateFile(
            fullpath,
            GENERIC_WRITE,
            0,                      // LȂ
            NULL,
            CREATE_NEW,             // Ȃ玸s
            FILE_ATTRIBUTE_NORMAL,
            NULL
        );
        DWORD lastError = GetLastError();
        if (hFile != INVALID_HANDLE_VALUE)
        {
            // VK쐬
            return hFile;
        }

        // ɑ݂ꍇ͎̔ԍ
        if (lastError != ERROR_FILE_EXISTS && lastError != ERROR_ALREADY_EXISTS)
        {
            // ȊÕG[͎s
            return INVALID_HANDLE_VALUE;
        }
    }

    // SR
    return INVALID_HANDLE_VALUE;
}

/**
 * CX^X쐬
 * @param[in] dirpath ۑfBNg
 * @return CX^X
 */
CComFile* CComFile::CreateInstance(LPCTSTR dirpath, int pageTimeout)
{
	CComFile* pFile = new CComFile;
	if (!pFile->Initialize(dirpath, pageTimeout))
	{
		delete pFile;
		pFile = NULL;
	}
	return pFile;
}

/**
 * RXgN^
 */
CComFile::CComFile()
	: CComBase(COMCONNECT_FILE)
	, m_dirpath()
	, m_hFile(INVALID_HANDLE_VALUE)
    , m_pageTimeout(5000)
    , m_lastSendTime(0)
    , m_hThreadTimeout(NULL)
    , m_hThreadExitEvent(NULL)
    , m_csPrint()
{
    InitializeCriticalSection(&m_csPrint);
    m_hThreadExitEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
}

/**
 * fXgN^
 */
CComFile::~CComFile()
{
	if (m_hFile != INVALID_HANDLE_VALUE)
	{
        CCEndThread();
        CCCloseFile();
	}
    CloseHandle(m_hThreadExitEvent);
    DeleteCriticalSection(&m_csPrint);
}

/**
 * 
 * @param[in] dirpath ۑfBNg
 * @retval true 
 * @retval false s
 */
bool CComFile::Initialize(LPCTSTR dirpath, int pageTimeout)
{
    m_pageTimeout = pageTimeout;

    DWORD ret = GetFullPathName(dirpath, NELEMENTS(m_dirpath), m_dirpath, NULL);
    if (ret == 0 || ret >= NELEMENTS(m_dirpath)) {
        return 0;
    }

	DWORD attr = GetFileAttributes(m_dirpath);
	if (attr == INVALID_FILE_ATTRIBUTES)
		return 0;

	return (attr & FILE_ATTRIBUTE_DIRECTORY);
}

/**
 * ^CAEgĎXbhJn
 */
void CComFile::CCStartThread()
{
    EnterCriticalSection(&m_csPrint);

    // ^CAEgĎJn
    if (m_pageTimeout > 0 && !m_hThreadTimeout) {
        unsigned int dwID;
        m_hThreadTimeout = (HANDLE)_beginthreadex(NULL, 0, cComFile_TimeoutThread, this, 0, &dwID);
    }

    m_lastSendTime = GetTickCounter();
finalize:
    LeaveCriticalSection(&m_csPrint);
}
/**
 * ^CAEgĎXbhI
 */
void CComFile::CCEndThread()
{
    // ^CAEgĎI
    if (m_hThreadTimeout) {
        SetEvent(m_hThreadExitEvent);
        if (WaitForSingleObject(m_hThreadTimeout, 10000) == WAIT_TIMEOUT)
        {
            TerminateThread(m_hThreadTimeout, 0); // ]rXbhׂ
        }
        CloseHandle(m_hThreadTimeout);
        m_hThreadTimeout = NULL;
    }
}
/**
 * t@C
 */
void CComFile::CCCloseFile()
{
    EnterCriticalSection(&m_csPrint);
    if (m_hFile) {
        ::CloseHandle(m_hFile);
        m_hFile = INVALID_HANDLE_VALUE;
    }
    LeaveCriticalSection(&m_csPrint);
}

/**
 * ǂݍ
 * @param[out] pData obt@
 * @return TCY
 */
UINT CComFile::Read(UINT8* pData)
{
	return 0;
}

/**
 * 
 * @param[out] cData f[^
 * @return TCY
 */
UINT CComFile::Write(UINT8 cData)
{
    UINT ret = 0;
    DWORD dwWrittenSize;

    EnterCriticalSection(&m_csPrint);
	if (m_hFile == INVALID_HANDLE_VALUE)
	{
        // ȂEOT͖
        if (cData == 0x04) {
            ret = 1; // 
            goto finalize;
        }

        m_hFile = OpenUniqueDumpFile(m_dirpath);
        if (m_hFile == INVALID_HANDLE_VALUE)
        {
            goto finalize;
        }
        CCStartThread();
	}
    m_lastSendTime = GetTickCounter();
    ret = (::WriteFile(m_hFile, &cData, 1, &dwWrittenSize, NULL)) ? 1 : 0;
finalize:
    LeaveCriticalSection(&m_csPrint);
    return ret;
}

/**
 * Xe[^X𓾂
 * bit 7: ~CI (RI, RING)
 * bit 6: ~CS (CTS)
 * bit 5: ~CD (DCD, RLSD)
 * bit 4: reserved
 * bit 3: reserved
 * bit 2: reserved
 * bit 1: reserved
 * bit 0: ~DSR (DR)
 * @return Xe[^X
 */
UINT8 CComFile::GetStat()
{
	return 0xa0;
}

/**
 * bZ[W
 * @param[in] nMessage bZ[W
 * @param[in] nParam p^
 * @return Ug R[h
 */
INTPTR CComFile::Message(UINT nMessage, INTPTR nParam)
{
    switch (nMessage)
    {
    case COMMSG_REOPEN:
            CCEndThread();

            EnterCriticalSection(&m_csPrint);

            CCCloseFile();

            if (nParam) {
                COMCFG* cfg = (COMCFG*)nParam;
                m_pageTimeout = cfg->fileTimeout;
                GetFullPathName(cfg->dirpath, NELEMENTS(m_dirpath), m_dirpath, NULL);
            }

            LeaveCriticalSection(&m_csPrint);
        break;

    default:
        break;
    }
    return 0;
}
