// Native NT API Header File
// =========================
// For more information see:
// Windows 2000/NT Native API Reference, Campus Press
// ISBN 2-7740-0916-4

#ifndef _NTAPI_H_
#define _NTAPI_H_

#include "types.h"

// __aligned is not needed for x86
#define UNALIGNED

// The usual NT_SUCCESS
#define NT_SUCCESS(Status) ((NTSTATUS) (Status) >= 0)

// Just for documentation.  This marks the kernel's export number.
#define EXPORTNUM(a)

// Initializes an OBJECT_ATTRIBUTES.  I added this because it's familiar to
// NT kernel mode programmers.  I just changed it to the XBOX style.
// Works as if it were this function:
// VOID
// InitializeObjectAttributes(
//     OUT POBJECT_ATTRIBUTES ObjectAttributes,
//     IN PANSI_STRING ObjectName,
//     IN ULONG Attributes,
//     IN HANDLE RootDirectory
//     )
// Differences from NT: SECURITY_DESCRIPTOR support is gone.
#define InitializeObjectAttributes( p, n, a, r ) { \
	(p)->RootDirectory = r; \
	(p)->Attributes = a; \
	(p)->ObjectName = n; \
	}

// Virtual memory page access settings/allocation types
#define PAGE_NOACCESS                           0x00000001
#define PAGE_READONLY                           0x00000002
#define PAGE_READWRITE                          0x00000004
#define PAGE_WRITECOPY                          0x00000008
#define PAGE_EXECUTE                            0x00000010
#define PAGE_EXECUTE_READ                       0x00000020
#define PAGE_EXECUTE_READWRITE                  0x00000040
#define PAGE_EXECUTE_WRITECOPY                  0x00000080
#define PAGE_GUARD                              0x00000100
#define PAGE_NOCACHE                            0x00000200
#define MEM_COMMIT                              0x00001000
#define MEM_RESERVE                             0x00002000
#define MEM_DECOMMIT                            0x00004000
#define MEM_RELEASE                             0x00008000
#define MEM_FREE                                0x00010000
#define MEM_PRIVATE                             0x00020000
#define MEM_MAPPED                              0x00040000
#define MEM_IMAGE                               0x01000000

// General security flags
#define DELETE						0x00010000L
#define READ_CONTROL				0x20000L
#define WRITE_DAC					0x40000L
#define WRITE_OWNER					0x80000L
#define SYNCHRONIZE					0x100000L
#define STANDARD_RIGHTS_REQUIRED	0xF0000
#define STANDARD_RIGHTS_READ		0x20000
#define STANDARD_RIGHTS_WRITE		0x20000
#define STANDARD_RIGHTS_EXECUTE		0x20000
#define STANDARD_RIGHTS_ALL			0x1F0000
#define SPECIFIC_RIGHTS_ALL			0xFFFF
#define ACCESS_SYSTEM_SECURITY		0x1000000
#define MAXIMUM_ALLOWED				0x2000000
#define GENERIC_READ				0x80000000
#define GENERIC_WRITE				0x40000000
#define GENERIC_EXECUTE				0x20000000
#define GENERIC_ALL					0x10000000

// Flags for OBJECT_ATTRIBUTES::Attributes
#define OBJ_INHERIT             0x00000002L
#define OBJ_PERMANENT           0x00000010L
#define OBJ_EXCLUSIVE           0x00000020L
#define OBJ_CASE_INSENSITIVE    0x00000040L
#define OBJ_OPENIF              0x00000080L
#define OBJ_OPENLINK            0x00000100L
#define OBJ_KERNEL_HANDLE       0x00000200L
#define OBJ_VALID_ATTRIBUTES    0x000003F2L

// CreateDisposition values for NtCreateFile()
#define FILE_SUPERSEDE                          0x00000000
#define FILE_OPEN                               0x00000001
#define FILE_CREATE                             0x00000002
#define FILE_OPEN_IF                            0x00000003
#define FILE_OVERWRITE                          0x00000004
#define FILE_OVERWRITE_IF                       0x00000005
#define FILE_MAXIMUM_DISPOSITION                0x00000005

// Security flags for file objects
#define FILE_READ_DATA				1
#define FILE_LIST_DIRECTORY			1
#define FILE_WRITE_DATA				2
#define FILE_ADD_FILE				2
#define FILE_APPEND_DATA			4
#define FILE_ADD_SUBDIRECTORY		4
#define FILE_CREATE_PIPE_INSTANCE	4
#define FILE_READ_EA				8
#define FILE_READ_PROPERTIES		8
#define FILE_WRITE_EA				16
#define FILE_WRITE_PROPERTIES		16
#define FILE_EXECUTE				32
#define FILE_TRAVERSE				32
#define FILE_DELETE_CHILD			64
#define FILE_READ_ATTRIBUTES		128
#define FILE_WRITE_ATTRIBUTES		256
#define FILE_ALL_ACCESS			(STANDARD_RIGHTS_REQUIRED|SYNCHRONIZE|0x1FF)
#define FILE_GENERIC_READ (STANDARD_RIGHTS_READ|FILE_READ_DATA|FILE_READ_ATTRIBUTES|FILE_READ_EA|SYNCHRONIZE)
#define FILE_GENERIC_WRITE (STANDARD_RIGHTS_WRITE|FILE_WRITE_DATA|FILE_WRITE_ATTRIBUTES|FILE_WRITE_EA|FILE_APPEND_DATA|SYNCHRONIZE)
#define FILE_GENERIC_EXECUTE	(STANDARD_RIGHTS_EXECUTE|FILE_READ_ATTRIBUTES|FILE_EXECUTE|SYNCHRONIZE)

// File sharing types
#define FILE_SHARE_READ		1
#define FILE_SHARE_WRITE	2
#define FILE_SHARE_DELETE	4

// File attributes
#define FILE_ATTRIBUTE_READONLY				1
#define FILE_ATTRIBUTE_HIDDEN				2
#define FILE_ATTRIBUTE_SYSTEM				4
#define FILE_ATTRIBUTE_DIRECTORY			16
#define FILE_ATTRIBUTE_ARCHIVE				32
#define FILE_ATTRIBUTE_ENCRYPTED			64
#define FILE_ATTRIBUTE_NORMAL				128
#define FILE_ATTRIBUTE_TEMPORARY			256
#define FILE_ATTRIBUTE_SPARSE_FILE			512
#define FILE_ATTRIBUTE_REPARSE_POINT		1024
#define FILE_ATTRIBUTE_COMPRESSED			2048
#define FILE_ATTRIBUTE_OFFLINE				0x1000
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED	0x2000

// CreateOption values for NtCreateFile()
// FILE_NON_DIRECTORY_FILE | FILE_SYNCHRONOUS_IO_NONALERT is what CreateFile
// uses for most things when translating to NtCreateFile.
#define FILE_DIRECTORY_FILE                     0x00000001
#define FILE_WRITE_THROUGH                      0x00000002
#define FILE_SEQUENTIAL_ONLY                    0x00000004
#define FILE_NO_INTERMEDIATE_BUFFERING          0x00000008
#define FILE_SYNCHRONOUS_IO_ALERT               0x00000010
#define FILE_SYNCHRONOUS_IO_NONALERT            0x00000020
#define FILE_NON_DIRECTORY_FILE                 0x00000040
#define FILE_CREATE_TREE_CONNECTION             0x00000080
#define FILE_COMPLETE_IF_OPLOCKED               0x00000100
#define FILE_NO_EA_KNOWLEDGE                    0x00000200
#define FILE_OPEN_FOR_RECOVERY                  0x00000400
#define FILE_RANDOM_ACCESS                      0x00000800
#define FILE_DELETE_ON_CLOSE                    0x00001000
#define FILE_OPEN_BY_FILE_ID                    0x00002000
#define FILE_OPEN_FOR_BACKUP_INTENT             0x00004000
#define FILE_NO_COMPRESSION                     0x00008000
#define FILE_RESERVE_OPFILTER                   0x00100000
#define FILE_OPEN_REPARSE_POINT                 0x00200000
#define FILE_OPEN_NO_RECALL                     0x00400000
#define FILE_OPEN_FOR_FREE_SPACE_QUERY          0x00800000
#define FILE_COPY_STRUCTURED_STORAGE            0x00000041
#define FILE_STRUCTURED_STORAGE                 0x00000441
#define FILE_VALID_OPTION_FLAGS                 0x00ffffff
#define FILE_VALID_PIPE_OPTION_FLAGS            0x00000032
#define FILE_VALID_MAILSLOT_OPTION_FLAGS        0x00000032
#define FILE_VALID_SET_FLAGS                    0x00000036

// Some basic types
typedef unsigned long long	UQUAD, *PUQUAD;
typedef short				CSHORT;
typedef ULONG				CLONG;

// The usual NTSTATUS
typedef LONG				NTSTATUS;

// String types
typedef CHAR				*PSZ;
typedef CONST CHAR			*PCSZ;

// ANSI_STRING
// Differences from NT: None.
typedef struct  _STRING {
    USHORT Length;
    USHORT MaximumLength;
    PCHAR Buffer;
} STRING, *PSTRING;
typedef STRING ANSI_STRING, *PANSI_STRING;

// Interrupt level type
typedef UCHAR KIRQL, *PKIRQL;

// Access mask
typedef UINT32 ACCESS_MASK;

// Object Attributes type
// Differences from NT: There are no Length, SecurityDescriptor, or
//     SecurityQualityOfService fields.  Also, ObjectName is ANSI, not
//     Unicode.
typedef struct  _OBJECT_ATTRIBUTES {
	HANDLE RootDirectory;
	PANSI_STRING ObjectName;
	ULONG Attributes;
} OBJECT_ATTRIBUTES, *POBJECT_ATTRIBUTES;

// IO Status Block type
// Differences from NT: None.
typedef struct  _IO_STATUS_BLOCK {
	union {
		NTSTATUS Status;
		PVOID Pointer;
	};

	ULONG_PTR Information;
} IO_STATUS_BLOCK, *PIO_STATUS_BLOCK;

// IO APC routine
typedef
VOID
(NTAPI *PIO_APC_ROUTINE) (
	IN PVOID ApcContext,
	IN PIO_STATUS_BLOCK IoStatusBlock,
	IN ULONG Reserved
	);

// LARGE_INTEGER (signed)
// Order depends on byte order of CPU but we're always x86
typedef union _LARGE_INTEGER {
	struct {
		ULONG LowPart;
		LONG HighPart;
	};

	LONGLONG QuadPart;
} LARGE_INTEGER, *PLARGE_INTEGER;

// KeRaiseIrqlToDpcLevel:
// Raises IRQL to DISPATCH_LEVEL.  Like KeRaiseIrql except returns old level directly.
//
// Differences from NT: None.
NTSYSAPI
EXPORTNUM(129)
KIRQL
(NTAPI *KeRaiseIrqlToDpcLevel)(
	VOID
	);

// KeLowerIrql:
// Lowers IRQL to the specified value.
//
// Differences from NT: None.
// Fastcall function - Converted from stdcall to fastcall by stub code
NTSYSAPI
EXPORTNUM(161)
VOID
(NTAPI *KfLowerIrql)(
	IN KIRQL NewIrql
	);

// NtAllocateVirtualMemory:
// Allocates virtual memory.
//
// Differences from NT: There is no ProcessHandle parameter.
NTSYSAPI
EXPORTNUM(184)
NTSTATUS
(NTAPI *NtAllocateVirtualMemory)(
	IN OUT PVOID *BaseAddress,
	IN ULONG ZeroBits,
	IN OUT PULONG AllocationSize,
	IN ULONG AllocationType,
	IN ULONG Protect
	);

// NtClose:
// Closes a file or other handle.
//
// Differences from NT: None.
NTSYSAPI
EXPORTNUM(187)
NTSTATUS
(NTAPI *NtClose)(
	IN HANDLE Handle
	);

// NtCreateFile:
// Creates or opens a file or device object.
//
// Differences from NT: The EaBuffer and EaLength options are gone.
//     OBJECT_ATTRIBUTES uses ANSI_STRING, so only ANSI filenames work.
NTSYSAPI
EXPORTNUM(190)
NTSTATUS
(NTAPI *NtCreateFile)(
    OUT PHANDLE FileHandle,
    IN ACCESS_MASK DesiredAccess,
    IN POBJECT_ATTRIBUTES ObjectAttributes,
    OUT PIO_STATUS_BLOCK IoStatusBlock,
    IN PLARGE_INTEGER AllocationSize OPTIONAL,
    IN ULONG FileAttributes,
    IN ULONG ShareAccess,
    IN ULONG CreateDisposition,
    IN ULONG CreateOptions
    );

// NtFreeVirtualMemory:
// Frees virtual memory.
//
// Differences from NT: There is no ProcessHandle parameter.
NTSYSAPI
EXPORTNUM(199)
NTSTATUS
(NTAPI *NtFreeVirtualMemory)(
	IN OUT PVOID *BaseAddress,
	IN OUT PULONG FreeSize,
	IN ULONG FreeType
	);

// NtWriteFile:
// Writes a file.
//
// Differences from NT: There is no Key parameter.
NTSYSAPI
EXPORTNUM(236)
NTSTATUS
(NTAPI *NtWriteFile)(
	IN HANDLE FileHandle,
	IN HANDLE Event OPTIONAL,
	IN PIO_APC_ROUTINE ApcRoutine OPTIONAL,
	IN PVOID ApcContext OPTIONAL,
	OUT PIO_STATUS_BLOCK IoStatusBlock,
	IN PVOID Buffer,
	IN ULONG Length,
	IN PLARGE_INTEGER ByteOffset
	);

// RtlInitAnsiString:
// Fills an ANSI_STRING structure to use the specified string.
//
// Differences from NT: None.
NTSYSAPI
EXPORTNUM(289)
VOID
(NTAPI *RtlInitAnsiString) (
	OUT PANSI_STRING DestinationString,
	IN PCSZ SourceString
	);

#endif
