/*
	-=[ Ninja Gaiden Screenshot Mod ]=-
	
	By Alucard @ Neotaku
*/

#include <memory.h>

#include "types.h"
#include "ntapi.h"
#include "gamepad.h"

// Parameters of the framebuffer (depth = 32bits)
#define WIDTH	768
#define HEIGHT	480

// Assembler routine to resolve kernel exports
extern VOID ResolveKernelExports(VOID);

// Prototype of our screenshot function
VOID DoScreenshot(VOID);

// A quick function to convert an integer to ascii
VOID IntegerToAscii(PSTR String, DWORD Integer, DWORD Size);

// -[!!]- Program entry point -[!!]-
//     DON'T PUT ANY CODE ABOVE
DWORD WINAPI _start(HANDLE Handle, PPAD_STATE PadState)
{
	// Pointer to Ninja Gaiden's pad poll routine
	static PPAD_POLL	PadPoll = (PPAD_POLL)0x3AEB4B;
	// Internal state of the mod
	static DWORD		State = 1;
	DWORD				Result;
	
	// One time init: Resolve kernel exports
	if (State == 1)
	{
		ResolveKernelExports();
		State++;
	}
	
	// Call the game's pad polling function
	Result = PadPoll(Handle, PadState);

	// Do a screenshot only when WHITE changes from depressed to pressed
	if ((PadState->AnalogButtons[PAD_WHITE] > 128)&&(State == 2))
	{
		State = 3;
		DoScreenshot();
	} else if ((PadState->AnalogButtons[PAD_WHITE] < 128)&&(State == 3))
		State = 2;

	// Prevent the game from seeing the state of WHITE
	PadState->AnalogButtons[PAD_WHITE] = 0;
	
	return Result;
}

//------------------------------------------------------------------------------
VOID IntegerToAscii(PSTR String, DWORD Integer, DWORD Size)
{
	while(Size)
	{
		*--String = (Integer % 10) + 0x30;
		Integer /= 10;
		Size--;
	}
}

//------------------------------------------------------------------------------
VOID DoScreenshot(VOID)
{
	static PSTR		Filename =
			"\\Device\\Harddisk0\\Partition1\\Screenshots\\Screenshot0000.bin";
	static DWORD		ScreenshotCounter = 1;
	KIRQL				Irql;
	PVOID				Buffer;
	PVOID				FrameBuffer;
	ULONG				AllocSize;
	ANSI_STRING			AnsiFilename;
	IO_STATUS_BLOCK		StatusBlock;
	OBJECT_ATTRIBUTES	ObjectAttributes;
	HANDLE				FileHandle;

	// Modify the filename according to the screenshot number
	IntegerToAscii(Filename + strlen(Filename) - 4, ScreenshotCounter, 4);
	
	// Increment the screenshot counter
	ScreenshotCounter++;
		
	// Get a valid frame buffer address from the GPU
	FrameBuffer = (PVOID)((*((volatile ULONG*)(0xFD600800))) | 0x80000000);
	
	// Allocate a buffer large enough to hold a copy of the framebuffer
	Buffer = NULL;
	AllocSize = WIDTH * HEIGHT * 4;
	NtAllocateVirtualMemory(
		&Buffer,
		2,
		&AllocSize,
		MEM_COMMIT,
		PAGE_EXECUTE_READWRITE);
	
	// Raise the interrupt level to the maximum.
	// This will prevent the game from page flipping or rendering to the buffer
	// while we are copying it.
	Irql = KeRaiseIrqlToDpcLevel();
	
	// Copy the framebuffer as fast as we can
	memcpy(Buffer, FrameBuffer, WIDTH * HEIGHT * 4);
	
	// Restore the previous interrupt level
	KfLowerIrql(Irql);

	// Initialize an ANSI_STRING with the filename
	RtlInitAnsiString(&AnsiFilename, Filename);
	InitializeObjectAttributes(
		&ObjectAttributes,
		&AnsiFilename,
		OBJ_CASE_INSENSITIVE,
		NULL);
	
	// Create / overwrite the file
	NtCreateFile(
		&FileHandle,
		GENERIC_WRITE,
		&ObjectAttributes,
		&StatusBlock,
		NULL,
		FILE_ATTRIBUTE_NORMAL,
		FILE_SHARE_READ,
		FILE_OVERWRITE_IF,
		FILE_NON_DIRECTORY_FILE | FILE_SYNCHRONOUS_IO_NONALERT);
	
	// Write the raw framebuffer data
	memset(&StatusBlock, 0, sizeof(IO_STATUS_BLOCK));
	NtWriteFile(
		FileHandle,
		NULL,
		NULL,
		NULL,
		&StatusBlock,
		Buffer,
		WIDTH * HEIGHT * 4,
		NULL);
	
	// Close the file
	NtClose(FileHandle);
	
	// Free the buffer
	AllocSize = 0;
	NtFreeVirtualMemory(&Buffer, &AllocSize, MEM_RELEASE);
}
