#include "types.h"

#ifndef _GAMEPAD_H_
#define _GAMEPAD_H_

// Masks for Buttons
#define PAD_UP			0x01
#define PAD_DOWN		0x02
#define PAD_LEFT		0x04
#define PAD_RIGHT		0x08
#define PAD_START		0x10
#define PAD_BACK		0x20
#define PAD_LTHUMB		0x40
#define PAD_RTHUMB		0x80

// Indexes for AnalogButtons
#define PAD_A			0
#define PAD_B			1
#define PAD_X			2
#define PAD_Y			3
#define PAD_BLACK		4
#define PAD_WHITE		5
#define PAD_LTRIGGER	6
#define PAD_RTRIGGER	7

// Pad state structure
typedef struct
{
	DWORD	Unknown;
	WORD	Buttons;
	BYTE	AnalogButtons[8];
	SHORT	LeftThumbX;
	SHORT	LeftThumbY;
	SHORT	RightThumbX;
	SHORT	RightThumbY;
} PAD_STATE, *PPAD_STATE;

typedef DWORD WINAPI (*PPAD_POLL)(HANDLE, PPAD_STATE);

#endif
