/*
	-=[ A tool to convert raw framebuffer dumps to BMP files ]=-
	
	 By Alucard @ Neotaku

	Should compile on almost anything with little or no modification.
	(see the makefile for compilation options)
	
	Tested on : Linux/x86, Windows
	Untested  : MacOS X
*/

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#include "stdtypes.h"
#include "list.h"
#include "xfile.h"

#define	WIDTH	768
#define HEIGHT	480
#define WIDTH2	720

const BYTE BmpHeader[] = {
	0x42, 0x4d, 0x36, 0xd2, 0x0f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x28, 0x00,
	0x00, 0x00, 0xd0, 0x02, 0x00, 0x00, 0xe0, 0x01,
	0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xd2, 0x0f, 0x00, 0x12, 0x0b,
	0x00, 0x00, 0x12, 0x0b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const BYTE BlockNo[] = {
	 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
	18, 19, 16, 17, 22, 23, 20, 21, 26, 27, 24, 25, 30, 31, 28, 29,
	33, 34, 35, 32, 37, 38, 39, 36, 41, 42, 43, 40, 45, 46, 47, 44,
	51, 48, 49, 50, 55, 52, 53, 54, 59, 56, 57, 58, 63, 60, 61, 62,
};

static BYTE	Buffer1[WIDTH * HEIGHT * 4];
static BYTE	Buffer2[WIDTH * HEIGHT * 4];

void DecodeFramebuffer(void *Src, void *Dest);

int main(void)
{
	XFILE			File;
	XFILE_FIND_DATA	FindData;
	LIST			FileList;
	DWORD			FileSize;
	LPSTR			Filename;
	int				i, j;

	ListCreate(&FileList, 32, 32);
	
	fprintf(stdout, "*** XBox Screenshot Converter v0.1\n\n");

	if (XFileFindFirst(&FindData, "."))
	{
		do
		{
			if ((strlen(FindData.Filename) > 4)
				 && (!strcmp(FindData.Filename + strlen(FindData.Filename) - 4, ".bin")))
			{
				if (XFileGetSize(FindData.Filename, &FileSize))
				{
					if (FileSize == WIDTH * HEIGHT * 4)
					{
						Filename = (LPSTR)malloc(strlen(FindData.Filename) + 1);
						strcpy(Filename, FindData.Filename);
						ListAdd(&FileList, (PVOID)Filename);
					}
					else
						fprintf(stderr, "Error: File %s doesn't look like a valid file!\n",
							FindData.Filename);
				}
				else
					fprintf(stderr, "Error: Can't access file %s, ignoring it.\n",
						FindData.Filename);
			}
		} while(XFileFindNext(&FindData));
	
		XFileFindClose(&FindData);
	}
	
	if (!FileList.Count)
		fprintf(stderr, "Error: Nothing to do !\n");
	
	for(i = 0;i < FileList.Count;i++)
	{
		Filename = (LPSTR)FileList.Pointers[i];
	
		fprintf(stdout, "Processing file %s...\n", Filename);
		
		if (!XFileOpen(&File, Filename, XFILE_READ))
		{
			fprintf(stderr, "Error: Can't open file %s for reading, ignoring it.\n",
				Filename);
			continue;
		}
		
		XFileRead(&File, Buffer1, WIDTH * HEIGHT * 4);
		XFileClose(&File);
		
		DecodeFramebuffer(Buffer1, Buffer2);
		
		for(j = 0;j < HEIGHT;j++)
			memcpy( &Buffer1[j * WIDTH2 * 3], &Buffer2[j * WIDTH * 3], WIDTH2 * 3);
		
		strcpy(Filename + strlen(Filename) - 4, ".bmp");
		
		if (XFileOpen(&File, Filename, XFILE_WRITE))
		{
			XFileWrite(&File, (PVOID)BmpHeader, sizeof(BmpHeader));
			XFileWrite(&File, (PVOID)Buffer1, WIDTH2 * HEIGHT * 3);
			XFileClose(&File);
		}
		else
			fprintf(stderr, "Error: Can't open/create file %s...\n", Filename);
		
	}
		
	ListDestroy(&FileList, TRUE);
		
	return 0;
}

void DecodeFramebuffer(void *Src, void *Dest)
{
	PBYTE			a, b, c, d;
	DWORD			i, j, k, l, offset, index;

	a = (PBYTE)Src;
	b = ((PBYTE)Dest) + ((HEIGHT-1) * WIDTH * 3);

	index = 0;

	for(i = 0;i < HEIGHT / 16;i++)
	{
		for(j = 0;j < WIDTH / 64;j++)
		{
			if (i & 1)
			{
				if (j & 1)
					b -= 192;
				else
					b += 192;
			}

			for(l = 0;l < 4;l++)
			{
				for(k = 0;k < 16;k++)
				{
					offset = (((BlockNo[index] & 0xFFFFFFFE) >> 2) * 256)
							 + ((BlockNo[index] & 3) * 16);
					index = (index + 1) & 63;

					d = &b[WIDTH * -3 * 0];
					c = &a[offset + 64 * 0];
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					
					d = &b[WIDTH * -3 * 1];
					c = &a[offset + 64 * 1];
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					
					d = &b[WIDTH * -3 * 2];
					c = &a[offset + 64 * 2];
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					

					d = &b[WIDTH * -3 * 3];
					c = &a[offset + 64 * 3];
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					
					*d++ = *c++;
					*d++ = *c++;
					*d++ = *c++;
					c++;					

					b += 12;
				}

				b = b - 192 - (WIDTH * 12);
			}

			b = b + (WIDTH * 48) + 192;
			a += 4096;

			if (i & 1)
			{
				if (j & 1)
					b += 192;
				else
					b -= 192;
			}
		}

		b = b - (WIDTH * 51);
	}
}
