init offset = -1





init:
    image loading_video = Movie(
        play="assets/video/loading.webm",  
        loop=True,                           
        xysize=(640, 480),
        channel="movie"                      
    )





style default:
    properties gui.text_properties()
    language gui.language

style input:
    properties gui.text_properties("input", accent=True)
    adjust_spacing False

style hyperlink_text:
    properties gui.text_properties("hyperlink", accent=True)
    hover_underline True

style gui_text:
    properties gui.text_properties("interface")


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.text_properties("button")
    yalign 0.5


style label_text is gui_text:
    properties gui.text_properties("label", accent=True)

style prompt_text is gui_text:
    properties gui.text_properties("prompt")


style bar:
    ysize gui.bar_size
    left_bar Frame("gui/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)





















screen say(who, what):


    use interrupt_button

    window:
        id "window"

        if who is not None:

            window:
                id "namebox"
                style "namebox"
                text who id "who"

        text what id "what"



    if not renpy.variant("small"):
        add SideImage() xalign 0.0 yalign 1.0

init:
    style my_loading_frame:
        background Solid("#FFFFFF")
        xpadding 10
        ypadding 10

screen loading_screen():
    frame:
        style "my_loading_frame"
        at truecenter
        add "loading_video" xysize (int(config.screen_width * 0.6), int(config.screen_height * 0.6))




init python:
    config.character_id_prefixes.append('namebox')

style window is default
style say_label is default
style say_dialogue is default
style say_thought is say_dialogue

style namebox is default
style namebox_label is say_label


style window:
    xalign 0.5
    xfill True
    yalign gui.textbox_yalign
    ysize gui.textbox_height

    background Image("gui/textbox.png", xalign=0.5, yalign=1.0)

style namebox:
    xpos gui.name_xpos
    xanchor gui.name_xalign
    xsize gui.namebox_width
    ypos gui.name_ypos
    ysize gui.namebox_height

    background Frame("gui/namebox.png", gui.namebox_borders, tile=gui.namebox_tile, xalign=gui.name_xalign)
    padding gui.namebox_borders.padding

style say_label:
    properties gui.text_properties("name", accent=True)
    xalign gui.name_xalign
    yalign 0.5

style say_dialogue:
    properties gui.text_properties("dialogue")

    xpos gui.dialogue_xpos
    xsize gui.dialogue_width
    ypos gui.dialogue_ypos

    adjust_spacing False











screen input(prompt):
    style_prefix "input"

    window:

        has vbox
        xanchor gui.dialogue_text_xalign
        xpos gui.dialogue_xpos
        xsize gui.dialogue_width
        ypos gui.dialogue_ypos

        text prompt style "input_prompt"
        input id "input"

style input_prompt is default

style input_prompt:
    xalign gui.dialogue_text_xalign
    properties gui.text_properties("input_prompt")

style input:
    xalign gui.dialogue_text_xalign
    xmaximum gui.dialogue_width
    size 26










screen choice(items):
    style_prefix "choice"

    vbox:
        for i in items:
            textbutton i.caption action i.action


style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    ypos 405
    yanchor 0.5

    spacing gui.choice_spacing

style choice_button is default:
    properties gui.button_properties("choice_button")

style choice_button_text is default:
    properties gui.text_properties("choice_button")







screen quick_menu():


    zorder 100

    if quick_menu:

        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 1.0

            textbutton _("Back") action Rollback()
            textbutton _("History") action ShowMenu('history')
            textbutton _("Skip") action Skip() alternate Skip(fast=True, confirm=True)
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Save") action ShowMenu('save')
            textbutton _("Q.Save") action QuickSave()
            textbutton _("Q.Load") action QuickLoad()
            textbutton _("Prefs") action ShowMenu('preferences')




init python:
    config.overlay_screens.append("quick_menu")

default quick_menu = True

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    properties gui.text_properties("quick_button")











screen navigation():

    vbox:
        style_prefix "navigation"

        xpos gui.navigation_xpos
        yalign 0.5

        spacing gui.navigation_spacing

        if main_menu:

            textbutton _("Start") action Start()

            textbutton _("Quick Start") action Start("quick_start")

            textbutton _("Custom Start") action Start("custom_start")

        else:

            textbutton _("History") action ShowMenu("history")

            textbutton _("Save") action ShowMenu("save")

        textbutton _("Load") action ShowMenu("load")

        textbutton _("Preferences") action ShowMenu("preferences")


        textbutton _("AI Prompts") action ShowMenu("ai_prompt_management")


        textbutton _("API Config") action ShowMenu("api_config")


        textbutton _("Persona") action ShowMenu("persona_management")

        if _in_replay:

            textbutton _("End Replay") action EndReplay(confirm=True)

        elif not main_menu:

            textbutton _("Main Menu") action MainMenu()

        textbutton _("About") action ShowMenu("about")

        if renpy.variant("pc") or (renpy.variant("web") and not renpy.variant("mobile")):


            textbutton _("Help") action ShowMenu("help")

        if renpy.variant("pc"):



            textbutton _("Quit") action Quit(confirm=not main_menu)


style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    padding (18, 14)

    background Frame(
        Transform(
            Solid("#2c4a6b"), 
            alpha=0.85
        ), 
        left=25, top=25, right=25, bottom=25
    )
    hover_background Frame(
        Transform(
            Solid("#4a6b8a"), 
            alpha=0.95
        ), 
        left=25, top=25, right=25, bottom=25
    )
    selected_background Frame(
        Transform(
            Solid("#5a7b9a"), 
            alpha=1.0
        ), 
        left=25, top=25, right=25, bottom=25
    )
    insensitive_background Frame(
        Transform(
            Solid("#1a2a3b"), 
            alpha=0.6
        ), 
        left=25, top=25, right=25, bottom=25
    )
    xsize 280
    xalign 0.0

    foreground Frame(
        Solid("#ffffff15"), 
        left=25, top=25, right=25, bottom=25
    )
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.text_properties("navigation_button")
    idle_color "#E8F4FF"
    hover_color "#FFFFFF"
    selected_color "#FFFFFF"
    insensitive_color "#8899AA"
    font gui.interface_text_font
    bold True
    size 30
    text_align 0.5
    xalign 0.5

    outlines [(2, "#00000040", 0, 0)]








screen main_menu():
    tag menu




    add Transform("assets/ui/main/main.png", fit="cover")


    frame:
        style "main_menu_frame"



    use navigation

    if gui.show_name:

        vbox:
            style "main_menu_vbox"

            text "[config.name!t]":
                style "main_menu_title"

            text "[config.version]":
                style "main_menu_version"


style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_frame:
    xsize 420
    yfill True


    background Frame(Solid("#00000000"), 0, 0)

style main_menu_vbox:
    xalign 1.0
    xoffset -30
    xmaximum 1200
    yalign 0.0
    yoffset 30

style main_menu_text:
    properties gui.text_properties("main_menu", accent=True)

style main_menu_title:
    properties gui.text_properties("title")

    color "#4A90E2"
    bold True

    outlines [(3, "#FFFFFF", 0, 0), (6, "#2E5A8A", 0, 0), (9, "#00000040", 2, 2)]

    size 85

style main_menu_version:
    properties gui.text_properties("version")

    color "#6BA3E8"
    bold True

    outlines [(2, "#FFFFFF", 0, 0), (4, "#3A6FA5", 0, 0), (6, "#00000030", 1, 1)]
    size 32











screen game_menu(title, scroll=None, yinitial=0.0, spacing=0):

    style_prefix "game_menu"

    if main_menu:
        add Transform("assets/ui/main/main.png", fit="cover")
    else:
        add gui.game_menu_background

    frame:
        style "game_menu_outer_frame"

        has hbox


        frame:
            style "game_menu_navigation_frame"

        frame:
            style "game_menu_content_frame"

            if scroll == "viewport":

                viewport:
                    yinitial yinitial
                    scrollbars "vertical"
                    mousewheel True
                    draggable True
                    pagekeys True

                    side_yfill True

                    has vbox
                    spacing spacing

                    transclude

            elif scroll == "vpgrid":

                vpgrid:
                    cols 1
                    yinitial yinitial

                    scrollbars "vertical"
                    mousewheel True
                    draggable True
                    pagekeys True

                    side_yfill True

                    spacing spacing

                    transclude

            else:

                transclude

    use navigation

    textbutton _("Return"):
        style "return_button"

        action Return()

    label title

    if main_menu:
        key "game_menu" action ShowMenu("main_menu")


style game_menu_outer_frame is empty
style game_menu_navigation_frame is empty
style game_menu_content_frame is empty
style game_menu_viewport is gui_viewport
style game_menu_side is gui_side
style game_menu_scrollbar is gui_vscrollbar

style game_menu_label is gui_label
style game_menu_label_text is gui_label_text

style return_button is navigation_button
style return_button_text is navigation_button_text

style game_menu_outer_frame:
    bottom_padding 45
    top_padding 180

    background "gui/overlay/game_menu.png"

style game_menu_navigation_frame:
    xsize 420
    yfill True

style game_menu_content_frame:
    left_margin 60
    right_margin 30
    top_margin 15

style game_menu_viewport:
    xsize 1380

style game_menu_vscrollbar:
    unscrollable gui.unscrollable

style game_menu_side:
    spacing 15

style game_menu_label:
    xpos 75
    ysize 180

style game_menu_label_text:
    size gui.title_text_size
    color gui.accent_color
    yalign 0.5

style return_button:
    xpos gui.navigation_xpos
    yalign 1.0
    yoffset -45









screen about():
    tag menu





    use game_menu(_("About"), scroll="viewport"):

        style_prefix "about"

        vbox:

            label "[config.name!t]"
            text _("Version [config.version!t]\n")


            if gui.about:
                text "[gui.about!t]\n"

            text _("Made with {a=https://www.renpy.org/}Ren'Py{/a} [renpy.version_only].\n\n[renpy.license!t]")


style about_label is gui_label
style about_label_text is gui_label_text
style about_text is gui_text

style about_label_text:
    size gui.label_text_size











screen save():
    tag menu


    use file_slots(_("Save"))


screen load():
    tag menu


    use file_slots(_("Load"))


screen file_slots(title):

    default page_name_value = FilePageNameInputValue(pattern=_("Page {}"), auto=_("Automatic saves"), quick=_("Quick saves"))

    use game_menu(title):

        fixed:



            order_reverse True


            button:
                style "page_label"

                key_events True
                xalign 0.5
                action page_name_value.Toggle()

                input:
                    style "page_label_text"
                    value page_name_value


            grid gui.file_slot_cols gui.file_slot_rows:
                style_prefix "slot"

                xalign 0.5
                yalign 0.5

                spacing gui.slot_spacing

                for i in range(gui.file_slot_cols * gui.file_slot_rows):

                    $ slot = i + 1

                    button:
                        action FileAction(slot)

                        has vbox

                        add FileScreenshot(slot) xalign 0.5

                        text FileTime(slot, format=_("{#file_time}%A, %B %d %Y, %H:%M"), empty=_("empty slot")):
                            style "slot_time_text"

                        $ _slot_save_name = FileSaveName(slot).replace("{", "{{").replace("[", "[[")
                        text _slot_save_name:
                            style "slot_name_text"

                        key "save_delete" action FileDelete(slot)


            vbox:
                style_prefix "page"

                xalign 0.5
                yalign 1.0

                hbox:
                    xalign 0.5

                    spacing gui.page_spacing

                    textbutton _("<") action FilePagePrevious()
                    key "save_page_prev" action FilePagePrevious()

                    if config.has_autosave:
                        textbutton _("{#auto_page}A") action FilePage("auto")

                    if config.has_quicksave:
                        textbutton _("{#quick_page}Q") action FilePage("quick")


                    for page in range(1, 10):
                        textbutton "[page]" action FilePage(page)

                if config.has_sync:
                    if CurrentScreenName() == "save":
                        textbutton _("Upload Sync"):
                            action UploadSync()
                            xalign 0.5
                    else:
                        textbutton _("Download Sync"):
                            action DownloadSync()
                            xalign 0.5


style page_label is gui_label
style page_label_text is gui_label_text
style page_button is gui_button
style page_button_text is gui_button_text

style slot_button is gui_button
style slot_button_text is gui_button_text
style slot_time_text is slot_button_text
style slot_name_text is slot_button_text

style page_label:
    xpadding 75
    ypadding 5

style page_label_text:
    textalign 0.5
    layout "subtitle"
    hover_color gui.hover_color

style page_button:
    properties gui.button_properties("page_button")

style page_button_text:
    properties gui.text_properties("page_button")

style slot_button:
    properties gui.button_properties("slot_button")

style slot_button_text:
    properties gui.text_properties("slot_button")









screen preferences():
    tag menu


    use game_menu(_("Preferences"), scroll="viewport"):

        vbox:

            hbox:
                box_wrap True

                if renpy.variant("pc") or renpy.variant("web"):

                    vbox:
                        style_prefix "radio"
                        label _("Display")
                        textbutton _("Window") action Preference("display", "window")
                        textbutton _("Fullscreen") action Preference("display", "fullscreen")

                vbox:
                    style_prefix "check"
                    label _("Skip")
                    textbutton _("Unseen Text") action Preference("skip", "toggle")
                    textbutton _("After Choices") action Preference("after choices", "toggle")
                    textbutton _("Transitions") action InvertSelected(Preference("transitions", "toggle"))

                vbox:
                    style_prefix "check"
                    label _("Sandbox")
                    textbutton _("Allow Advance to Afternoon in Q/A") action ToggleVariable("enable_qa_time_advance")




            null height (4 * gui.pref_spacing)

            hbox:
                style_prefix "slider"
                box_wrap True

                vbox:

                    label _("Text Speed")

                    bar value Preference("text speed")

                    label _("Auto-Forward Time")

                    bar value Preference("auto-forward time")

                vbox:

                    if config.has_music:
                        label _("Music Volume")

                        hbox:
                            bar value Preference("music volume")

                    if config.has_sound:

                        label _("Sound Volume")

                        hbox:
                            bar value Preference("sound volume")

                            if config.sample_sound:
                                textbutton _("Test") action Play("sound", config.sample_sound)


                    if config.has_voice:
                        label _("Voice Volume")

                        hbox:
                            bar value Preference("voice volume")

                            if config.sample_voice:
                                textbutton _("Test") action Play("voice", config.sample_voice)

                    if config.has_music or config.has_sound or config.has_voice:
                        null height gui.pref_spacing

                        textbutton _("Mute All"):
                            action Preference("all mute", "toggle")
                            style "mute_all_button"


style pref_label is gui_label
style pref_label_text is gui_label_text
style pref_vbox is vbox

style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox

style check_label is pref_label
style check_label_text is pref_label_text
style check_button is gui_button
style check_button_text is gui_button_text
style check_vbox is pref_vbox

style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style slider_pref_vbox is pref_vbox

style mute_all_button is check_button
style mute_all_button_text is check_button_text

style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 3

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 338

style radio_vbox:
    spacing gui.pref_button_spacing

style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/radio_[prefix_]foreground.png"

style radio_button_text:
    properties gui.text_properties("radio_button")

style check_vbox:
    spacing gui.pref_button_spacing

style check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style check_button_text:
    properties gui.text_properties("check_button")

style slider_slider:
    xsize 525

style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 15

style slider_button_text:
    properties gui.text_properties("slider_button")

style slider_vbox:
    xsize 675










screen history():
    tag menu



    predict False

    use game_menu(_("History"), scroll=("vpgrid" if gui.history_height else "viewport"), yinitial=1.0, spacing=gui.history_spacing):

        style_prefix "history"

        for h in _history_list:

            window:


                has fixed
                yfit True

                if h.who:

                    label h.who:
                        style "history_name"
                        substitute False



                        if "color" in h.who_args:
                            text_color h.who_args["color"]

                $ what = renpy.filter_text_tags(h.what, allow=gui.history_allow_tags)
                text what:
                    substitute False

        if not _history_list:
            label _("The dialogue history is empty.")




define gui.history_allow_tags = { "alt", "noalt", "rt", "rb", "art" }


style history_window is empty

style history_name is gui_label
style history_name_text is gui_label_text
style history_text is gui_text

style history_label is gui_label
style history_label_text is gui_label_text

style history_window:
    xfill True
    ysize gui.history_height

style history_name:
    xpos gui.history_name_xpos
    xanchor gui.history_name_xalign
    ypos gui.history_name_ypos
    xsize gui.history_name_width

style history_name_text:
    min_width gui.history_name_width
    textalign gui.history_name_xalign

style history_text:
    xpos gui.history_text_xpos
    ypos gui.history_text_ypos
    xanchor gui.history_text_xalign
    xsize gui.history_text_width
    min_width gui.history_text_width
    textalign gui.history_text_xalign
    layout ("subtitle" if gui.history_text_xalign else "tex")

style history_label:
    xfill True

style history_label_text:
    xalign 0.5








screen help():
    tag menu


    default device = "keyboard"

    use game_menu(_("Help"), scroll="viewport"):

        style_prefix "help"

        vbox:
            spacing 23

            hbox:

                textbutton _("Keyboard") action SetScreenVariable("device", "keyboard")
                textbutton _("Mouse") action SetScreenVariable("device", "mouse")

                if GamepadExists():
                    textbutton _("Gamepad") action SetScreenVariable("device", "gamepad")

            if device == "keyboard":
                use keyboard_help
            elif device == "mouse":
                use mouse_help
            elif device == "gamepad":
                use gamepad_help


screen keyboard_help():

    hbox:
        label _("Enter")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Space")
        text _("Advances dialogue without selecting choices.")

    hbox:
        label _("Arrow Keys")
        text _("Navigate the interface.")

    hbox:
        label _("Escape")
        text _("Accesses the game menu.")

    hbox:
        label _("Ctrl")
        text _("Skips dialogue while held down.")

    hbox:
        label _("Tab")
        text _("Toggles dialogue skipping.")

    hbox:
        label _("Page Up")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Page Down")
        text _("Rolls forward to later dialogue.")

    hbox:
        label "H"
        text _("Hides the user interface.")

    hbox:
        label "S"
        text _("Takes a screenshot.")

    hbox:
        label "V"
        text _("Toggles assistive {a=https://www.renpy.org/l/voicing}self-voicing{/a}.")

    hbox:
        label "Shift+A"
        text _("Opens the accessibility menu.")


screen mouse_help():

    hbox:
        label _("Left Click")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Middle Click")
        text _("Hides the user interface.")

    hbox:
        label _("Right Click")
        text _("Accesses the game menu.")

    hbox:
        label _("Mouse Wheel Up")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Mouse Wheel Down")
        text _("Rolls forward to later dialogue.")


screen gamepad_help():

    hbox:
        label _("Right Trigger\nA/Bottom Button")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Left Trigger\nLeft Shoulder")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Right Shoulder")
        text _("Rolls forward to later dialogue.")

    hbox:
        label _("D-Pad, Sticks")
        text _("Navigate the interface.")

    hbox:
        label _("Start, Guide, B/Right Button")
        text _("Accesses the game menu.")

    hbox:
        label _("Y/Top Button")
        text _("Hides the user interface.")

    textbutton _("Calibrate") action GamepadCalibrate()


style help_button is gui_button
style help_button_text is gui_button_text
style help_label is gui_label
style help_label_text is gui_label_text
style help_text is gui_text

style help_button:
    properties gui.button_properties("help_button")
    xmargin 12

style help_button_text:
    properties gui.text_properties("help_button")

style help_label:
    xsize 375
    right_padding 30

style help_label_text:
    size gui.text_size
    xalign 1.0
    textalign 1.0















screen confirm(message, yes_action, no_action):


    modal True

    zorder 200

    style_prefix "confirm"

    add "gui/overlay/confirm.png"

    frame:

        has vbox
        xalign .5
        yalign .5
        spacing 45

        label _(message):
            style "confirm_prompt"
            xalign 0.5

        hbox:
            xalign 0.5
            spacing 150

            textbutton _("Yes") action yes_action
            textbutton _("No") action no_action


    key "game_menu" action no_action


style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text

style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5

style confirm_prompt_text:
    textalign 0.5
    layout "subtitle"

style confirm_button:
    properties gui.button_properties("confirm_button")

style confirm_button_text:
    properties gui.text_properties("confirm_button")









screen skip_indicator():

    zorder 100
    style_prefix "skip"

    frame:

        has hbox
        spacing 9

        text _("Skipping")

        text "▸" at delayed_blink(0.0, 1.0) style "skip_triangle"
        text "▸" at delayed_blink(0.2, 1.0) style "skip_triangle"
        text "▸" at delayed_blink(0.4, 1.0) style "skip_triangle"



transform delayed_blink(delay, cycle):
    alpha .5

    pause delay

    block:
        linear .2 alpha 1.0
        pause .2
        linear .2 alpha 0.5
        pause (cycle - .4)
        repeat


style skip_frame is empty
style skip_text is gui_text
style skip_triangle is skip_text

style skip_frame:
    ypos gui.skip_ypos
    background Frame("gui/skip.png", gui.skip_frame_borders, tile=gui.frame_tile)
    padding gui.skip_frame_borders.padding

style skip_text:
    size gui.notify_text_size

style skip_triangle:

    size gui.notify_text_size


screen interrupt_button():


    if current_scene_queue and not interrupt_requested:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.97, 0.02)
            padding (20, 10)

            has hbox
            spacing 10
            text "⚡" color "#FFE09B" size 22 outlines [(2, "#936A4C", 0, 0)] yalign 0.5
            textbutton "Interrupt":
                text_color "#FFFFFF"
                text_hover_color "#FFFBEC"
                text_outlines [(2, "#936A4C", 0, 0)]
                text_size 22
                action SetVariable("interrupt_requested", True)
                sensitive not interrupt_requested
            text "⚡" color "#FFE09B" size 22 outlines [(2, "#936A4C", 0, 0)] yalign 0.5


screen manual_roster_controls():

    python:
        from store import ManualCharacterManager
        show_button = False
        if ManualCharacterManager.is_manual_mode_active():
            
            show_button = getattr(store, 'show_roster_button', False) and getattr(store, 'in_ai_conversation', False)

    if show_button:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.03, 0.08)
            padding (20, 10)

            has hbox
            spacing 8

            text "🐴":
                size 24
                yalign 0.5

            textbutton "Manage Characters":
                text_color "#FFFFFF"
                text_hover_color "#FFFBEC"
                text_outlines [(2, "#4C6A93", 0, 0)]
                text_size 20
                action Show("manual_roster_modal")


screen manual_roster_modal():
    modal True
    zorder 250


    on "show":
        action Function(init_temp_roster_selection)


    add Solid("#00000080")

    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (30, 25)
        xsize 1200
        ysize 700

        has vbox
        spacing 20


        hbox:
            xfill True
            text "Select Characters for Conversation" size 28 color "#FFFFFF" xalign 0.5


        text "Click characters to add/remove them from the conversation. At least 1 character must remain." size 16 color "#B8C5DB"


        python:
            from store import ManualCharacterManager
            available_chars = ManualCharacterManager.get_available_characters()


            selected_tags = getattr(store, 'temp_roster_selection', [])


            entries = []
            for char in available_chars:
                
                icon_path = None
                base_folder = char.folder.rstrip('/').rsplit('/', 1)[0] if '/' in char.folder else char.folder
                
                icon_candidates = [
                        f"{base_folder}/icon/icon.png",
                        f"{base_folder}/Icon/icon.png",
                        f"{base_folder}/icon.png",
                        f"{base_folder}/Icon.png",
                    ]
                
                for path in icon_candidates:
                    if renpy.loadable(path):
                        icon_path = path
                        break
                
                entries.append({
                        "config": char,
                        "name": char.name,
                        "tag": char.tag,
                        "icon": icon_path,
                        "in_roster": char.tag in selected_tags
                    })


        viewport:
            xfill True
            yfill True
            draggable True
            mousewheel True
            scrollbars "vertical"

            has vpgrid
            cols 5
            spacing 16
            xfill True

            for entry in entries:
                $ is_selected = entry["in_roster"]

                button:
                    xsize 210
                    ysize 190


                    if is_selected:
                        background Frame(Transform(Solid("#2E3B55"), alpha=0.95), 14, 14)
                        hover_background Frame(Transform(Solid("#3E4B65"), alpha=0.95), 14, 14)
                    else:
                        background Frame(Transform(Solid("#1E2433"), alpha=0.95), 14, 14)
                        hover_background Frame(Transform(Solid("#2B3247"), alpha=0.95), 14, 14)

                    action Function(toggle_temp_roster_selection, entry["tag"])

                    vbox:
                        spacing 8
                        xalign 0.5


                        if entry["icon"]:
                            add Transform(entry["icon"], fit="contain") xalign 0.5 ysize 110
                        else:
                            text "🎭" size 60 xalign 0.5 color "#B8C5DB"


                        text entry["name"] size 18 color "#FFFFFF" xalign 0.5 text_align 0.5


                        if is_selected:
                            text "✓ In Conversation" size 14 color "#90EE90" xalign 0.5
                        else:
                            text "Available" size 14 color "#B8C5DB" xalign 0.5


        hbox:
            spacing 20
            xalign 0.5

            textbutton "Close":
                text_size 20
                text_color "#FFFFFF"
                text_hover_color "#FFECFB"
                text_outlines [(2, "#6A4C93", 0, 0)]
                padding (20, 10)
                background Frame(Transform(Solid("#5a6b7a"), alpha=0.8), 10, 10)
                hover_background Frame(Transform(Solid("#6a7b8a"), alpha=0.9), 10, 10)
                action Hide("manual_roster_modal")

            textbutton "Apply Changes":
                text_size 20
                text_color "#FFFFFF"
                text_hover_color "#ECFFFB"
                text_outlines [(2, "#4C936A", 0, 0)]
                padding (20, 10)
                background Frame(Transform(Solid("#4a7c59"), alpha=0.8), 10, 10)
                hover_background Frame(Transform(Solid("#5a9c69"), alpha=0.9), 10, 10)
                action [Function(apply_roster_changes), Hide("manual_roster_modal")]


screen manual_location_controls():

    python:
        from store import ManualLocationManager, ManualCharacterManager
        show_button = False
        if ManualLocationManager.is_available_during_qa():
            
            show_button = getattr(store, 'show_location_button', False) and getattr(store, 'in_ai_conversation', False)


        show_roster = False
        if show_button and ManualCharacterManager.is_manual_mode_active():
            show_roster = getattr(store, 'show_roster_button', False) and getattr(store, 'in_ai_conversation', False)


        button_position = (0.03, 0.16) if show_roster else (0.03, 0.08)

    if show_button:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align button_position
            padding (20, 10)

            has hbox
            spacing 8

            text "🗺️":
                size 24
                yalign 0.5

            textbutton "Change Location":
                text_color "#FFFFFF"
                text_hover_color "#ECFFFB"
                text_outlines [(2, "#6A934C", 0, 0)]
                text_size 20
                action Show("manual_location_modal")


screen manual_location_modal():
    modal True
    zorder 250


    on "show":
        action Function(init_temp_location_selection)


    add Solid("#00000080")

    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (30, 25)
        xsize 1400
        ysize 800

        has vbox
        spacing 20


        hbox:
            xfill True
            text "Select Location" size 28 color "#FFFFFF" xalign 0.5


        text "Click on a location to change the scene. The background and music will change immediately." size 16 color "#B8C5DB"


        python:
            from store import ManualLocationManager
            locations = ManualLocationManager.get_available_locations()
            current_loc = ManualLocationManager.get_current_location()


        viewport:
            xfill True
            yfill True
            draggable True
            mousewheel True
            scrollbars "vertical"


            has vpgrid
            cols 4
            spacing 20
            xfill True

            for loc in locations:
                $ is_current = (loc["id"] == current_loc)

                button:
                    xsize 320
                    ysize 220
                    background Frame("gui/frame.png", 10, 10)
                    hover_background Frame("gui/button/slot_hover_background.png", 10, 10)
                    selected (is_current)
                    selected_background Frame("gui/button/slot_hover_background.png", 10, 10)
                    padding (10, 10)

                    action [Function(apply_location_change_immediate, loc["id"]), Hide("manual_location_modal")]

                    has vbox
                    spacing 5


                    python:
                        thumb = ManualLocationManager.get_location_thumbnail(loc["background"], size=(300, 169))

                    if thumb:
                        add thumb xalign 0.5
                    else:

                        frame:
                            xsize 300
                            ysize 169
                            background Solid("#2a2a2a")
                            xalign 0.5

                            text loc["name"]:
                                size 18
                                color "#888888"
                                text_align 0.5
                                xalign 0.5
                                yalign 0.5


                    text loc["name"]:
                        size 16
                        color ("#FFFF00" if is_current else "#FFFFFF")
                        text_align 0.5
                        xalign 0.5


                    if is_current:
                        text "(Current)":
                            size 12
                            color "#88FF88"
                            text_align 0.5
                            xalign 0.5


        hbox:
            xalign 0.5
            spacing 50

            textbutton "Cancel":
                text_size 24
                text_color "#FFFFFF"
                text_hover_color "#FF9999"
                text_outlines [(2, "#993333", 0, 0)]
                action Hide("manual_location_modal")

init python:
    def apply_location_change_immediate(location_id):
        """Apply location change immediately when selected."""
        from store import ManualLocationManager
        ManualLocationManager.change_location(location_id)

    def init_temp_roster_selection():
        """Initialize temporary roster selection with current roster."""
        from store import ManualCharacterManager
        current_roster = ManualCharacterManager.get_current_roster()
        store.temp_roster_selection = [c.tag for c in current_roster]
        
        store.pending_roster_changes = None

    def toggle_temp_roster_selection(tag):
        """Toggle a character in the temporary selection."""
        if not hasattr(store, 'temp_roster_selection'):
            store.temp_roster_selection = []
        
        
        if tag in store.temp_roster_selection:
            if len(store.temp_roster_selection) <= 1:
                renpy.notify("At least 1 character must remain selected")
                return
            store.temp_roster_selection.remove(tag)
        else:
            
            if len(store.temp_roster_selection) >= 3:
                renpy.notify("Warning: More than 3 characters may cause overlapping")
            if tag not in store.temp_roster_selection:
                store.temp_roster_selection.append(tag)
        
        
        renpy.restart_interaction()

    def apply_roster_changes():
        """Save the temporary selection as pending changes."""
        from store import ManualCharacterManager
        
        
        current_roster = ManualCharacterManager.get_current_roster()
        current_tags = [c.tag for c in current_roster]
        
        
        selected_tags = getattr(store, 'temp_roster_selection', current_tags)
        arrivals = [tag for tag in selected_tags if tag not in current_tags]
        departures = [tag for tag in current_tags if tag not in selected_tags]
        
        
        if arrivals or departures:
            store.pending_roster_changes = {
                'selected_tags': selected_tags,
                'arrivals': arrivals,
                'departures': departures
            }
            
            
            message_parts = []
            if arrivals:
                message_parts.append(f"Will add: {', '.join(arrivals)}")
            if departures:
                message_parts.append(f"Will remove: {', '.join(departures)}")
            renpy.notify("Changes will apply with next message | " + " | ".join(message_parts))
        else:
            store.pending_roster_changes = None
            renpy.notify("No changes made")









screen notify(message):

    zorder 100
    style_prefix "notify"

    frame at notify_appear:
        text "[message!tq]"

    timer 3.25 action Hide('notify')


transform notify_appear:
    on show:
        alpha 0
        linear .25 alpha 1.0
    on hide:
        linear .5 alpha 0.0


style notify_frame is empty
style notify_text is gui_text

style notify_frame:
    ypos gui.notify_ypos

    background Frame("gui/notify.png", gui.notify_frame_borders, tile=gui.frame_tile)
    padding gui.notify_frame_borders.padding

style notify_text:
    properties gui.text_properties("notify")









screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox
        spacing gui.nvl_spacing


        if gui.nvl_height:

            vpgrid:
                cols 1
                yinitial 1.0

                use nvl_dialogue(dialogue)

        else:

            use nvl_dialogue(dialogue)



        for i in items:

            textbutton i.caption:
                action i.action
                style "nvl_button"

    add SideImage() xalign 0.0 yalign 1.0


screen nvl_dialogue(dialogue):

    for d in dialogue:

        window:
            id d.window_id

            has fixed
            yfit gui.nvl_height is None

            if d.who is not None:

                text d.who:
                    id d.who_id

            text d.what:
                id d.what_id




define config.nvl_list_length = gui.nvl_list_length

style nvl_window is default
style nvl_entry is default

style nvl_label is say_label
style nvl_dialogue is say_dialogue

style nvl_button is button
style nvl_button_text is button_text

style nvl_window:
    xfill True
    yfill True

    background "gui/nvl.png"
    padding gui.nvl_borders.padding

style nvl_entry:
    xfill True
    ysize gui.nvl_height

style nvl_label:
    xpos gui.nvl_name_xpos
    xanchor gui.nvl_name_xalign
    ypos gui.nvl_name_ypos
    yanchor 0.0
    xsize gui.nvl_name_width
    min_width gui.nvl_name_width
    textalign gui.nvl_name_xalign

style nvl_dialogue:
    xpos gui.nvl_text_xpos
    xanchor gui.nvl_text_xalign
    ypos gui.nvl_text_ypos
    xsize gui.nvl_text_width
    min_width gui.nvl_text_width
    textalign gui.nvl_text_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_thought:
    xpos gui.nvl_thought_xpos
    xanchor gui.nvl_thought_xalign
    ypos gui.nvl_thought_ypos
    xsize gui.nvl_thought_width
    min_width gui.nvl_thought_width
    textalign gui.nvl_thought_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_button:
    properties gui.button_properties("nvl_button")
    xpos gui.nvl_button_xpos
    xanchor gui.nvl_button_xalign

style nvl_button_text:
    properties gui.text_properties("nvl_button")











screen bubble(who, what):
    style_prefix "bubble"

    window:
        id "window"

        if who is not None:

            window:
                id "namebox"
                style "bubble_namebox"

                text who:
                    id "who"

        text what:
            id "what"

style bubble_window is empty
style bubble_namebox is empty
style bubble_who is default
style bubble_what is default

style bubble_window:
    xpadding 30
    top_padding 5
    bottom_padding 5

style bubble_namebox:
    xalign 0.5

style bubble_who:
    xalign 0.5
    textalign 0.5
    color "#000"

style bubble_what:
    align (0.5, 0.5)
    text_align 0.5
    layout "subtitle"
    color "#000"

define bubble.frame = Frame("gui/bubble.png", 55, 55, 55, 95)
define bubble.thoughtframe = Frame("gui/thoughtbubble.png", 55, 55, 55, 55)

define bubble.properties = {
    "bottom_left" : {
        "window_background" : Transform(bubble.frame, xzoom=1, yzoom=1),
        "window_bottom_padding" : 27,
    },

    "bottom_right" : {
        "window_background" : Transform(bubble.frame, xzoom=-1, yzoom=1),
        "window_bottom_padding" : 27,
    },

    "top_left" : {
        "window_background" : Transform(bubble.frame, xzoom=1, yzoom=-1),
        "window_top_padding" : 27,
    },

    "top_right" : {
        "window_background" : Transform(bubble.frame, xzoom=-1, yzoom=-1),
        "window_top_padding" : 27,
    },

    "thought" : {
        "window_background" : bubble.thoughtframe,
    }
}

define bubble.expand_area = {
    "bottom_left" : (0, 0, 0, 22),
    "bottom_right" : (0, 0, 0, 22),
    "top_left" : (0, 22, 0, 0),
    "top_right" : (0, 22, 0, 0),
    "thought" : (0, 0, 0, 0),
}







style pref_vbox:
    variant "medium"
    xsize 675



screen quick_menu():
    variant "touch"

    zorder 100

    if quick_menu:

        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 1.0

            textbutton _("Back") action Rollback()
            textbutton _("Skip") action Skip() alternate Skip(fast=True, confirm=True)
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Menu") action ShowMenu()


style window:
    variant "small"
    background "gui/phone/textbox.png"

style radio_button:
    variant "small"
    foreground "gui/phone/button/radio_[prefix_]foreground.png"

style check_button:
    variant "small"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style nvl_window:
    variant "small"
    background "gui/phone/nvl.png"

style main_menu_frame:
    variant "small"
    background "gui/phone/overlay/main_menu.png"

style game_menu_outer_frame:
    variant "small"
    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "small"
    xsize 510

style game_menu_content_frame:
    variant "small"
    top_margin 0

style pref_vbox:
    variant "small"
    xsize 600

style bar:
    variant "small"
    ysize gui.bar_size
    left_bar Frame("gui/phone/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/phone/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    variant "small"
    xsize gui.bar_size
    top_bar Frame("gui/phone/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/phone/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    variant "small"
    ysize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    variant "small"
    xsize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    variant "small"
    ysize gui.slider_size
    base_bar Frame("gui/phone/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/horizontal_[prefix_]thumb.png"

style vslider:
    variant "small"
    xsize gui.slider_size
    base_bar Frame("gui/phone/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/vertical_[prefix_]thumb.png"

style slider_vbox:
    variant "small"
    xsize None

style slider_slider:
    variant "small"
    xsize 900






init python:

    config.overlay_screens.append("ai_conversation_controls")
    config.overlay_screens.append("interrupt_button")
    config.overlay_screens.append("manual_roster_controls")
    config.overlay_screens.append("manual_location_controls")

screen ai_conversation_controls():

    if show_ai_quit_button:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.97, 0.07)
            padding (20, 10)

            has hbox
            spacing 10
            text "✦" color "#FF9BE4" size 22 outlines [(2, "#6A4C93", 0, 0)] yalign 0.5
            textbutton "Quit Chat":
                text_color "#FFFFFF"
                text_hover_color "#FFECFB"
                text_outlines [(2, "#6A4C93", 0, 0)]
                text_size 22
                action Jump("end_ai_conversation")
            text "✦" color "#FF9BE4" size 22 outlines [(2, "#6A4C93", 0, 0)] yalign 0.5


    if show_regenerate_button:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.97, 0.14)
            padding (20, 10)

            has hbox
            spacing 10
            text "↻" color "#9BFF9E" size 22 outlines [(2, "#4C936A", 0, 0)] yalign 0.5
            textbutton "Regenerate":
                text_color "#FFFFFF"
                text_hover_color "#ECFFFB"
                text_outlines [(2, "#4C936A", 0, 0)]
                text_size 22
                action [SetVariable("regenerate_requested", True), Return()]
            text "↻" color "#9BFF9E" size 22 outlines [(2, "#4C936A", 0, 0)] yalign 0.5


    if show_regenerate_button:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.97, 0.21)
            padding (20, 10)

            has hbox
            spacing 10
            text "↩" color "#9BB2FF" size 22 outlines [(2, "#4C6A93", 0, 0)] yalign 0.5
            textbutton "Undo":
                text_color "#FFFFFF"
                text_hover_color "#ECF2FF"
                text_outlines [(2, "#4C6A93", 0, 0)]
                text_size 22
                action [SetVariable("undo_requested", True), Return()]
            text "↩" color "#9BB2FF" size 22 outlines [(2, "#4C6A93", 0, 0)] yalign 0.5


    # Advance to Afternoon button (optional, sandbox morning only)
    python:
        show_time_advance_button = False
        button_left_pos_y = 0.08
        try:
            # Base visibility conditions (match right-side controls cadence)
            if (show_regenerate_button and in_ai_conversation and getattr(store, 'sandbox_mode', False)
                and getattr(store, 'enable_qa_time_advance', True)
                and getattr(store, 'current_time_slot', 0) == getattr(store, 'time_system').MORNING):
                show_time_advance_button = True

                # Compute stacking on the left under manual controls
                roster_on = False
                location_on = False
                try:
                    from store import ManualCharacterManager
                    roster_on = ManualCharacterManager.is_manual_mode_active() and getattr(store, 'show_roster_button', False) and getattr(store, 'in_ai_conversation', False)
                except Exception:
                    roster_on = False
                try:
                    from store import ManualLocationManager
                    location_on = ManualLocationManager.is_available_during_qa() and getattr(store, 'show_location_button', False) and getattr(store, 'in_ai_conversation', False)
                except Exception:
                    location_on = False

                # Place at top if none, else below any visible manual buttons
                preceding = (1 if roster_on else 0) + (1 if location_on else 0)
                button_left_pos_y = 0.08 + 0.08 * preceding
        except Exception:
            show_time_advance_button = False

    if show_time_advance_button:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.03, button_left_pos_y)
            padding (20, 10)

            hbox:
                spacing 10
                text "🕐" color "#FFB347" size 22 outlines [(2, "#B8860B", 0, 0)] yalign 0.5
                textbutton "Advance to Afternoon":
                    text_color "#FFFFFF"
                    text_hover_color "#FFF5EE"
                    text_outlines [(2, "#B8860B", 0, 0)]
                    text_size 18
                    action [SetVariable("time_advance_requested", True), Return()]
                text "🕐" color "#FFB347" size 22 outlines [(2, "#B8860B", 0, 0)] yalign 0.5

    python:
        show_sleepover_button = False

        if show_regenerate_button and in_ai_conversation and hasattr(store, 'current_conversation_characters') and current_conversation_characters:
            if hasattr(store, 'SleepoversSystem') and hasattr(store, 'current_location_id') and current_location_id:
                
                initial_loc = getattr(store, 'qa_session_start_location', None)
                show_sleepover_button = SleepoversSystem.can_sleepover(current_location_id, current_conversation_characters, initial_loc)

    if show_sleepover_button and (not sleepover_planned or sleepover_error_recovery) and not sleepover_morning:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.97, 0.28)
            padding (20, 10)

            has hbox
            spacing 10
            text "🌙" color "#FFD700" size 22 outlines [(2, "#8B4513", 0, 0)] yalign 0.5
            textbutton "Spend the Night":
                text_color "#FFFFFF"
                text_hover_color "#FFF7E6"
                text_outlines [(2, "#8B4513", 0, 0)]
                text_size 22
                action [SetVariable("show_roster_button", False), SetVariable("sleepover_requested", True), Return()]
            text "🌙" color "#FFD700" size 22 outlines [(2, "#8B4513", 0, 0)] yalign 0.5


    if sleepover_planned and not sleepover_error_recovery and not sleepover_morning and not nighttime_conversation_active and show_regenerate_button:
        frame:
            background Frame("gui/frame.png", 5, 5, tile=False)
            align (0.97, 0.28)
            padding (20, 10)

            has hbox
            spacing 10
            text "😴" color "#B19CD9" size 22 outlines [(2, "#4A2C6A", 0, 0)] yalign 0.5
            textbutton "Sleep":
                text_color "#FFFFFF"
                text_hover_color "#E6D7FF"
                text_outlines [(2, "#4A2C6A", 0, 0)]
                text_size 22
                action [SetVariable("show_roster_button", False), Jump("enhanced_sleep_action")]
            text "😴" color "#B19CD9" size 22 outlines [(2, "#4A2C6A", 0, 0)] yalign 0.5


screen conversation_loading_indicator():
    zorder 100
    frame:
        background Frame("gui/frame.png", 5, 5, tile=False)
        align (0.03, 0.05)
        padding (15, 10)

        has hbox
        spacing 10
        text "Thinking" color "#FFFFFF" size 20 outlines [(2, "#4C6A93", 0, 0)]


        text DynamicDisplayable(thinking_dots) color "#FFFFFF" size 20 outlines [(2, "#4C6A93", 0, 0)]


init python:

    def thinking_dots(st, at=None):
        """Returns a displayable for the animated thinking dots"""
        num_dots = 1 + int(st * 1.5) % 3
        return Text("." * num_dots, color="#FFFFFF", size=20, 
                outlines=[(2, "#4C6A93", 0, 0)]), 0.1


screen enhanced_sleep_choice_menu():
    modal True
    zorder 200


    add Solid("#00000099")


    frame:
        background Frame(Solid("#2a2a4e"), 5, 5)
        align (0.5, 0.4)
        padding (35, 30)
        xsize 450
        ysize None

        has vbox
        spacing 20
        xalign 0.5


        hbox:
            spacing 8
            xalign 0.5

            text "🌙":
                size 24
                color "#FFF8DC"

            text "Bedtime Scene":
                size 26
                color "#E6E6FA"
                font "DejaVuSans.ttf"
                outlines [(1, "#1a1a3e", 0, 0)]


        add Solid("#4a4a6a"):
            xsize 300
            ysize 1
            xalign 0.5
            alpha 0.4


        hbox:
            spacing 15
            xalign 0.5


            textbutton "Continue":
                text_size 20
                text_color "#C8E6C9"
                text_hover_color "#FFFFFF"
                text_font "DejaVuSans.ttf"
                background Frame(Solid("#2a4a2a"), 3, 3)
                hover_background Frame(Solid("#3a5a3a"), 3, 3)
                padding (18, 10)
                action Return("continue")


            textbutton "Retry":
                text_size 20
                text_color "#D1C4E9"
                text_hover_color "#FFFFFF"
                text_font "DejaVuSans.ttf"
                background Frame(Solid("#3a2a4a"), 3, 3)
                hover_background Frame(Solid("#4a3a5a"), 3, 3)
                padding (18, 10)
                action Return("retry")


            textbutton "Edit":
                text_size 20
                text_color "#B3E5FC"
                text_hover_color "#FFFFFF"
                text_font "DejaVuSans.ttf"
                background Frame(Solid("#2a3a4a"), 3, 3)
                hover_background Frame(Solid("#3a4a5a"), 3, 3)
                padding (18, 10)
                action Return("edit")


screen edit_sleep_prompt(current_prompt=""):
    modal True
    zorder 300
    add Solid("#000000A0")

    default edited_prompt_text = current_prompt
    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (30, 25)
        has vbox
        spacing 16
        text "Edit sleep scene instructions":
            size 26
            color "#FFFFFF"
            outlines [(2, "#6A4C93", 0, 0)]
        input:
            value ScreenVariableInputValue("edited_prompt_text")
            length 1200
            allow "[A-Za-z0-9 .,!?;:\n\-_'\"()\[\]]"
            pixel_width 800
            copypaste True
            multiline True
        hbox:
            spacing 16
            textbutton "Apply":
                action Return(edited_prompt_text)
            textbutton "Cancel":
                action Return("__CANCEL__")


screen scene_choice_menu():
    modal True
    zorder 200


    add Solid("#00000080")


    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (40, 35)
        margin (50, 50)

        has vbox
        spacing 30
        align (0.5, 0.5)


        text "How do you feel about this scene?":
            size 32
            xalign 0.5
            color "#FFFFFF"
            outlines [(2, "#6A4C93", 0, 0), (4, "#000000", 0, 0)]
            text_align 0.5


        hbox:
            spacing 50
            xalign 0.5


            button:
                xsize 180
                ysize 70
                action Return("keep")

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    has vbox
                    xalign 0.5
                    yalign 0.5

                    text "KEEP":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#ECFFFB"
                        outlines [(2, "#4C936A", 0, 0), (4, "#003300", 0, 0)]



                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

            button:
                xsize 180
                ysize 70
                action Return("edit")

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    has vbox
                    xalign 0.5
                    yalign 0.5

                    text "EDIT PROMPT":
                        xalign 0.5
                        yalign 0.5
                        size 22
                        color "#FFFFFF"
                        hover_color "#FFFBEC"
                        outlines [(2, "#6A934C", 0, 0), (4, "#003300", 0, 0)]



                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

            button:
                xsize 180
                ysize 70
                action Return("retry")

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    has vbox
                    xalign 0.5
                    yalign 0.5

                    text "RETRY":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#FFECFB"
                        outlines [(2, "#934C6A", 0, 0), (4, "#330000", 0, 0)]



                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

screen ai_prompt_management():
    tag menu

    use game_menu(_("AI Prompts"), scroll="viewport"):
        style_prefix "ai_prompt"
        vbox:
            spacing 25

            at transform:
                alpha 0.0
                pause 0.1
                linear 0.3 alpha 1.0

            frame:
                background Frame(Transform(Solid("#2E3F5F"), alpha=0.3), 20, 20)
                padding (30, 20)
                xfill True

                has vbox
                spacing 15

                hbox:
                    xfill True


                    hbox:
                        spacing 15
                        text "⚡" size 42 color "#FFD700" yalign 0.5
                        label _("AI Prompt Management") style "ai_prompt_title_modern"

                text _("Customize how the AI generates dialogue, scenes, and story summaries."):
                    size 20
                    color "#B8C5DB"
                    xmaximum 1000


            vpgrid:
                cols 2
                spacing 25
                xfill True


                frame:
                    style "ai_prompt_card"
                    xsize 580
                    ysize 320

                    at transform:
                        on hover:
                            linear 0.15 zoom 1.02
                        on idle:
                            linear 0.15 zoom 1.0
                    has vbox
                    spacing 15
                    xfill True


                    frame:
                        background Frame(Transform(Solid("#4A90E2"), alpha=0.2), 15, 15)
                        padding (20, 15)
                        xfill True

                        has hbox
                        xfill True

                        hbox:
                            spacing 10
                            text "💬" size 32 yalign 0.5
                            text _("Conversation Prompt") style "ai_prompt_card_title"



                    vbox:
                        spacing 10
                        xfill True

                        text _("Controls character responses during conversations"):
                            size 18
                            color "#D4D8E0"
                            xfill True

                        frame:
                            background Frame(Transform(Solid("#000000"), alpha=0.3), 10, 10)
                            padding (15, 10)
                            xfill True

                            text _("prompts/conversation_prompt.json"):
                                size 16
                                color "#8B95A6"


                    hbox:
                        spacing 15
                        xalign 0.5

                        textbutton _("Edit") action Show("edit_conversation_prompt_improved"):
                            style "ai_prompt_primary_button"

                        textbutton _("Reset") action [Function(lambda: (PromptManager.reset_prompt("conversation"), None)[1]), NullAction()]:
                            style "ai_prompt_secondary_button"

                        textbutton _("Reload") action [Function(lambda: (PromptManager.load_prompt("conversation"), None)[1]), NullAction()]:
                            style "ai_prompt_secondary_button"


                frame:
                    style "ai_prompt_card"
                    xsize 580
                    ysize 320

                    at transform:
                        on hover:
                            linear 0.15 zoom 1.02
                        on idle:
                            linear 0.15 zoom 1.0
                    has vbox
                    spacing 15
                    xfill True


                    frame:
                        background Frame(Transform(Solid("#50C878"), alpha=0.2), 15, 15)
                        padding (20, 15)
                        xfill True

                        has hbox
                        xfill True

                        hbox:
                            spacing 10
                            text "🎬" size 32 yalign 0.5
                            text _("Scene Generation") style "ai_prompt_card_title"



                    vbox:
                        spacing 10
                        xfill True

                        text _("Defines how scenes are created at interaction start"):
                            size 18
                            color "#D4D8E0"
                            xfill True

                        frame:
                            background Frame(Transform(Solid("#000000"), alpha=0.3), 10, 10)
                            padding (15, 10)
                            xfill True

                            text _("prompts/scene_prompt.json"):
                                size 16
                                color "#8B95A6"


                    hbox:
                        spacing 15
                        xalign 0.5

                        textbutton _("Edit") action Show("edit_scene_prompt_improved"):
                            style "ai_prompt_primary_button"

                        textbutton _("Reset") action [Function(lambda: (PromptManager.reset_prompt("scene"), None)[1]), NullAction()]:
                            style "ai_prompt_secondary_button"

                        textbutton _("Reload") action [Function(lambda: (PromptManager.load_prompt("scene"), None)[1]), NullAction()]:
                            style "ai_prompt_secondary_button"


                frame:
                    style "ai_prompt_card"
                    xsize 580
                    ysize 320

                    at transform:
                        on hover:
                            linear 0.15 zoom 1.02
                        on idle:
                            linear 0.15 zoom 1.0
                    has vbox
                    spacing 15
                    xfill True


                    frame:
                        background Frame(Transform(Solid("#E2725B"), alpha=0.2), 15, 15)
                        padding (20, 15)
                        xfill True

                        has hbox
                        xfill True

                        hbox:
                            spacing 10
                            text "📖" size 32 yalign 0.5
                            text _("Story Summary") style "ai_prompt_card_title"



                    vbox:
                        spacing 10
                        xfill True

                        text _("Manages story summarization for sandbox mode"):
                            size 18
                            color "#D4D8E0"
                            xfill True

                        frame:
                            background Frame(Transform(Solid("#000000"), alpha=0.3), 10, 10)
                            padding (15, 10)
                            xfill True

                            text _("prompts/story_summary_prompt.json"):
                                size 16
                                color "#8B95A6"


                    hbox:
                        spacing 15
                        xalign 0.5

                        textbutton _("Edit") action Show("edit_story_summary_prompt_improved"):
                            style "ai_prompt_primary_button"

                        textbutton _("Reset") action [Function(lambda: (PromptManager.reset_prompt("story_summary"), None)[1]), NullAction()]:
                            style "ai_prompt_secondary_button"

                        textbutton _("Reload") action [Function(lambda: (PromptManager.load_prompt("story_summary"), None)[1]), NullAction()]:
                            style "ai_prompt_secondary_button"


                frame:
                    style "ai_prompt_card"
                    xsize 580
                    ysize 320

                    at transform:
                        on hover:
                            linear 0.15 zoom 1.02
                        on idle:
                            linear 0.15 zoom 1.0
                    has vbox
                    spacing 15
                    xfill True


                    frame:
                        background Frame(Transform(Solid("#9B59B6"), alpha=0.2), 15, 15)
                        padding (20, 15)
                        xfill True

                        has hbox
                        xfill True

                        hbox:
                            spacing 10
                            text "💾" size 32 yalign 0.5
                            text _("Story Context") style "ai_prompt_card_title"



                    vbox:
                        spacing 10
                        xfill True

                        text _("Export or import your story progress"):
                            size 18
                            color "#D4D8E0"
                            xfill True

                        frame:
                            background Frame(Transform(Solid("#000000"), alpha=0.3), 10, 10)
                            padding (15, 10)
                            xfill True

                            text _("prompts/story.txt"):
                                size 16
                                color "#8B95A6"


                    hbox:
                        spacing 15
                        xalign 0.5

                        textbutton _("Export") action [Function(StorySummarizer.export_context), Show("notify", message="Story context exported!")]:
                            style "ai_prompt_primary_button"

                        textbutton _("Import") action [Function(StorySummarizer.import_context), Show("notify", message="Story context imported!")]:
                            style "ai_prompt_primary_button"

            null height 30


            frame:
                background Frame(Transform(Solid("#1A1E2E"), alpha=0.5), 20, 20)
                padding (30, 25)
                xfill True

                has vbox
                spacing 20

                text _("Global Actions"):
                    size 22
                    color "#FFD700"
                    bold True

                hbox:
                    xalign 0.5
                    spacing 30

                    textbutton _("Reset All Prompts") action [Function(PromptManager.reset_all_prompts), NullAction()]:
                        style "ai_prompt_danger_button"

                    textbutton _("Reload All Prompts") action [Function(PromptManager.load_all_prompts), NullAction()]:
                        style "ai_prompt_action_button"

                    textbutton _("Open Prompts Folder") action Function(open_prompts_folder):
                        style "ai_prompt_action_button"

                null height 10

                frame:
                    background Frame(Transform(Solid("#FFD700"), alpha=0.1), 15, 15)
                    padding (20, 15)
                    xfill True

                    has hbox
                    spacing 10
                    text "ℹ" size 24 color "#FFD700" yalign 0.5
                    text _("Tip: Edit JSON files directly in the 'prompts' directory and click 'Reload' to apply changes without restarting."):
                        size 18
                        color "#B8C5DB"
                        xmaximum 900


style ai_prompt_title:
    size 36
    color "#fff"
    outlines [(2, "#000", 0, 0)]
    yalign 0.5

style ai_prompt_title_modern:
    size 40
    color "#FFFFFF"
    bold True
    outlines [(2, "#1A1E2E", 0, 0)]
    yalign 0.5

style ai_prompt_card:
    background Frame(Transform(Solid("#1E2433"), alpha=0.95), 20, 20)
    padding (25, 25)
    hover_background Frame(Transform(Solid("#252B3D"), alpha=0.95), 20, 20)

style ai_prompt_card_title:
    size 24
    color "#FFFFFF"
    bold True
    yalign 0.5


style ai_prompt_primary_button:
    background Frame(Transform(Solid("#4A90E2"), alpha=0.8), 15, 15)
    hover_background Frame(Transform(Solid("#5BA3FF"), alpha=0.9), 15, 15)
    padding (20, 12)

style ai_prompt_primary_button_text:
    size 18
    color "#FFFFFF"
    hover_color "#FFFFFF"
    bold True

style ai_prompt_secondary_button:
    background Frame(Transform(Solid("#3A4150"), alpha=0.8), 15, 15)
    hover_background Frame(Transform(Solid("#4A5160"), alpha=0.9), 15, 15)
    padding (20, 12)

style ai_prompt_secondary_button_text:
    size 18
    color "#B8C5DB"
    hover_color "#FFFFFF"

style ai_prompt_danger_button:
    background Frame(Transform(Solid("#E74C3C"), alpha=0.8), 15, 15)
    hover_background Frame(Transform(Solid("#FF5C4C"), alpha=0.9), 15, 15)
    padding (25, 15)

style ai_prompt_danger_button_text:
    size 20
    color "#FFFFFF"
    hover_color "#FFFFFF"
    bold True

style ai_prompt_action_button:
    background Frame(Transform(Solid("#27AE60"), alpha=0.8), 15, 15)
    hover_background Frame(Transform(Solid("#37BE70"), alpha=0.9), 15, 15)
    padding (25, 15)

style ai_prompt_action_button_text:
    size 20
    color "#FFFFFF"
    hover_color "#FFFFFF"
    bold True

style ai_prompt_section:
    size 28
    color "#ff9"
    outlines [(1, "#000", 0, 0)]

style ai_prompt_button_text:
    size 24
    hover_color "#ff9"

style ai_prompt_text:
    size 22
    color "#fff"



screen edit_scene_prompt(current_prompt):
    modal True
    zorder 200
    key "K_RETURN" action NullAction()


    default edited_prompt_text = current_prompt


    on "show" action SetScreenVariable("_focus", "prompt_input")


    add Solid("#00000080")

    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (40, 35)
        xsize 1000
        ysize 600

        has vbox
        spacing 20
        xfill True
        yfill True


        text "Edit Scene Prompt":
            size 32
            xalign 0.5
            color "#FFFFFF"
            outlines [(2, "#6A4C93", 0, 0), (4, "#000000", 0, 0)]


        text "Modify the scene prompt below to change how the AI generates the scene.":
            size 22
            xalign 0.5
            color "#FFFFFF"


        frame:
            background "#00000060"
            padding (20, 20)
            xfill True
            ysize 400

            input:
                id "prompt_input"
                value ScreenVariableInputValue("edited_prompt_text")
                size 22
                color "#FFFFFF"
                xfill True
                yfill True
                multiline True
                copypaste True
                allow "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 !@#$%^&*()_+-=[]{}|;':\",./<>?`~\n\t"
                length 10000


        hbox:
            spacing 50
            xalign 0.5


            button:
                xsize 180
                ysize 60
                action Return("__CANCEL__")

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Cancel":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#FFECFB"
                        outlines [(2, "#934C6A", 0, 0), (4, "#330000", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

            button:
                xsize 180
                ysize 60

                action Return(edited_prompt_text)

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Apply":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#ECFFFB"
                        outlines [(2, "#4C936A", 0, 0), (4, "#003300", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

screen edit_conversation_prompt():
    modal True
    zorder 200
    key "K_RETURN" action NullAction()


    python:
        PromptManager.ensure_prompts_loaded()
        prompt_data = PromptManager.PROMPT_CONFIG["conversation"]["data"]
        initial_text = json.dumps(prompt_data, indent=4)

    default edited_prompt_text = initial_text


    on "show" action SetScreenVariable("_focus", "prompt_input")


    add Solid("#00000080")

    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (40, 35)
        xsize 1000
        ysize 600

        has vbox
        spacing 20
        xfill True
        yfill True


        text "Edit Conversation Prompt":
            size 32
            xalign 0.5
            color "#FFFFFF"
            outlines [(2, "#6A4C93", 0, 0), (4, "#000000", 0, 0)]


        text "Modify the conversation prompt JSON below. This controls how characters respond during conversations.":
            size 22
            xalign 0.5
            color "#FFFFFF"


        frame:
            background "#00000060"
            padding (20, 20)
            xfill True
            ysize 400

            has viewport
            scrollbars "vertical"
            mousewheel True
            yinitial 0.0

            input:
                id "prompt_input"
                value ScreenVariableInputValue("edited_prompt_text")
                size 18
                color "#FFFFFF"
                xfill True
                multiline True
                copypaste True
                allow "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 !@#$%^&*()_+-=[]{}|;':\",./<>?`~\n\t"
                length 50000


        hbox:
            spacing 50
            xalign 0.5


            button:
                xsize 180
                ysize 60
                action Hide("edit_conversation_prompt")

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Cancel":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#FFECFB"
                        outlines [(2, "#934C6A", 0, 0), (4, "#330000", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

            button:
                xsize 180
                ysize 60
                action [Function(lambda: save_conversation_prompt(edited_prompt_text)), Hide("edit_conversation_prompt")]

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Apply":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#ECFFFB"
                        outlines [(2, "#4C936A", 0, 0), (4, "#003300", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

screen edit_scene_prompt_template():
    modal True
    zorder 200
    key "K_RETURN" action NullAction()


    python:
        PromptManager.ensure_prompts_loaded()
        prompt_data = PromptManager.PROMPT_CONFIG["scene"]["data"]
        initial_text = json.dumps(prompt_data, indent=4)

    default edited_prompt_text = initial_text


    on "show" action SetScreenVariable("_focus", "prompt_input")


    add Solid("#00000080")

    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (40, 35)
        xsize 1000
        ysize 600

        has vbox
        spacing 20
        xfill True
        yfill True


        text "Edit Scene Prompt Template":
            size 32
            xalign 0.5
            color "#FFFFFF"
            outlines [(2, "#6A4C93", 0, 0), (4, "#000000", 0, 0)]


        text "Modify the scene prompt template JSON below. This controls how scenes are generated.":
            size 22
            xalign 0.5
            color "#FFFFFF"


        frame:
            background "#00000060"
            padding (20, 20)
            xfill True
            ysize 400

            has viewport
            scrollbars "vertical"
            mousewheel True
            yinitial 0.0

            input:
                id "prompt_input"
                value ScreenVariableInputValue("edited_prompt_text")
                size 18
                color "#FFFFFF"
                xfill True
                multiline True
                copypaste True
                allow "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 !@#$%^&*()_+-=[]{}|;':\",./<>?`~\n\t"
                length 50000


        hbox:
            spacing 50
            xalign 0.5


            button:
                xsize 180
                ysize 60
                action Hide("edit_scene_prompt_template")

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Cancel":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#FFECFB"
                        outlines [(2, "#934C6A", 0, 0), (4, "#330000", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

            button:
                xsize 180
                ysize 60
                action [Function(lambda: save_scene_prompt(edited_prompt_text)), Hide("edit_scene_prompt_template")]

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Apply":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#ECFFFB"
                        outlines [(2, "#4C936A", 0, 0), (4, "#003300", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

screen edit_story_summary_prompt():
    modal True
    zorder 200
    key "K_RETURN" action NullAction()


    python:
        PromptManager.ensure_prompts_loaded()
        prompt_data = PromptManager.PROMPT_CONFIG["story_summary"]["data"]
        initial_text = json.dumps(prompt_data, indent=4)

    default edited_prompt_text = initial_text


    on "show" action SetScreenVariable("_focus", "prompt_input")


    add Solid("#00000080")

    frame:
        background Frame("gui/frame.png", 20, 20)
        align (0.5, 0.5)
        padding (40, 35)
        xsize 1000
        ysize 600

        has vbox
        spacing 20
        xfill True
        yfill True


        text "Edit Story Summary Prompt":
            size 32
            xalign 0.5
            color "#FFFFFF"
            outlines [(2, "#6A4C93", 0, 0), (4, "#000000", 0, 0)]


        text "Modify the story summary prompt JSON below. This controls how story summaries are generated.":
            size 22
            xalign 0.5
            color "#FFFFFF"


        frame:
            background "#00000060"
            padding (20, 20)
            xfill True
            ysize 400

            has viewport
            scrollbars "vertical"
            mousewheel True
            yinitial 0.0

            input:
                id "prompt_input"
                value ScreenVariableInputValue("edited_prompt_text")
                size 18
                color "#FFFFFF"
                xfill True
                multiline True
                copypaste True
                allow "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 !@#$%^&*()_+-=[]{}|;':\",./<>?`~\n\t"
                length 50000


        hbox:
            spacing 50
            xalign 0.5


            button:
                xsize 180
                ysize 60
                action Hide("edit_story_summary_prompt")

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Cancel":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#FFECFB"
                        outlines [(2, "#934C6A", 0, 0), (4, "#330000", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0

            button:
                xsize 180
                ysize 60
                action [Function(lambda: save_story_summary_prompt(edited_prompt_text)), Hide("edit_story_summary_prompt")]

                frame:
                    background Frame("gui/button/choice_idle_background.png", 10, 10)
                    hover_background Frame("gui/button/choice_hover_background.png", 10, 10)
                    xfill True
                    yfill True

                    text "Apply":
                        xalign 0.5
                        yalign 0.5
                        size 28
                        color "#FFFFFF"
                        hover_color "#ECFFFB"
                        outlines [(2, "#4C936A", 0, 0), (4, "#003300", 0, 0)]


                at transform:
                    on hover:
                        easein 0.2 zoom 1.05
                    on idle:
                        easeout 0.2 zoom 1.0




init -2:

    style congrats_title:
        size 50
        color "#FF9BE4"
        outlines [(2, "#000000", 0, 0)]
        xalign 0.5

    style congrats_subtitle:
        size 32
        color "#FFFFFF"
        outlines [(1, "#000000", 0, 0)]
        xalign 0.5

    style congrats_body:
        size 26
        color "#FFFFFF"
        xmaximum 1100
        line_spacing 4
        outlines [(1, "#000000", 0, 0)]
        xalign 0.5

    style congrats_footer:
        size 22
        color "#DDDDDD"
        outlines [(1, "#000000", 0, 0)]
        xalign 0.5


screen sandbox_congrats():
    modal True
    zorder 200


    add Solid("#000000B0")


    frame:
        background Frame("gui/frame.png", 30, 30)
        padding (40, 50)
        align (0.5, 0.5)
        xsize int(config.screen_width * 0.8)

        has vbox
        spacing 25
        xalign 0.5

        text "Thank You for Playing!" style "congrats_title"
        text "You've completed the main story demo of the game." style "congrats_subtitle"
        text "You're now entering {i}Friendship Sandbox Mode{/i}, where you can freely visit any location in Ponyville and continue conversations with all the ponies you've met!" style "congrats_body"
        text "Feel free to explore at your own pace and deepen your friendships with the residents of Ponyville." style "congrats_body"
        null height 15
        text "~ Press any key or click to continue ~" style "congrats_footer"


    key "dismiss" action Hide("sandbox_congrats")
    key "mousedown_1" action Hide("sandbox_congrats")


screen persona_management():
    tag menu

    use game_menu(_("Persona"), scroll="viewport"):
        style_prefix "ai_prompt"
        vbox:
            spacing 25

            at transform:
                alpha 0.0
                pause 0.1
                linear 0.3 alpha 1.0

            frame:
                background Frame(Transform(Solid("#2E3F5F"), alpha=0.3), 20, 20)
                padding (30, 20)
                xfill True
                has vbox
                spacing 10
                hbox:
                    spacing 15
                    text "👤" size 42 color "#FFD700" yalign 0.5
                    label _("Player Persona") style "ai_prompt_title_modern"
                text _("Define up to six personas for your player character. Select one to be active; it will be appended to prompts as 'Information on the player:'."):
                    size 20
                    color "#B8C5DB"
                    xmaximum 1000


            python:
                from store import PersonaManager
                PersonaManager._ensure_initialized()
                slots = PersonaManager.get_slots()
                previews = PersonaManager.get_slot_previews()
                active_idx = PersonaManager.get_active_index()
            default persona_selected_idx = 0 if active_idx == -1 else active_idx
            default persona_editor_text = slots[persona_selected_idx]


            frame:
                background Frame(Transform(Solid("#1E2433"), alpha=0.95), 20, 20)
                padding (20, 20)
                xfill True
                has vbox
                spacing 12
                text _("Select Slot") size 22 color "#FFD700" bold True
                grid 6 1:
                    spacing 12
                    xfill True
                    for i in range(6):
                        $ is_active = (active_idx == i)
                        $ is_selected = (persona_selected_idx == i)
                        button:
                            xsize 120
                            ysize 120
                            background Frame(Transform(Solid("#2B3247" if not is_selected else "#3B4563"), alpha=0.95), 12, 12)

                            action [SetScreenVariable("persona_selected_idx", i), SetScreenVariable("persona_editor_text", slots[i])]
                            has vbox
                            spacing 6
                            text _("Slot ") + str(i+1):
                                xalign 0.5
                                size 18
                                color "#FFFFFF"
                            if previews[i]:
                                text previews[i]:
                                    xalign 0.5
                                    size 14
                                    color "#B8C5DB"
                                    textalign 0.5
                                    xmaximum 100
                            else:
                                text _("(empty)") size 14 color "#666" xalign 0.5
                            if is_active:
                                text _("Active") size 14 color "#90EE90" xalign 0.5


            frame:
                background Frame(Transform(Solid("#1E2433"), alpha=0.95), 20, 20)
                padding (20, 20)
                xfill True
                has vbox
                spacing 12
                hbox:
                    spacing 10
                    text _("Editing: Slot ") + str(persona_selected_idx+1):
                        size 22
                        color "#FFD700"
                        bold True
                    if active_idx == persona_selected_idx:
                        text _("(Active)") size 20 color "#90EE90"
                frame:
                    background "#00000060"
                    padding (10, 10)
                    xfill True
                    ysize 220
                    input:
                        value ScreenVariableInputValue("persona_editor_text")
                        size 18
                        color "#FFFFFF"
                        xfill True
                        yfill True
                        multiline True
                        copypaste True
                        allow "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 !@#$%^&*()_+-=[]{}|;':\",./<>?`~\n\t"
                        length 20000
                hbox:
                    spacing 12
                    textbutton _("Set Active") action [Function(set_active_persona, persona_selected_idx), SetScreenVariable("persona_active_idx", persona_selected_idx)] style "ai_prompt_secondary_button"
                    textbutton _("Clear") action [SetScreenVariable("persona_editor_text", ""), Function(clear_persona_slot, persona_selected_idx)] style "ai_prompt_secondary_button"
                    textbutton _("Import") action [Function(import_persona_slot, persona_selected_idx), Function(refresh_persona_after_import, persona_selected_idx)] style "ai_prompt_secondary_button"
                    textbutton _("Export") action Function(export_persona_slot, persona_selected_idx) style "ai_prompt_secondary_button"

                timer 0.4 repeat True action Function(persona_debounced_save)


            frame:
                background Frame(Transform(Solid("#1E2433"), alpha=0.95), 20, 20)
                padding (20, 15)
                xfill True
                has vbox
                spacing 10
                hbox:
                    spacing 20
                    textbutton _("Open Persona Folder") action Function(open_persona_folder)
                    textbutton _("Export All") action [Function(lambda: [export_persona_slot(k) for k in range(6)]), NullAction()]
                    textbutton _("Import All") action [Function(lambda: [import_persona_slot(k) for k in range(6)]), NullAction()]
                text _("Personas are saved in persistent data and can be exported/imported as .txt files in the 'game/persona' folder."):
                    size 16
                    color "#B8C5DB"
                    xmaximum 1000
# Decompiled by unrpyc: https://github.com/CensoredUsername/unrpyc
