#include "fbgfx.bi"
using fb

dim shared tiles(4, 1604) as integer
dim shared racter(12, 1135) as integer
dim x as integer
dim z as integer
dim y as integer

type otype          'creates a custom type for objects like players
    x as single
    y as single
    px as single
    py as single
    speed as single
    frame as integer
    direction as integer
    move as integer
    atack as integer
    alive as integer
    bbx as integer
    bby as integer
    tx as integer
    ty as integer
end type

dim shared player as otype
player.x = 160
player.y = 99
player.speed = 0.75
player.direction = 1
player.bbx = 30
player.bby = 39

dim shared frame1 as integer
dim shared frame2 as integer 

Type tile
    graphic as integer
    state as integer
end type

dim tilemap(9, 15) as tile 'makes a tilemap array

z = 2


screen 13, 8, 2
screenset 0, 1

bload "test\testile1.bmp", 0

get (0, 0) - (19, 19), tiles(1, 0)
get (22, 0) - (41, 19), tiles(2, 0)
get (44, 0) - (63, 19), tiles(3, 0)
get (66, 0) - (85, 19), tiles(4, 0)
cls

bload "test\racspr2.bmp", 0  'loads the sprite to page 0
                            'top row
get (0,0) - (28,38), racter(1,0)
get (30,0) - (58,38), racter(2,0)
get (60,0) - (88,38), racter(3,0)
get (90,0) - (118,38), racter(4,0)
                            'middle row
get (0,39) - (28,77), racter(5,0)
get (30,39) - (58,77), racter(6,0)
get (60,39) - (88,77), racter(7,0)
get (90,39) - (118,77), racter(8,0)
                            'bottom row
get (0,78) - (28,116), racter(9,0) 
get (30,78) - (58,116), racter(10,0)
get (60,78) - (88,116), racter(11,0)
get (90,78) - (118,116), racter(12,0)
cls


for y = 0 to 9      'defines the left and right sides of the tile box
    tilemap(y, 0).graphic = z
    tilemap(y, 15).graphic = z
    tilemap(y, 0).state = 1
    tilemap(y, 15).state = 1
next

for x = 0 to 15     'makes the top and bottom sides of the tile box
    tilemap(0, x).graphic = z
    tilemap(9, x).graphic = z
    tilemap(0, x).state = 1
    tilemap(9, x).state = 1
next



do                      'start of game loop

                        '1 is down
                        '2 is up 
                        '3 is left
                        '4 is right
player.move = false
player.tx = player.x/20
player.ty = player.y/20

Frame2 = (Frame2 MOD 22) + 1
IF Frame2 = 10 THEN Frame1 = (Frame1 MOD 4) + 1

'moves player according to direction pressed and changes sprite accordingly
if multikey(sc_down) then                   'down
    player.py = player.y + player.speed
    player.direction = 1
    player.move = true
    player.ty = player.py/20
    if tilemap((player.ty + 1), player.tx).state = 1 then player.py = (player.y - 0) else
    player.y = player.py
end if

if multikey(sc_up) then                      'up
    player.py = player.y - player.speed
    player.direction = 2
    player.move = true
    player.ty = player.py/20
    if tilemap(player.ty, player.tx).state = 1 then player.py = (player.y + 0) else 
    player.y = player.py
end if

if multikey(sc_left) then                    'left
    player.px = player.x - player.speed
    player.direction = 3
    player.move = true
    player.tx = player.px/20
    if tilemap(player.ty, (player.tx + 0)).state = 1 then player.px = (player.x + 0) else
    player.x = player.px
end if

if multikey(sc_right) then                   'right
    player.px = player.x + player.speed
    player.direction = 4
    player.move = true
    player.tx = player.px/20
    if tilemap(player.ty, (player.tx + 1)).state = 1 then player.px = (player.x - 0) else
    player.x = player.px
end if


'defines individual frame used based on player state
if player.move = false then
    if player.direction = 1 then player.frame = 1
    if player.direction = 2 then player.frame = 2
    if player.direction = 3 then player.frame = 3
    if player.direction = 4 then player.frame = 4
end if

if player.move = true then
    if frame1 = 1 then player.frame = player.direction + (1 * 4)
    if frame1 = 2 then player.frame = player.direction
    if frame1 = 3 then player.frame = player.direction + (2 * 4)
    if frame1 = 4 then player.frame = player.direction
end if

for x = 0 to 15
    for y = 0 to 9
        put ((x * 20),(y * 20)), tiles(tilemap(y, x).graphic, 0)
    next
next

'draws the correct sprite to the screen based on current frame and 
'location of x and y coords
'also makes it transparent
put (player.x, player.y), racter(player.frame, 0), trans

                'graphics go here
screencopy
screensync
sleep 2
cls     'remember to include this, or the graphics get fucked

loop until multikey(sc_escape)
