﻿init python:

    config.has_autosave = False
    config.has_quicksave = False
    config.autosave_on_quit = False
    config.autosave_on_choice = False

define menu = nvl_menu

    # The color of a menu choice when it isn't hovered.
    #style.nvl_menu_choice.idle_color = "#ccccccff"

    # The color of a menu choice when it is hovered.
    #style.nvl_menu_choice.hover_color = "#ffffffff"

    # The color of the background of a menu choice, when it isn't
    # hovered.
    #style.nvl_menu_choice_button.idle_background = "#00000000"

#what_outlines=[(3, "#ffffff",0,0)]
#what_outlines= [(3, "#ffffff", 0, 0)]

define S = Character("You", color='#ffffff', what_prefix='"', what_suffix='"')
define A = Character("Artemis", color='#ffffff', what_prefix='"', what_suffix='"')

#Prisoners
define GP = Character("Gruff Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define CP = Character("Chatty Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define IP = Character("Idle Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define PP = Character("Puny Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')
define QP = Character("Quiet Prisoner", color='#ffffff', what_prefix='"', what_suffix='"')

#Wardens
#Officers
define CO = Character("Cheerful Officer", color='#ffffff', what_prefix='"', what_suffix='"')
define DO = Character("Droning Officer", color='#ffffff', what_prefix='"', what_suffix='"')
define SO = Character("Stern Officer", color='#ffffff', what_prefix='"', what_suffix='"')

#nurse
define KN = Character("Prison Nurse", color='#ffffff', what_prefix='"', what_suffix='"')

#NVL
define n = Character("", kind=nvl, color='#000000')
define S2 = Character("You", kind=nvl, color='#ffffff')
define A3 = Character("Artemis", kind=nvl, color='#ffffff')

image white = "#ffffff"

define flash = Fade(0.5, 0.1, 0.5, color="#FFFFFF")

transform artemiscentre:
    xalign 0.5 yalign -0.06 zoom 0.35

transform prisonerleft:
    yalign 0.0

transform prisonerright:
    yalign 0.0

transform wardencentre:
    xalign 0.5 yalign 0.0 zoom 0.4

transform bounceup:
    easein 0.2 yoffset -10
    easein 0.2 yoffset 0

transform bounceuplong:
    easein 0.2 yoffset -10
    easein 0.2 yoffset 0
    easein 0.2 yoffset -8
    easein 0.2 yoffset 0

transform bounceupbig:
    easein 0.2 yoffset -15
    easein 0.2 yoffset 0

transform bouncedown:
    easein 0.2 yoffset 10
    easein 0.2 yoffset 0

transform bouncedownlong:
    easein 0.2 yoffset 10
    easein 0.2 yoffset 0
    easein 0.2 yoffset 8
    easein 0.2 yoffset 0

transform bouncedownbig:
    easein 0.2 yoffset 15
    easein 0.2 yoffset 0

transform sideswayleft:
    easein 0.2 xoffset 10
    easein 0.3 xoffset -10
    easein 0.2 xoffset 0

transform sideswayright:
    easein 0.2 xoffset -10
    easein 0.3 xoffset 10
    easein 0.2 xoffset 0

transform dissolve2:
    alpha 0
    linear 0.5 alpha 1

layeredimage artemis:

    group body:
        attribute body default:
            "artemis body"

    group eye:
        attribute e1 default:
            "e1"

        attribute e2:
            "e2"

        attribute e3:
            "e3"

        attribute e4:
            "e4"

    group brows:
        attribute b1 default:
            "b1"

        attribute b2:
            "b2"

        attribute b3:
            "b3"

    group mouth:
        attribute m1 default:
            "m1"

        attribute m2:
            "m2"

        attribute m3:
            "m3"

        attribute m4:
            "m4"

        attribute m5:
            "m5"

    group blush:
        attribute nothing default:
            "nothing"
        
        attribute blush:
            "blush"
    
    group bruises:
        attribute nothing default:
            "nothing"

        attribute bruises:
            "bruises"

    group doom:
        attribute nothing default:
            "nothing"
        
        attribute bodydoom:
            "artemis body doom"

    group sweat:
        attribute nothing default:
            "nothing"

        attribute sweat:
            "sweat"

label start:
    default prisonrape = False
    default prisonassault = False
    default overhear = False

    stop music

    $ quick_menu = False
    scene black
    
    centered "{color=#ffffff}This game is intended for players 18 years of age and older.\nScenes may contain physical, mental, and sexual violence.\n\nPlayer discretion is advised.{/color}"

    $ quick_menu = True

    #play music "audio/Ludum Dare 30 - 05.ogg" fadein 1.0
    label scene1:
        #HOW COME THERE ARE FOUR PRISONERS HERE IN THIS CELL WHEN SWAPPING IS A PLOT POINT LATER???

        scene jail cell

        n "When you peer into the cell, your eyes gradually adjust to the darkness."

        n "As the shadows give way to a dim light, you see a tangle of bodies. Your spine tingles with the natural revulsion of walking into an illicit scene."
        
        n "In front of you huddle four men, three standing with one kneeling between them."

        n "The look on their faces ranges from shock to glee."

        menu (nvl=True):
            "Look closer.":
                nvl clear 
                n "The man in the middle catches your eye."
                n "He kneels between the other three with his mouth parted. In the dim lighting, his lips look glossy, like they're wet."
                n "Though the others have their jumpsuits on, their clothes are rumpled and clearly sporting bulges."
                n "It doesn't take a genius to figure out why."
                nvl clear
                jump scene1a
            "Look away.":
                nvl clear
                n "A glimpse is enough to know what's going on. You turn your head away from the sordid scene, made uncomfortable by their shameless natures."
                n "Surely there must be some dignity these men have held onto, if nothing else."
                n "Especially the one in the middle, with his mouth open."
                nvl clear
                jump scene1a

    label scene1a:

        show artemis bodydoom e1 b3 m1 at artemiscentre zorder 10

        show prisoner2 zorder 3:
            xzoom -1 xalign 0.5 yalign 0.27 zoom 0.45
        show prisoner1 zorder 4:
            xalign 1.0 yalign 0.27 zoom 0.35
        show prisoner4 zorder 5:
            xzoom -1 xalign 0.0 yalign 0.27 zoom 0.35

        S "What's going on here?"

        "The men turn to their leader, who glances at your uniform before speaking."

        show prisoner4 at bouncedown

        GP "Nothing, officer."

        S "Then what are you doing with him?"

        GP "We're just socializing."

        GP "Isn't that right? Tell him we're having a good time together."

        show artemis bodydoom e2 b3 m1 -blush sweat at bounceup

        "He wrenches the kneeling man upright, forcing him to stand."

        show artemis e1 b3 m1

        QP "Um..."

        GP "You know how to talk. Weren't you using your mouth just now?"

        show artemis m3

        QP "It's nothing."

        show artemis e2 m1

        QP "We're not doing anything."

        GP "See, that's what he says."

        show prisoner1 at bouncedownlong

        "There's a muffled chuckle from one of the other prisoners."
        "You ignore him, choosing to turn your eyes away from the scene. Whatever's happening, you don't need to be a part of it."

        S "It's lights out right now. As long as you don't disturb the other inmates, it's none of my business."
        
        "Before you leave, something in you gives pause. The prisoner's eyes are haunted."

        S "He's doing it willingly, right?"

        show prisoner4 at bouncedown

        GP "Of course he is. Why wouldn't he be?"

    label scene2:

        window show

        scene jail hall with fade

        "Every day at five in the morning, you get up before the sun rises."
        "You put on your work clothes and drive to the prison, down a stretch of road with no traffic."
        "When you arrive, you go through security first. Then you clock in."
        "By six, you're waking up the prisoners for breakfast."

        scene cafeteria with fade

        "Each of the inmates has a file. You've seen all sorts of criminals, every kind of crime."
        "The violence doesn't stop once they're behind bars. The way it happens just changes."
        "From breaking up petty squabbles to restraining violent assaults, what's important is to stay out of things that don't concern you."
        "Don't borrow money, use drugs, or pick fights. Stay out of the gangs and resist being bribed. Keep out of trouble and work hard, and it'll be like any other job."
        "No one grows up wanting to become a prison guard but the pay is good and the hours are solid."
        "They say this place has a way of warping anyone who steps inside, but it's how you make a living."
        #you were never good with people to begin with.
        #Since the day you started, it's become harder to trust people.

        show warden with dissolve:
            zoom 0.35 xalign 0.5 yalign -0.05

        CO "Morning."

        S "Hey."

        show warden at bounceup

        "Your shift partner yawns."

        CO "Did anyone give you trouble while you were getting them out?"

        S "No, it was as usual."

        CO "That's good. In our line of work, you take what you can get."

        scene cafeteria

        show prisoner3 zorder 20:
            xalign 0.9 yalign -0.5 zoom 0.275
        show prisoner2 zorder 30:
            xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
        show prisonergroup zorder 10:
            xalign 0.49 yalign -1.5 zoom 0.275
        with dissolve

        "The two of you look out into the mess hall, where the prisoners are lining up for food."
        "The men file up in an orderly line, with their orange jumpsuits and white sneakers. No shoelaces, only velcro."
        "The cafeteria workers, in their masks and hairnets, spoon oatmeal and beans onto their trays."

        $ menu = renpy.display_menu

        menu:
            "From afar, it's hard to tell which is the oatmeal and which is the beans."

            "Observe them.":

                "The inmates group together, sitting at tables while they shovel food into their mouths."
                "Their meals are nothing remarkable. Barely enough to feel full, but at least one tray contains all five food groups and the full range of essential vitamins."
                "Even if none of them are fresh."
                "The staff get better meals, and you always have the option of bringing in food from outside. You don't let the prisoners see you eat, though."
                "Inmate or staff, everyone has to watch their back here. Last night proves as much."
                "At an all-men's prison, people turn to anything for release. Anything and anyone."
                "Incidents between inmates are an open secret. If you were to get upset, or even worse, traumatized, then you wouldn't be working here."
                "Stiff upper lip, everyone's got to get by somehow."

                jump scene2a
            "Talk to the officer.":

                hide prisoner3
                hide prisoner2
                hide prisonergroup

                show warden:
                    zoom 0.35 xalign 0.5 yalign -0.05
                with dissolve

                S "Any inmates in our ward getting out soon?"

                CO "Not for a while."
                CO "One guy was scheduled for a parole hearing next month, but the court's pushing it back."
                CO "No idea what'll happen to his case now."

                S "That's too bad. Can't his lawyer try to do something?"

                show warden at bounceuplong

                CO "Honey, his lawyer's some pro bono attorney who wishes he was working for a millionaire."
                CO "No one cares that much."

                S "You're right, I suppose."

                "You've heard the courts are backed up, but it's like that everywhere. There's a staffing shortage in the system, not enough funds to hire new people."
                "Too much money spent on cushy lifestyles for criminals, half the public cries. Not enough money spent on humane conditions, the other half yells back."
                "The big cases get plastered all over the news, so everyone has an opinion these days."
                "Now you have to do twelve hour shifts without overtime. Really wears on you after a while."
                #"It's true that inmates have television in their cells these days,"
                jump scene2a
    
    label scene2a:

        hide warden
        hide prisoner3
        hide prisoner2

        show prisonergroup zorder 10:
            xalign 0.49 yalign 0.0 zoom 0.5
        with dissolve

        "Laughter from a table catches your attention."

        show prisonergroup at bounceuplong

        CP "Did you hear those noises last night?"
        CP "You know, the {i}sounds{/i}."

        IP "Yeah, they're really stimulating, aren't they?"
        IP "I didn't mind adding to the sounds myself. Just me and my right hand."

        CP "He sounded like he was enjoying it too."

        show prisonergroup at bounceup

        CP "Hey, there he is. Why don't we ask him?"

        hide prisonergroup

        show artemis at artemiscentre
        with dissolve

        "The inmate from last night arrives to jeers and catcalls."
        "He sits alone, his shoulders hunched, as others call for him from across the room."

        hide artemis

        show prisoner3 zorder 20:
            xalign 0.9 yalign -0.5 zoom 0.275
        show prisoner2 zorder 30:
            xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
        show prisonergroup zorder 10:
            xalign 0.49 yalign -1.5 zoom 0.275
        with dissolve

        show prisoner2 at bounceup

        IP "Had fun last night?"

        show prisoner3 at bounceup

        CP "Let me have a piece of that next time!"

        hide prisoner3
        hide prisoner2
        hide prisonergroup

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        CO "What are you looking at? Don't tell me you want him too."

        S "What? No."
        S "I was just curious. He was making trouble last night, but I left him to it."
        S "Who is he?"

        CO "That's Artemis."
        CO "The moment he came here, I thought to myself, {i}that one's going to be someone's prison bitch{i}."

        show warden at sideswayright

        CO "I was right. Pretty gross, don't you think?"

        "The officer leers at him from across the room. You'd expect a middle-aged woman like her to be pushed around, but her demeanour is hard."
        "Legend has it that she was once attacked by an inmate. A real violent fight, her body thrown to the ground with the wind knocked out of her."
        "Without hesitation, she got up and hit him with her baton until he stopped moving."
        "Since then, people respect her. Prisoner or staff, everyone knows she's not one to cross."

        show warden at bounceupbig

        CO "Hey, stop harassing him!"
        CO "Focus on your food, breakfast ends in five! If you don't eat, you don't get anything until lunch!"
        CO "You have work next, so you'll need the energy!"

        "Your eyes linger on the prisoners as you leave the canteen."

    label scene3:

        scene workroom

        show prisoner4:
            zoom 0.35 xalign 0.5 yalign -0.1
        with fade

        "After breakfast, the inmates are sent to work."
        #"Some, for bad behaviour, are put back in their cells. It's at least better than solitary confinement, since they're supervised the entire time, until the bars close behind them."
        "No one makes money, of course. The wages are barely enough to buy a pack of ramen at the commissary."
        "Most of the earnings go to the upkeep of the prison. Government funding alone isn't enough, so a private company stepped in."
        "At the time, some locals protested. They showed up with signs and a catchy slogan: {i}Free our prisons! Prisons should stay free!{/i}."
        "Now it's just how things are, in order to help the prisoners give back to society."

        show prisoner4 at bounceuplong

        DO "Come on, folks, these boxes won't package themselves! Get to it!"
        DO "{i}Fitzroy's Organic Juice, an orchard in every sip...{/i}"

        show prisoner4 at bouncedown

        DO "Am I right or am I right?!"

        "The deal was signed with Fitzroy Foods, allowing them to become the sole provider of prison meals. That the company was creating jobs for prisoners was just a sweetener."

        hide prisoner4

        show prisoner3 zorder 20:
            xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
        show prisoner2 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with dissolve

        "Inmates stand in rows, each one with a box in front of him. Today, they're packaging drinks."
        
        show prisoner3 at sideswayleft

        "The first inmate takes the juice and lines them up. Then he passes the bottles on to the next person, who wraps them with plastic."

        show prisoner2 at sideswayright

        "A final prisoner seals the container shut."
        "Like this, a team of three can package sixty juice boxes in an hour. A machine could do better, but that's saying the obvious."
        "No one working here will ever complain about keeping the prisoners occupied for an hour or two."

        show prisoner3 at bouncedown

        IP "Here. Watch the boxes, they're loose."

        show prisoner2 at bouncedown

        PP "Thanks."

        IP "No problem, friend."

        "You watch the inmates work, standing by the side so you don't get in the way. Though your presence is keenly felt, the men do their best to ignore you."

        show prisoner3 at bouncedown

        IP "Pass me that."

        show prisoner2 at bouncedown

        PP "Okay."

        show prisoner3 at bounceupbig

        IP "I can't take it anymore! I can't!"

        show prisoner3 at bounceuplong

        IP "Any more of this and I'll snap. They'll regret messing with me!"

        show prisoner2 at bounceup

        PP "What are you talking about?!"
        
        IP "Nothing."

        show prisoner2 at sideswayright
        
        PP "Then don't lose it on me. Jesus Christ..."
        
        #IP "Look! {i}Twelve vitamins in every sip!{/i}"
        #IP "What do we need vitamins for?! Who knows what's in there, they're trying to turn us into sheeple!"
        #IP "The commissary is full of Fitzroy products! What are we supposed to buy with our shit wages?! 
        #IP "Anything they make you drink, you have to spit it out!"
        
        #PP "Calm down!"

        PP "Just shut up and do your work, I don't want any officers coming by."
        PP "You're ruining this for the rest of us."

        IP "I'm not. Just look at {i}him{/i}."

        #let me have it then. my knees hurt i need the vitamins. but you see theyre LYING we have no other options cant you understand that?! cant you?! and staff run over to pull him away and through the door

        hide prisoner3
        hide prisoner2

        show artemis e1 b1 m1 at artemiscentre zorder 10:
            xalign 0.26
        
        show prisoner4 zorder 1:
            xalign 0.74 yalign 0.1 zoom 0.37
        with dissolve

        "The prisoner glances around the room to where Artemis is sitting. He's working slower than any other inmate."
        "An officer is leaning over him with one hand on his shoulder."

        show prisoner4 at sideswayright

        DO "See here, the bottles are out of place."
        DO "You have to put them in order so they fit. Let me do one for you."

        show artemis e3 b3 m3

        A "Okay, thanks."

        hide artemis
        hide prisoner4

        show prisoner3 zorder 20:
            xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
        show prisoner2 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with dissolve

        "You stand there, baton in hand, feeling useless and irritable. With nothing better to do, you turn to the chatty prisoners and glare."

        show prisoner3 at bounceup
        show prisoner2 at bounceup

        S "No talking! Eyes on your work."
        S "I'll watch to make sure you're doing it properly."

        "They look down at the boxes with matching expressions of discontent before their hands start moving again."
        "You don't let it deter you. If you don't monitor the inmates properly, you'll be the one written up."

    label scene3a:
        scene jail hall

        n "That night, the prisoners settle into their cells. As you close the iron bars behind them, you get a glimpse of their quarters."
        n "There's not much to look at. Only the bunk, the sink, and the toilet. Sometimes a writing desk for the lucky few with a larger room."
        n "No walls, no rooms. With each cell holding two men, there's no privacy inside or outside. There will always be someone to witness their lowest moments, how far a person can fall."
        n "It's no wonder they run Scared Straight programs for the kids to see."
        n "{i}Don't be bad or you'll end up like them.{/i} Many a child has gone back to the straight and narrow from the sight."
        n "Then there are people like the superintendant, who is your boss' boss. He likes to tell people how he decided to work here because of a Scared Straight trip in sixth grade."
        n "\"I just knew,\" he once said, \"that someone had to help them. It might as well be me.\""

        nvl clear
        
        n "\"Hello? Hello, hello, anyone out there?\""
        n "{i}Clang! Clang... Clang... Thump...{/i}"

        n "The prison is loud at night. There's always someone screaming, as if they're suffering from night terrors. Then there are the banging noises, the footsteps, the radio, and strange sounds you can't explain."

        n "\"Shut the fuck up!\""
        n "\"You shut the fuck up! I'll kill you!\""
        n "\"Today on Channel 9, a five-year old crashed his mom's car while taking it on a joyride, but not before driving a full eighty kilometres...\""
        n "{i}Clang... Thump! Thump... Clang! Thump...{/i}"
        n "\"I said, hurry up and do it!\""
        n "\"Oh, yes... Keep going...\""
        
        nvl clear
        
        n "Distantly, you can hear noises of a different sort, which make you feel mildly disgusted when you catch on. You wrinkle your nose but some part of you can't help but listen closer."
        n "Even now, you can't forget the sight of Artemis on his knees, surrounded by the men. It fills you with a pitch black unease."
        n "Fooling around with his cellmates is no good. You hope this isn't a nightly occurrence, if he's sneaking people into the room."
        n "The other officers must turn a blind eye, thinking that at least the prisoners have someone to vent their frustrations on."
        n "You swallow."
        n "What happens between the prisoners has nothing to do with you. Unlike them, you're on the outside looking in."
        #n "Only a few hours left until your shift ends and you can sleep. You really need the break."
        #n "Even so, that night you toss and turn, unable to sleep."

        nvl clear

    label scene5:

        scene jail cell

        "Another day begins as you head to work poorly rested."
        "The inmates are restless today. Men shake the bars, hurling harsh words at anyone that gets too close. Insults and curses build up, threatening to explode."
        "It's still better than the alternative, a quiet morning where no one makes a sound. On those days, the chances of finding a dead body are higher than you'd like."
        #"With some concern, you notice that the inmates are particularly rowdy today"

        S "Come on, get up. It's time for breakfast."

        show artemis e1 b3 m1 bruises at artemiscentre zorder 10 with dissolve

        "You unlock Artemis' cell, and he comes stumbling out."

        show artemis e4 m3

        A "My cellmate... he's still asleep."

        show artemis m1

        A "He says not to bother him."

        S "What happened to you?"

        show artemis e3 b3 m1
        
        A "Nothing."

        show artemis at bouncedown

        "He's limping as he walks. You take him by the shoulder and pull up the sleeve."
        "There are marks on his skin, all the way up his arm to where his jumpsuit covers the rest. Some appear to be fresh, while others fade into a mottled purple."

        S "Looks bad."

        show artemis e2 b2 m1

        "Artemis frowns at you before wrenching his arm away."

        show artemis e2 b1 m5 sweat

        A "I'm fine."

        S "I didn't ask how you were. Do you want to make an incident report?"

        show artemis e1 b1 m1 sweat
        
        A "Will it help?"
        
        S "It's my job to offer you the chance to file one."

        menu:

            "He avoids your gaze, standing in silence. After a while, it becomes clear he won't answer."

            "Let him go.":

                S "Fine. If this is what you want, then keep doing it."

                show artemis e2 b2

                A "Don't tell me what to do."

                scene jail hall

                show prisoner3 zorder 20:
                    xalign 0.9 yalign -0.5 zoom 0.275
                show prisoner4 zorder 30:
                    xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
                show prisonergroup zorder 10:
                    xalign 0.49 yalign -1.5 zoom 0.275
                with fade

                "With a wan look, Artemis makes his way down the hall. You notice that he's walking funny."
                "You're not the only one who's caught on either, judging by the sneers he gets."

                show prisonergroup at bouncedownlong

                PP "So it's true, you really are a bitch."

                CP "If you like it rough, you know where to find me!"

                show prisoner3 at bouncedown

                IP "Wait until I get my hands on you, I'll buy you from him. How much do you think you're worth?"

                "Even the officer passing by sees him and scoffs."

                show prisoner4 at bouncedown

                DO "Earned that limp last night, did you?"

                "Though their words are crude, you feel as if there's truth in them."
                "After all, Artemis doesn't complain. All he does is stare ahead of himself, not even denying it."
                "You've seen how he is with the inmates. If you were in his shoes, you wouldn't act like that."
                "You wouldn't take it lying down. Or rather, does he take it on all fours?"

                show prisoner4 at bounceup

                DO "Hey, what are you making a face about?"

                S "It's nothing."

                DO "Alright, have a good shift. I don't envy you, dealing with the morning crowd."

                hide prisoner4 with dissolve

                "He claps you on the shoulder and walks off."
                "Artemis has disappeared too. You're glad he's gone, because the sight of him made you nervous."
                "Any longer and you might've started to look for his other bruises. They must be all over his body."
                #"Thinking about it makes your heart rate speed up."
                #"God, you're such a bad person for thinking that. You won't do it again."

                jump scene8

            "Take him to the nurse.":

                S "You should still see someone for your injuries."

                show artemis e4 b2 m3
                
                A "I don't need to."
                
                S "I'm telling you to. Follow me."

                show artemis e2 b2 m1

                "With those words, you turn away. Though you half-thought he wouldn't, Artemis follows."
                #keeping your grip on his wrist. your fingers covering the bruises

                scene doctors office

                show artemis e1 b3 m1 bruises sweat at artemiscentre zorder 10:
                    xzoom -1 xalign 0.15 yalign -0.2

                show nurse:
                    xalign 0.85 yalign 0.0 zoom 0.4
                
                with fade

                "The two of you arrive at the nurse's office."
                "Here, the inmates get treated for any illness or injury that arises. In your line of work, you've seen a lot."
                "Most people have been hurt at least once. Though the prison tries to catch weapons and other dangerous items, anything can be used to harm someone."
                "There was one prisoner who choked out his cellmate with a bedsheet. After that, the prison had to look into banning bed items entirely."

                show nurse at bounceup
                
                KN "Hello there."

                show artemis bodydoom

                "The nurse greets you with a raised eyebrow. Pulling Artemis over, you lift his arm to show the bruises."

                KN "Oh dear, what happened to you?"

                show artemis e3 b3 m3

                A "Nothing."

                KN "If you won't tell me what's wrong, I can't do anything for you. You'll have to let it heal by itself."
                KN "Unless you want to go into protective custody, which I'm sure could be arranged."

                show artemis m1 at artemiscentre:
                    xzoom -1 xalign 0.15 yalign -0.2
                    sideswayright

                "Artemis's face turns red. He shakes his head quickly, not wanting to be sent to solitary confinement."

                KN "What are you even here for, then?"

                S "I was the one who took him here. Sorry if it's an inconvenience."

                "You feel like you have done Artemis a disservice, dragging him to the nurse for nothing. If everyone came complaining of being roughed up, the line would stretch across the prison."
                "Prison isn't supposed to be comfortable. Anyone who can't stay out of trouble will toughen up soon enough."

                S "I'll keep an eye on him from now on. Make sure he doesn't come back."

                show nurse at bouncedown

                KN "You do that."
                KN "How many years do you have left of your sentence, sweetie?"

                show artemis e1 b3 m1

                A "I don't know."

                S "How can you not know?"

                show artemis e2 b2 m1

                A "It can't be that much."

                "That doesn't answer the question. Frowning, you rest one hand on your hip, over the baton."

                S "Come on, there's no reason to hide, unless what you did was that bad."

                show artemis m3

                A "No."

                show artemis e1 b3 m1

                A "The lawyer... he never came. I don't know how it's supposed to work without a lawyer."

                S "Then find a new lawyer."

                show artemis b1 m2

                A "Right, because that's so easy."

                #"Don't they have volunteer lawyers? He just has to ask for one, so you don't understand it."

                hide nurse
                with dissolve

                menu:
                    
                    "As you turn to escort him out, you pause at the door."

                    "\"You should thank me.\"":
                        
                        show artemis e2 b2 m1

                        "He looks at you with his brow furrowed. It's clear that he wants to say, {i}for what?{/i}"
                        "Sourly, his mouth moves."
                        
                        show artemis m5

                        A "Thank you."

                        show artemis m1

                        S "You're welcome."

                        hide artemis with dissolve
                        
                        "After you send him back, you decide not to write an incident report. It'll only get tossed out with all the rest."

                jump scene8
                
    label scene8:

        scene field with fade

        "The inmates are on their noon break. Free time lasts for an hour, during which men run laps around the compound."
        "You can see their red faces and hear the panting breaths. Some prisoners hang back, unable to continue, while others keep pace with the stragglers just to harass them."
        "The air is hot and dry, making for a painfully sweaty experience. You often find yourself wishing there was wind, but instead, each year has been the hottest on record."
        "It seems even a comfortable temperature is too much to ask for. Thank goodness the offices are air-conditioned, even if you can't say the same for the cells."
        #"It's grueling work. Then there are the men twice their size, leering at them while doing the rounds."

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with dissolve

        S "Glad we're not out there running. They must be really bored."

        CO "What else is there to do? All the work goes to us."
        CO "They act like they're the only ones having a hard time, but that attitude is why they're here."
        CO "Forget about us or the victims, the universe is only out to get them."

        show warden at bouncedown

        CO "You want a smoke?"

        S "Sure."

        "She hands you a cigarette before continuing on. Some of the prisoners watch enviously."

        CO "The other day, I had to deal with an overdose, and you know what I was thinking the entire time?"
        CO "{i}This is making me late for my son's recital. Couldn't he have done it on someone else's shift?{/i}"

        show warden at bouncedownlong

        CO "I don't even care if that makes me sound like a terrible person. They're dragging us down in here."

        "You nod in understanding."

        S "It pays the bills, at least."

        CO "I can't afford shit."

        "As smoke trails into the air, you focus on the taste of the cigarette in your mouth. Even ashes are more palatable than everything else today."

        S "Well, I tell myself it's not my problem. None of this is."
        S "The way the world works, someone has to be them and someone has to be us."
        S "That's all."

        show warden at bouncedown

        CO "Still wish I knew what it'd be like before I joined. Now I'm too used to the job to leave."
        CO "Get out while you can because it doesn't get better."
        CO "Unless you're careful, you'll end up like me someday."

        #CO "I would've taken the women's prison across the state, but this one paid better."

        #CO "Listen, my kid's birthday is next week so I'm off on Friday."
        #CO "Sorry for making you deal with this by yourself." 

        #S "It's okay, you should enjoy your time with family."
        #S "How old are they turning?"

        #CO "Eight."

        #S "Well, enjoy. Tell them happy birthday from me."

        #CO "Sure, sure."

        #"You hope she still cares deep down, because sometimes you find it hard to."

        hide warden

        show prisonergroup zorder 10:
            xalign 0.49 yalign 0.0 zoom 0.5
        with dissolve

        "Your idle chatter distracts you from the commotion on the field."

        show prisonergroup at sideswayleft

        "A large inmate shoves a smaller one to the ground. As you turn your head, he gets on top of him and smacks his face. The other men laugh as they pass by."
        "After a while, the big one gets bored and leaves."

        hide prisonergroup with dissolve

        menu:

            "Your eyes follow him as he walks away, rounding the corner to stop in the shadows."

            "Investigate.":

                show prisoner1 zorder 20:
                    xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
                show prisoner3 zorder 30:
                    xalign 0.85 yalign -0.1 zoom 0.35
                with dissolve

                "Another man is waiting for him while leaning against the fence."

                IP "How much for one night?"

                GP "Thirty dollars. No, make that fifty."

                show prisoner1 at bounceuplong

                GP "He's not worth much but at least he's tight down there."

                IP "Fine."
                IP "This doesn't mean anything. I just miss my girlfriend, okay?"

                GP "Do it from behind and you can pretend you're with anyone you want."

                #GP "Men, women, we all have asses."
                #GP "Depends on what you're going to do with him."

                #GP "You're paying for his looks."
                
                #As long as it's still tight, who cares?"
                #IP "You do you, buddy. I, for one, miss my girlfriend Kate from Canada."

                "They fall quiet as you pass by."

                $ overhear = True

                jump scene9

            "Tell them off.":

                show prisoner1 zorder 20:
                    xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
                show prisoner3 zorder 30:
                    xalign 0.85 yalign -0.1 zoom 0.35
                with dissolve

                "You stride forward, catching the prisoners in the middle of their conversation."

                S "What are you doing there? Stay where I can see you."
                #S "That's right, keep it moving! Stop hanging around, there's nothing to see!"

                hide prisoner1 with dissolve

                "The inmates glance at each other before walking away in opposite directions."
                "You hear one of them mutter to himself under his breath."

                show prisoner3 at bouncedown

                IP "This better be worth it."

                S "What better be worth it?"

                IP "Nothing."

                S "Then think before you speak."

                show prisoner3 at bounceupbig

                "He shoulder checks you."

                IP "Watch it, officer. You think you're so cool, but you're not."

                "Your right eye twitches. As least he'll be behind bars soon."

                #"Deals happen a lot. Sometimes drugs, sometimes items from the commissary, sometimes trinkets sent by people back home."
                #"You tend to give them the space to do it. It's not like they can do much otherwise."
                #"You join in with shouting orders, but it's not like the inmates ever listen. Instead, they give you the stink eye."

                jump scene9

    label scene9:

        scene jail hall

        show prisoner3 zorder 20:
            xzoom -1 xalign 0.15 yalign -0.1 zoom 0.35
        show prisoner1 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with fade

        "As you finish closing for the night, you lead the inmates into their cells and lock the doors."
        "Two stragglers walk up to you. You recognize them as the prisoners who were talking earlier."

        show prisoner1 at bounceup

        "The gruff prisoner jerks his chin up at you."

        #"There are always hiding places in prison, where inmates can duck in for private time. Sometimes that's sex, other times drug deals and weapon smuggling. Gangs get involved, too."

        GP "Hey, officer. Let me and this guy switch cells for the night."

        S "Why should I do that?"

        GP "My cellmate keeps whimpering in his sleep. You know him, the cute one."
        GP "If you don't move me, I'm going to beat him up."

        "Seeing the look on your face, he repeats his words."

        GP "I'm going to get him real bad. Bad enough that he'll need to go to the nurse."

        show prisoner3
    
        menu:

            IP "As for me, I swear I won't lay a hand on him. Scout's honour."

            "Agree.":
                
                if overhear == True:
                    "Artemis is in that cell too. From what the inmates were whispering about, he's already been sold."
                    "This has to be better for him. He's already used to it, so surely he knows what to do."
                    "At least if he stays still and remains quiet, it'll be over soon. What they've agreed on has nothing to do with you."
                
                else: 
                    "Artemis is in that cell too. You have a suspicion about what the switch is for, but there's nothing you can do about it."
                    "Either way, he's in for an unpleasant night. You don't want to bring him to the nurse, so at least you can pretend you didn't know."
                    "You don't take orders from inmates, but right now, you nod your head."

                S "Only for tonight, and it won't happen again."

                show prisoner1 at bouncedownlong
                
                GP "Of course not, officer."
                jump scene9a
            
            "Refuse.":

                if overhear == True:
                    "Artemis is in that cell too. From what the inmates were whispering about, you know what will happen."
                    "As a correctional officer, you have to refuse. Prisoners can't be threatening you however they want."
                
                else: 
                    "Artemis is in that cell too. You have a suspicion about what the switch is for, and it disgusts you."
                    "If it happens, the responsibility will fall on you for letting them break the rules."

                S "I won't move you or him. That's against the protocol here."
                S "Don't try anything funny tonight. There are guards on duty and you'll be punished for it."

                "The inmate gives you a chilling smile. His companion narrows his eyes at you."

                show prisoner1 at bouncedown

                GP "No funny business you say, but this place's full of funny business."
                GP "I'll remember you, officer."
                jump scene9b

    label scene9a:

        scene jail cell

        show prisoner3 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with fade

        S "Come with me."

        "The inmate trails behind as you walk him to the cell. Unlocking the door, he steps inside."

        show artemis e2 b3 m1 at artemiscentre:
            xalign 0.15 xzoom -1 yalign -0.45 zoom 0.9
        with dissolve

        "Artemis, who is sitting on the cot, shrinks in on himself."

        show artemis e3 b1 m3

        A "What's he doing here?"

        S "He's switching cells for the night. Don't worry about it."

        show prisoner3 at bouncedown

        IP "That's right, listen to what the officer says. I'll take good care of you."

        show artemis e1 b3 m1 bodydoom

        "Artemis' eyes go wide as the man slings an arm over his shoulders."

        IP "Thanks, officer. You can leave now."

        "Guilt churns within you. The moment you leave, Artemis will be left to his own devices."
        "Something bad will happen."
        "You tell yourself it'll only be bad for him, and has nothing to do with you."
        "They're criminals. They don't deserve your sympathy. Whatever they've done to other people must be worse."
        #"Isn't that the point of prison, to punish them?" protag never learned about deterrence and rehab :/

        "The cell clicks shut with you on the other side."

        scene jail hall

        n "Nighttime fills the ward with the sound of crying and laughing."
        n "You fix a button on your uniform, feeling as if everyone can see the unease on your face. No excuses for what you've done, but it wasn't like you could do anything else."
        
        n "\"Alright, your daddy let me have you for the night. Will you be good?\""

        n "\"Yes... What do you want me to do?\""

        # Artemis acts creepy and servile like ok I'll be yours for tonight I can share / what do you want me to do
        #n  "No, not yet! Don't go in dry, I'm not ready! Please, if you're not going to use a condominium, then at least..."

        n "\"A chuckle comes from behind the bars.\""
        
        n "\"Suck me off first. Get on your knees and make my dick wet.\""

        n "\"Okay.\""

        nvl clear

        n "You strain your eyes to make out the shadows on the wall, and swear you can see him kneeling down."
        n "Lewd noises fill the air, with low, guttural moans layering over each other. In the cell next door, an inmate whistles."

        n "\"Give it to him good!\""

        n "\"Shut up, asshole!\""

        n "\"Mmph, mmm...\""

        n "Before long, their moans and grunts get increasingly louder. You force your footsteps to go past them, and they don't even pause."
        #n "Your heart is jumping out of your chest. Nothing has affected you like this before."

        nvl clear

        n "\"Come on, we don't have all night. I want to fuck you.\""

        n "They settle onto the cot, and the bed starts to creak with movement. You lose track of whose limbs are where, because the prisoner engulfs Artemis in his larger body."

        n "\"Nnn... ah...\""

        n "\"You like that, you little bitch? Fucking take it, then.\""

        n "The heavy slapping causes the walls to shake. You are teetering on the edge of a cliff as you watch. Resentment, dark and oily, fills you."
        n "Artemis isn't moving. He's not resisting, and he even sounds like he likes it."
        n "He shouldn't be allowed to sound like that."

        nvl clear

        n "\"Please... please...\""

        n "\"Please what?\""

        n "\"It hurts...\""

        n "\"What? I didn't hear that.\""

        n "\"You're crushing me!\""

        n "\"Am I, now?\""
        n "\"I bought you and now I own you. If you're unhappy about it, then stop being a slut.\""
        n "\"Who gave you the right to be here, huh?\""

        show jail hall at vpunch

        n "A sharp crack cuts through the air."
        n "Then, silence."

        nvl clear 
        n "After that, the panting and huffing starts up again, and the bars shake with their fucking."
        n "All the way until morning."

        nvl clear

        $ prisonrape = True
        jump scene10

    label scene9b:

        scene jail cell

        show prisoner1 zorder 30:
            xalign 0.85 yalign -0.1 zoom 0.35
        with fade

        "You take the men back to their original cells. When you open the door, the inmate walks inside without a second look."

        show artemis e2 b3 m1 at artemiscentre:
            xalign 0.15 xzoom -1 yalign -0.45 zoom 0.9
        with dissolve
        
        "Artemis glances between the two of you, but says nothing."

        S "You shouldn't be putting yourself into dangerous situations. It'll only end badly for you."

        show artemis e2 b1 m3

        A "Why are you telling me that now?"

        S "I don't know. Have a good night."

        "The cell clicks shut with you on the other side."

        scene jail hall

        n "As you stand on patrol, you can hear the gruff prisoner's voice echo down the hall. He's talking to Artemis."

        n "\"I'm in a bad mood today.\""

        n "\"Oh. Why is that?\""

        n "\"It doesn't matter. Come here and sit on my lap.\""

        n "There's a silence, as if the air itself is still."
        n "Then, all hell breaks loose."

        nvl clear

        show jail hall with vpunch

        n "\"Get off me! Please, it hurts!\""

        n "\"Good.\""

        show jail hall with vpunch

        n "\"I was going to have a nice night all alone, but some asshole had to stop me from moving cells.\""

        show jail hall with vpunch

        n "\"You're stuck with me now, so let's teach him that actions have consequences.\""

        show jail hall with vpunch
        
        n "\"Hey, officer! You watching?!\""

        n "A cry rends through the air, punctuated by sounds of pain."

        nvl clear

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05

        CO "You two, what's going on here?!"

        show warden at bounceup

        CO "Jesus Christ! Someone separate them and call the nurse!"
        CO "Shit, he got him bad. Right when the doors were locked too..."
        
        "You take a deep breath and remain where you are, standing across from the scene with your arms at your side."
        "Somewhere in you, you must've known this would happen."

        nvl clear

        $ prisonassault = True
        jump scene10
    
    label scene10:

        if prisonrape == True:

            scene cafeteria

            show prisoner1 zorder 20:
                xalign 0.93 yalign -0.5 zoom 0.275
            show prisoner2 zorder 30:
                xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
            show prisonergroup zorder 10:
                xalign 0.49 yalign -1.5 zoom 0.275

            "The next day, you see Artemis sobbing and limping into the mess hall."
            "People turn their heads to look. Some prisoners whisper to each other under their breaths, disgust on their faces. Others smirk with a predatory glint in their eyes."

            show prisoner2 at bouncedown

            CP "You hear them go at it last night? What a beast!"

            show prisonergroup at bouncedownlong

            PP "Do you think he'll let us have a turn next time?"

            CP "Are you kidding? Just go ask his pimp."

            show prisoner1 at bounceup

            GP "Hey, bitch! Had fun?"

            hide prisoner2
            hide prisonergroup

            show artemis e3 b3 m1 bruises at artemiscentre:
                xalign 0.15 xzoom -1 yalign -0.6 zoom 0.85
            with dissolve

            "His shout echoes throughout the room, making Artemis flinch."
            "Though the officers turn a blind eye to many things, the commotion is too large now."

            hide prisoner1
            show warden:
                zoom 0.3 xalign 0.93 yalign -0.3
            with dissolve

            CO "My god, what happened to you?!"
            
            "She grabs his arm, forcing him to show the bruises on his neck and face."
            "He has a black eye and bloody cheek. Anyone can tell that it looks bad."

            show warden at bounceup

            CO "Speak up. Tell me what's going on."

            show artemis e3 b3 m3 sweat bodydoom

            A "Nothing..."

            hide artemis with dissolve

            "Artemis' legs give out from under him. The officer curses."

            CO "You're going to the nurse, and we'll figure out what to do with you after."
            CO "Come with me now."

        else:

            scene cafeteria

            show prisoner1 zorder 20:
                xalign 0.93 yalign -0.5 zoom 0.275
            show prisoner2 zorder 30:
                xzoom -1 xalign 0.05 yalign -0.5 zoom 0.275
            show prisonergroup zorder 10:
                xalign 0.49 yalign -1.5 zoom 0.275
            with fade

            "The next day, Artemis doesn't appear in the cafeteria. As breakfast is being served, you hear the inmates whisper amongst themselves."

            show prisoner2 at bouncedown

            CP "A fight broke out last night. I heard he got taken away."
            CP "Do you think he was trying something with his cellmate?"

            show prisonergroup at bouncedownlong

            PP "Lover's quarrel gone wrong, I bet."

            GP "Heh."

            show prisoner1 at bounceup

            "The gruff prisoner stands up, staring you in the eye from across the room."

            menu:

                GP "Going to lock me up in solitary too, officer?"

                "Threaten him.":

                    S "I'll make sure you're in there next time."

                    show prisoner1 at bounceuplong

                    "He turns his head away with a half-laugh, his eyebrows pulling together."

                    GP "I said I'd do it, didn't I?"
                    GP "He got taken away by the guards. When he gets out, I'll tell him it was you who helped me."
                    GP "Well, no hard feelings. At least I get the cell to myself for a while."

                    jump scene10a
                "Remain silent.":
                    GP "I knew you wouldn't be able to say anything."

                    "You flinch from his words, unable to deny them."
                    "He has the look of a man with nothing to lose. A prisoner with a life sentence, so nothing you do can hurt him."
                    "As much as you want to punish him, he might not care about what happens."
                
                    jump scene10a
        
    label scene10a:

        hide prisoner1
        hide prisoner2
        hide prisonergroup
        hide artemis
        hide warden
        with dissolve

        "The inmates eventually disperse, but not without a commotion. You work with the other officers to send them along."
        "It strikes you that you could've prevented this. If only you'd put Artemis in the protective custody ward so he wouldn't be around anyone."
        "No, you can't think like that."
        "You'd never be able to separate him forever. He'd be moved back to his cell eventually, where he'd have to give them what they want."

        "All these thoughts go through your head, draining your body of any feeling at all."
        "The inmates could do their time peacefully, but who really does? Well-behaved people don't go to prison in the first place."

    label scene11:
        scene jail hall

        show warden:
            zoom 0.35 xalign 0.5 yalign -0.05
        with fade

        CO "Goddamn, how does that boy keep getting into trouble?"

        show warden at sideswayright

        CO "Just look at the state of him. Now I'll have to file a report."

        if prisonrape == True:

            S "He's going to end up in solitary, isn't he?"

            CO "It's for his own good."

        "Her voice is fierce."

        CO "It's disgusting what they do to each other. I would never lay my hands on an inmate, or anyone else for that matter."

        S "I thought you didn't care about them."

        CO "When did I say that?"
        CO "We're all they have in here. Of course I feel responsible."
        #CO "No one else but us."

        "She looks to the side, her jaw set. You feel a twinge of betrayal."
        "If you'd known how she felt, you would've said something earlier. Now you seem like a worse person than her."

        S "I'll write the report for you. Say he's been on good behavior until now, make it a one-time incident."
        S "The sooner he gets parole, the better."

        CO "No, don't go that far. If he didn't break the law in the first place, he wouldn't have these problems."

        show warden at bouncedown

        CO "Do you think the victims care if he's living a comfortable life?"
        CO "Justice isn't in our hands, so don't go messing with it."

        #S "He can't be in here forever."

        "She fixes you with a stern look."

        CO "The inmates will get their rights back when they leave. It's up to them to decide what kind of life they want after they're out."
        CO "I'll worry more about my own family, thank you very much, and hope my son never ends up like them."

        window hide

    label scene12:

        scene black with fade
        centered "To be continued..."

    return