screen memories_screen():
    key ("m", "M") action Return()
    tag menu

    use game_menu(_("Memories"), scroll="viewport"):

        vbox:
            spacing 25
            style_prefix "mem"

            # Main Events
            vbox:
                spacing 10

                fixed:
                    ysize 90
                    xfill True

                    add "gui/overlay/cloud.png" xalign 0 yalign 0.5 zoom 0.75

                    text "Main Events":
                        style "mem_label_text"
                        xpos 30
                        ypos 22

                hbox:
                    spacing 12
                    imagebutton:
                        idle "gui/memories/keiface.png"
                        hover "gui/memories/keifacehover.png"
                        action Show("memories_character", girl_id="ch1")
                        at scale_thumb
                        focus_mask True

                    textbutton "Chapter 1":
                        action Show("memories_character", girl_id="ch1")
                        ypos 15  
                        xalign 0.0

                add "gui/backloghbar.png" xalign 0.0 zoom 0.97
                null height 0

            # Heroines
            vbox:
                spacing 10

                fixed:
                    ysize 90
                    xfill True

                    add "gui/overlay/cloud.png" xalign 0 yalign 0.5 zoom 0.75

                    text "Heroines":
                        style "mem_label_text"
                        xpos 70
                        ypos 22

                for char in [
                        (aiko_name, "gui/memories/redactedface.png", "aiko"),
                        ("Kaede", "gui/memories/kaedeface.png", "kaede"),
                        ("Hina", "gui/memories/hinaface.png", "hina"),
                        ("Miu", "gui/memories/miuface.png", "miu"),
                        ("Senri", "gui/memories/senriface.png", "senri"),
                    ]:

                    vbox:
                        spacing 0
                        $ char_pending = False
                        for mem_flag, unlock_flag, mem_char in memory_requirements:
                            if mem_char == char[2] and globals().get(unlock_flag) and not globals().get(mem_flag):
                                $ char_pending = True
                                break

                        hbox:
                            spacing 16
                            imagebutton:
                                idle char[1]
                                hover char[1].replace(".png", "hover.png")
                                action Show("memories_character", girl_id=char[2])
                                at scale_thumb
                                focus_mask True

                            if char_pending:
                                textbutton char[0]:
                                    action Show("memories_character", girl_id=char[2])
                                    text_style "mem_char_name_pending"
                                    xalign 0.0
                                    ypos 10                                    
                            else:
                                textbutton char[0]:
                                    action Show("memories_character", girl_id=char[2])
                                    text_style "mem_button_text"
                                    xalign 0.0
                                    ypos 10

                        add "gui/backloghbar.png" xalign 0.0 zoom 0.97



            null height 0

screen memories_character(girl_id):
    tag menu

    default girl_data = {
        "ch1": {
            "fullname": "Chapter 1",
            "events": [
                ("start", start, "Storm"),
                ("backtome", backtome, "Back To Me"),
                ("firstyear", firstyear, "First Year"),
                ("ourhome", ourhome, "Our Home"),
                ("girlsday", girlsday, "Girls Day"),
                ("alongwalk", alongwalk, "A Long Walk"),
                ("alongshore", alongshore, "Along The Shore"),
                ("silverlining", silverlining, "Silver Lining"),
                ("whatmatters", whatmatters, "What Matters"),
                ("mischief", mischief, "Mischief"),
                ("theclub", theclub, "The Club"),
                ("notourstory", notourstory, "Let's Make A Promise"),
                ("sweetsandyou", sweetsandyou, "Sweets & You"),
                ("uhiwarning", uhiwarning, "The President's Warning"),
                ("whenwewerekids", whenwewerekids, "When We Were Kids"),
            ],
        },
        "aiko": {
            "fullname": aiko_fullname,
            "events": [
                ("schoolgate", schoolgate, "School Gate"),
                ("thechurch", schoolgate, "The Church - memory"),
                ("themaid", themaid, "The Maid And The Beast"),
            ],
        },
        "kaede": {
            "fullname": "Kitamura Kaede",
            "events": [
                ("insomnia", insomnia, "Insomnia"),
                ("lastdate", theclub, "Let's have a... date? - memory"),
                ("walkhome", walkhome, "Walk Home"),
                ("icecream", icecream, "Icecream"),
            ],
        },
        "hina": {
            "fullname": "Arimura Hina",
            "events": [
                ("backtoyou", backtoyou, "Back To You"),
                ("myducks", myducks, "Kanae & Hana"),                
            ],
        },
        "miu": {
            "fullname": "Uehara Miu",
            "events": [
                ("stayhere", stayhere, "Please, Stay Here"),
                ("detention", detention, "Detention Already!?"),                
            ],
        },
        "senri": {
            "fullname": "Maeda Senri",
            "events": [
                ("rooftop", backtome, "Rooftop Key - memory"),
                ("intervention", intervention, "Intervention"),                       
            ],
        },
    }

    use game_menu(_("Memories"), scroll="viewport"):

        $ data = girl_data.get(girl_id, {"fullname": "Unknown", "events": []})
        $ name = data["fullname"]
        $ events = data["events"]

        vbox:
            spacing 0
            style_prefix "memories_check"

            fixed:
                ysize 90
                xfill True
                add "gui/overlay/cloud.png" xalign 0 yalign 0.5 zoom 0.75
                text name:
                    style "mem_label_text"
                    xpos 20
                    ypos 22
            add "gui/backloghbar.png" xalign 0.0 zoom 0.97
            null height 15

            for label, flag, event_name in events:
                hbox:
                    spacing 0
                    image "gui/memories/cherry.png" yalign 0.5 xysize (50, 50)

                    $ is_pending = False
                    for mem_flag, unlock_flag, mem_char in memory_requirements:
                        if label == mem_flag and globals().get(unlock_flag) and not globals().get(mem_flag):
                            $ is_pending = True
                            break

                    if flag:
                        # Event is available (unlocked)
                        if event_name.endswith("- memory"):
                            if is_pending:
                                textbutton event_name[:-9] + " (!)":
                                    action [Replay(label, scope={'save_uuid': save_uuid}), Function(smart_load)]
                                    text_style "mem_button_text_pending"
                                    xpos -20
                                    ypos -8

                            else:
                                textbutton event_name[:-9]:
                                    action [Replay(label, scope={'save_uuid': save_uuid}), Function(smart_load)]
                                    text_style "mem_button_text_dlc"
                                    ypos 3

                        else:
                            if is_pending:
                                textbutton event_name:
                                    action Replay(label)
                                    text_style "mem_button_text_pending"
                                    xpos -20
                                    ypos -8

                            else:
                                textbutton event_name:
                                    action Replay(label)
                                    text_style "mem_button_text2"
                                    xpos -20
                                    ypos -8
                    else:
                        textbutton "?????":
                            action NullAction()
                            style "mem_button"
                            text_style "mem_button_text2"
                            ypos -8

                add "gui/backloghbar.png" xalign 0.0 zoom 0.15



            null height 40
            add "gui/backloghbar.png" xalign 0.0

            textbutton "Go back":
                action Show("memories_screen")


style memories_check_label is pref_label
style memories_check_label_text is pref_label_text
style memories_check_button is gui_button
style memories_check_button_text is gui_button_text
style memories_check_vbox is pref_vbox

style memories_check_vbox:
    spacing gui.pref_button_spacing

style memories_check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style memories_check_button_text:
    size 21
    color "#ffffff"
    outlines [ 
        (2, "#00000050", 0, 3),
        (1, "#00000050", 0, 3)
    ]
    font "fonts/Nunito/NunitoSans-Bold.ttf"
    hover_color "#fadb51"
    properties gui.text_properties("check_button")
    xpos -22
    ypos 22


style mem_label is gui_label
style mem_label_text is gui_label_text

style mem_button_text_dlc:
    size 21
    color "#00ce9a"
    outlines [ 
        (2, "#00000050", 0, 3),
        (1, "#00000050", 0, 3)
    ]
    font "fonts/Nunito/NunitoSans-Bold.ttf"
    hover_color "#fadb51"
    properties gui.text_properties("check_button")
    xpos -21

style mem_label:
    top_margin 20
    bottom_margin 8

style mem_label_text:
    size 37
    color "#f08d9c"
    outlines [
        (2.5, "#ffffffd8", -1, -1)
    ]
    font "fonts/poetry.ttf"

style mem_vbox is vbox

style mem_button is gui_button
style mem_button_text is gui_button_text

style mem_vbox:
    spacing 10

style mem_button_text:
    size 23
    color "#ffffff"
    outlines [
        (2, "#00000050", 0, 3),
        (1, "#00000050", 0, 3)
    ]
    xalign 0.0
    font "fonts/poetry.ttf"
    hover_color "#fadb51"
    ypos 30

style mem_button_text2 is mem_button_text:
    size 21
    color "#ffffff"
    outlines [
        (2, "#00000050", 0, 3),
        (1, "#00000050", 0, 3)
    ]
    xalign 0.0
    font "fonts/Nunito/NunitoSans-Bold.ttf"
    hover_color "#fadb51"
    ypos 30


# new

style mem_button_text_pending is mem_button_text:
    color "#00ce9a"
    hover_color "#fadb51"
    font "fonts/Nunito/NunitoSans-Bold.ttf"

style mem_char_name_pending is mem_button_text:
    color "#00ce9a"
    hover_color "#fadb51"


############################## Android ############################## 

style mem_button_text:
    variant "small"
    
    size 23
    color "#ffffff"
    outlines [
        (2, "#00000050", 0, 3),
        (1, "#00000050", 0, 3)
    ]
    xalign 0.0
    font "fonts/poetry.ttf"
    hover_color "#fadb51"
    ypos 30

style mem_button_text2 is mem_button_text:
    variant "small"
    
    size 21
    color "#ffffff"
    outlines [
        (2, "#00000050", 0, 3),
        (1, "#00000050", 0, 3)
    ]
    xalign 0.0
    font "fonts/Nunito/NunitoSans-Bold.ttf"
    hover_color "#fadb51"
    ypos 30


# new

style mem_button_text_pending is mem_button_text:
    variant "small"
    
    color "#00ce9a"
    hover_color "#fadb51"
    font "fonts/Nunito/NunitoSans-Bold.ttf"

style mem_char_name_pending is mem_button_text:
    variant "small"
    
    color "#00ce9a"
    hover_color "#fadb51"