init:
    ###################################
    ###### MAIN EVENTS CHAPTER 1 ######
    ###################################
    $ gameactive = False
    $ age_verified = False
    $ backtome = False
    $ start = False
    $ firstyear = False
    $ ourhome = False
    $ girlsday = False
    $ alongwalk = False
    $ alongshore = False
    $ silverlining = False
    $ whatmatters = False
    $ mischief = False
    $ theclub = False
    $ notourstory = False
    $ sweetsandyou = False
    $ uhiwarning = False
    $ whenwewerekids = False

    # SENRI EVENTS
    $ thetalk = False
    $ intervention = False

    # AIKO EVENTS
    $ schoolgate = False
    $ themaid = False

    # HINA EVENTS
    $ backtoyou = False
    $ myducks = False
    
    # MIU EVENTS
    $ stayhere = False
    $ detention = False

    # KAEDE EVENTS
    $ insomnia = False
    $ walkhome = False
    $ icecream = False

    # AFFECTION POINTS
    $ kaede_aff = 0
    $ miu_aff = 0
    $ senri_aff = 0
    $ aiko_aff = 0
    $ hina_aff = 0

    ###################
    ###### FLAGS ######
    ###################
    $ kaedeprank = False
    $ kaedetrust = False
    $ miuinvolved = False
    $ miuintroflustered = False
    $ counttracker = 0

    $ senriv3miuend = False
    $ senriv3q1 = True
    $ senriv3q2 = True
    $ senriv3q3 = True
    $ senriv3q4 = True

    $ menuopt1 = True
    $ menuopt2 = True
    $ menuopt3 = True
    $ menuopt4 = True

    $ askedaiko = False

    default chatname = ""

    ###################################
    ###### CHARACTER DEFINITIONS ######
    ###################################

    define base_character = Character(ctc="ctc_cherry", ctc_position="nestled-close", ctc_pause="ctc_cherry", ctc_timedpause="ctc_cherry")

    define narrator = Character(None, kind=base_character)

    # Main cast
    define miu = Character("Miu", color="#d65fe9")
    define kaede = Character("Kaede", color="#c83c3c", kind=base_character)
    define senri = Character("Senri", color="#26d4f7", kind=base_character)
    define hina = Character("Hina", color="#239673", kind=base_character)
    define aiko = Character("Aiko", color="#fee070", kind=base_character)
    define kei = Character("Kei", color="#e9e2e2", kind=base_character)

    define miucolor = "#d65fe9"
    define kaedecolor = "#c83c3c"
    define senricolor = "#26d4f7"
    define hinacolor = "#239673"
    define aikocolor = "#fee070"

    # Supporting
    define clerk = Character("Clerk", color="#c04761", kind=base_character)
    define inouesensei = Character("Inoue-San", color="#bbddff", kind=base_character)
    define shop = Character("Shopkeeper", color="#590680", kind=base_character)
    define icecreamman = Character("Ice-cream man", color="#c89795", kind=base_character)
    define doctor = Character("Dr. Yoshioka", color="#590680", kind=base_character)

    define q = Character("???", color="#99ccff") 
    define n = Character(None, kind=nvl, what_style="poetry_nvl_dialogue")
    define np = Character(None, kind=nvl, what_style="nvl_dialogue")
    define everyone = Character("Everyone", color="#99ccff", kind=base_character) 

    define sister = Character("Sister", color="#c83c3c", kind=base_character)
    define girl = Character("Girl", color="#239673", kind=base_character)
    define boy = Character("Boy", color="#e9e2e2", kind=base_character)

    define uhi = Character("Uhi", color="#67f3b9", kind=base_character)

    define inoue = Character("Inoue", color="#bbddff", kind=base_character)
    define ayumi = Character("Ayumi", color="#ec6a6a", kind=base_character)
    define miiko = Character("Miiko", color="#3b61a8", kind=base_character)
    define jin = Character("Jin", color="#4d32b1")
    define kenji = Character("Kenji", color="#42df83", kind=base_character)   


    # THOUGHTS
    define tsenri = Character("Senri", color="#26d4f780", who_style="say_label_thoughts", what_style="say_dialogue_thoughts", what_prefix="(", what_suffix=")", kind=base_character)
    define tmiu = Character("Miu", color="#d65fe980", who_style="say_label_thoughts", what_style="say_dialogue_thoughts", what_prefix="(", what_suffix=")", kind=base_character)
    define tkaede = Character("Kaede", color="#c83c3c80", who_style="say_label_thoughts", what_style="say_dialogue_thoughts", what_prefix="(", what_suffix=")", kind=base_character)
    define thina = Character("Hina", color="#23967380", who_style="say_label_thoughts", what_style="say_dialogue_thoughts", what_prefix="(", what_suffix=")", kind=base_character)
    define tq = Character("???", color="#99ccff80") 
    define tkenji = Character("Kenji", color="#42df8380", who_style="say_label_thoughts", what_style="say_dialogue_thoughts", what_prefix="(", what_suffix=")", kind=base_character)

    define sandm = Character("Senri & Miu", color="#99ccff", kind=base_character)
    define kandk = Character("Kei & Kaede", color="#99ccff", kind=base_character)
    define kands = Character("Kei & Senri", color="#99ccff", kind=base_character)
    define kandm = Character("Kaede & Miu", color="#99ccff", kind=base_character)

    ############################
    ####### PAST MEMORIES ######
    ############################
    $ renpy.mark_label_seen("rooftop")
    $ renpy.mark_label_seen("thechurch")
    $ renpy.mark_label_seen("lastdate")


init python:
    def nvlchat(user, name):
        store.nvl_mode = "phone"
        store.phone_user = user
        store.chatname = name

    my_fontgroup = FontGroup()
    my_fontgroup.add("fonts/LINESeed/LINESeedSans_Rg.ttf", 0x0020, 0x007F)       # ASCII
    my_fontgroup.add("fonts/Noto Sans JP/static/NotoSansJP-Bold.ttf", 0x3040, 0x30FF)  # Hiragana + Katakana
    my_fontgroup.add("fonts/Symbola/Symbola.ttf", 0x2000, 0x25FF)                 # Misc symbols
    my_fontgroup.add("fonts/Noto Sans JP/static/NotoSansJP-Bold.ttf", 0xFF00, 0xFFEF)  # Fullwidth punctuation (｡)
    my_fontgroup.add("fonts/Symbola/Symbola.ttf", 0x1F000, 0x1FFFF)               # Emoji range
    my_fontgroup.add("fonts/Symbola/Symbola.ttf", 0x02B0, 0x02FF)                 # IPA Extensions
    my_fontgroup.add("fonts/Symbola/Symbola.ttf", 0x1D00, 0x1D7F)                 # Phonetic Extensions
    my_fontgroup.add("fonts/NotoSansSymbols2/NotoSansSymbols2-Regular.ttf", 0x1D00, 0x1D7F)
    my_fontgroup.add("fonts/Noto Sans Myanmar/NotoSansMyanmar-Regular.ttf", 0x1000, 0x109F)

    my_fontgroup.add("fonts/Noto Sans JP/static/NotoSansJP-Bold.ttf", None, None)  # Fallback

###################################
############# REPLAYS #############
###################################


default save_uuid = None
default thechurchname = False
default persistent.psaves = {}
default senriv3miu = False

default aiko_name = "???"
default aiko_fullname = "     ???"

# Seen past memories?
default rooftop = False
default lastdate = False
default thechurch = False


init python:
    memory_requirements = [
        ("rooftop", "backtome", "senri"),
        ("thechurch", "schoolgate", "aiko"),
        ("lastdate", "theclub", "kaede"),
    ]


    def is_memory_pending(mem_flag):
        return bool(globals().get(mem_flag) is not True and any(
            mem_flag == req_mem and globals().get(unlock) 
            for req_mem, unlock, _char in memory_requirements
        )) and any(
            mem_flag == req_mem for req_mem, _unlock, _char in memory_requirements
        ) and not globals().get(mem_flag)

    def is_char_pending(char_id):
        for mem_flag, unlock_flag, mem_char in memory_requirements:
            if mem_char == char_id and globals().get(unlock_flag) and not globals().get(mem_flag):
                return True
        return False

    def has_pending_memories():
        for mem_flag, unlock_flag, _mem_char in memory_requirements:
            if globals().get(unlock_flag) and not globals().get(mem_flag):
                return True
        return False

    def psave(name, value):
        if _in_replay:
            if save_uuid:
                psaves = persistent.psaves
                psave = psaves.get(save_uuid, {})
                psave[name] = value
                psaves[save_uuid] = psave
                persistent.psaves = psaves

    def smart_load():
        try:
            if store.save_uuid:
                psaves = persistent.psaves
                psave = psaves.get(save_uuid, {})

                store.thechurchname = psave.get('thechurchname', False)
                
                if store.rooftop == False:
                    store.senriv3miu = psave.get('senriv3miu', False)
                store.rooftop = psave.get('rooftop', False)
                
                if store.thechurchname == True:
                    store.aiko_name = "Aiko"
                    store.aiko_fullname = "Ishikawa Aiko"
                
                store.lastdate = psave.get('lastdate', False)
                
                store.thechurch = psave.get('thechurch', False)


        except:
            pass