--[[
    This is a part of "Morph Test".
    Copyright (C) 2025 Jan Wielkiewicz <tona_kosmicznego_smiecia@interia.pl>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
--]]

core.register_entity(
    "morph_test:cube_entity", {
        initial_properties = {
            hp_max = 10,
            breath_max = 0,
            physical = false,
            collide_with_objects = true,
            collisionbox = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },  -- default
            selectionbox = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5, rotate = false },
            pointable = true,
            visual = "mesh",
            visual_size = {x = 1, y = 1, z = 1},
            mesh = "morph_test_cube.glb",
            textures = {name = "morph_test_cube.png"},
            use_texture_alpha = false,
            is_visible = true,
            --backface_culling = true,
            nametag = "",
            static_save = true,
            damage_texture_modifier = "^[brighten",
            --shaded = true,
            show_on_minimap = false,
        },
})

core.register_tool(
    "morph_test:cube_item", {
        description = "Spawner for gltf morph target testing cubes",
        groups = {},
        inventory_image = "morph_test_cube.png",
        stack_max = 1,
        range = 6.0,
        -- on_place = function(itemstack, placer, pointed_thing)
        -- end,
        on_use = function(itemstack, user, pointed_thing)
            local pos = pointed_thing.above
            local obj = core.add_entity(pos, "morph_test:cube_entity")
            obj:set_animation({x = 0, y = 40}, 5, 0.0, yes)
        end,
})

core.register_node(
    "morph_test:cube_node", {
        description = "Spawner for gltf morph target testing cubes",
        drawtype = "mesh",
        mesh = "morph_test_cube.glb",
        tiles = {
            {name = "morph_test_cube.png"},
        },
        groups = {}
})
