style diceText is text:
    xanchor .5
    yanchor .5
    size 30
    font "fonts/Parisienne-Regular.ttf"
    bold True

define diceColors = ["#fff", "#49AEF7", "#f7498c"]

init python:
    class die:
        def __init__(self, pos, value = 0):
            self.pos = pos
            self.card = None
            self.rollValue(value)
            self.usable = True
            self.locked = False
            self.hidden = False
            self.color = None
            self.drag = None
            self.spawn = None
        
        def rollValue(self, value = 0):
            #if no value, roll
            if value == 0:
                self.value = renpy.random.randint(1,6)
            else:
                self.value = value
        
        def increaseValue(self, amount):
            self.value += amount
            if self.value > 6:
                self.value = 6
            elif self.value < 1:
                self.value = 1
        
        @property
        def isEven(self):
            return self.value % 2 == 0

        @property
        def isOdd(self):
            return not self.isEven

        @property
        def draggable(self):
            return self.usable and not self.locked

        @property
        def imagePath(self):
            if self.locked:
                return "Dice/DLocked.png"
            elif self.hidden:
                return "Dice/DX.png"
            else:
                return "Dice/D{}.png".format(self.value)
        @property
        def combatImagePath(self):
            if self.locked:
                return "Dice/CLocked.png"
            elif self.hidden:
                return "Dice/CX.png"
            else:
                return "Dice/C{}.png".format(self.value)
        @property
        def pxpos(self):
            if self.spawn:
                return self.spawn[0]
            else:
                return 460 + 80 * (self.pos % 15)
                #return 10 + 80 * (self.pos % 5)
        @property
        def pypos(self):
            if self.spawn:
                return self.spawn[1]
            else:
                return 490 + 80 * int(self.pos / 15)
                #return 50 + 80 * int(self.pos / 5)
        @property
        def oxpos(self):
            return 7 + (self.pos * 80)

    class abilityCard:
        def __init__(self, abi, pos):
            self.pos = pos
            self.dice = []
            self.setAbility(abi)
        
        def setAbility(self, abi):
            self.abi = abi
            self.uses = abi.uses
            self.maxUses = abi.uses
            self.count = abi.countMax
            self.countMax = abi.countMax

        @property
        def name(self):
            return self.abi.name
        @property
        def imagePath(self):
            return self.abi.imagePath
        @property
        def description(self):
            return self.abi.description
        @property
        def description(self):
            return self.abi.description
        @property
        def abilityDice(self):
            return self.abi.abilityDice
        @property
        def usable(self):
            return self.uses > 0

        @property
        def countStr(self):
            return str(self.count)

        @property
        def tooltip(self):
            return self.abi.tooltip

        @property
        def xpos(self):
            return 460 + 350 * (self.pos % 3)
        @property
        def ypos(self):
            return 20 + 580 * int(self.pos / 3)
            #return 78 + 487 * int(self.pos / 3)

        def checkDice(self):
            if self.abi.checkDice(self):
                #if self.countMax == None or self.count <= 0:
                self.uses -= 1
                self.count = self.countMax

        def playAbility(self):
            return

        def resetUses(self):
            self.dice = []
            self.uses = self.maxUses

    class abilityDie:
        def __init__(self, value = 0, type = ""):
            if type == "Odd":
                self.values = [1,3,5]
                self.diceText = "Odd"
            elif type == "Even":
                self.values = [2,4,6]
                self.diceText = "Even"
            elif type == "+":
                self.values = []
                for i in range(value, 7):
                    self.values.append(i)
                self.diceText = "{}+".format(value)
            elif type == "-":
                self.values = []
                for i in range(1, value + 1):
                    self.values.append(i)
                self.diceText = "{}-".format(value)
            elif value == 0:
                self.values = [1,2,3,4,5,6]
                self.diceText = ""
            else:
                self.values = [value]
                self.diceText = "{}".format(value)
            #TODO : check if dice are equal
            #TODO : Additive values

    class simpleAbility:
        def diceValue(self, dice, mod = 1, bonus = 0):
            val = 0
            for d in dice:
                val += d.value
            val *= mod
            val += bonus
            return val
                    
        @property
        def countStr(self):
            return str(self.count)

        @property
        def tooltip(self):
            tt = ""

            for eff in self.effects:
                tt += "\n" + abiEffects[eff].description + "\n"

            return tt

    class playerSuccubus:
        def __init__(self, name, chara, image, maxHP, dice, abilities, maxAbi = 3, save = True):
            self.name = name
            self.chara = chara
            self.image = image
            self.maxHP = maxHP
            self.maxAbi = maxAbi

            self.dice = dice
            self.luck = 0
            self.abilities = abilities

            if save:
                pSuccubusDB[name] = self
        
        def clone(self):
            other = playerSuccubus(self.name, self.chara, self.image, self.maxHP, self.dice, [], self.maxAbi, save = False)
            for abi in self.abilities:
                other.abilities.append(abi)
            return other

        def applyBonuses(self, bonuses):
            self.maxHP = int(self.maxHP * bonuses.hpMod)
            self.dice += bonuses.bonusDice
            for abi in bonuses.bonusAbilities:
                self.abilities.append(abi)
            self.luck = bonuses.luck
            self.maxAbi = bonuses.maxAbi
        
        @property
        def abilityList(self):
            lst = []
            for abi in self.abilities:
                lst.append(abi.name)
            return lst

    class playerAbility(simpleAbility):
        def __init__(self, name, imagePath, description, abilityDice = [abilityDie()], uses = 1, tooltip = None, countMax = None, sound = None, singleUse = False, effects = []):
            self.name = name
            self.imagePath = imagePath
            self.description = description
            self.uses = uses
            self.abilityDice = abilityDice
            #self.count = countMax
            self.sound = sound
            self.countMax = countMax
            self.effects = effects

            pAbilityDB[self.name] = self

        def checkDice(self, card):
            slots = self.abilityDice.copy()
            played = []
            for d in card.dice:
                for slot in slots:
                    if d.value in slot.values:
                        slots.remove(slot)
                        played.append(d)
                        break

            if len(self.abilityDice) > len(played):
                return False

            for d in played:
                card.dice.remove(d)
                d.usable = False
                d.card = None
                if self.countMax:
                    card.count -= d.value

            if self.countMax and card.count > 0:
                    return False

            if self.sound:
                playSound(self.sound)
            self.playAbility(played, card)
            return True

        def playAbility(self, dice, card):
            renpy.notify("Debug : Play ability {}".format(self.name))

        def resetUses(self):
            self.dice = []
            if not singleUse:
                self.uses = self.abi.uses

    class opponentSuccubus:
        def __init__(self, id, name, image, maxHP, abilities, playerAbility, onStart = None, onEnd = None):
            self.id = id
            self.name = name
            self.image = image
            self.maxHP = maxHP

            self.abilities = []
            for a in abilities:
                self.abilities.append(oAbilityDB[a])

            self.playerAbility = playerAbility
            self.onStart = onStart
            self.onEnd = onEnd

            oSuccubusDB[id] = self

        def RandomAbility(self, previousAbility):
            if len(self.abilities) == 1:
                return self.abilities[0]
            else:
                for i in range(6):
                    abi = renpy.random.choice(self.abilities)
                    if abi != previousAbility:
                        return abi
                return abi
        
        def onTurnStart(self):
            if self.onStart:
                self.onStart()
        
        def onTurnEnd(self):
            if self.onEnd:
                self.onEnd()

    class succubusAbility(simpleAbility):
        def __init__(self, name, description = "", rolls = 1, countMax = None, diceGroups = None, effects = []):
            self.name = name
            #self.description = description
            self.rolls = rolls
            self.count = countMax
            self.countMax = countMax
            self.diceGroups = diceGroups
            self.effects = effects

            oAbilityDB[self.name] = self
        
        @property
        def description(self):
            return "*Description Missing*"

        def playAbility(self, dice):
            renpy.notify("Debug : Play ability {}".format(self.name))
        
    def diceToText(start = 0, end = -1, mod = 1, bonus = 0, color = 0):
        if end == -1 or end > len(oppRolls):
            end = len(oppRolls)
        
        val = 0

        for roll in range(start, end):
            if oppRolls[roll]:
                val += oppRolls[roll].value
            
        val = int(val * mod + bonus + .5)
        
        return "{u}{color=" + diceColors[color] + "}" + str(val) +"{/color}{/u}"
    
    def evenAndOdd(evenIco, oddIco, evenCol, oddCol):
        even = 0
        odd = 0

        for roll in oppRolls:
            if roll.value %2 == 0:
                even += roll.value
                roll.color = evenCol
            else:
                odd += roll.value
                roll.color = oddCol

        even = "{u}{color=" + evenCol + "}" + str(even) + "{/color}{/u}"
        odd = "{u}{color=" + oddCol + "}" + str(odd) + "{/color}{/u}"

        return "Even : " + even + " " + evenIco + "\nOdd : " + odd + " " + oddIco