image townSunset = Transform("Backgrounds/Town.webp", matrixcolor=TintMatrix("#cf8a11c0"))
image townNight = Transform("Backgrounds/Town.webp", matrixcolor=TintMatrix("#33195AC0"))
    
screen dayScreen:
    hbox:
        xalign 1.0
        if renpy.variant("touch"):
            button:
                image "UI/Save.png"
                action ShowMenu("save")
        if config.developer:
            button:
                image "UI/Next.png"
                action Jump("advanceTime")

    if dayTime < 3:
        transform:
            xpos 20
            ypos 20
            
            $timeString = timeStrings[dayTime]
            $timeStringLower = timeStringsLower[dayTime]
            text "{image=UI/[timeString].png} Day [day]":
                style "dayText"
                color timeColors[dayTime]

        $ tooltip = GetTooltip()
        if tooltip:
            text tooltip[0]:
                xpos .5
                xanchor .5
                style "dayText"
                if len(tooltip[1]) == 6:
                    color tooltip[1]

        for chara in characters.values():
            if chara.succubus != queenServant:
                imagebutton:
                    anchor (.5, .5)
                    pos (chara.xpos, chara.ypos)
                    idle "Characters/" + chara.lower + " T.png"
                    hover "Characters/" + chara.lower + " TH.png"
                    action [SetVariable("shownChara", characters[chara.name]), Hide("dayScreen"), Call("showChara")]
                    tooltip (chara.name, chara.color)
                if chara.name == ladyOfTheNight:
                    image "ui/favoured.png":
                        anchor (.5, .5)
                        pos (chara.xpos + 60, chara.ypos - 45)

        for location in locationDB.values():
            imagebutton:
                anchor (.5, .5)
                pos (location.xpos, location.ypos)
                idle "Locations/" + location.name + " T.png"
                hover "Locations/" + location.name + " TH.png"
                action Function(goLocation, location)
                tooltip (location.displayName, location.color)
        
        if story == 30:
            imagebutton:
                anchor (.5, .5)
                pos (pCharaDB["Debora"].xpos, pCharaDB["Debora"].ypos)
                idle "Locations/Manor T.png"
                hover "Locations/Manor TH.png"
                action Call("DeboraMeeting")
                tooltip ("Lady Azure's Manor", pCharaDB["Debora"].color)
    else:
        button:
            pos (0.5, 0.5)
            xanchor 0.5
            yanchor 0.5
            image "Locations/Dream.png":
                xsize 250
                ysize 250
            action [Hide("dayScreen"), Call("nightTime")]

screen charaScreen:
    image "Backgrounds/White.webp":
        alpha .3
    transform:
        xpos 0.5
        ypos 20
        xanchor 0.5
        text shownChara.name:
            color shownChara.color
            style "charaName"
    frame:
        xanchor 0.5
        yanchor 0.5
        xpos 0.2
        ypos 0.45
        xpadding 50
        ypadding 150
        background fadingFrame
        if shownChara.friendship >= 0:
            vbox:
                xalign 0.5
                yalign 0.5
                #Friendship
                transform:
                    xalign 0.5
                    ypos -10
                    xsize 300
                    ysize 50
                    text "Friendship":
                        style "relationText"
                    if shownChara.friendship < 10:
                        text "Mult\n[shownChara.frBonus]%":
                            style "relationSubtext"
                            xpos 300
                        text "Next\n[shownChara.frPointsInt] / [shownChara.frNext]":
                            style "relationSubtext"
                            xpos 0
                    else:
                        text ""
                grid 5 2:
                    for i in range(10):
                        if i < shownChara.friendship:
                            image "Relationships/Friendship.png"
                        elif i == shownChara.friendship and shownChara.getNextEvent(0):
                            image "Relationships/Filling.png"
                        else:
                            image "Relationships/Empty.png"
                if not shownChara.getNextEvent(0) and shownChara.friendship < 10 and shownChara.notes[0][shownChara.friendship]:
                    text shownChara.notes[0][shownChara.friendship]:
                        style "relationSubtext"
                if shownChara.love >= 0:
                    image "Relationships/Tail.png" xalign 0.5
                    #Love
                    transform:
                        xalign 0.5
                        yalign 0.5
                        xsize 300
                        ysize 50
                        text "Love":
                            style "relationText"
                        if shownChara.love < 5:
                            text "Mult\n[shownChara.lvBonus]%":
                                style "relationSubtext"
                                xpos 300
                            text "Next\n[shownChara.lvPointsInt] / [shownChara.lvNext]":
                                style "relationSubtext"
                                xpos 0
                        else:
                            text ""
                    grid 5 1:
                        for i in range(5):
                            if i < shownChara.love:
                                image "Relationships/Love.png" #size (75, 75)
                            elif i == shownChara.love and shownChara.getNextEvent(1):# and shownChara.canProgress(1):
                                image "Relationships/Filling.png" #size (75, 75)
                            else:
                                image "Relationships/Empty.png"
                    if not shownChara.getNextEvent(1) and shownChara.love < 5 and shownChara.notes[1][shownChara.love]:
                        text shownChara.notes[1][shownChara.love]:
                            style "relationSubtext"
                if shownChara.lust >= 0:
                    image "Relationships/Tail.png" zoom -1 xalign 0.5
                    #Lust
                    transform:
                        xalign 0.5
                        yalign 0.5
                        xsize 300
                        ysize 50
                        text "Lust":
                            style "relationText"
                        if shownChara.lust < 5:
                            text "Mult\n[shownChara.lsBonus]%":
                                style "relationSubtext"
                                xpos 300
                            text "Next\n[shownChara.lsPointsInt] / [shownChara.lsNext]":
                                style "relationSubtext"
                                xpos 0
                        else:
                            text ""
                    grid 5 1:
                        for i in range(5):
                            if i < shownChara.lust:
                                image "Relationships/Lust.png" #size (75, 75)
                            elif i == shownChara.lust and shownChara.getNextEvent(2):# and shownChara.canProgress(-1):
                                image "Relationships/Filling.png" #size (75, 75)
                            else:
                                image "Relationships/Empty.png"
                    if not shownChara.getNextEvent(2) and shownChara.lust < 5 and shownChara.notes[2][shownChara.lust]:
                        text shownChara.notes[2][shownChara.lust]:
                            style "relationSubtext"
    image shownChara.lower at right

screen nightScreen:
    transform:
        xpos 20
        ypos 20
        
        $timeString = timeStrings[dayTime]
        $timeStringLower = timeStringsLower[dayTime]
        text "{image=UI/[timeString].png} Day [day]":
            style "dayText"
            color timeColors[dayTime]

    $ tooltip = GetTooltip()
    if tooltip:
        text tooltip[0]:
            xpos .5
            xanchor .5
            style "dayText"
            if len(tooltip[1]) == 6:
                color tooltip[1]
            
    if config.developer:
        button at topright:
            image "UI/Next.png"
            action Jump("advanceTime")

    for chara in characters.values():
        if chara.succubus != queenServant:
            imagebutton:
                anchor (.5, .5)
                pos (chara.xpos, chara.ypos)
                idle "Characters/" + chara.lower + " T.png"
                hover "Characters/" + chara.lower + " TH.png"
                tooltip (chara.name, chara.color)
                action Call("nightPrep", chara)
            if chara.name == ladyOfTheNight:
                image "ui/favoured.png":
                    anchor (.5, .5)
                    pos (chara.xpos + 60, chara.ypos - 45)

       
screen nightPrepScreen:
    $playerBattle = pSuccubusDB[dreamDiver.succubus].clone()
    $diverBonus = dayBonuses.getCharaBonuses(dreamDiver)
    $playerBattle.applyBonuses(diverBonus)

    image "Backgrounds/White.webp":
        alpha .1

    transform:
        xpos 0.5
        ypos 20
        xanchor 0.5
        text playerBattle.name:
            color dreamDiver.color
            style "charaName"

    image playerBattle.image:
        xanchor 0.5
        yanchor 0.5
        xpos 0.25
        ypos 0.45

    frame: # 400 * 900 ish or 700 * 700
        xanchor 0.5
        yanchor 0.5
        xpos 0.75
        ypos 0.45
        xpadding 50
        ypadding 150
        background fadingFrame
        hbox:
            vbox:
                xalign 0.5
                yalign 0.5
                text "Abilities ([diverBonus.maxAbi])\n":
                    style "relationText"
                for abi in playerBattle.abilities:
                    textbutton "[abi]":
                        text_style "charaStats"
                        tooltip abi
                        action NullAction()  
            null width 30
            vbox:
                xalign 0.5
                yalign 0.5
                text "Stats":
                    style "relationText"
                text "HP : [playerBattle.maxHP]":
                    style "charaStats"
                text "(base * [diverBonus.hpMod])":
                    style "charaSubStats"
                text "Dice : [playerBattle.dice]":
                    style "charaStats"
                text "(base + [diverBonus.bonusDice])":
                    style "charaSubStats"
                text "Luck : [diverBonus.luck]":
                    style "charaStats"
                image "Relationships/Tail.png" xalign 0.5
                text "Relationships":
                    style "relationText"
                if ladyOfTheNight == dreamDiver.name:
                    text "{image=Icons/favoured.png}":
                        style "charaStats"
                    text "Lady of the Night":
                        style "charaStats"
                    text "All relationships\nBonus + 100%":
                        style "charaSubStats"
                $tmp = int(dreamDiver.frMod * diverBonus.frMod)
                text "[i_friendship]":
                    style "charaStats"
                text "Friendship * [tmp]%":
                    style "charaStats"
                text "Base : [dreamDiver.frBonus]%":
                    style "charaSubStats"
                text "Bonus : [diverBonus.frBonus]%":
                    style "charaSubStats"
                $tmp = int(dreamDiver.lvMod * diverBonus.lvMod)
                text "[i_love]":
                    style "charaStats"
                text "Love * [tmp]%":
                    style "charaStats"
                text "Base : [dreamDiver.lvBonus]%":
                    style "charaSubStats"
                text "Bonus : [diverBonus.lvBonus]%":
                    style "charaSubStats"
                $tmp = int(dreamDiver.lsMod * diverBonus.lsMod)
                text "[i_lust]":
                    style "charaStats"
                text "Lust * [tmp]%":
                    style "charaStats"
                text "Base : [dreamDiver.lsBonus]%":
                    style "charaSubStats"
                text "Bonus : [diverBonus.lsBonus]%":
                    style "charaSubStats"


    $ tooltip = GetTooltip()
    if tooltip and pAbilityDB.has_key(tooltip):
        $tmpAbi = pAbilityDB[tooltip]
        transform:
            xysize(300,462)
            xanchor 0.5
            yanchor 0.5
            xpos 0.5
            ypos 0.5

            image "Card/card_char_bg.png"
            image AlphaMask (tmpAbi.imagePath, "Card/card_mask.png")
            image "Card/card_char_borders.png"

            fixed:
                ypos .5
                image "Card/card_char_title.png"
                text tmpAbi.name:
                    style "cardName"
                    ypos 17
            fixed:
                xysize (250, 100)
                xalign .5
                ypos 310
                text tmpAbi.description:
                    style "cardDescription"
                
            if tmpAbi.uses > 1:
                fixed:
                    xysize (100, 100)
                    image "Card/orb_red.png"
                    text str(tmpAbi.uses):
                        style "cardNumbers"

            hbox:
                ypos 400
                xalign .5
                
                for die in tmpAbi.abilityDice:
                    fixed:
                        xysize(50, 50)
                        image "Dice/C0.png"
                        text "[die.diceText]":
                            style "diceText"
            
        if tmpAbi.tooltip:  
            frame:
                padding (150, 50)
                xpos .2
                xanchor .5
                yalign 0.5
                text "[tmpAbi.tooltip]"


    button:
        pos (0.55, 0.8)
        image "UI/Exit.png":
            xsize 120
            ysize 120
        action [Hide("nightPrepScreen"), Jump("nightTime")]

    button:
        pos (0.45, 0.8)
        image "UI/Dream.png":
            xsize 120
            ysize 120
        action [Hide("nightScreen"), Hide("nightPrepScreen"), Jump("startDreamDive")]
    