
define eventManager = {}
default playedEvents = []

init python:
    def newEvent(label, trigger, repeat = True, condition = None):
        addEvent(gameEvent(label, trigger, repeat, condition))

    def addEvent(event):
        if not eventManager.has_key(event.trigger):
            eventManager[event.trigger] = []
        
        eventManager[event.trigger].append(event)
    
    def removeEvent(label, trigger):
        eventManager[trigger] = [e for e in eventManager[trigger] if e.label != label]
    
    def getEvents(trigger):
        if eventManager.has_key(trigger):
            return [event for event in eventManager[trigger] if (event.check() and (event.repeat or not event.label in playedEvents))]
        else:
            return None

    def hasEvent(trigger):
        events = getEvents(trigger)
        return len(events) > 0

            
    def getEvent(trigger):
        event = getEvents(trigger)
        if event:
            event = renpy.random.choice(event)
            if not event.repeat:
                playedEvents.append(event.label)
            return event.label
        else:
            return None
    
    def wasPlayed(label):
        return label in playedEvents

    class gameEvent:
        def __init__(self, label, trigger, repeat = True, condition = None):
            self.label = label
            self.trigger = trigger
            self.repeat = repeat
            self.condition = condition

        def check(self):
            if self.condition:
                return eval(self.condition)
            return True
            
    """
    Events triggers :

        "Morning", "Afternoon", "Evening", "Night" : Triggers after time changed
        (int) X : Triggers at the morning of day X
        "X" : Triggers before entering a location
        
        "X_Talk" : Triggers before talking to the character X
        "X_Greeting" : Triggers before interaction menu of character X. Should be single line, but can have exceptions
        "X_SpendTime" : Triggers when spending time with character X
        "X_Friendship_Y", "X_Love_Y", "X_Lust_Y" : Triggers when Friendship, Love or Lust values of character X allow leveling up from Y
        
        "X_Win", "X_Loss" : Triggers when winning/losing against succubus X
        "X_Start", "X_End" : Triggers at the start/end of dream X
        "Diver_X" : Dream Diver event, X diver name

        "Succ_X" : At the start of a fight against succubus X

        (str) "X" : Manual trigger
    """