default dreamDepth = 1
#default diveLevel = 0
default battlesRemaining = 0
default bossBattle = False
default unplayedEvents = []
default currentDream = None
default dreamEvents = []
default selectedEvent = None
default playerBattle = None
default dreamDiver = None
default diverBonus = None
default lustCrystals = 0
default luck = 0

default currentDivers = None
default ladyOfTheNight = False

default currentAbilities = []
default backupAbilities = []
default abilityPage = 0
default tradeSuccessful = False

default dreamsCleared = []
       
init python:
    def addArousal(amount):
        global playerHP

        if playerHP < -amount:
            amount = -playerHP
            playerHP = 0
        else:
            playerHP += amount

        if amount > 0:
            renpy.notify("+{0} Arousal".format(amount))
        else:
            renpy.notify("{0} Arousal".format(amount))
        
        return amount

    def mulArousal(amount):
        global playerHP

        tmp = playerHP
        playerHP = int(playerHP * amount + .5)

        if amount > 1.0:
            renpy.notify("Arousal *{} (+{})".format(amount, playerHP - tmp))
        else:
            renpy.notify("Arousal *{} ({})".format(amount, playerHP - tmp))
        
        return amount

    #Abilities
    def moveCard(cardDrag, cardDrop):
        if cardDrop == None:
            i = cardDrag[0].drag_name
            cardDrag[0].snap(710 + 350 * (i % 3), 78 + 487 * int(i / 3))
            renpy.restart_interaction()

    def swapAbility(cardDrop, cardDrag):
        i1 = cardDrop.drag_name
        i2 = cardDrag[0].drag_name

        if i1 < 6:
            card1 = currentAbilities[i1]
        else:
            card1 = backupAbilities[i1 - 6]
        
        if i2 < 6:
            card2 = currentAbilities[i2]
            currentAbilities[i2] = card1
            cardDrag[0].snap(710 + 350 * (i2 % 3), 78 + 487 * int(i2 / 3))
        else:
            card2 = backupAbilities[9 * abilityPage + i2 - 6]
            if card1:
                backupAbilities[9 * abilityPage + i2 - 6] = card1
            else:
                backupAbilities.remove(card2)
            cardDrag[0].snap(80 + 200 * ((i2 - 6) % 3), 98 + 283 * int((i2 - 6) / 3))

        if i1 < 6:
            currentAbilities[i1] = card2
        elif card1:
            backupAbilities[i1 - 6] = card2
        else:
                backupAbilities.remove(card1)

        if abilityPage > 0 and abilityPage > (len(backupAbilities) - 1) / 9:
            previousPage()
        playClick()
        renpy.restart_interaction()

    def removeAbility(cardDrop, cardDrag):
        card = cardDrag[0].drag_name
        if card < 6:
            backupAbilities.append(currentAbilities[card])
            currentAbilities[card] = None  
            cardDrag[0].snap(710 + 350 * (card % 3), 78 + 487 * int(card / 3))
        
            playClick()
        else:
            card -= 6
            cardDrag[0].snap(80 + 200 * (card % 3), 98 + 283 * int(card / 3))
        
        renpy.restart_interaction()

    def deleteAbility(cardDrop, cardDrag):
        card = 9 * abilityPage + cardDrag[0].drag_name
        if card < 6:
            card = currentAbilities[card]
        else:
            card = backupAbilities[card - 6]

        playClick()
        renpy.call("deleteCard", card)
        
    def tradeAbility(cardDrop, cardDrag):
        card = 9 * abilityPage + cardDrag[0].drag_name
        if card < 6:
            card = currentAbilities[card]
        else:
            card = backupAbilities[card - 6]

        playClick()
        renpy.call("tradeCard", card)
    
    def addAbilityNoDuplicate(abiID):
        for abi in currentAbilities:
            if abi and abi.name == abiID:
                return
        for abi in backupAbilities:
            if abi and abi.name == abiID:
                return
        backupAbilities.append(pAbilityDB[abiID])

        
    def removeCard(card):
        if card in backupAbilities:
            backupAbilities.pop(backupAbilities.index(card))
            if abilityPage > 0 and abilityPage > (len(backupAbilities) - 1) / 9:
                previousPage()
        else:
            currentAbilities[currentAbilities.index(card)] = None
    
    def nextPage():
        global abilityPage, backupAbilities
        abilityPage = abilityPage + 1

        if abilityPage > (len(backupAbilities) - 1) / 9:
            abilityPage = 0
        
    def previousPage():
        global abilityPage, backupAbilities
        abilityPage = abilityPage - 1

        if abilityPage < 0:
            abilityPage = int((len(backupAbilities) - 1) / 9)


    def addCrystals(amount):
        amount = int(amount)
        global lustCrystals
        lustCrystals += amount
        if amount > 0:    
            p = "+{}".format(amount)
        else:
            p = "{}".format(amount)
        add_popup_message(popupData("UI/LustCrystal.png", p, renpy.random.randint(1200, 1400), renpy.random.randint(60, 100)))

    def addLuck(amount):
        global luck
        luck += amount
        if amount > 0:    
            p = "+{}".format(amount)
        else:
            p = "{}".format(amount)
        add_popup_message(popupData("UI/Luck.png", p, renpy.random.randint(1200, 1400), renpy.random.randint(60, 100)))
    
    def addMaxArousal(amount, modArousal = False):
        global playerBattle

        if playerBattle:
            playerBattle.maxHP += amount

            if modArousal:
                addArousal(amount)

            if amount >= 0:
                renpy.notify("+{} Max[i_arouse]".format(amount))
            else:
                renpy.notify("{} Max[i_arouse]".format(amount))
        else:
            renpy.notify("Error : No night character found.")

label startDreamDive:
    #$renpy.music.play(audio.dreamMusic, if_changed = True)
    python:        
        if dreamDiver == None:
            dreamDiver = marC
            
        playerBattle = pSuccubusDB[dreamDiver.succubus].clone()
        diverBonus = dayBonuses.getCharaBonuses(dreamDiver)
        playerBattle.applyBonuses(diverBonus)

    if playerBattle.maxHP <= 0 or playerBattle.dice <= 0:
        "You try to take control of [dreamDiver.succubus], but she is too weak to fight tonight..."
        jump wakeUp

        
    python:
        if currentDream == None:
            currentDream = playingDream(dreamDB["Inn"])

        currentAbilities = []
        backupAbilities = []
        missedSuccubi = {}

        for i in range(0, playerBattle.maxAbi):
            currentAbilities.append(None)

        i = 0
        for abi in playerBattle.abilities:
            if i < len(currentAbilities):
                currentAbilities[i] = pAbilityDB[abi]
            else:
                backupAbilities.append(pAbilityDB[abi])
            i += 1
            
        luck = playerBattle.luck
        lustCrystals = 0
        dreamDepth = 0

        currentDivers = [d for d in list(divers.values()) if d.check()] 
        renpy.random.shuffle(currentDivers)

    
    jump startDream

label startDream(dreamID = "Inn"):
    play music dreamMusic if_changed
    $playerHP = 0
    $dEvent = getEvent(currentDream.name + "_Start")
    if dEvent:
        $renpy.call(dEvent)
        play music dreamMusic if_changed

    python:
        dreamDepth += 1
        currentDream = playingDream(dreamDB[dreamID])
        #unplayedEvents = currentDream.events.copy()
        unplayedEvents = [e for e in currentDream.events if e.check()]
        unplayedEvents.append(merchantEvent())
        if len(currentDivers) > 0:
            unplayedEvents.append(currentDivers.pop())
        battlesRemaining = currentDream.length

    
    jump nextDreamStage

label nextDreamStage:
    python:
        if battlesRemaining <= 0:
            if len(unplayedEvents) < 2:
                dreamEvents = unplayedEvents.copy()
            else:
                dreamEvents = renpy.random.sample(unplayedEvents, 2)
            dreamEvents.append(currentDream.bossEvent)     
        else:
            if len(unplayedEvents) < 3:
                dreamEvents = unplayedEvents.copy()
            else:
                dreamEvents = renpy.random.sample(unplayedEvents, 3)
    
    if currentDream.background:
        scene expression currentDream.background
        show spaceoverlay:
            alpha .8
    else:
        scene space1
    with Dissolve(.3)

    call screen dreamDiveScreen

label wakeUp:
    if story >= 39:
        jump EndingDiveLoss
    else:
        $dreamDiver = None
        $playerBattle = None
        jump startDay

label nextDream:
    $dEvent = getEvent(currentDream.name + "_End")
    if dEvent:
        $renpy.call(dEvent)
        play music dreamMusic if_changed

    python:
        if currentDream.name not in dreamsCleared:
            dreamsCleared.append(currentDream.name)
            
        lovePts = dreamDepth * 100

        links = getDreamLinks(currentDream.name)
        if story >= 39:
            if links:
                options = []
            else:
                options = [("Free Princess Cecilia", "final")]    
        else:
            options = [("Wake up (+[lovePts] [i_love])", "wakeUp")]
        for link in links:
            options.append((link, link))
        
        choice = renpy.display_menu(options)

        if choice == "wakeUp":
            diverBonus.giveRelationPoints(1, lovePts)
            renpy.jump("wakeUp")
        elif choice == "final":
            renpy.jump("EndingAfterQueen")
        elif not dreamDB.has_key(choice):
            renpy.notify("Dream {} not found...".format(choice))
            renpy.jump("wakeUp")
        else:
            renpy.call("startDream", choice)
  
label showAbilities:
    call screen abilityScreen
 
label deleteCard(card):
    menu:
        "Throw away [card.name]?"
        "Yes":
            $removeCard(card)
        "No":
            pass
    call screen abilityScreen

label tradeCard(card):
    menu:
        "Give away [card.name]?"
        "Yes":
            $removeCard(card)
            $tradeSuccessful = True
            return
        "No":
            call screen abilityScreen

label backToDive:
    call screen dreamDiveScreen

label cancelTrade:
    menu:
        "Cancel trade?"
        "Yes":
            $tradeSuccessful = False
            return
        "No":
            call screen abilityScreen 
