define timeStrings = ["Morning", "Afternoon", "Evening", "Night", "Deep Night"]
define timeStringsLower = ["morning", "afternoon", "evening", "night", "deep night"]
define timeColors = ["#F8E71C", "#F6C61F", "#F5A623", "#9013FE", "#3F0076"]

define dayFrame = Frame("images/UI/Background.png", 10, 10)
define nightFrame = Frame("images/UI/Background2.png", 10, 10)
define dynFrame = lambda: dayFrame if dayTime < 3 else nightFrame

default day = 0
default dayTime = 0
default timeString = timeStrings[0]
default timeStringLower = timeStringsLower[0]
default nextEvent = None

default shownChara = None
default dayBonuses = None
default tmpAbi = None

init python:
    def talkChara(charaID):
        global characters, shownChara, cTalk
        shownChara = characters[charaID]
        cTalk = shownChara.character
        renpy.call("meetChara")
    
    def goLocation(location):
        #renpy.notify(location.name)
        event = getEvent(location.name)
        if event:
            renpy.call(event)
        else:
            renpy.call(location.label)

label startDay:
    $dayTime = 0
    $day += 1
    $dayBonuses = dayBonus()

    if story >= 20:
        $ladyOfTheNight = renpy.random.choice(list(characters.keys()))

    $dEvent = getEvent(day)
    if dEvent:
        call expression dEvent from _call_expression
    $dEvent = getEvent("DayStart")
    if dEvent:
        call expression dEvent from _call_expression_1
    
    jump dayTown

label advanceTime:
    $dayTime += 1
    if story >= 39:
        jump EndAdvanceTime
    elif dayTime > 4:
        jump startDay
    elif dayTime == 4:
        jump startDreamDive
    else:
        jump dayTown

label dayTown:
    if story >= 39:
        jump EndingPreps
    $renpy.set_return_stack([])
    play music dayMusic if_changed
    $nextEvent = getEvent(timeStrings[dayTime])
    if nextEvent:
        $renpy.call(nextEvent)
    #while len(simpleEvents[dayTime]) > 0:
    #    $nextEvent = simpleEvents[dayTime].pop()
    #    $renpy.call(nextEvent)

    if dayTime < len(timeString):
        $e = getEvent(timeString[dayTime])
        if e:
            call e from _call_e
    call townscene from _call_townscene_3

    with Dissolve(.3)
    call screen dayScreen
    with Dissolve(.3)

label townscene:
    if dayTime < 2:
        scene town
    elif dayTime == 2:
        scene townSunset
    else:
        scene townNight
    return

label showChara:
    show screen charaScreen
    with Dissolve(.2)
    $shownChara.playGreeting()
    call charaMenu from _call_charaMenu
        
label charaMenu:
    $talk = shownChara.getImportantTalk()
    menu:
        "[i_fairy] Relationships [i_fairy]" if config.developer:
            menu:
                "+ Friendship":
                    $shownChara.addPoints(0, 100)
                "+ Love":
                    $shownChara.addPoints(1, 100)
                "+ Lust":
                    $shownChara.addPoints(2, 100)
            
            jump charaMenu
            
        "[talk[1]] Spend time [i_time]" if talk:
            hide screen dayScreen
            hide screen charaScreen
            $renpy.call(talk[0])         
            jump advanceTime
        "Spend time [i_time]" if not talk:
            hide screen dayScreen
            hide screen charaScreen
            $shownChara.playSpendTime()
            jump advanceTime
        "Back to town":
            hide screen charaScreen
            jump dayTown


label nightTime:
    call screen nightScreen
    with Dissolve(.2)

label nightPrep(diver):
    $dreamDiver = diver
    call screen nightPrepScreen