init 1 python:
    newEvent("introStart", 1)

label naming:
    $pName = renpy.input("First name?", default = pName, length=32)
    $pSurname = renpy.input("Last name?", default = pSurname, length=32)
    $pNickname = pName[:3]
    $pNickname = renpy.input("Nickname?", default = pNickname, length=32)

    menu :
        "[pName] \"[pNickname]\" [pSurname], is that okay?"
        "Yes":
            pass
        "No":
            $story = 5
            call naming from _call_naming
        
    $pc.name = pName
        
    if persistent.pName == None:
        call persistentNames from _call_persistentNames
    elif persistent.pName != pName or persistent.pSurname != pSurname or persistent.pNickname != pNickname:
        menu:
            "Keep this name for the extra scenes? (Currently [pName] \"[pNickname]\" [pSurname])"
            "Yes":
                call persistentNames from _call_persistentNames_1
            "No":
                pass
    return

label persistentNames:
    $persistent.pName = pName
    $persistent.pSurname = pSurname
    $persistent.pNickname = pNickname
    return


label introStart:
    if config.developer:
        menu:
            "Play intro":
                pass
            "Skip intro":
                $eveC = playChara("Evelyn")
                $eveC.unlock()
                if persistent.evelyn == None:
                    $persistent.margaret = "B"
                show player
                call naming from _call_naming_1
                jump startDay

    play music dayMusic if_changed
    scene town with fade
    show player
    "You're finally back home. It's been a few years since you've seen your family."
    "The town of Queensrest hasn't changed much since you left, except that she is now sheltered in a huge magical barrier, preventing anyone from going in or out without notice."
    show player at toleft
    $sil.name = "Guard"
    show silhouette at right
    sil "Stop, access to Queensrest has been forbidden since the recent outbreak. If you are a traveler, I'll have to ask you to continue to the next town over."
    "The outbreak she is talking of is an unknown phenomenon that started two months ago called the Blissful Sleep. People affected, also called Sleepers, fall unconscious and never seem to fully wake up."
    "The strangest part of it is that they can still take care of their basic needs, like eating or drinking, but do so in a state closer to sleepwalking than conscious activity."
    "Doctors examined them but they have no explanation for its origin. The Sleepers don't seem to be in bad condition, on the contrary, they all seem to be peacefully resting, hence the name Blissful Sleep."
    "This is the reason you came back. Last week, you received a letter from your mother saying that Evelyn, your older sister, had contracted the Sleep. She was desperate so you had to come back."
    sil "If you are here on official business, I'll need to see your papers."
    "You had proven yourself in the recent war against demons and managed to use your fame and the fact that you are from here to obtain a pass to enter the city."
    "You hand the guard your authorization and your id, showing your name."
    #Input first & last name
    call naming from _call_naming_2
    pc "Here you are."
    sil "Oh, I didn't realize you were [pName] [pSurname]! Sorry for the disrespect... and thank you for fighting for us!"
    pc "It's nothing, I wasn't expecting you to recognize me anyway, I'm not that famous."
    sil "What do you mean, not that famous? You're the adventurer who managed to take down Lilith, one of the Demon Knight!"
    "You're not really comfortable when people react like that about what you did. They often forget about how you weren't alone in that fight, but since you were the only human, you get all the credit."
    pc "I was only the backup, Lanelle was the main reason we won that fight. And Rhaz was way better in a fight than me."
    sil "If you say so, but still... to think you were able to fight a Demon Knight and win..."
    "You talk for a while with her before she quickly checks your pass and seem even more impressed when she sees the royal seal."
    sil "So you came in Queensrest to solve the Blissful Sleep?"
    pc "It's less glorious than that. I lived here before becoming an adventurer and my sister contracted the Sleep. I came back to take care of her and take her place to help my mother with our family inn."
    sil "Alright, you are clear to enter. I'm sure you already know, but it's important so I need to be certain : I can allow you to pass through the barrier but you won't be able to get out."
    sil "It can be until the Blissful Sleep is cured or at least its origin are identified. You won't have any particular protection against it, so don't count on an authorization to leave before that."
    pc "Thank you, I know. But I can't leave my family like that."
    "And to be fair, since the war ended, your career as an adventurer is way less interesting. You are relegated to escorting nobles or merchants and fight against thieves and low level monsters."
    pc "Well, time to go in. Thank you for your work."
    "With a nod, the guard touches the barrier which seems to become liquid. You pass through and enter Queensrest."
    show silhouette at outleft
    show player at tocenter
    "Inside the town it would be impossible to know there is an outbreak occurring. The weather is great and everyone is getting busy around the city, chatting or working."
    "From what you learned before coming here, the barrier was summoned without telling the citizen and that caused a lot of unrest, mainly from travelers and trader stuck since then."
    "Since the origin of the Blissful Sleep, or just the Sleep, was unknown, people could be healthy carriers and spread it out of town, so even if it was a drastic measure, it was understood."
    "The thing that helped most was that the crown Princess Cecilia was also quarantined. It is tradition that the next queen prove herself by ruling Queensrest before taking the throne, so she had to stay."
    "Then the Queen announced that she would take care of all lodging fees for the travelers, followed by allowing trading posts through the barrier."
    "The daily life of the citizen was almost normal and travelers enjoyed holidays paid by the crown, so everything calmed down."
    "A fun and unexpected side effect of the barrier was that the weather is always warm and it never rains."
    call introDay from _call_introDay

label IntroMorning:
    scene innlobby
    show player at left
    "After walking around town, you find yourself in the Princess' Harem, your family's inn."
    "It's around midday but you see that the restaurant is almost empty. What's wierd is that the few people who are present are waiting at their table but don't seem too bothered."
    "You enter the kitchen to find it empty, but someone shouted from behind you."
    "Patron" "If you're searching for Alice, she's busy for now : her daughter got up to eat and fell down the stairs. You can wait here with us or go to the restaurant down the street."
    pc "Thank you, I'm going to see if I can help."
    scene bedroom
    show player at left
    show mother at right
    "You get to the private quarters, towards the private bedrooms, when you hear sobbing in your parent's. Your mother is crying there, alone. You dropped your luggage in the hall before entering."
    pc "Is Evelyn okay? I learned what happened from a client."
    mom "[pName]?"
    show player at toleft3
    show mother at toright3
    "She quickly wiped her tears before getting up to hug you. It's a bit tight, but you're not going to tell her that."
    show player at toleft
    show mother at toright
    mom "Thank you for coming back. Eve's okay, the doctor is inside with her to check if she doesn't have anything broken."
    pc "What about dad? Or Violet?"
    mom "Your dad's at work right now, I didn't want to bother her for now. And Violet... she's become distant the last few years, she doesn't help at all with Evelyn."
    "You can see she's about to start crying again, but forces herself to stay strong in front of you."
    mom "It was my fault Eve hurt herself : I left her room unlocked when I brought her lunch. I was already late to serve the clients at the restaurant, so I rushed and forgot to lock..."
    pc "It's alright, you said she wasn't hurt... and I'm back, I'm going to help you with taking care of her, and the inn."
    mom "Thank you, really. With the barrier, a lot of people are lodging here and the inn is almost full, it was already hard with Eve's help, but since then..."
    "You stand next to her in silence, until you hear to door from the next room opening."
    show mother at toleft3
    show hilda at inright
    hil "I finished to check her, and no major injury. I didn't see any improvement in her condition, but at least, it didn't worsen either."
    mom "..."
    "Your mother looks relieved, but doesn't seem to know what to say."
    hil "And good afternoon [pName], it's nice to see you back, even if it's in this conditions. And thank you for your job out there."
    pc "Ehm... yes, hello to you, too."
    "Doctor Warder is the best in town, so it's no surprise to see her taking care of the Sleepers."
    hil "I'm sorry I can't help much more, I promise I'll do all I can to fight the Blissful Sleep : if it's an illness, I'll find a cure for it, and if it's a curse, I have enough notions in magic to help and find someone to dispel it."
    mom "Thank you doctor Warder."
    hil "I'll be leaving then, but before I go : don't worry about your sister, the Bliss only makes her sleep. As long as you keep her locked in her room and keep your ears open to any strange noise, everything will be okay."
    $dayTime = 1
    $story = 1
    call introDay from _call_introDay_1

label IntroAfternoon:
    hide hilda
    hide mother
    scene innlobby
    show player
    "For the remainder of the day, you help your mother take care of the patrons. Most of them were okay with the less than average service since they know her circumstances, but there are still a few annoyances."
    "It's been a while for you, and making the beds and cleaning the rooms now feels relaxing. You're sure it will again become a chore, but compared to adventuring, it's a breeze."
    "You are in the laundry room, taking out a pile of clean sheets when you hear Violet, your younger sister, behind you."
    show player at toleft
    show violet at inright
    vi "Mom asked for you to bring food to Eve'."
    pc "Oh.. I... Okay, I'll go right after."
    vi "Do what you want, I did what I was asked."
    show violet at outright
    "And she was gone."
    "That was strange. You weren't expecting a hug but seeing her acting so dismissive after not seeing her for years hurt a little."
    "From your mother's letters, you know that your sisters changed quite a bit since you left."
    hide player
    show violet at center
    "As a teen, Violet was kind of a tsundere. She whined when asked to do something but always ended up doing it and doing it well. She was weak to praise and acted cold but it was only a facade."
    "Now, she seems to only do the bare minimum and more often than not, she had Evelyn doing it. She knows your parents wouldn't kick her out but is testing their limit."
    hide violet
    show evelyn
    "Evelyn became the opposite. She was really self-conscious and hid in her room all day, only helping with tasks that had no contact with patrons. Now, she was doing the work of five people."
    "She did all the work you were in charge of, mainly room service, she was at the reception when Violet didn't feel like being there, she cooked, she did the laundry, shopping, cleaning..."
    "Your mother was worried as she worked all the time. She didn't seem to have any friend or hobby, only stopping work to quickly eat and sleep."
    "But she seemed closed off emotionally. She never seemed happy or sad, never getting angry at Violet when she tricked her. That description made her feel soulless, but priests didn't find anything wrong with her."
    "When she contracted the Sleep, you felt your mother's tears in her words calling herself a bad parent for not taking care of her and protecting her."
    scene bedroom
    show player
    "As you enter her room with her meal, you set her plate on the table and take a look at her. She is sleeping comfortably and she seemed to have a faint smile."
    pc "Hello Eve', I'm back home. And I brought your supper..."
    "She stirs in her sleep and starts getting up. You are a bit surprised but you were warned Sleepers are somewhat active."
    "You keep an eye on her as she sleepwalks to the table and drinks her soup. Your mother prepared something easy to eat, as she sometimes choked on solid food, but she still managed to spill half of it."
    "After finishing, she gets back to bed. You tuck her in, clean her mess and then leave, making sure you lock the door correctly."
    $dayTime = 2
    $story = 2
    call introDay from _call_introDay_2

label IntroEvening:
    scene innlobby
    show player at left
    show mother at right
    "During supper, you eat alone with your mother. She tries catching up with you but you know she has other things on her mind."
    pc "You look exhausted, you should go rest for tonight."
    mom "But there are still patrons that..."
    pc "Mom, stop. I'll take care of what's needed with Violet, don't worry. Where is she, by the way?"
    mom "She eats in her room. But she won't help in the evening, she goes out after eating."
    pc "Well, you need to slow down. I'll go talk to her. And don't worry about Evelyn, I'll watch over her too."
    mom "Thanks [pName]. When your dad comes back, tell her that I'm already in bed."
    scene innlobby
    show player
    "You clean your dishes and go knock on Violet's door. She answers but doesn't open."
    vi "Yeah?"
    pc "It's me, I need you to help me during tonight's shift."
    vi "I can't, I'm going out."
    pc "Mom was completely exhausted, I told her to go to sleep. I need your help, just for tonight."
    vi "{i}*Sigh*{/i} You could have asked before volunteering me."
    pc "I know and I'm sorry, but after what happened with Eve, mom really needed to rest tonight."
    vi "Yeah, yeah, I'll be there. Give me ten minutes."
    scene innlobby
    show player at left
    show violet at inleft2
    "You go to the reception and wait for your sister. As expected, she arrives exactly ten minutes later."
    "The clients are less difficult than you're used to, Violet tells you that's because they've been here since the barrier, so they know what to expect."
    "The evening goes slowly. You only need to bring a late supper to a high elf patron that Violet qualified as \"bitch\"."
    "By the time your father comes back, your sister is asleep on the desk."
    show father at inright
    dad "Ah, [pName], welcome back."
    pc "Hi dad. Mom is already sleeping, there was an accident with Eve before I came back. Nothing serious but she was exhausted."
    "She asks the usual questions after not seeing you for a while, but after a couple minutes, Violet gets up."
    vi "I did what you asked, I'm going to bed."
    show violet at outleft
    "She took you by surprise and left before you had the time to say anything. You still shout a thanks before she gets out of view."
    dad "That girl is worrying me. Her attitude's getting worse every day."
    pc "What happened exactly?"
    dad "Don't know. She always seemed to dislike me, but now she avoids me."
    dad "But don't worry about her, I'm glad you're back with us. And it's getting late, I'm going to bed, 'night."
    show father at outleft
    "Your father works at the castle. She's managing the royal guards, so she has strange shifts all along the day. You never saw her the days she worked and she rarely took days off."
    "You continue to stay there until 11, time where the reception closes, then go check on Evelyn."
    $dayTime = 3
    $story = 3
    $eveC = playChara("Evelyn")
    if persistent.evelyn == None:
        $persistent.evelyn = "B"
    $eveC.unlock()
    call introDay from _call_introDay_3

label IntroNight:
    scene bedroom
    show player at left
    "She's still sleeping, so you pull a chair next to the bed and watch her for a while."
    "You didn't realize that you were so tired, but you traveled a lot recently and worked almost all the time since you're back. Sleep took you by surprise and you fell asleep next to Eve."
    "..."
    play music dreamMusic if_changed
    scene campfire
    show spaceoverlay:
            alpha .8
    show player at left
    "It's been a tough day fighting demons. The three of you have been on the road for two weeks and still no sign of a Demon Knight or their Queen."
    "You've set up camp at last, Rhaz needed to bandage her wounds. You got ambushed and she was injured as you got ready to fight."
    "The fight is over, yet you still feel a strange presence nearby. It's too dark for you to check it out but Lanelle might want to go check it out. You're kind of jealous of her elven eyes."
    show melody at right
    pc "How's Rhaz?"
    mel "She'll be fine. I just came to pick some water, she'll need it."
    mel "You can take care of keeping watch? I'll stay in her tent for the night, we'll be... too busy."
    "Lanelle is acting a bit strange... she's a bit too sexual tonight."
    "Wait, that's not Lanelle, it's Melody. How can you mistake them? And why even is Melody with you right now?"
    "Ah, right, it's another lucid dream. You're back home, no need to worry. You often have this kind of dream and the nice thing about it is how you're able to do anything you want."
    menu:
        "Ah, right, it's another lucid dream. You're back home, no need to worry. You often have this kind of dream and the nice thing about it is how you're able to do anything you want."
        "Keep Melody with you":
            pc "Mel, don't do that. Stay with me for tonight."
            mel "Okay, [pName], I was only teasing you."
            show melody n
            "She starts stripping in front of you. You don't know how much you'll push it but it's a nice view."
        "Let them have fun":
            pc "Okay, Mel. Have fun."
            mel "We will!"
            hide melody
            "She goes into the orc's tent and you quickly start hearing their fun. Meanwhile, you wonder what you'll do with your dream."
    "You try to dismiss the strange presence you feel, but it doesn't seem to go away. Annoyed, you get up and walk in its general direction."
    hide melody
    "However, you can't seem to get any closer. Even for a dream, it feels strange to you."
    "But since it's a dream, you could just try to project yourself towards it."
    show spaceoverlay:
            alpha .9
    "You move at an incredible speed and it feels a bit nauseous. Quickly, you feel some resistance pulling you back, and the background becomes emptier."
    scene space1
    hide spaceoverlay
    show player at left
    "And suddenly, everything pops... you're somewhere empty and nothing else holding you. You feel someone close by and slowly hover towards them."
    "Another wall, but you can see inside. It looks like the inn. You push against it and somewhat easily fall through."
    scene innlobby
    show spaceoverlay:
            alpha .8
    show player at left
    "You now feel another presence and it feels familiar."
    pc "Who's there?"
    show maidS at right
    show evelyn at right2
    $mai.name = "Strange Maid"
    mai "Hey, that's my question! What are you doing in here, she's mine!"
    "A strange woman is standing there, a maid? And behind her... that's..."
    pc "Eve!"
    mai "Wait... you're an hume? How did you get in here?"
    $mai.name = "Succubus Maid"
    show player naked
    "She's a demon, a succubus, you instinctively try to grab your dagger but you can't find it as you're suddenly naked."
    mai "It's not your domain, you have no power here. Now, you'll obey me and kneel."
    menu:
        mai "It's not your domain, you have no power here. Now, you'll obey me and kneel."
        "Yes, Head Maid":
            pass
        "Yes, Mistress":
            pass
        "Yes, I'll obey":
            pass
    mai "Good slave."
    "She quickly invades your whole mind and you can't even resist her, it's even worse than last time. How is she more powerful than Lilith?"
    mai "I control her dream, everything happens how I want. I'll have another pet to play with."
    show player at toleft3
    "You start crawling towards her. As you slowly get close to her, you panic and look everywhere around for something to help."
    "Then, you look at Evelyn. She's just standing there in her maid uniform ignoring you, as if she was waiting for her master's orders."
    pc "Evelyn, help me!"
    mai "Oh, you know her? She won't help. She's under my orders, I'm her superior."
    pc "What have you done to her?"
    mai "It doesn't matter. Come here I'll just drain you, I don't need another slave."
    "She pulls her dress up to reveal an alluring cock. You crawl towards it, mouth open, only wanting to take care of it."
    show margaret succubus at left2
    $mar.name = "Succubus"
    mar "Let her go, now!"
    show player at toleft
    "Another succubus comes behind you and you somewhat regain control of your body."
    mai "Hey, they are mine, I claimed this dream!"
    mar "Can't you see that this one is conscious? If you drain her, she'll simply die."
    mai "And what are you? The protector of the humes?"
    mar "What I mean to say is that if they started to die, not just sleep, bigger problems will arise, for all of us."
    mai "It's only one, they won't care. If we let her go, she'll talk about what happened, so it's the better option. And you can't stop me, it's my dream here."
    mar "You don't leave me any choice, then. Hume, let me help you."
    "The more she talks, the more control you regain. She holds out her hand to you."
    menu:
        "The more she talks, the more control you regain. She holds out her hand to you."
        "Help me":
            $margaretDom = 5
            pc "Please, help me. That girl is my sister."
            "She takes your hand and pulls you up."
            mar "Good girl, let me do and we'll save her."
        "I'll manage":
            $margaretDom = -5
            pc "I can move again, I'll manage by myself."
            mar "Now, now, don't say that. Don't let your pride get in the way. Your sister can be saved too, I only need your help to do it."
            "You look again at Evelyn, still immobile next to that maid. The newcomer holds out her hand."
            menu:
                "You look again at Evelyn, still immobile next to that maid. The newcomer holds out her hand."
                "Grab it and accept her help":
                    "Reluctantly, you take the hand of the succubus and get yourself up."
                "Ignore her":
                    "You get up by yourself, ignoring the succubus' offer."
                    jump introGameOver
    $mar.name = "Margaret"
    mar "My name is Margaret, It's only polite to exchange names before merging souls."
    mai "Wait, don't do that, it's forbidden. And you, hume, she'll be able to fully control you even when you wake up."
    show margaret at toleft
    "But it's too late, you slowly melt into her. The sensation is strange, it feels uncomfortably good everywhere in your body."
    show player at left2:
            alpha .3
    if margaretDom >= 0:
        "She's overwhelming you, her power invading every part of your body. You feel yourself shrink to be nestled inside of her. You are now protected by her whole being."
    else:
        "You're starting to control her. Her power and abilities are now yours and the presence of the maid inside you totally disappeared. You are now in control of her whole being."
    "You two are now one. You seem to have control of her body, and it still seems to have a memory of her abilities."
    mar "Now that I'm in your mind, you'll be able to use my powers to make her submit. Do your best, it shouldn't be hard."
    mar "Do you want some pointers before the fight?"
    menu:
        mar "Do you want some pointers before the fight?"
        "Yes, please":
            $margaretDom += 2
            call tutorial from _call_tutorial
        "No, thanks":
            $margaretDom -= 2
            mar "Okay, have fun."

    #Start fight Margaret Vs Maid
    $story = 4
    $dreamDiver = marC
    call startBattle(oSuccubusDB["Maid"], "introFightWon", "introFightLost", "Margaret") from _call_startBattle_1

label introFightLost:
    play music dreamMusic if_changed
    scene innlobby
    show spaceoverlay:
            alpha .8
    show player naked at left2:
            alpha .3
    show margaret nakedsuccubus at left
    show maidS at right
    show evelyn at right2
    "A rope of cum escapes from your cock. Or is it Margaret's?"
    mar "Okay, pause."
    mar "I know it can be quite overwhelming, but try to focus on the fight. I'll explain quickly how I work."
    mar "Use the [i_dice]dice on my abilities to use them. [i_arouse]Arousing a succubus is the easiest way to win, forcing an orgasm will make us submissive, it's in our nature."
    mar "On the other hand, if you stay [i_calm]calm as she is on the offensive, it will prevent your own [i_arouse]arousal to increase."
    mar "She will use the same kind of techniques as I am, so stay on your guard."
    if margaretDom >= 0:
        mar "And you don't need to worry about us, someone like her won't be able to make me kneel, so keep trying."
        mai "Hey! I can hear you. Who are you, anyway?"
    else:
        mar "I'll just take a deep breath and we can try again. You shouldn't have any problem against her."
        mai "That's mean. I'm right here, you know."
    $margaretDom += 5
    mar "Do you want some explanations on how to fight?"
    menu:
        mar "Do you want some explanations on how to fight?"
        "Yes":
            call tutorial from _call_tutorial_1
        "No, thanks":
            mar "Okay, have fun."
    call startBattle(oSuccubusDB["Maid"], "introFightWon", "introFightLost", "Margaret") from _call_startBattle_2

label introFightWon:
    play music dreamMusic if_changed
    scene innlobby
    show spaceoverlay:
            alpha .8
    show player naked at left2:
            alpha .3
    show margaret succubus at left
    show maidS at right
    show evelyn at right2
    mai "{i}Mmmaaaahhhh...{/i}"
    "She came intensely, spraying cum in a straight line in front of her."
    mar "Good job, she'll serve us well. Let's continue milking her, to make her nice and submissive."
    show margaret at toleft3
    show player at toleft
    show maidS at toright3
    if margaretDom >= 0:
        "Almost instinctively, you are walking towards the panting maid. You place your hand on her cock and start giving her slow, gentle strokes."
    else:
        "You walk towards the maid, grab her cock and milk her efficiently."
    mar "Okay, now that this problem has been taken care of, we can have a little talk."
    "You feel really awkward talking to someone sharing the same body as yourself while giving a handjob to someone else but Margaret doesn't seem to care."
    mar "Can you start by explaining what you are doing here?"
    "After a brief hesitation, you describe to her how you were in a lucid dream, started feeling something strange and ended up finding the maid and your sister."
    mar "I kind of understand, I'll give you more information. First, as you seem to know, she and I are succubi. We can invade people's dreams and drain them of their life force."
    pc "But, how? We defeated Lilith, succubi retreated from our world after that."
    mai "{i}*moan*{/i} Mistress Lilith, for you, human."
    "You strengthen your grip to make her shut up."
    mar "Ignore her. Lilith was only the most powerful succubus, not all of us followed her. Some, like me, would rather enjoy peace here than retreat with the others. But it doesn't matter right now."
    mar "Here is something more important for you : that girl is now in control of your sister's dreams. We recently found how to be able to keep a hume under our influence and keep draining them, giving us more and more power."
    mar "This is what you call Blissful Sleep, dreams they don't want to leave. It's not possession, so your priests are unable to find our presence, and since nobody dies, they don't suspect us either."
    "Great, you now that you know its origin, you'll be able to tell mages and get everyone in town safe."
    pc "But why are you telling me that? If I share this information, you'll be hunted out of here."
    mar "Not so fast, I'm only trying to prevent death on both camps. What do you think other succubi will do if they feel they are in danger?"
    mar "They'll drain their target completely before fleeing or fighting back. With the barrier in town, it'll be a bloodbath in a week."
    mar "That's why I try to prevent idiots like this one to kill humes, someone will end up finding that demons are here and \"heroes\" will come to exterminate all of us."
    pc "So, what are you doing, exactly? You're a good succubus trying to fight for the humes?"
    mar "You can say that. We still need humes' energy to survive and asking politely isn't an option, thanks to our bad reputation. The difference is that I don't make humes submit to me. At least, not unwillingly."
    mar "We are able to sustain ourselves by feeding here and there. When our prey wakes up, they feel a bit more tired than usual, but they often put it down to the wet dream they just had."
    mar "But once you taste some easy energy, it's hard to say no to more, and some of us decide to capture someone's dreams to have a constant source."
    pc "Do you have a solution then? The Blissful Sleep is spreading in town, my own sister has it, I can't leave her like that. It's the same for others, they are at the whims of the succubi draining them."
    mar "I'm... still working on it. I'm doing it alone, succubi can be easily distracted by their lust so I didn't find anyone reliable. But we can free your sister, since her owner is... right... here..."
    "Margaret suddenly seem deep in thought, you feel your shared brain working intensely, even if you don't know what's on her mind."
    mar "I know how to solve this problem. First let's take care of your sister. I can wake her up, you need to make this slut fully submit to you."
    pc "How do I do that?"
    mar "With my help, I should be able to link her with your sister. That would keep her submissive to you and feed her enough to be helpful. Then, your sister would be able to wake up and this girl would protect her."
    mai "{i}*moan*{/i} but I don't want to..."
    "Your other hand clasps her balls and she comes again."
    mar "You're sure about that?"
    "The maid emit a small sound but doesn't answer."
    "Even if she doesn't seem to lie, you have a feeling Margaret doesn't tell you everything."
    pc "It doesn't seem like Evelyn would be free of her then, is it really the only way?"
    "The succubus stays silent for a moment."
    mar "I'm going to be frank. I have... plans for you. The easiest solution would be to kick her out of your sister's dream, but she'll probably find someone else to possess if you don't banish or kill her."
    mar "I won't do that. I need someone's help, a Dream Diver like you. The ability for humes to be conscious in a dream isn't common, and the few Divers I found weren't the type to help me or were too weak."
    mar "With you, I have a good feeling. I know you already fought Lilith, so you are strong willed, even if the fight is totally different this time. And I have leverage so you won't betray me immediately."
    mar "I need someone to explore the town's dreams. There are reasons I can't do it myself. And I won't be able to give you much information about what you'll be doing until I know I can trust you."
    mar "Those are my conditions for helping your sister. Keep in mind that even if I don't help her, she'll probably be fine while sleeping, but the moment someone finds that succubi are in town, she won't be the only one at risk..."
    "She makes a good case. You still have apprehensions about cooperating with a succubus. Even if you know they aren't all bad, you were fighting them until quite recently."
    menu:
        "She makes a good case. You still have apprehensions about cooperating with a succubus. Even if you know they aren't all bad, you were fighting them until quite recently."
        "Okay, but be patient with me":
            pc "Okay, but be patient with me. It might take time for me to completely trust you."
            $margaretDom += 1
        "I don't completely trust you, but...":
            pc "I don't completely trust you yet, but I don't have much of a choice."
            $margaretDom -= 1
    mar "That's fine with me, I'll train you to fight as a succubus and we'll investigate the Blissful Sleep together."
    mar "But now, it's time to fuck the maid."
    "You revert your attention towards the succubus maid. She came a few times from your hand as you continuously kept stroking her."
    mar "To make her fully submit to you, she needs to be really submissive, like she is right now, and you give her a creampie. Your call for how you want to proceed."
    menu:
        mar "To make her fully submit to you, she needs to be really submissive, like she is right now, and you give her a creampie. Your call for how you want to proceed."
        "Fuck her hard":
            "Her cunt is drenched after all the teasing you did to her, so you flip her on her stomach and plunge deep in one thrust."
            mai "{i}Mhhhnn...{/i}"
            "She moans under you, enjoying your ministrations. You only care about your own pleasure, but she enjoys it nonetheless."
            mar "You don't have to care about her, you only need to fill her up."
            "You do just as Margaret said and quickly accelerate."
            mai "Please, Mistress, I want to cum..."
            menu:
                mai "Please, Mistress, I want to cum..."
                "Make her beg":
                    pc "Do you really?"
                    mai "Yes!"
                    pc "I didn't hear it."
                    mai "Please, Mistress, let me cum."
                    "You feel your own orgasm coming from her submission, but you hold a few more seconds to finish together."
                    mai "Mmmm, thank you, Mistress..."
                "Ignore her":
                    "You thrust faster and faster, feeling her squirm under you."
                    mai "I'm getting close..."
                    "So are you, and you continue without paying attention to her. You quickly feel your orgasm coming and thrust in deep."
                    mai "Wait, just a few more..."
                    "But you don't care and fill her up."
                    mai "Mhh, I can't... reach... *grumble*"
        "Treat her gently":
            "You gently start massaging her breasts, not to arouse her but to show your intentions. She relaxes a bit and, with a nod, allows you inside of her."
            mai "Mhh..."
            "You make a few slow thrusts to judge her reactions and find a rhythm that fits you both."
            mar "You don't have to care about her, you only need to fill her up."
            "Even if that's the case, you'll reach the end anyway, so might as well make you both enjoy it. You slowly feel your orgasm come."
            mai "I'm coming soon... Mistress."
            menu:
                mai "I'm coming soon... Mistress."
                "Kiss her":
                    "Your mouths join together as you share a sloppy kiss. You feel her arms pulling you towards her and take you as deep as possible for your creampie."
                    mai "Did I please you, Mistress."
                "Suck her nipple":
                    "You take her nipple into your mouth, teasing her over the limit. You feel her cum on your belly and her pussy contracts, pushing you over the edge."
                    mai "Thank you, Mistress."
    show spaceoverlay:
        alpha .9
    "A few seconds later, you feel light-headed and your sight starts to blur."
    mar "Don't worry, everything is as planned. You are waking up, I don't have time now, but I'll explain everything to you soon."
    "You feel your mind escape from Margaret's body."
    mar "Wait for me, but don't tell anyone of what happened before we talk, okay?"
    "She winks at you before everything fades away."
    "..."
    scene bedroom
    show player at left
    "You awake slumped on Evelyn's bed. Your mind is still hazy when you hear the door open."
    show mother at right
    mom "[pName]? I was wondering why the door was unlocked."
    "Your mother is bringing your sister's breakfast before starting the day."
    pc "I was more tired than I expected and just... fell asleep before I knew."
    mom "It's my bad. You just came back home and I made you work."
    pc "Don't worry, I'm better now. I overestimated my stamina, that's all."
    "Your mother was about to apologize again but was interrupted by a groan coming from the bed. She puts the plate on the table before coming next to you."
    mom "She sometimes makes noise when she sleeps. It reassures me to hear her."
    "Eve starts moving, turns towards you and open her eyes."
    show mother at toleft3
    show evelyn at right
    eve "Mom? Am I late for work?... [pName]? What are you doing here?"
    "You feel relieved and surprised, but it's nothing compared to your mom. She stands wide eyed for a few seconds, then hugs the confused Evelyn."
    show mother at left3
    eve "What?... Mom, what happened?"
    "She cries for a moment before she's able to talk again."
    mom "Eve, you had the Sleep... I thought you'd never wake up... I'm such a bad mom... I should have had faith in you..."
    eve "I had... the sleep? The Blissful Sleep?"
    mom "Yes... Oh, [pName], quickly call Doctor Warder, she needs to see this."
    show mother at outleft
    show evelyn at outleft
    "You leave her explaining the situation to Eve and go to the hallway. You take your Scroll before casting the Call spell."
    "Doctor Warder answers and you quickly tell her of the situation. You have to confirm three times that you were sure she woke up before she says she'll be here immediately."
    show hilda at inright
    "She comes in less than ten minutes and rushed to Evelyn's bedroom, almost ignoring you."
    show hilda at toleft3
    show evelyn at inright3
    show mother at inright
    "You feel a bit awkward while she checks on Eve. You know the reason why she woke up but you promised the demon you wouldn't tell anyone."
    "Still on the fence about telling them what happened tonight, your mother gives you an excuse to get away."
    mom "[pName], could you go and open the inn? I want to stay here for a while but it's already time..."
    pc "Sure, shout if you need anything."
    mom "Thanks, if they need anything, tell them I'll be late."
    scene innlobby
    show player at left
    show highElf at right
    "You are barely sitting at the reception that the same high elf as yesterday is coming down to ask why her breakfast was late. And she isn't interested in any excuse you give her."
    show margaret at right2
    mar "I'm sorry miss but I have to speak to this employee."
    "The elf was getting ready to talk back to the newcomer but she suddenly huffed and walked back to her room."
    show highElf at outright
    show margaret at right with move
    "You've never seen the woman in front of you but she feels strangely familiar."
    mar "I told you I'd be here soon, but you were further in town that I thought."
    "That's Margaret but she looks... human."
    mar "You expected me to come to you in my demon form? This is easier like this."
    mar "So, she woke up as I told you?"
    pc "Yes, thank you."
    mar "Great, can I go check up on her? Just to be sure everything went right."
    pc "If you want, but we already called a doctor, shouldn't we wait until they leave?"
    mar "No worries, I'm on official business."
    scene bedroom
    show player at left
    show margaret at left2
    show player at left
    show mother at right2
    show hilda at right
    show evelyn naked at right3
    "You lead her to the bedroom where you find her mid check-up, sitting naked on the bed."
    hil "We're busy right now."
    mar "Don't worry, I'm here for the same reason."
    hil "Margaret? How are you already here?"
    mar "I was going to your office, but you were absent, so your wife told me what happened."
    hil "{i}*Sigh*{/i} Could you come later, I'm doing a few tests and checking if her health is in good condition."
    mar "Yes, yes. I'm going to question her sister then, just in case. We'll be in her room."
    "She grabs you by the arm and drags you next door."
    scene playerbedroom
    show player at left
    show margaret at right
    mar "Now we have time until she finishes. I'll explain everything I can about our current situation."
    pc "Yes, that's needed."
    mar "First, a summary from last night. I'm a nice succubus who only want to live in peace, anything else you want to know?"
    jump introQuestions

label introQuestions:
    menu:
        mar "Anything else you want to know?"
        "Who are you?":
            pc "Who are you exactly?"
            mar "I'm only a decently powerful succubus, I already told you my reasons for doing what I do and there isn't much more to say."
            pc "Why are you disguised as a human mage? And Doctor Warder knew you."
            mar "Quite perceptive. That's good. Any succubus can exist in the waking world if they wish to, and the human form is quite easy to do, you don't need much energy."
            mar "The reason I know Warder is because I'm working at the castle at the moment, I'm supposed to investigate the Blissful Sleep."
            jump introQuestions 
        "Blissful Sleep?":
            pc "What's the Blissful Sleep, exactly?"
            mar "As I told you before, we succubi need to feed on humes' lust to survive. There are three main ways to do it."
            mar "Fist, as I do, is to use our ability to invade dreams, giving nice and pleasing feelings, or hard sex on some cases, and we have enough energy for a few days. It's the least efficient way to do it, but as we don't do anything harmful, nobody have any reason to think succubi are present."
            mar "The second way should be obvious to you, as it was Lilith's way, is to charm humes or make them submit. They become addicted to our presence and do anything we ask of them. In this case, we have a willing source of energy who's always available. Of course, other humes view that as a threat and will come to chase us."
            mar "The third is a combination of the two, we make humes addicted to their dreams. This is the Blissful Sleep, making them unwilling to wake up, and after some time, unable to."
            mar "It's a great option, for unethical succubi. But it should be harder to do, lower succubi are able to do it even though powerful ones were unable to until recently. I'm still investigating how they got this power, and all I found was it came from a strange Dream Diver they met."
            mar "Oh, Dream Diver is the name we give to people who can walk between dreams, like us, or even you as you found last night."
            jump introQuestions 
        "Body fusion?":
            pc "How did we share body, did I control you?"
            mar "My human self is a researcher in magic and I specialize in mind magic. I transferred your mind to my body and withdrew mine. It allowed you to control it for a time."
            mar "Fortunately, with my mind still inside, making you use my abilities wasn't too hard."
            mar "Succubi are immune to each other's charm, having my own body allows you to be able to resist her too."
            pc "Why didn't you fight rather than making me fight through you?"
            mar "We were in your sister's dream, so even though she was weak, the Maid had a lot of energy available whilst I had none. When we shared bodies, it used yours instead."
            pc "Couldn't you have only used my energy instead of making me fight?"
            mar "It would have been easier, yes, but since you will need to fight like that, think of it as a way to train you."
            jump introQuestions 
        "Maid succubus?":
            pc "What happened with the maid succubus from tonight?"
            mar "It's the drawback of our nature, when a succubus loses to a hume, they instinctively submit to them. It's some kind of self-defense mechanism to charm dominant opponents and try to extract their lust for a comeback."
            mar "But if the opponent is skilled enough, we can stay into a submissive role and hope to keep them as Mistress or Master for a reliable source of energy."
            pc "So she submits to me, now?"
            mar "As long as you keep my help, yes. You aren't skilled enough to keep her on your own for now. Even if that one was particularly weak."
            jump introQuestions 
        "Evelyn?":
            pc "Is Evelyn safe now?"
            mar "Safe... not entirely. If we free that maid, she'll be able to charm your sister whenever she wants."
            pc "Can't we do something about it?"
            mar "We could, but I suggest we keep them like they are now. The maid won't do anything without our consent and she'll get more powerful over time."
            pc "More powerful?"
            mar "Only somewhat, she won't overpower us but enough to be helpful."
            jump introQuestions 
        "Save others?":
            pc "So can we save other people with the Sleep?"
            mar "We could if we wanted, but I think it's better to not do too much. If we save too many Sleepers, other succubi will be on guard and our job will be harder."
            mar "But if we keep them like this, nothing bad will happen to them anyway, as they need them alive to drain them."
            pc "I'm not really happy with that."
            mar "I doesn't mean we won't be able to save anyone. If there's someone in particular you'd like to save, there shouldn't be any problem."
            jump introQuestions 
        "No more question":
            pass
    pc "I don't have any more question, thank you."
    mar "Good. Now my plan for solving the situation. I need you to find who is giving this power to the succubi."
    mar "You will need to delve deeper in the dreams of the city to find more information. Since I will be doing the same, you won't be able to use my powers you'll need someone else's."
    mar "Luckily for us, we have a cute little maid available for you to use."
    pc "So I'll have to fight as her? Will she allow it?"
    mar "I'll make sure of that. The only problem is that she's kind of weak, so you'll need to buff her up."
    pc "Will I have to train as her every night? It's a lot different to what I usually do."
    mar "Hahaha, no, there's no need to train. Her power will grow with her host's spirit. If the host becomes mentally stronger, so will she."
    mar "What you'll need to do is to spend time with your sister. Be supportive or show compassion and she will grow. Or you can be a jerk, if it's your style, but it's more of an all-or-nothing scenario."
    mar "She will be more affected by everything happening, so I'd suggest you to be careful."
    mar "Speaking of witch, the opposite is true. I told you that training isn't needed, but it's still helpful : if you are skilled and show strength, it will improve your sister's morale. And if you lose and get dominated, it will degrade, so pay attention and don't hesitate to wake up if it becomes too dangerous."
    pc "That's quite a lot to take in..."
    mar "If you want to help me, and you do, it's the basics you needed to know."
    pc "What about you? What will be your role in this?"
    mar "I'll be investigating too, but mainly in the waking world. I try to make myself sparse in the dream world, since I'm in the minority now, I might be killed by any succubus with their hume."
    pc "What now?"
    mar "Now, I'll go see if Warder has finished with your sister, make a few checks to see if she's alright and won't have any surprise from her time sleeping."
    mar "If you're willing to Dream Dive tonight, you can do a lot to prepare. You can spend time with your sister, but almost anything you do will impact what will happen. Just try and find out."
    mar "Oh, and I'll go ask if I can get a room here. You know, to keep an eye on the miraculous recovery of your sister."
    if persistent.margaret == None:
        $persistent.margaret = "B"
    "She winks at you and before leaving the room."
    show margaret at outright
    "You spend some time wondering what to do with your day, outside of the rush hours at the inn, you are quite free to do as you will."
    $story = 5
    jump startDay

label introGameOver:
    mar "I see... that's too bad."
    pc "I don't trust you either."
    mar "I know, I know, and I won't beg. But still I can't have you killed here. Awaken from this dream, and forget."
    "She starts casting a spell and you immediately enter your fighting stance, but before you had time to do anything, you wake up."
    scene bedroom
    show player
    "You are covered in cold sweat, slouched on Evelyn's bed as she's still asleep. You quickly glance around the room and listen, but you don't perceive anything."
    "Evelyn groans in her sleep, as if you just bothered her."
    pc "Sorry Eve', I just had a wierd dream..."
    "You don't remember what it was exactly but you feel exhausted."
    "..."
    scene town
    "You went back to your room, as it was still the middle of the night, but were unable to fall back asleep. You got up at 6 when you heard your mother starting the day."
    "Your day was spent working at the inn. Around midday Doctor Warder came with a colleague to see Evelyn, but her condition hadn't changed. Otherwise the day was quite busy."
    "The next day was lighter, you walked around town, getting back your marks, but found it quite changed."
    "Passing by an old friend's house, you knocked but she didn't answer. You realized it was the middle of the day, so she was probably out."
    "The first week went by quickly, and you started helping out more at the inn. You decided to leave Evelyn to your mother, seeing her asleep made you more uncomfortable every time you opened her door."
    "You went back to look for your friend, a young elf called Melody. After trying to call her and going there, her landlady informed you she became a Sleeper recently, fell down the stairs and was quite hurt."
    "The cases of Blissful Sleep became more common during the next month, and your inn soon became more rooms for taking care of the Sleepers."
    "Violet disappeared, she said she didn't want to spend her days taking care of them, so she went to live with some friends."
    "You became a glorified nurse by the time your mother fell asleep too, soon followed by your father. The Palace sent some guards to help you take care of them, but it was hard."
    "In less than a year, the situation was dire. Sleepers were installed on the streets, with all necessities close to them and the few people still awake were busy round the clock to keep them out of harm's way."
    "Mages and other people sent by the Queen tried to help you through the barrier, but they were too afraid to enter anymore. No one else was coming."
    "And finally, you were the only one awake. You were interrogated as to why, but were unable to answer. Some said it was because you were a strong fighter with good constitutions, others were suspecting you."
    "You tried to take care of the Sleepers as best you could, but hundreds of them died of accidents. You were exhausted, on the verge of giving up."
    "You were crying in the middle of the central square, alone between the remaining Sleepers, when you heard a familiar voice nearby."
    "Familiar voice" "Ah, of course you're the last one. And you're finally broken, good. Now give in and we'll finally break this prison to find our freedom!"
    "Your vision started to blur..."
    "You fell forwards..."
    "Asleep..."
    "..."
    ".."
    "."
    $MainMenu(confirm=False)()

label introDay:
    if dayTime < 2:
        scene town
    elif dayTime == 2:
        scene townSunset
    else:
        scene townNight
    call screen introScreen


screen introScreen:
    transform:
        xpos 20
        ypos 20
        
        $timeString = timeStrings[dayTime]
        text "{image=UI/[timeString].png} Day [day]":
            style "dayText"
            color timeColors[dayTime]

    $ tooltip = GetTooltip()
    if tooltip:
        text tooltip[0]:
            xpos .5
            xanchor .5
            style "dayText"
            color tooltip[1]

    if story < 3:
        $location = locationDB["Inn"]
        imagebutton:
            anchor (.5, .5)
            pos (location.xpos, location.ypos)
            idle "Locations/" + location.name + " T.png"
            hover "Locations/" + location.name + " TH.png"
            if dayTime == 0:
                action Call("IntroMorning")
            elif dayTime == 1:
                action Call("IntroAfternoon")
            elif dayTime == 2:
                action Call("IntroEvening")
            tooltip (location.displayName, location.color)
    else:
        $chara = characters["Evelyn"]
        imagebutton:
            anchor (.5, .5)
            pos (chara.xpos, chara.ypos)
            idle "Characters/" + chara.lower + " T.png"
            hover "Characters/" + chara.lower + " TH.png"
            action Call("IntroNight")
            tooltip (chara.name, chara.color)



label tutorial:
    scene space3
    with Dissolve(.3)
    mar "Okay, I'll explain you how succubus battles work..."
    $playerBattle = pSuccubusDB["Margaret"].clone()
    show player portrait at playerTrans
    mar "We're here. Well, you can only see me, but you're with me in spirit."
    $opponentBattle = oSuccubusDB["Maid"]
    show opponent portrait at opponentTrans
    mar "And that's her."
    show screen tutoScreen
    mar "Those bars are how aroused we are. Succubi become submissive if you show us how dominant you are, so do your best to make her come first and she'll become putty in your hands."
    mar "Buuut if you're the one who comes first, you'll be more submissive yourself. Now, don't worry too much about that : since you're only dreaming, having an orgasm will wake you up."
    python:
        for i in range(playerBattle.dice):
            rollNewDie(playSound = False)
    mar "Those dice are my energy. I'll generate some each turn for you to use."    
    python:        
        combatAbilities = []
        i = 0
        for abi in playerBattle.abilities:
            combatAbilities.append(abilityCard(pAbilityDB[abi], i))
            i += 1
    mar "You just need to place them on my abilities and it'll trigger by itself."
    mar "Some abilities need more than one die [i_dice]. You can check under the card to see how many they need."
    mar "And some abilities require specific dice [i_dice]. Even needs an even number, 4+ needs 4 or more... I'm sure you understand."
    mar "[i_arouse] will arouse her, for the other symbols, you can check it with {image=UI/MiniHelp.png} on those cards."
    show nextturn:
        pos (250, 220)
    mar "Once you've done what you could, you have give her a chance to fight back. Use {image=UI/NextTurn.png} above me to end your turn."
    python:
        oAbility = opponentBattle.RandomAbility(oAbility)
        oppRolls.clear()
        for i in range(oAbility.rolls):
            rollNewDie(toPlayer = False, playSound = False)
    mar "Under her, you can see her ability. [i_arouse] show how much arousal she'll give you. You can use abilities with Focus[i_focus] to prevent it."
    mar "She'll use it as soon as her turn start. After that, it's your turn again and you roll new dice."
    mar "And that's it. I'll let you try things out and watch how you're doing. There are a few other things, but you'll pick them up by doing."
    mar "But don't worry about losing here. I won't let her do anything bad to you or the human under her control."
    hide screen tutoScreen
    return

screen tutoScreen:
    transform:
        xysize(400,100)
        xpos 20
        ypos 320
        bar:
            style "arousal_bar"
            value playerHP
            range playerBattle.maxHP
            ypos 50
        text "[playerHP]/[playerBattle.maxHP]":
            style "hpText"
            ypos 58
        text "[playerBattle.name]":
            style "combatName"

    #Opponent infos
    transform:
        xalign 1.0
        xysize(400,100)
        pos (1880, 650)
        bar:
            style "arousal_bar"
            value opponentHP
            range opponentBattle.maxHP
            #xysize(400,50)
            ypos 50
        text "[opponentHP]/[opponentBattle.maxHP]":
            style "hpText"
            ypos 58
        text "[opponentBattle.name]":
            style "combatName"

    if oAbility:
        #Opponent ability
        fixed:
            pos (1890, 1080)
            anchor (1.0, 1.0)
            
            xsize 420
            ysize 332
            image "Card/card_enemy_bg.png"
            image "Card/card_enemy_borders.png"

            fixed:
                xysize (420, 165)
                xalign 0.5
                yalign 0.08
                image "Card/card_enemy_title.png"
                text oAbility.name:
                    style "oCardName"
                    text_align 0.5
                    ypos 30
            if oAbility.count:
                text oAbility.countStr:
                    xalign 0.9
                    yalign 0.08
                    text_align 0.5
                    color "#FFFFFF"
            fixed:
                xysize (300, 150)
                xalign .5
                ypos .6
                yanchor .5
                text oAbility.description:
                    style "cardDescription"
                    size 24
            vpgrid:
                cols 5
                ypos 260
                xalign .5
                for roll in oppRolls:
                    image roll.combatImagePath:
                        if roll.color:
                            matrixcolor TintMatrix(roll.color)

    #Abilities
    draggroup:
        for i in range(0, len(combatAbilities)):
            $abi = combatAbilities[i]
            if abi != None:
                drag:
                    drag_name abi
                    draggable False
                    droppable abi.usable
                    dropped dieOnAbility

                    xysize(300,437)
                    xpos abi.xpos
                    ypos abi.ypos
                    transform:
                        xysize(300,462)
                        xpos abi.xpos
                        ypos abi.ypos

                        if not abi.usable:
                            matrixcolor SaturationMatrix(0.25)

                        image "Card/card_char_bg.png"
                        image AlphaMask (abi.imagePath, "Card/card_mask.png")
                        if len(abi.dice) > 0:
                            image "Card/card_char_inner_glow.png"
                        image "Card/card_char_borders.png"

                        fixed:
                            ypos .5
                            image "Card/card_char_title.png"
                            text abi.name:
                                style "cardName"
                                ypos 17
                        fixed:
                            xysize (250, 100)
                            xalign .5
                            ypos 310
                            text abi.description:
                                style "cardDescription"
                            
                        if abi.maxUses > 1:
                            fixed:
                                xysize (100, 100)
                                image "Card/orb_red.png"
                                text str(abi.uses):
                                    style "cardNumbers"

                        if abi.count != None:
                            fixed:
                                xpos 1.0
                                xanchor 1.0
                                xysize (100, 100)
                                image "Card/orb_blue.png"
                                text str(abi.count):
                                    style "cardNumbers"

                        hbox:
                            ypos 400
                            xalign .5
                            
                            for die in abi.abilityDice:
                                fixed:
                                    xysize(50, 50)
                                    image "Dice/C0.png"
                                    text "[die.diceText]":
                                        style "diceText"

            else:
                drag:
                    drag_name None
                    child "Card/NoCard.png"
                    xpos 460 + 350 * (i % 3)
                    ypos 78 + 487 * int(i / 3)
        

        #Dice
        for roll in playerRolls:
            if roll.usable:
                drag:
                    drag_name roll
                    xpos roll.pxpos
                    ypos roll.pypos
                    draggable roll.draggable
                    droppable False
                    image roll.imagePath at diceRoll:
                        if roll.color:
                            matrixcolor TintMatrix(roll.color)
                        elif dreamDiver:
                            matrixcolor TintMatrix(dreamDiver.color)