init 10 python:
    #Sporty
    class asBuildup(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Buildup",
                description = "Buildup your power, then strike\n[i_dmax][i_ardor]\n1[i_arouse]",
                rolls = 2,
                effects = ["Ardor"])

        @property
        def description(self):
            return "Buildup your power, then strike\nHighest[i_dice][i_arouse]\nLowest[i_dice][i_ardor]"

        def playAbility(self, dice):
            val = getLowest(dice)
            hpToPlayer(self.diceValue(dice))
            addEffectToOpponent("Ardor", val)
    asBuildup()
    
    class abiBuildup(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Buildup", 
                "Cards/CSporty.webp", 
                "1[i_ardor]", 
                [abilityDie()],
                2,
                effects = ["Ardor"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Ardor", 1)  
    abiBuildup()
    
    opponentSuccubus("Sporty",
        "Sporty",
        "Succubi/Sporty.webp",
        25,
        ["Buildup"],
        "Buildup")

    #Guard
    class asGuardedAttack(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Guarded Attack",
                description = "She's careful of you\n[i_d1] & [i_d2][i_arouse]\n[i_dice][i_focus]",
                rolls = 3,
                diceGroups = [0, 0, 1],
                effects = ["Focus"])

        @property
        def description(self):
            return "She's careful of you\n" + diceToText(0, 2) + "[i_arouse]\n" + diceToText(2, -1, color = 1) + "[i_focus]"

        def playAbility(self, dice):   
            if len(dice) > 0:
                hpToPlayer(dice.pop(0).value)    
            if len(dice) > 0:
                hpToPlayer(dice.pop(0).value)
            addEffectToOpponent("Focus", self.diceValue(dice))  
    asGuardedAttack()

    class asShielding(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Shielding",
                description = "Nice shield\n[i_d1][i_arouse]\n[i_dice][i_focus] & 1[i_infinite][i_focus]",
                rolls = 3,
                diceGroups = [0, 1],
                effects = ["Focus"])

        @property
        def description(self):
            return "Nice shield\n" + diceToText(0, 1) + "[i_arouse]\n" + diceToText(1, -1, color = 1) + "[i_focus]\n1[i_infinite][i_focus]"

        def playAbility(self, dice):      
            if len(dice) > 0:
                hpToPlayer(dice.pop(0).value)
                addEffectToOpponent("Focus", self.diceValue(dice))  
            addEffectToOpponent("Focus", 1, True)  
    asShielding()

    class abiGuardedAttack(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Guarded Attack", 
                "Cards/CGuard.webp", 
                "[i_dice][i_arouse]\n[i_dice]/2[i_focus]", 
                [abilityDie(type = "Even"), abilityDie(type = "Even")],
                effects = ["Focus"])

        def playAbility(self, dice, card):
            val = self.diceValue(dice)
            hpToOpponent(val)
            addEffectToPlayer("Focus", val / 2)  
    abiGuardedAttack()
    
    opponentSuccubus("Guard",
        "Guard",
        "Succubi/Guard.webp",
        30,
        ["Guarded Attack", "Shielding"],
        "Guarded Attack")
    
    #Alchemist
    class asMysteryPotion(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Mystery Potion",
                description = "Crafts a potion with a random effect...\n[i_1][i_locked], [i_2] 2[i_aphro], [i_3] 3[i_phero],\n[i_4]4[i_smitten], [i_5][i_arouse], [i_6][i_vigor][i_infinite]",
                rolls = 2,
                effects = ["Locked", "Aphrodisiac", "Pheromones", "Smitten", "Vigor"])

        @property
        def description(self):
            return "Crafts a potion with a random effect...\n[i_1][i_locked], [i_2] 2[i_aphro], [i_3] 3[i_phero],\n[i_4]4[i_smitten], [i_5][i_arouse], [i_6][i_vigor][i_infinite]"

        def playAbility(self, dice):
            for die in dice:
                if die.value == 1:
                    addEffectToPlayer("Locked", 1)  
                elif die.value == 2:
                    addEffectToPlayer("Aphrodisiac", 2)
                elif die.value == 3:
                    addEffectToOpponent("Pheromones", 3)  
                elif die.value == 4:
                    addEffectToPlayer("Smitten", 4)  
                elif die.value == 5:
                    addEffectToPlayer("Arouse", 5)  
                else:
                    addEffectToOpponent("Vigor", 1, True)
    asMysteryPotion()

    class abiLustPotion(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Lust Potion", 
                "Cards/CAlchemist.webp", 
                "[i_dice][i_aphro]", 
                [abilityDie(3, "-")],
                effects = ["Aphrodisiac"])

        def playAbility(self, dice, card):
            addEffectToOpponent("Aphrodisiac", self.diceValue(dice))  
    abiLustPotion()

    opponentSuccubus("Alchemist",
        "Alchemist",
        "Succubi/Alchemist.webp",
        37,
        ["Mystery Potion"],
        "Lust Potion")

    #Businesswoman
    class asHaughtySneer(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Haughty Sneer",
                description = "She looks down on you\n[i_dice][i_arouse]\nOn 6 : 2[i_insensitive]",
                rolls = 3,
                effects = ["Insensitive"])

        @property
        def description(self):
            return "She looks down on you\n" + diceToText() + "[i_arouse]\nOn 6 : 2[i_insensitive]"

        def playAbility(self, dice):
            val = 0
            for die in dice:
                val += die.value
                if die.value >= 6:
                    addEffectToOpponent("Insensitive", 2)
                
            hpToPlayer(val)
    asHaughtySneer()
    
    class abiSneer(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Sneer", 
                "Cards/CBoss.webp", 
                "[i_dice][i_arouse]\nOn 6 : 2[i_insensitive]", 
                [abilityDie()],
                effects = ["Insensitive"])

        def playAbility(self, dice, card):
            hpToOpponent(self.diceValue(dice = dice))
            if dice[0].value == 6:
                addEffectToPlayer("Insensitive", 2)
    abiSneer()

    opponentSuccubus("Businesswoman",
        "Businesswoman",
        "Succubi/Boss.webp",
        23,
        ["Haughty Sneer"],
        "Sneer")

    #Prostitute
    class asWhoring(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Whoring",
                description = "Pay for sex or she'll entice you.",
                rolls = 2,
                effects = ["Calm", "Pheromones"])

        @property
        def description(self):
            return "Pay her " + diceToText(mod = .5) + "[i_crystal] for " + diceToText(mod = .5) + "[i_calm]\nOr she'll entice you for " + diceToText() + "[i_infinite][i_phero]"

        def playAbility(self, dice): 
            renpy.call("ProstituteAbility", self.diceValue(dice)) 
    asWhoring()

    class abiFragrantPerfume(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Fragrant Perfume", 
                "Cards/CProstitute.webp", 
                "[i_dice][i_phero]\nOn 6 : 1[i_crystal]", 
                [abilityDie()],
                effects = ["Pheromones"])

        def playAbility(self, dice, card):
            val = self.diceValue(dice)
            addEffectToPlayer("Pheromones", val)  
            if val == 6:
                addCrystals(1)
    abiFragrantPerfume()

    opponentSuccubus("Prostitute",
        "Prostitute",
        "Succubi/Prostitute.webp",
        31,
        ["Whoring"],
        "Fragrant Perfume")

    #Beggar
    class asBeg(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Beg",
                description = "Can I have a few [i_crystal], please?",
                rolls = 1)

        @property
        def description(self):
            return "Can I have a few [i_crystal], please?"

        def playAbility(self, dice): 
            renpy.call("BeggarAbility", self.diceValue(dice))
    asBeg()

    class abiPlease(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Please?", 
                "Cards/CBeggar.webp", 
                "Get [i_dice][i_crystal]", 
                [abilityDie(1)]
                )

        def playAbility(self, dice, card):
            addCrystals(self.diceValue(dice))
    abiPlease()

    opponentSuccubus("Beggar",
        "Beggar",
        "Succubi/Beggar.webp",
        9,
        ["Beg"],
        "Please?")

    #BOSS : Knight          https://www.hentai-foundry.com/pictures/user/botslim/693686/Livia
    class asSlash(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Slash",
                description = "How can her sword arouse you so much?\n[i_dmax][i_arouse]",
                rolls = 2)

        @property
        def description(self):
            return "How can her sword arouse you so much?\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):   
            hpToPlayer(self.diceValue(dice))          
    asSlash()

    class asParry(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Parry",
                description = "Not the best time to attack\n[i_dmax][i_focus]&[i_phero]",
                rolls = 2,
                effects = ["Focus", "Pheromones"])

        @property
        def description(self):
            return "Not the best time to attack\n" + diceToText() + "[i_focus]&[i_phero]"

        def playAbility(self, dice):
            val = self.diceValue(dice)
            addEffectToOpponent("Focus", val)
            addEffectToOpponent("Pheromones", val)
    asParry()

    class asConviction(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Conviction",
                description = "Such confidence\nInflicts [i_dice][i_arouse]\nOn 1-5 : [i_infinite][i_zeal]\nOn 6 : [i_infinite][i_vigor].",
                rolls = 1,
                effects = ["Zeal", "Vigor"])

        @property
        def description(self):
            return "Such confidence\nInflicts " + diceToText() + "[i_arouse]\nOn 1-5 : [i_infinite][i_zeal]\nOn 6 : [i_infinite][i_vigor]"

        def playAbility(self, dice):
            val = 0
            for die in dice:
                val += die.value
                if die.value < 6:
                    addEffectToOpponent("Zeal", 1, True)
                else:
                    addEffectToOpponent("Vigor", 1, True)
            hpToPlayer(val)   
    asConviction()

    class abiConviction(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Conviction", 
                "Cards/CKnight.webp", 
                "1[i_zeal]\nReroll die", 
                [abilityDie(6)],
                effects = ["Zeal"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Zeal", 1)  
            rerollDie(dice[0])
    abiConviction()

    opponentSuccubus("Knight",
        "Knight",
        "Succubi/Knight.webp",
        50,
        ["Slash", "Parry", "Conviction"],
        "Conviction")

    
    #Dream
    dream("Town",
        3,
        "Knight",
        ["Sporty", "Guard", "Alchemist", "Businesswoman", "Prostitute", "Beggar"],
        [miscDreamEvent("deAngel", "Characters/placeholder.png")],
        "town")
    
    addDreamLink("Inn", "Town", lambda: story > 11)


       
define spo = Character("Sporty Succubus", callback = name_callback, cb_name = "sporty")
image sportyS:
    "sporty"
    function SpriteFocus("sporty") 
define gua = Character("Guard Succubus", callback = name_callback, cb_name = "guard")
image guardS:
    "guard"
    function SpriteFocus("guard") 
define alc = Character("Alchemist Succubus", callback = name_callback, cb_name = "alchemist")
image alchemistS:
    "alchemist"
    function SpriteFocus("alchemist") 
define bus = Character("Businesswoman Succubus", callback = name_callback, cb_name = "businesswoman")
image businesswomanS:
    "boss"
    function SpriteFocus("businesswoman") 
define pro = Character("Prostitute Succubus", callback = name_callback, cb_name = "prostitute")
image prostituteS:
    "prostitute"
    function SpriteFocus("prostitute") 
define beg = Character("Beggar Succubus", callback = name_callback, cb_name = "beggar")
image beggarS:
    "beggar"
    function SpriteFocus("beggar") 
define kni = Character("Succubus Knight", callback = name_callback, cb_name = "knight")
image knightS:
    "knight"
    function SpriteFocus("knight")