init 10 python:
    #hpToPlayer(self.diceValue(dice))
    #addEffectToOpponent("Vigor", self.diceValue(dice))
    #addEffectToPlayer("Zeal", 1)

    #Warrior
    class asRoughGrope(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Rough Grope",
                description = "",
                rolls = 3)

        @property
        def description(self):
            return "She can go for a while\nDice +1\n" + diceToText(bonus = self.rolls) + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice) + len(dice))
    asRoughGrope()

    class abiRoughGrope(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Rough Grope", 
                "Cards/CWarrior.webp", 
                "[i_dice]+1 [i_arouse]", 
                [abilityDie()])

        def playAbility(self, dice, card):
            hpToOpponent(self.diceValue(dice) + len(dice))
    abiRoughGrope()

    opponentSuccubus("Warrior",
        "Warrior",
        "Succubi/Warrior.webp",
        96,
        ["Rough Grope"],
        "Rough Grope")
    
    #Mage
    class asIncantArousal(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Incant Arousal",
                description = "",
                rolls = 3,
                countMax = 20)

        @property
        def description(self):
            return "Magically induced orgasm\n25[i_arouse]"

        def playAbility(self, dice):
            self.count -= self.diceValue(dice)
            if self.count <= 0:
                hpToPlayer(25)
                self.count = self.countMax
    asIncantArousal()

    class abiIncantArousal(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Incant Arousal", 
                "Cards/CMage.webp", 
                "20[i_arouse]", 
                [abilityDie()],
                countMax = 20)

        def playAbility(self, dice, card):
            self.count -= self.diceValue(dice)
            if self.count <= 0:
                hpToOpponent(20)
                self.count = self.countMax
    abiIncantArousal()

    opponentSuccubus("Mage",
        "Mage",
        "Succubi/Mage.webp",
        55,
        ["Incant Arousal"],
        "Incant Arousal")    
    
    #Priestess
    class asCureCorruption(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Cure Corruption",
                description = "",
                rolls = 3,
                diceGroups = [0, 1],
                effects = ["Calm"])

        @property
        def description(self):
            return "Transfer her corruption into you\n" + diceToText(0, 1) + "[i_calm]\n" + diceToText(1, -1, color = 1) + "[i_arouse]"

        def playAbility(self, dice):
            addEffectToOpponent("Calm", dice.pop(0).value)
            hpToPlayer(self.diceValue(dice))
    asCureCorruption()

    class abiCureCorruption(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Cure Corruption", 
                "Cards/CPriestess.webp", 
                "[i_dice][i_arouse] & [i_calm]", 
                [abilityDie()],
                effects = ["Calm"])

        def playAbility(self, dice, card):
            val = self.diceValue(dice)
            hpToOpponent(val)
            addEffectToPlayer("Calm", val)
    abiCureCorruption()

    opponentSuccubus("Priestess",
        "Priestess",
        "Succubi/Priestess.webp",
        53,
        ["Cure Corruption"],
        "Cure Corruption")

    #Rogue
    class asBackstab(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Backstab",
                description = "",
                rolls = 3,
                effects = ["❤ Arouse ❤"])

        @property
        def description(self):
            return "Swiftly moves behind you and bypasses your defense\n" + diceToText() + "[i_arouse2]"

        def playAbility(self, dice):
            addEffectToPlayer("❤ Arouse ❤", self.diceValue(dice))
    asBackstab()

    class abiBackstab(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Backstab", 
                "Cards/CRogue.webp", 
                "[i_dice][i_arouse2]\nIgnore defenses", 
                [abilityDie()],
                effects = ["❤ Arouse ❤"])

        def playAbility(self, dice, card):
            addEffectToOpponent("❤ Arouse ❤", self.diceValue(dice))
    abiBackstab()

    opponentSuccubus("Rogue",
        "Rogue",
        "Succubi/Rogue.webp",
        50,
        ["Backstab"],
        "Backstab")
        
    
    #Queen
    class asRoyalEdict(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Royal Edict",
                description = "",
                rolls = 0)

        @property
        def description(self):
            return "By order of the Queen..."

        def playAbility(self, dice):
            renpy.call("QueenLoss")
    asRoyalEdict()
    
    #Shielding Edict : 2 Barrier, X Shield, 5D
    class asShieldingEdict(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Edict of Shielding",
                description = "",
                rolls = 5)

        @property
        def description(self):
            return "Protect your Queen\n" + diceToText() + "[i_focus]\n2[i_shielding]"

        def playAbility(self, dice):
            addEffectToOpponent("Focus", self.diceValue(dice))
            addEffectToOpponent("Shielding", 2)
    asShieldingEdict()

    #Superiority Edict : X Damage, 2 Curse, 2 Bless, 5D
    class asSuperiorityEdict(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Edict of Superiority",
                description = "",
                rolls = 5)

        @property
        def description(self):
            return "Bow to your Queen\n" + diceToText() + "[i_arouse]\n2[i_cursed] & 2[i_blessed]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            addEffectToPlayer("Cursed", 2)
            addEffectToOpponent("Blessed", 2)
    asSuperiorityEdict()

    #Smiting Edict : X Damage, YSmitten, 5D
    class asSmitingEdict(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Edict of Smiting",
                description = "",
                rolls = 5)

        @property
        def description(self):
            return "Worship your Queen\n" + diceToText() + "[i_arouse]\n2[i_smitten]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            addEffectToPlayer("Smitten", 2)
    asSmitingEdict()

    #Empowering Edict : X Damage, 1=> InfTired, 6 => InfVigor
    class asEmpoweringEdict(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Edict of Empowerment",
                description = "",
                rolls = 5)

        @property
        def description(self):
            return "I am your Queen" + diceToText() + "[i_arouse]\n1 => [i_tired]\n6 => [i_vigor]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            for die in dice:
                if die.value == 1:
                    addEffectToOpponent("Tired", 1)
                else:
                    addEffectToOpponent("Vigor", 1)
    asEmpoweringEdict()


    opponentSuccubus("Queen",
        "Queen",
        "Succubi/Queen.webp",
        100,
        ["Edict of Shielding", "Edict of Superiority", "Edict of Smiting", "Edict of Empowerment"],
        None)

    #Maid
    class asServingQueen(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Serving the Queen",
                description = "",
                rolls = 4)

        @property
        def description(self):
            return "Yes, my Queen\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))         
    asServingQueen()

    class asMaidDevotion(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Maid's Devotion",
                description = "",
                rolls = 5,
                diceGroups = [0, 1],
                effects = ["Focus"])

        @property
        def description(self):
            return "Queen...\n" + diceToText(0, 2) + "[i_arouse] then " + diceToText(2, -1, color = 1) + "[i_focus]"
            
        def playAbility(self, dice): 
            if len(dice) > 0:
                hpToPlayer(dice.pop(0).value + dice.pop(0).value)
                addEffectToOpponent("Focus", self.diceValue(dice))  
    asMaidDevotion()

    opponentSuccubus("Maid2",
        "Maid",
        "Succubi/Maid.webp",
        60,
        ["Serving the Queen", "Maid's Devotion"],
        None)

    #Pixie
    class asPixieOrders(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Pixie's Orders",
                description = "",
                rolls = 4,
                effects = ["Smitten"])

        @property
        def description(self):
            return "No fun allowed\n" + diceToText() + "[i_arouse]\n5[i_smitten]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
            addEffectToPlayer("Smitten", 5)
    asPixieOrders()

    opponentSuccubus("Pixie2",
        "Pixie",
        "Succubi/Pixie.webp",
        56,
        ["Pixie's Orders"],
        None)

    #Nurse
    class asPrescriptionShot(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Prescription Shot",
                description = "",
                rolls = 4,
                diceGroups = [1, 0],
                effects = ["Sensitive"])

        @property
        def description(self):
            return "Queen's instructions\n" + diceToText(2, -1) + "[i_arouse]\n" + diceToText(0, 2, color = 1) + "[i_sensitive]\n"

        def playAbility(self, dice):
            if len(dice) > 0:
                val = dice.pop(0).value
                if len(dice) > 0:
                    val += dice.pop(0).value
                    if len(dice) > 0:
                        hpToPlayer(self.diceValue(dice))
                addEffectToPlayer("Sensitive", val)
    asPrescriptionShot()

    class asDopingDrink(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Doping Drink",
                description = "",
                rolls = 2,
                diceGroups = [1, 0],
                effects = ["Insensitive", "Vigor"])

        @property
        def description(self):
            return "{i}Guh...{/i}\n" + diceToText(0, 2, color = 1) + "[i_insensitive]\n" + diceToText(2, -1) + "[i_arouse]\n50% : [i_vigor]"

        def playAbility(self, dice):
            if len(dice) > 0:
                addEffectToOpponent("Insensitive", dice.pop(0).value)
                if len(dice) > 0:
                    addEffectToOpponent("Insensitive", dice.pop(0).value)
                    hpToPlayer(self.diceValue(dice))
                    if renpy.random.random() <= .5:
                        addEffectToOpponent("Vigor", 1)
    asDopingDrink()

    opponentSuccubus("Nurse2",
        "Nurse",
        "Succubi/Nurse.webp",
        66,
        ["Prescription Shot", "Doping Drink"],
        None)

    #Dragon
    class asDragonSlash(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Dragon Slash",
                description = "",
                rolls = 4,
                effects = ["Focus"])

        @property
        def description(self):
            return "I shall defend my Queen\n" + diceToText() + "[i_dice][i_focus]\n" + str(len(oppRolls)) + "[i_arouse] (1 per die)"

        def playAbility(self, dice):
            addEffectToOpponent("Focus", self.diceValue(dice))
            for i in range(0, len(dice)):
                hpToPlayer(1)
    asDragonSlash()

    class asFireBreath(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Fire Breath",
                description = "",
                rolls = 3,
                diceGroups = [1, 0],
                effects = ["Sensitive"])
                
        @property
        def description(self):
            return "You won't see her!\n" + diceToText(0, 2, color = 1) + "[i_sensitive] & self [i_arouse]\n" + diceToText(2, -1) + "[i_arouse]"

        def playAbility(self, dice):
            val = dice.pop().value
            addEffectToOpponent("Sensitive", val)
            hpToOpponent(val)
            hpToPlayer(self.diceValue(dice))
    asFireBreath()

    class asFury(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Fury",
                description = "Fuck you!",
                rolls = 2,
                effects = ["Vigor"])

        @property
        def description(self):
            return "Let me OUT!\n" + diceToText() + "[i_arouse] to you and her\nSet 1[i_infinite][i_vigor] per 10 missing health"

        def playAbility(self, dice):
            val = self.diceValue(dice)
            hpToPlayer(val)
            hpToOpponent(val)
            val = int(opponentHP / 10)
            addEffectToOpponent("Vigor", -100, True)
            addEffectToOpponent("Vigor", val, True)
    asFury()

    opponentSuccubus("Dragon2",
        "Dragon",
        "Succubi/Dragon.webp",
        99,
        ["Dragon Slash", "Brun Up", "Fury"],
        None)


    """ 
    Lust :
    https://www.hentai-foundry.com/pictures/user/Abysmal0/471082/Aludian

    Greed :
    https://www.hentai-foundry.com/pictures/user/barretxiii/602996/Worship-Your-Queen

    Sloth :
    https://www.hentai-foundry.com/pictures/user/Moonbound/619782/Patreon-Tezarya-futa-version

    Gluttony :
    https://www.hentai-foundry.com/pictures/user/KinkyJimmy/47844/Futa-Shedevil

    Pride :
    https://www.hentai-foundry.com/pictures/user/Hijabolic/415616/She-Devil

    Wrath :
    https://www.hentai-foundry.com/pictures/user/Uxdragon/976519/Lynn-The-Demonic-Entity

    Envy :
    https://www.hentai-foundry.com/pictures/user/MapleMoon/1033609/demon-queen-futa
    """
    dream("Palace",
        4,
        "Queen",
        ["Warrior", "Mage", "Priestess", "Rogue"],
        [],
        "palace")

    addDreamLink("Park", "Palace", lambda: story > 30)
    
define que = Character("Succubus Queen", callback = name_callback, cb_name = "queen")
image queenS:
    "queen"
    function SpriteFocus("queen")
define war = Character("Succubus Warrior", callback = name_callback, cb_name = "warrior")
image warriorS:
    "warrior"
    function SpriteFocus("warrior")    
define pri = Character("Succubus Priestess", callback = name_callback, cb_name = "priestess")
image priestessS:
    "priestess"
    function SpriteFocus("priestess")    
define mag = Character("Succubus Mage", callback = name_callback, cb_name = "mage")
image mageS:
    "mage"
    function SpriteFocus("mage")    
define rog = Character("Succubus Rogue", callback = name_callback, cb_name = "rogue")
image rogueS:
    "rogue"
    function SpriteFocus("rogue")
    