﻿init 10 python:
    #Equine
    class asBigGun(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Big gun",
                description = "Takes a while to load\n10[i_arouse]",
                rolls = 2,
                countMax = 15)

        @property
        def description(self):
            return "Takes a while to load\n10[i_arouse]"

        def playAbility(self, dice):
            self.count -= self.diceValue(dice)
            if self.count <= 0:
                hpToPlayer(10)
                self.count = self.countMax
    asBigGun()

    class abiBigGun(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Big Gun", "Cards/CEquine.webp", "10[i_arouse]", [abilityDie()], countMax = 15)

        def playAbility(self, dice, card):
            card.count -= self.diceValue(dice)
            if card.count <= 0:
                hpToOpponent(10)
    abiBigGun()

    opponentSuccubus("Equine",
        "Equine",
        "Succubi/Equine.webp",
        20,
        ["Big gun"],
        "Big Gun")

    #Spider
    class asSilkjob(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Silkjob",
                description = "Wraps you up with smooth, silky webs\n[i_d1][i_sticky]\n[i_dmax][i_arouse]",
                rolls = 2,
                diceGroups = [1, 0],
                effects = ["Sticky"])

        @property
        def description(self):
            return "Wraps you up with smooth, silky webs\n" + diceToText(0, 1, color = 1) + "[i_sticky]\n" + diceToText(1, -1) + "[i_arouse]"

        def playAbility(self, dice):
            if len(dice) > 0:
                addEffectToPlayer("Sticky", dice.pop(0).value)
                hpToPlayer(self.diceValue(dice))
    asSilkjob()
    
    class asWidowKiss(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Widow's kiss",
                description = "A fanged kiss leaving you hot and numb\n[i_dmax]/2 [i_aphro]\n1 [i_locked]",
                rolls = 1,
                effects = ["Aphrodisiac", "Locked"])

        @property
        def description(self):
            return "A fanged kiss leaving you hot and numb\n" + diceToText() + "/2 [i_aphro]\n1 [i_locked]"

        def playAbility(self, dice):
            addEffectToPlayer("Aphrodisiac", self.diceValue(dice) / 2)
            addEffectToPlayer("Locked", 1)
    asWidowKiss()    

    class abiWidowKiss(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Widow's kiss", 
                "Cards/CSpider.webp", 
                "[i_dice][i_aphro]", 
                [abilityDie(3, "-")],
                effects = ["Aphrodisiac"])

        def playAbility(self, dice, card):
            addEffectToOpponent("Aphrodisiac", self.diceValue(dice))
    abiWidowKiss()

    opponentSuccubus("Spider",
        "Spider",
        "Succubi/Spider.webp",
        12,
        ["Silkjob", "Widow's kiss"],
        "Widow's kiss")


    #Drunk
    class asUnfocusedGrope(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Unfocused Grope",
                description = "Suddenly groupes you\n[i_dice][i_arouse]",
                rolls = 1)

        @property
        def description(self):
            return "Suddenly groupes you\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
    asUnfocusedGrope()

    class asDuh(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Ehm...",
                description = "...",
                rolls = 0)

        @property
        def description(self):
            return "..."

        def playAbility(self, dice):
            return            
    asDuh()
    
    class asOneMoreDrink(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "One More Drink",
                description = "One more drink won't hurt...\n[i_infinite][i_vigor]\nSelf : [i_dmax][i_arouse2]",
                rolls = 1,
                effects = ["Vigor", "❤ Arouse ❤"])

        @property
        def description(self):
            return "One more drink won't hurt...\n[i_infinite][i_vigor]\nSelf : " + diceToText() + "[i_arouse2]"

        def playAbility(self, dice):
            addEffectToOpponent("Vigor", 1, True)
            addEffectToOpponent("❤ Arouse ❤", self.diceValue(dice))           
    asOneMoreDrink()

    class abiJustASip(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Just a sip", 
                "Cards/CDrunk.webp", 
                "Duplicate die\nSelf : [i_dice]/2 [i_arouse2]", 
                [abilityDie()],
                effects = ["❤ Arouse ❤"])

        def playAbility(self, dice, card):
            die = rollNewDie(dice[0].value)
            die = rollNewDie(dice[0].value)
            addEffectToPlayer("❤ Arouse ❤", die.value / 2)
    abiJustASip()

    opponentSuccubus("Drunk",
        "Drunk",
        "Succubi/Drunk.webp",
        19,
        ["Unfocused Grope", "Ehm...", "One More Drink"],
        "Just a sip")


    #Waitress
    class asService(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Service",
                description = "Service with a smile\n[i_dice][i_arouse]",
                rolls = 2)

        @property
        def description(self):
            return "Service with a smile\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))         
    asService()

    class asRefill(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Refill",
                description = "One more for the road?\n[i_d1][diceToText()][i_arouse]\n[i_dmax][i_focus]",
                rolls = 3,
                diceGroups = [0, 1],
                effects = ["Focus"])

        @property
        def description(self):
            return "One more for the road?\n" + diceToText(0, 1) + "[i_arouse]\n" + diceToText(1, -1, color = 1) + "[i_focus]"

        def playAbility(self, dice): 
            if len(dice) > 0:
                hpToPlayer(dice.pop(0).value)
            addEffectToOpponent("Focus", self.diceValue(dice))  
    asRefill()    

    class abiRefill(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Refill", 
                "Cards/CWaitress.webp", 
                "[i_d1][i_arouse]\n[i_d2][i_focus]", 
                [abilityDie(), abilityDie()],
                effects = ["Focus"])

        def playAbility(self, dice, card):
            hpToOpponent(dice[0].value)
            addEffectToPlayer("Focus", dice[1].value)  
    abiRefill()

    opponentSuccubus("Waitress",
        "Waitress",
        "Succubi/Waitress.webp",
        15,
        ["Service", "Refill"],
        "Refill")


    #BOSS : Mature
    class asNursingHJ(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Nursing Handjob",
                description = "Drink from her breast while she takes care of you\n[i_dice][i_arouse]",
                rolls = 3)

        @property
        def description(self):
            return "Drink from her breast while she takes care of you\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))
    asNursingHJ()

    class asNapTime(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Nap time",
                description = "Rest for a while\nYou : [i_dice][i_calm]\n2[i_tired]",
                rolls = 1,
                effects = ["Tired"])

        @property
        def description(self):
            return "Rest for a while\nYou : " + diceToText() + "[i_calm]\n2[i_tired]"

        def playAbility(self, dice):
            addEffectToPlayer("Calm", self.diceValue(dice))
            addEffectToPlayer("Tired", 2)  
    asNapTime()

    class asMotherlyKiss(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Motherly Kiss",
                description = "A simple kiss from a mother\n1[i_arouse]",
                rolls = 0)

        @property
        def description(self):
            return "A simple kiss from a mother\n1[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(1)
    asMotherlyKiss()

    class abiNapTime(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, 
                "Nap time", 
                "Cards/CMature.webp", 
                "[i_dice][i_calm]\nYou : [i_tired]", 
                [abilityDie()],
                effects = ["Tired"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Calm", self.diceValue(dice))
            addEffectToPlayer("Tired", 1)  
    abiNapTime()

    opponentSuccubus("Mature",
        "Mature",
        "Succubi/Mature.webp",
        32,
        ["Nursing Handjob", "Nap time", "Motherly Kiss"],
        "Nap time")

    #Dream
    dream("Inn",
        3,
        "Mature",
        ["Equine", "Spider", "Drunk", "Waitress"],
        [miscDreamEvent("deInnRest", "Succubi/Sleeping.webp")],
        "innlobby")

    newEvent("deInnRest", "Dream_Inn")


define equ = Character("Equine Succubus", callback = name_callback, cb_name = "equine")
image equineS:
    "equine"
    function SpriteFocus("equine")
define spi = Character("Spider Succubus", callback = name_callback, cb_name = "spider")
image spiderS:
    "spider"
    function SpriteFocus("spider")
define dru = Character("Drunk Succubus", callback = name_callback, cb_name = "drunk")
image drunkS:
    "drunk"
    function SpriteFocus("drunk")
define wai = Character("Waitress Succubus", callback = name_callback, cb_name = "waitress")
image waitressS:
    "waitress"
    function SpriteFocus("waitress")
define mat = Character("Mature Succubus", callback = name_callback, cb_name = "mature")
image matureS:
    "mature"
    function SpriteFocus("mature")
