define eve = Character("Evelyn", color="#605C6E", callback = name_callback, cb_name = "evelyn")
layeredimage evelyn:
    at sprite_highlight('evelyn')

    group main:
        attribute base default:
            "evelyn b"
        attribute naked:
            "evelyn n"
define mai = Character("Maid", color="#605C6E", callback = name_callback, cb_name = "maid")
image maidS:
    "maid"
    function SpriteFocus("maid")
default eveC = playChara("Evelyn")
define pCharaDB["Evelyn"] = playableChara("Evelyn", eve, "evelyn", "Maid", 380, 405, "#605C6E", "Audio/Music/Jazz Brunch.mp3",
[
    [None, None, None, "Find a friend at night (Meet a Dream Diver)", "Meet Eve during the day", "Meet Eve during the evening", None, "Have a friend to spend time with", None, None],
    ["Find someone for her (Friendship 5)", "Meet Eve during the day", None, None, None],
    ["Check on her first (Friendship 1)", None, "Meet Eve during the evening", None, None]
])

init 10 python:    
    class abiServingMaster(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Serving Master", "Cards/CMaid.webp", "[i_dice][i_arouse]", [abilityDie(3, "+")], 2)

        def playAbility(self, dice, card):
            hpToOpponent(self.diceValue(dice = dice))
    abiServingMaster()
    
    class abiMaidDuty(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Maid Duty", "Cards/CMaid.webp", "[i_dice][i_focus]", [abilityDie(4, "-")], 2, effects = ["Focus"])

        def playAbility(self, dice, card):
            addEffectToPlayer("Focus", self.diceValue(dice = dice))
    abiMaidDuty()

    class abiCleanup(playerAbility):
        def __init__(self):
            playerAbility.__init__(self, "Cleanup", "Cards/CMaid.webp", "Reroll[i_dice]", [abilityDie()], 3)

        def playAbility(self, dice, card):
            rerollDie(dice[0])
    abiCleanup()

    playerSuccubus("Maid", "Evelyn",
        "Succubi/Maid.webp", 
        20, 
        3, 
        ["Serving Master", "Maid Duty", "Cleanup"])
    
    class asServingMaster(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Serving Master",
                description = "I live only to serve, Mistress\n[i_dmax][i_arouse]",
                rolls = 2)

        @property
        def description(self):
            return "I live only to serve, Mistress\n" + diceToText() + "[i_arouse]"

        def playAbility(self, dice):
            hpToPlayer(self.diceValue(dice))         
    asServingMaster()

    class asMaidDuty(succubusAbility):
        def __init__(self):
            succubusAbility.__init__(self,
                "Maid Duty",
                description = "It's my duty, Mistress!",
                rolls = 3,
                diceGroups = [0, 1],
                effects = ["Focus"])

        @property
        def description(self):
            return "It's my duty, Mistress\n" + diceToText(0, 1) + "[i_arouse] then " + diceToText(1, -1, color = 1) + "[i_focus]"
            
        def playAbility(self, dice): 
            if len(dice) > 0:
                hpToPlayer(dice.pop(0).value)
                addEffectToOpponent("Focus", self.diceValue(dice))  
    asMaidDuty()

    opponentSuccubus("Maid",
        "Maid",
        "Succubi/Maid.webp",
        25,
        ["Serving Master", "Maid Duty"],
        None)

    newEvent("EvelynGreeting", "Evelyn_Greeting")
    newEvent("EvelynSpendTime", "Evelyn_SpendTime")

    newEvent("EvelynFriendship1", "Evelyn_Friendship_0")
    newEvent("EvelynFriendship2", "Evelyn_Friendship_1")
    newEvent("EvelynFriendship3", "Evelyn_Friendship_2")
    newEvent("EvelynFriendship4", "Evelyn_Friendship_3", condition = "orcRel > 0")
    newEvent("EvelynFriendship5", "Evelyn_Friendship_4", condition = "dayTime > 0")
    newEvent("EvelynFriendship6", "Evelyn_Friendship_5", condition = "dayTime == 2")
    newEvent("EvelynFriendship7", "Evelyn_Friendship_6")
    newEvent("EvelynFriendship8", "Evelyn_Friendship_7", condition = "story >= 12 and queenServant != 'Pixie'")
    newEvent("EvelynFriendship9", "Evelyn_Friendship_8")
    newEvent("EvelynFriendship10", "Evelyn_Friendship_9")

    newEvent("EvelynLove1", "Evelyn_Love_0", condition = "eveC and eveC.friendship >= 5")
    newEvent("EvelynLove2", "Evelyn_Love_1", condition = "dayTime > 0")
    newEvent("EvelynLove3", "Evelyn_Love_2")
    newEvent("EvelynLove4", "Evelyn_Love_3")
    newEvent("EvelynLove5", "Evelyn_Love_4")
    
    newEvent("EvelynLust1", "Evelyn_Lust_0", condition = "eveC and eveC.friendship >= 1")
    newEvent("EvelynLust2", "Evelyn_Lust_1")
    newEvent("EvelynLust3", "Evelyn_Lust_2", condition = "dayTime == 2")
    newEvent("EvelynLust4", "Evelyn_Lust_3")
    newEvent("EvelynLust5", "Evelyn_Lust_4")