init python:
    class charaBonus:
        def __init__(self, character):
            self.relBonus = {None : 1.0}
            self.hpMod = 1.0
            self.bonusDice = 0
            self.bonusAbilities = []
            self.effects = {}
            self.autoEffects = {}
            self.character = character
            self.maxAbi = 0
            self.luck = 0
        
        def addRelationBonus(self, relation, amount):
            self.checkRelation(relation)
            self.relBonus[relation] = self.relBonus[relation] + amount
                
        def addBonusEffect(self, effect, amount = 1, auto = False):
            if auto:
                if self.autoEffects.has_key(effect):
                    self.autoEffects[effect] += amount
                else:
                    self.autoEffects[effect] = amount
                    
                global abiEffects
                effect = abiEffects[effect]
                if self.character:
                    renpy.notify("Tonight :\n+{} {}[i_infinite]\nfor {}".format(amount, effect.icon, self.character))
                else:
                    renpy.notify("Tonight :\n+{} {}[i_infinite]".format(amount, effect.icon))

            else:
                if self.effects.has_key(effect):
                    self.effects[effect] += amount
                else:
                    self.effects[effect] = amount

                global abiEffects
                effect = abiEffects[effect]
                if self.character:
                    renpy.notify("Tonight :\n+{} {}\nfor {}".format(amount, effect.icon, self.character))
                else:
                    renpy.notify("Tonight :\n+{} {}".format(amount, effect.icon))
                
        def checkRelation(self, relation):
            if not self.relBonus.has_key(relation):
                self.relBonus[relation] = 1.0
        
        def add(self, other):
            for k, v in other.relBonus.items():
                if self.relBonus.has_key(k):
                    self.relBonus[k] = self.relBonus[k] + other.relBonus[k] - 1.0
                else:
                    self.relBonus[k] = other.relBonus[k]
            
            self.hpMod += other.hpMod - 1.0
            self.bonusDice += other.bonusDice
            bonusAbilities = self.bonusAbilities.copy()
            for abi in other.bonusAbilities:
                bonusAbilities.append(abi)
            self.bonusAbilities = bonusAbilities
            self.effects.update(other.effects)
            self.autoEffects.update(other.autoEffects)
            self.luck += other.luck

        def getRelationBonus(self, relation):
            mod = self.relBonus[None]
            if self.relBonus.has_key(relation):
                return mod * self.relBonus[relation]
            else:
                return mod
                
        @property
        def frMod(self):
            return int(self.getRelationBonus(0) * 100)
        @property
        def frBonus(self):
            return int(self.getRelationBonus(0) * 100) - 100
        @property
        def lvMod(self):
            return int(self.getRelationBonus(1) * 100)
        @property
        def lvBonus(self):
            return int(self.getRelationBonus(1) * 100) - 100
        @property
        def lsMod(self):
            return int(self.getRelationBonus(2) * 100)
        @property
        def lsBonus(self):
            return int(self.getRelationBonus(2) * 100) - 100
        
        def giveRelationPoints(self, relation, amount):
            if self.character in characters:
                characters[self.character].addPoints(relation, amount * self.getRelationBonus(relation))


    class dayBonus:
        def __init__(self):
            self.bonus = {None : charaBonus(None)}

        def addRelationBonus(self, relation, amount, character = None):
            self.checkCharacter(character)
            self.bonus[character].addRelationBonus(relation, amount)
            if character:
                renpy.notify("Tonight :\n+{}% [i_{}]\nfor {}".format(amount, relation.lower(), character))
            else:
                renpy.notify("Tonight :\n+{}% [i_{}]".format(amount, relation.lower()))
        
        def addHPBonus(self, amount, character = None):
            self.checkCharacter(character)
            self.bonus[character].hpMod += amount
            if character:
                renpy.notify("Tonight :\n+{}% max [i_arouse]\nfor {}".format(int(amount * 100), character))
            else:
                renpy.notify("Tonight :\n+{}% max [i_arouse]".format(int(amount * 100)))
        
        def addBonusDice(self, amount, character = None):
            self.checkCharacter(character)
            self.bonus[character].bonusDice += amount
            if character:
                renpy.notify("Tonight :\n+{} [i_dice]\nfor {}".format(amount, character))
            else:
                renpy.notify("Tonight :\n+{} [i_dice]".format(amount))
        
        def addLuck(self, amount, character = None):
            self.checkCharacter(character)
            self.bonus[character].luck += amount
            if character:
                renpy.notify("Tonight :\n+{} luck\nfor {}".format(amount, character))
            else:
                renpy.notify("Tonight :\n+{} luck".format(amount))
        
        def addBonusEffect(self, effect, amount = 1, character = None, auto = False):
            self.checkCharacter(character)
            self.bonus[character].addBonusEffect(effect, amount, auto)       

        def addBonusAbility(self, abilityID, character = None):
            self.checkCharacter(character)
            self.bonus[character].bonusAbilities.append(abilityID)
            if character:
                renpy.notify("Tonight :\n+{}\nfor {}".format(abilityID, character))
            else:
                renpy.notify("Tonight :\n+{}".format(abilityID))

        def checkCharacter(self, character):
            if not self.bonus.has_key(character):
                self.bonus[character] = charaBonus(character)
        
        def getCharaBonuses(self, character):            
            chara = charaBonus(character.name)
            chara.add(self.bonus[None])
            if self.bonus.has_key(character.name):
                chara.add(self.bonus[character.name])

            if character.love > 0:
                chara.hpMod += chara.hpMod * character.love * 0.2

            if character.friendship > 4:
                chara.maxAbi = 6
            elif character.friendship > 2:
                chara.maxAbi = 5
            elif character.friendship > 0:
                chara.maxAbi = 4
            else:
                chara.maxAbi = 3
                
            if character.lust > 4:
                chara.bonusDice += 3
            elif character.lust > 2:
                chara.bonusDice += 2
            elif character.lust > 0:
                chara.bonusDice += 1
            
            if character.friendship > 0:
                chara.luck += int(character.friendship / 2)
            if character.love > 0:
                chara.luck += character.love
            if character.lust > 0:
                chara.luck += character.lust

            if character.name == ladyOfTheNight:
                for rel in chara.relBonus.keys():
                    chara.relBonus[rel] += 1

            return chara
    
        def clear(self):
            bonus = {None : charaBonus(None)}